/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ParallelUploadConfig {
    private final boolean skipIfExists;
    private final @NonNull String bucketName;
    private final @NonNull UploadBlobInfoFactory uploadBlobInfoFactory;
    private final @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest;

    private ParallelUploadConfig(boolean skipIfExists, @NonNull String bucketName, @NonNull UploadBlobInfoFactory uploadBlobInfoFactory, @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
        this.skipIfExists = skipIfExists;
        this.bucketName = bucketName;
        this.uploadBlobInfoFactory = uploadBlobInfoFactory;
        this.writeOptsPerRequest = ParallelUploadConfig.applySkipIfExists(skipIfExists, writeOptsPerRequest);
    }

    public boolean isSkipIfExists() {
        return this.skipIfExists;
    }

    public @NonNull String getPrefix() {
        if (this.uploadBlobInfoFactory instanceof PrefixObjectNames) {
            PrefixObjectNames prefixObjectNames = (PrefixObjectNames)this.uploadBlobInfoFactory;
            return prefixObjectNames.prefix;
        }
        return "";
    }

    public @NonNull UploadBlobInfoFactory getUploadBlobInfoFactory() {
        return this.uploadBlobInfoFactory;
    }

    public @NonNull String getBucketName() {
        return this.bucketName;
    }

    public @NonNull List<Storage.BlobWriteOption> getWriteOptsPerRequest() {
        return this.writeOptsPerRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelUploadConfig that = (ParallelUploadConfig)o;
        return this.skipIfExists == that.skipIfExists && this.bucketName.equals(that.bucketName) && this.uploadBlobInfoFactory.equals(that.uploadBlobInfoFactory) && this.writeOptsPerRequest.equals(that.writeOptsPerRequest);
    }

    public int hashCode() {
        return Objects.hash(this.skipIfExists, this.bucketName, this.uploadBlobInfoFactory, this.writeOptsPerRequest);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("skipIfExists", this.skipIfExists).add("bucketName", (Object)this.bucketName).add("uploadBlobInfoFactory", (Object)this.uploadBlobInfoFactory).add("writeOptsPerRequest", this.writeOptsPerRequest).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static List<Storage.BlobWriteOption> applySkipIfExists(boolean skipIfExists, List<Storage.BlobWriteOption> writeOptsPerRequest) {
        if (skipIfExists) {
            return ImmutableList.copyOf((Object[])Storage.BlobWriteOption.dedupe(writeOptsPerRequest, Storage.BlobWriteOption.doesNotExist()));
        }
        return writeOptsPerRequest;
    }

    public static interface UploadBlobInfoFactory {
        public BlobInfo apply(String var1, String var2);

        public static UploadBlobInfoFactory prefixObjectNames(String prefix) {
            return new PrefixObjectNames(prefix);
        }

        public static UploadBlobInfoFactory defaultInstance() {
            return DefaultUploadBlobInfoFactory.INSTANCE;
        }

        public static UploadBlobInfoFactory transformFileName(Function<String, String> fileNameTransformer) {
            return (b, f) -> BlobInfo.newBuilder(b, (String)fileNameTransformer.apply(f)).build();
        }
    }

    private static final class PrefixObjectNames
    implements UploadBlobInfoFactory {
        private final String prefix;

        private PrefixObjectNames(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public BlobInfo apply(String bucketName, String fileName) {
            String separator = "";
            if (!fileName.startsWith("/")) {
                separator = "/";
            }
            return BlobInfo.newBuilder(bucketName, this.prefix + separator + fileName).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrefixObjectNames)) {
                return false;
            }
            PrefixObjectNames that = (PrefixObjectNames)o;
            return Objects.equals(this.prefix, that.prefix);
        }

        public int hashCode() {
            return Objects.hashCode(this.prefix);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).toString();
        }
    }

    public static final class Builder {
        private boolean skipIfExists;
        private @NonNull String bucketName = "";
        private @NonNull UploadBlobInfoFactory uploadBlobInfoFactory = UploadBlobInfoFactory.defaultInstance();
        private @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest = ImmutableList.of();

        private Builder() {
        }

        public Builder setSkipIfExists(boolean skipIfExists) {
            this.skipIfExists = skipIfExists;
            return this;
        }

        public Builder setPrefix(@NonNull String prefix) {
            this.uploadBlobInfoFactory = UploadBlobInfoFactory.prefixObjectNames(prefix);
            return this;
        }

        public Builder setUploadBlobInfoFactory(@NonNull UploadBlobInfoFactory uploadBlobInfoFactory) {
            this.uploadBlobInfoFactory = uploadBlobInfoFactory;
            return this;
        }

        public Builder setBucketName(@NonNull String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setWriteOptsPerRequest(@NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
            this.writeOptsPerRequest = writeOptsPerRequest;
            return this;
        }

        public ParallelUploadConfig build() {
            Preconditions.checkNotNull((Object)this.bucketName);
            Preconditions.checkNotNull((Object)this.uploadBlobInfoFactory);
            Preconditions.checkNotNull(this.writeOptsPerRequest);
            return new ParallelUploadConfig(this.skipIfExists, this.bucketName, this.uploadBlobInfoFactory, this.writeOptsPerRequest);
        }
    }

    private static final class DefaultUploadBlobInfoFactory
    implements UploadBlobInfoFactory {
        private static final DefaultUploadBlobInfoFactory INSTANCE = new DefaultUploadBlobInfoFactory();

        private DefaultUploadBlobInfoFactory() {
        }

        @Override
        public BlobInfo apply(String bucketName, String fileName) {
            return BlobInfo.newBuilder(bucketName, fileName).build();
        }
    }
}

