/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.evaluation;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.AbstractEvaluator;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.provenance.EvaluationProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.evaluation.RegressionEvaluation;
import org.tribuo.regression.evaluation.RegressionEvaluationImpl;
import org.tribuo.regression.evaluation.RegressionMetric;
import org.tribuo.regression.evaluation.RegressionMetrics;

public final class RegressionEvaluator
extends AbstractEvaluator<Regressor, RegressionMetric.Context, RegressionEvaluation, RegressionMetric> {
    private final boolean useExampleWeights;

    public RegressionEvaluator() {
        this(false);
    }

    public RegressionEvaluator(boolean useExampleWeights) {
        this.useExampleWeights = useExampleWeights;
    }

    protected Set<RegressionMetric> createMetrics(Model<Regressor> model) {
        HashSet<RegressionMetric> metrics = new HashSet<RegressionMetric>();
        for (Regressor variable : model.getOutputIDInfo().getDomain()) {
            MetricTarget target = new MetricTarget((Output)variable);
            metrics.add(RegressionMetrics.R2.forTarget((MetricTarget<Regressor>)target));
            metrics.add(RegressionMetrics.RMSE.forTarget((MetricTarget<Regressor>)target));
            metrics.add(RegressionMetrics.MAE.forTarget((MetricTarget<Regressor>)target));
            metrics.add(RegressionMetrics.EV.forTarget((MetricTarget<Regressor>)target));
        }
        MetricTarget macroAverage = new MetricTarget(EvaluationMetric.Average.MACRO);
        metrics.add(RegressionMetrics.R2.forTarget((MetricTarget<Regressor>)macroAverage));
        metrics.add(RegressionMetrics.RMSE.forTarget((MetricTarget<Regressor>)macroAverage));
        metrics.add(RegressionMetrics.MAE.forTarget((MetricTarget<Regressor>)macroAverage));
        metrics.add(RegressionMetrics.EV.forTarget((MetricTarget<Regressor>)macroAverage));
        return metrics;
    }

    protected RegressionMetric.Context createContext(Model<Regressor> model, List<Prediction<Regressor>> predictions) {
        return new RegressionMetric.Context(model, predictions, this.useExampleWeights);
    }

    protected RegressionEvaluation createEvaluation(RegressionMetric.Context context, Map<MetricID<Regressor>, Double> results, EvaluationProvenance provenance) {
        return new RegressionEvaluationImpl(results, context, provenance);
    }
}

