/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.model.BaseModelConfig;

public class RemoteModelConfig
extends BaseModelConfig {
    public static final String PARSE_FIELD_NAME = "remote";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(RemoteModelConfig.class, new ParseField("remote", new String[0]), it -> RemoteModelConfig.parse(it));

    public RemoteModelConfig(String modelType, Integer embeddingDimension, BaseModelConfig.FrameworkType frameworkType, String allConfig, BaseModelConfig.PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength, Map<String, Object> additionalConfig) {
        super(modelType, allConfig, additionalConfig, embeddingDimension, frameworkType, poolingMode, normalizeResult, modelMaxLength, null, null);
        this.validateNoDuplicateKeys(allConfig, additionalConfig);
        this.validateTextEmbeddingConfig();
    }

    public static RemoteModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        Integer embeddingDimension = null;
        BaseModelConfig.FrameworkType frameworkType = null;
        String allConfig = null;
        BaseModelConfig.PoolingMode poolingMode = null;
        boolean normalizeResult = false;
        Integer modelMaxLength = null;
        Map additionalConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block20;
                }
                case "embedding_dimension": {
                    embeddingDimension = parser.intValue();
                    continue block20;
                }
                case "framework_type": {
                    frameworkType = BaseModelConfig.FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block20;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block20;
                }
                case "pooling_mode": {
                    poolingMode = BaseModelConfig.PoolingMode.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block20;
                }
                case "normalize_result": {
                    normalizeResult = parser.booleanValue();
                    continue block20;
                }
                case "model_max_length": {
                    modelMaxLength = parser.intValue();
                    continue block20;
                }
                case "additional_config": {
                    additionalConfig = parser.map();
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return new RemoteModelConfig(modelType, embeddingDimension, frameworkType, allConfig, poolingMode, normalizeResult, modelMaxLength, additionalConfig);
    }

    @Override
    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public RemoteModelConfig(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.embeddingDimension != null) {
            builder.field("embedding_dimension", this.embeddingDimension);
        }
        if (this.frameworkType != null) {
            builder.field("framework_type", (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.poolingMode != null) {
            builder.field("pooling_mode", (Object)this.poolingMode);
        }
        if (this.normalizeResult) {
            builder.field("normalize_result", this.normalizeResult);
        }
        if (this.modelMaxLength != null) {
            builder.field("model_max_length", this.modelMaxLength);
        }
        if (this.additionalConfig != null) {
            builder.field("additional_config", this.additionalConfig);
        }
        builder.endObject();
        return builder;
    }

    private void validateTextEmbeddingConfig() {
        if (this.modelType != null && this.modelType.equalsIgnoreCase("text_embedding")) {
            if (this.embeddingDimension == null) {
                throw new IllegalArgumentException("Embedding dimension must be provided for remote text embedding model");
            }
            if (this.frameworkType == null) {
                throw new IllegalArgumentException("Framework type must be provided for remote text embedding model");
            }
            if (this.additionalConfig == null || !this.additionalConfig.containsKey("space_type")) {
                throw new IllegalArgumentException("Space type must be provided in additional_config for remote text embedding model");
            }
        }
    }

    @Generated
    public static RemoteModelConfigBuilder builder() {
        return new RemoteModelConfigBuilder();
    }

    @Generated
    public RemoteModelConfigBuilder toBuilder() {
        return new RemoteModelConfigBuilder().modelType(this.modelType).embeddingDimension(this.embeddingDimension).frameworkType(this.frameworkType).allConfig(this.allConfig).poolingMode(this.poolingMode).normalizeResult(this.normalizeResult).modelMaxLength(this.modelMaxLength).additionalConfig(this.additionalConfig);
    }

    @Generated
    public static class RemoteModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private BaseModelConfig.FrameworkType frameworkType;
        @Generated
        private String allConfig;
        @Generated
        private BaseModelConfig.PoolingMode poolingMode;
        @Generated
        private boolean normalizeResult;
        @Generated
        private Integer modelMaxLength;
        @Generated
        private Map<String, Object> additionalConfig;

        @Generated
        RemoteModelConfigBuilder() {
        }

        @Generated
        public RemoteModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder embeddingDimension(Integer embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder frameworkType(BaseModelConfig.FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder poolingMode(BaseModelConfig.PoolingMode poolingMode) {
            this.poolingMode = poolingMode;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder normalizeResult(boolean normalizeResult) {
            this.normalizeResult = normalizeResult;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder modelMaxLength(Integer modelMaxLength) {
            this.modelMaxLength = modelMaxLength;
            return this;
        }

        @Generated
        public RemoteModelConfigBuilder additionalConfig(Map<String, Object> additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        @Generated
        public RemoteModelConfig build() {
            return new RemoteModelConfig(this.modelType, this.embeddingDimension, this.frameworkType, this.allConfig, this.poolingMode, this.normalizeResult, this.modelMaxLength, this.additionalConfig);
        }

        @Generated
        public String toString() {
            return "RemoteModelConfig.RemoteModelConfigBuilder(modelType=" + this.modelType + ", embeddingDimension=" + this.embeddingDimension + ", frameworkType=" + String.valueOf((Object)this.frameworkType) + ", allConfig=" + this.allConfig + ", poolingMode=" + String.valueOf((Object)this.poolingMode) + ", normalizeResult=" + this.normalizeResult + ", modelMaxLength=" + this.modelMaxLength + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ")";
        }
    }
}

