/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.DNSServerOperations;
import com.microsoft.windowsazure.management.compute.DNSServerOperationsImpl;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.DeploymentOperationsImpl;
import com.microsoft.windowsazure.management.compute.ExtensionImageOperations;
import com.microsoft.windowsazure.management.compute.ExtensionImageOperationsImpl;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperationsImpl;
import com.microsoft.windowsazure.management.compute.LoadBalancerOperations;
import com.microsoft.windowsazure.management.compute.LoadBalancerOperationsImpl;
import com.microsoft.windowsazure.management.compute.OperatingSystemOperations;
import com.microsoft.windowsazure.management.compute.OperatingSystemOperationsImpl;
import com.microsoft.windowsazure.management.compute.ServiceCertificateOperations;
import com.microsoft.windowsazure.management.compute.ServiceCertificateOperationsImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperationsImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineExtensionOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineExtensionOperationsImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperationsImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperationsImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineVMImageOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineVMImageOperationsImpl;
import com.microsoft.windowsazure.management.compute.models.CertificateFormat;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbeTransportProtocol;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ComputeManagementClientImpl
extends ServiceClient<ComputeManagementClient>
implements ComputeManagementClient {
    private String apiVersion = "2015-04-01";
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private DeploymentOperations deployments = new DeploymentOperationsImpl(this);
    private DNSServerOperations dnsServer = new DNSServerOperationsImpl(this);
    private ExtensionImageOperations extensionImages = new ExtensionImageOperationsImpl(this);
    private HostedServiceOperations hostedServices = new HostedServiceOperationsImpl(this);
    private LoadBalancerOperations loadBalancers = new LoadBalancerOperationsImpl(this);
    private OperatingSystemOperations operatingSystems = new OperatingSystemOperationsImpl(this);
    private ServiceCertificateOperations serviceCertificates = new ServiceCertificateOperationsImpl(this);
    private VirtualMachineDiskOperations virtualMachineDisks = new VirtualMachineDiskOperationsImpl(this);
    private VirtualMachineExtensionOperations virtualMachineExtensions = new VirtualMachineExtensionOperationsImpl(this);
    private VirtualMachineOperations virtualMachines = new VirtualMachineOperationsImpl(this);
    private VirtualMachineOSImageOperations virtualMachineOSImages = new VirtualMachineOSImageOperationsImpl(this);
    private VirtualMachineVMImageOperations virtualMachineVMImages = new VirtualMachineVMImageOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public DeploymentOperations getDeploymentsOperations() {
        return this.deployments;
    }

    @Override
    public DNSServerOperations getDnsServerOperations() {
        return this.dnsServer;
    }

    @Override
    public ExtensionImageOperations getExtensionImagesOperations() {
        return this.extensionImages;
    }

    @Override
    public HostedServiceOperations getHostedServicesOperations() {
        return this.hostedServices;
    }

    @Override
    public LoadBalancerOperations getLoadBalancersOperations() {
        return this.loadBalancers;
    }

    @Override
    public OperatingSystemOperations getOperatingSystemsOperations() {
        return this.operatingSystems;
    }

    @Override
    public ServiceCertificateOperations getServiceCertificatesOperations() {
        return this.serviceCertificates;
    }

    @Override
    public VirtualMachineDiskOperations getVirtualMachineDisksOperations() {
        return this.virtualMachineDisks;
    }

    @Override
    public VirtualMachineExtensionOperations getVirtualMachineExtensionsOperations() {
        return this.virtualMachineExtensions;
    }

    @Override
    public VirtualMachineOperations getVirtualMachinesOperations() {
        return this.virtualMachines;
    }

    @Override
    public VirtualMachineOSImageOperations getVirtualMachineOSImagesOperations() {
        return this.virtualMachineOSImages;
    }

    @Override
    public VirtualMachineVMImageOperations getVirtualMachineVMImagesOperations() {
        return this.virtualMachineVMImages;
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.core.windows.net");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.core.windows.net");
    }

    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected ComputeManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new ComputeManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }

    static CertificateFormat parseCertificateFormat(String value) {
        if ("pfx".equalsIgnoreCase(value)) {
            return CertificateFormat.Pfx;
        }
        if ("cer".equalsIgnoreCase(value)) {
            return CertificateFormat.Cer;
        }
        throw new IllegalArgumentException("value");
    }

    static String certificateFormatToString(CertificateFormat value) {
        if (value == CertificateFormat.Pfx) {
            return "pfx";
        }
        if (value == CertificateFormat.Cer) {
            return "cer";
        }
        throw new IllegalArgumentException("value");
    }

    static LoadBalancerProbeTransportProtocol parseLoadBalancerProbeTransportProtocol(String value) {
        if ("tcp".equalsIgnoreCase(value)) {
            return LoadBalancerProbeTransportProtocol.Tcp;
        }
        if ("http".equalsIgnoreCase(value)) {
            return LoadBalancerProbeTransportProtocol.Http;
        }
        throw new IllegalArgumentException("value");
    }

    static String loadBalancerProbeTransportProtocolToString(LoadBalancerProbeTransportProtocol value) {
        if (value == LoadBalancerProbeTransportProtocol.Tcp) {
            return "tcp";
        }
        if (value == LoadBalancerProbeTransportProtocol.Http) {
            return "http";
        }
        throw new IllegalArgumentException("value");
    }

    @Override
    public Future<OperationStatusResponse> getOperationStatusAsync(final String requestId) {
        return this.getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ComputeManagementClientImpl.this.getOperationStatus(requestId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse getOperationStatus(String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (requestId == null) {
            throw new NullPointerException("requestId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("requestId", requestId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/operations/";
        url = url + URLEncoder.encode(requestId, "UTF-8");
        String baseUrl = this.getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new OperationStatusResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element operationElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Operation");
                if (operationElement != null) {
                    Element errorElement;
                    Element httpStatusCodeElement;
                    Element statusElement;
                    Element idElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID");
                    if (idElement != null) {
                        String idInstance = idElement.getTextContent();
                        result.setId(idInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                        OperationStatus statusInstance = OperationStatus.valueOf((String)statusElement.getTextContent());
                        result.setStatus(statusInstance);
                    }
                    if ((httpStatusCodeElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HttpStatusCode")) != null && httpStatusCodeElement.getTextContent() != null && !httpStatusCodeElement.getTextContent().isEmpty()) {
                        Integer httpStatusCodeInstance = Integer.valueOf(httpStatusCodeElement.getTextContent());
                        result.setHttpStatusCode(httpStatusCodeInstance);
                    }
                    if ((errorElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                        Element messageElement;
                        OperationStatusResponse.ErrorDetails errorInstance = new OperationStatusResponse.ErrorDetails();
                        result.setError(errorInstance);
                        Element codeElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code");
                        if (codeElement != null) {
                            String codeInstance = codeElement.getTextContent();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                            String messageInstance = messageElement.getTextContent();
                            errorInstance.setMessage(messageInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

