/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import lombok.Generated;

public abstract class WindowBound {
    private WindowBound() {
    }

    public static class UnboundedWindowBound
    extends WindowBound {
        private final boolean isPreceding;

        UnboundedWindowBound(boolean isPreceding) {
            this.isPreceding = isPreceding;
        }

        public boolean isPreceding() {
            return this.isPreceding;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof UnboundedWindowBound && this.isPreceding == ((UnboundedWindowBound)o).isPreceding;
        }

        public String toString() {
            return this.isPreceding ? "UNBOUNDED PRECEDING" : "UNBOUNDED FOLLOWING";
        }
    }

    public static class CurrentRowWindowBound
    extends WindowBound {
        CurrentRowWindowBound() {
        }

        public String toString() {
            return "CURRENT ROW";
        }
    }

    public static class OffSetWindowBound
    extends WindowBound {
        private final long offset;
        private final boolean isPreceding;

        OffSetWindowBound(long offset, boolean isPreceding) {
            this.offset = offset;
            this.isPreceding = isPreceding;
        }

        public boolean isPreceding() {
            return this.isPreceding;
        }

        @Generated
        public long getOffset() {
            return this.offset;
        }
    }
}

