/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.transport.client.node.NodeClient;

public class RestNodesInfoAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = NodesInfoRequest.Metric.allMetrics();
    private final SettingsFilter settingsFilter;

    public RestNodesInfoAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/{metrics}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/info/{metrics}")));
    }

    @Override
    public String getName() {
        return "nodes_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesInfoRequest nodesInfoRequest = RestNodesInfoAction.prepareRequest(request);
        nodesInfoRequest.timeout(request.param("timeout"));
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().nodesInfo(nodesInfoRequest, new RestActions.NodesResponseRestListener<NodesInfoResponse>((RestChannel)channel));
    }

    static NodesInfoRequest prepareRequest(RestRequest request) {
        Set metrics;
        String[] nodeIds;
        if (request.hasParam("nodeId") && !request.hasParam("metrics")) {
            String nodeId = request.param("nodeId", "_all");
            Set metricsOrNodeIds = Strings.tokenizeByCommaToSet((String)nodeId);
            boolean isMetricsOnly = ALLOWED_METRICS.containsAll(metricsOrNodeIds);
            if (isMetricsOnly) {
                nodeIds = new String[]{"_all"};
                metrics = metricsOrNodeIds;
            } else {
                nodeIds = Strings.tokenizeToStringArray((String)nodeId, (String)",");
                metrics = Sets.newHashSet((Object[])new String[]{"_all"});
            }
        } else {
            nodeIds = Strings.tokenizeToStringArray((String)request.param("nodeId", "_all"), (String)",");
            metrics = Strings.tokenizeByCommaToSet((String)request.param("metrics", "_all"));
        }
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodeIds);
        nodesInfoRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesInfoRequest.all();
        } else {
            nodesInfoRequest.clear();
            metrics.retainAll(ALLOWED_METRICS);
            nodesInfoRequest.addMetrics((String[])metrics.stream().toArray(String[]::new));
        }
        return nodesInfoRequest;
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

