'''++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Python file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

'''


import ctypes
import platform
import enum
import os

name = "lib3mf"

'''Definition of domain specific exception
'''
class ELib3MFException(Exception):
	def __init__(self, code, message = ''):
		self._code = code
		self._message = message
	
	def __str__(self):
		if self._message:
			return 'Lib3MFException ' + str(self._code) + ': '+ str(self._message)
		return 'Lib3MFException ' + str(self._code)
	
	def get_error_code(self):
		"""Returns the error code"""
		return self._code
	
	def get_error_message(self):
		"""Returns the custom error message"""
		return self._message
	
	def get_error_name(self):
		"""Returns the error name (constant name)"""
		if self._code == ErrorCodes.SUCCESS:
			return 'SUCCESS'
		elif self._code == ErrorCodes.NOTIMPLEMENTED:
			return 'NOTIMPLEMENTED'
		elif self._code == ErrorCodes.INVALIDPARAM:
			return 'INVALIDPARAM'
		elif self._code == ErrorCodes.INVALIDCAST:
			return 'INVALIDCAST'
		elif self._code == ErrorCodes.BUFFERTOOSMALL:
			return 'BUFFERTOOSMALL'
		elif self._code == ErrorCodes.GENERICEXCEPTION:
			return 'GENERICEXCEPTION'
		elif self._code == ErrorCodes.COULDNOTLOADLIBRARY:
			return 'COULDNOTLOADLIBRARY'
		elif self._code == ErrorCodes.COULDNOTFINDLIBRARYEXPORT:
			return 'COULDNOTFINDLIBRARYEXPORT'
		elif self._code == ErrorCodes.INCOMPATIBLEBINARYVERSION:
			return 'INCOMPATIBLEBINARYVERSION'
		elif self._code == ErrorCodes.CALCULATIONABORTED:
			return 'CALCULATIONABORTED'
		elif self._code == ErrorCodes.SHOULDNOTBECALLED:
			return 'SHOULDNOTBECALLED'
		elif self._code == ErrorCodes.READERCLASSUNKNOWN:
			return 'READERCLASSUNKNOWN'
		elif self._code == ErrorCodes.WRITERCLASSUNKNOWN:
			return 'WRITERCLASSUNKNOWN'
		elif self._code == ErrorCodes.ITERATORINVALIDINDEX:
			return 'ITERATORINVALIDINDEX'
		elif self._code == ErrorCodes.INVALIDMODELRESOURCE:
			return 'INVALIDMODELRESOURCE'
		elif self._code == ErrorCodes.RESOURCENOTFOUND:
			return 'RESOURCENOTFOUND'
		elif self._code == ErrorCodes.INVALIDMODEL:
			return 'INVALIDMODEL'
		elif self._code == ErrorCodes.INVALIDOBJECT:
			return 'INVALIDOBJECT'
		elif self._code == ErrorCodes.INVALIDMESHOBJECT:
			return 'INVALIDMESHOBJECT'
		elif self._code == ErrorCodes.INVALIDCOMPONENTSOBJECT:
			return 'INVALIDCOMPONENTSOBJECT'
		elif self._code == ErrorCodes.INVALIDCOMPONENT:
			return 'INVALIDCOMPONENT'
		elif self._code == ErrorCodes.INVALIDBUILDITEM:
			return 'INVALIDBUILDITEM'
		elif self._code == ErrorCodes.INVALIDBASEMATERIALGROUP:
			return 'INVALIDBASEMATERIALGROUP'
		elif self._code == ErrorCodes.INVALIDSLICESTACKRESOURCE:
			return 'INVALIDSLICESTACKRESOURCE'
		elif self._code == ErrorCodes.INVALIDTEXTURERESOURCE:
			return 'INVALIDTEXTURERESOURCE'
		elif self._code == ErrorCodes.INVALIDCOLORGROUP:
			return 'INVALIDCOLORGROUP'
		elif self._code == ErrorCodes.INVALIDTEXTURE2DGROUP:
			return 'INVALIDTEXTURE2DGROUP'
		elif self._code == ErrorCodes.INVALIDCOMPOSITEMATERIALS:
			return 'INVALIDCOMPOSITEMATERIALS'
		elif self._code == ErrorCodes.INVALIDMULTIPROPERTYGROUP:
			return 'INVALIDMULTIPROPERTYGROUP'
		elif self._code == ErrorCodes.INVALIDRESOURCEINDEX:
			return 'INVALIDRESOURCEINDEX'
		elif self._code == ErrorCodes.ATTACHMENTNOTFOUND:
			return 'ATTACHMENTNOTFOUND'
		elif self._code == ErrorCodes.FORBIDDENCYCLICREFERENCE:
			return 'FORBIDDENCYCLICREFERENCE'
		elif self._code == ErrorCodes.INVALIDATTACHMENTSTREAM:
			return 'INVALIDATTACHMENTSTREAM'
		elif self._code == ErrorCodes.INVALIDPROPERTYCOUNT:
			return 'INVALIDPROPERTYCOUNT'
		elif self._code == ErrorCodes.UNKOWNPROGRESSIDENTIFIER:
			return 'UNKOWNPROGRESSIDENTIFIER'
		elif self._code == ErrorCodes.ELEMENTCOUNTEXCEEDSLIMIT:
			return 'ELEMENTCOUNTEXCEEDSLIMIT'
		elif self._code == ErrorCodes.INVALIDRESOURCE:
			return 'INVALIDRESOURCE'
		elif self._code == ErrorCodes.INVALIDLEVELSET:
			return 'INVALIDLEVELSET'
		elif self._code == ErrorCodes.COULDNOTFINDTRIANGLESET:
			return 'COULDNOTFINDTRIANGLESET'
		elif self._code == ErrorCodes.INVALIDTRIANGLESETINDEX:
			return 'INVALIDTRIANGLESETINDEX'
		elif self._code == ErrorCodes.BEAMLATTICE_INVALID_OBJECTTYPE:
			return 'BEAMLATTICE_INVALID_OBJECTTYPE'
		elif self._code == ErrorCodes.INVALIDKEYSTORE:
			return 'INVALIDKEYSTORE'
		elif self._code == ErrorCodes.INVALIDKEYSTORECONSUMER:
			return 'INVALIDKEYSTORECONSUMER'
		elif self._code == ErrorCodes.KEYSTORECONSUMERNOTFOUND:
			return 'KEYSTORECONSUMERNOTFOUND'
		elif self._code == ErrorCodes.KEYSTORERESOURCEDATANOTFOUND:
			return 'KEYSTORERESOURCEDATANOTFOUND'
		elif self._code == ErrorCodes.SECURECONTEXTNOTREGISTERED:
			return 'SECURECONTEXTNOTREGISTERED'
		elif self._code == ErrorCodes.INVALIDKEYSIZE:
			return 'INVALIDKEYSIZE'
		elif self._code == ErrorCodes.INCOMPATIBLEPORTTYPES:
			return 'INCOMPATIBLEPORTTYPES'
		elif self._code == ErrorCodes.GRAPHISCYCLIC:
			return 'GRAPHISCYCLIC'
		elif self._code == ErrorCodes.INPUTNOTSET:
			return 'INPUTNOTSET'
		elif self._code == ErrorCodes.INVALIDNODECONFIGURATION:
			return 'INVALIDNODECONFIGURATION'
		else:
			return 'UNKNOWN'
	
	def get_error_description(self):
		"""Returns the error description (human-readable)"""
		if self._code == ErrorCodes.SUCCESS:
			return 'success'
		elif self._code == ErrorCodes.NOTIMPLEMENTED:
			return 'functionality not implemented'
		elif self._code == ErrorCodes.INVALIDPARAM:
			return 'an invalid parameter was passed'
		elif self._code == ErrorCodes.INVALIDCAST:
			return 'a type cast failed'
		elif self._code == ErrorCodes.BUFFERTOOSMALL:
			return 'a provided buffer is too small'
		elif self._code == ErrorCodes.GENERICEXCEPTION:
			return 'a generic exception occurred'
		elif self._code == ErrorCodes.COULDNOTLOADLIBRARY:
			return 'the library could not be loaded'
		elif self._code == ErrorCodes.COULDNOTFINDLIBRARYEXPORT:
			return 'a required exported symbol could not be found in the library'
		elif self._code == ErrorCodes.INCOMPATIBLEBINARYVERSION:
			return 'the version of the binary interface does not match the bindings interface'
		elif self._code == ErrorCodes.CALCULATIONABORTED:
			return 'a calculation has been aborted'
		elif self._code == ErrorCodes.SHOULDNOTBECALLED:
			return 'functionality should not be called'
		elif self._code == ErrorCodes.READERCLASSUNKNOWN:
			return 'the queried reader class is unknown'
		elif self._code == ErrorCodes.WRITERCLASSUNKNOWN:
			return 'the queried writer class is unknown'
		elif self._code == ErrorCodes.ITERATORINVALIDINDEX:
			return 'the current index of an iterator is invalid'
		elif self._code == ErrorCodes.INVALIDMODELRESOURCE:
			return 'no Model Resource has been given'
		elif self._code == ErrorCodes.RESOURCENOTFOUND:
			return 'Resource not found'
		elif self._code == ErrorCodes.INVALIDMODEL:
			return 'A model is invalid'
		elif self._code == ErrorCodes.INVALIDOBJECT:
			return 'An object is invalid'
		elif self._code == ErrorCodes.INVALIDMESHOBJECT:
			return 'A mesh object is invalid'
		elif self._code == ErrorCodes.INVALIDCOMPONENTSOBJECT:
			return 'A components object is invalid'
		elif self._code == ErrorCodes.INVALIDCOMPONENT:
			return 'A component is invalid'
		elif self._code == ErrorCodes.INVALIDBUILDITEM:
			return 'A build item is invalid'
		elif self._code == ErrorCodes.INVALIDBASEMATERIALGROUP:
			return 'A basematerialgroup is invalid'
		elif self._code == ErrorCodes.INVALIDSLICESTACKRESOURCE:
			return 'A slicestack resource is invalid'
		elif self._code == ErrorCodes.INVALIDTEXTURERESOURCE:
			return 'A texture resource is invalid'
		elif self._code == ErrorCodes.INVALIDCOLORGROUP:
			return 'A color group resource is invalid'
		elif self._code == ErrorCodes.INVALIDTEXTURE2DGROUP:
			return 'A texture2d group resource is invalid'
		elif self._code == ErrorCodes.INVALIDCOMPOSITEMATERIALS:
			return 'A composite materials resource is invalid'
		elif self._code == ErrorCodes.INVALIDMULTIPROPERTYGROUP:
			return 'A MultiPropertyGroup resource is invalid'
		elif self._code == ErrorCodes.INVALIDRESOURCEINDEX:
			return 'A resource index is invalid'
		elif self._code == ErrorCodes.ATTACHMENTNOTFOUND:
			return 'Attachment not found'
		elif self._code == ErrorCodes.FORBIDDENCYCLICREFERENCE:
			return 'A component references one of its ancestors'
		elif self._code == ErrorCodes.INVALIDATTACHMENTSTREAM:
			return 'An attachment stream is invalid'
		elif self._code == ErrorCodes.INVALIDPROPERTYCOUNT:
			return 'Invalid property count.'
		elif self._code == ErrorCodes.UNKOWNPROGRESSIDENTIFIER:
			return 'A progress identifier is unknown'
		elif self._code == ErrorCodes.ELEMENTCOUNTEXCEEDSLIMIT:
			return 'An element buffer exceeds its spec limit'
		elif self._code == ErrorCodes.INVALIDRESOURCE:
			return 'A resource is invalid'
		elif self._code == ErrorCodes.INVALIDLEVELSET:
			return 'A level set is invalid'
		elif self._code == ErrorCodes.COULDNOTFINDTRIANGLESET:
			return 'Could not find triangle set'
		elif self._code == ErrorCodes.INVALIDTRIANGLESETINDEX:
			return 'Invalid triangle set index'
		elif self._code == ErrorCodes.BEAMLATTICE_INVALID_OBJECTTYPE:
			return 'This object type is not valid for beamlattices'
		elif self._code == ErrorCodes.INVALIDKEYSTORE:
			return 'The keystore object is invalid'
		elif self._code == ErrorCodes.INVALIDKEYSTORECONSUMER:
			return 'The consumer keystore object is invalid'
		elif self._code == ErrorCodes.KEYSTORECONSUMERNOTFOUND:
			return 'A consumer has not been found'
		elif self._code == ErrorCodes.KEYSTORERESOURCEDATANOTFOUND:
			return 'A resource data has not been found'
		elif self._code == ErrorCodes.SECURECONTEXTNOTREGISTERED:
			return 'A Key or Conentent encryption callback has not been registered'
		elif self._code == ErrorCodes.INVALIDKEYSIZE:
			return 'The key size is invalid'
		elif self._code == ErrorCodes.INCOMPATIBLEPORTTYPES:
			return 'Link could not be added, the port types are incompatible'
		elif self._code == ErrorCodes.GRAPHISCYCLIC:
			return 'The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.'
		elif self._code == ErrorCodes.INPUTNOTSET:
			return 'The input of a node is not set.'
		elif self._code == ErrorCodes.INVALIDNODECONFIGURATION:
			return 'The selected node configuration is not supported'
		else:
			return 'unknown error'
	
	@property
	def error_code(self):
		"""Property to access error code"""
		return self._code
	
	@property
	def error_message(self):
		"""Property to access custom error message"""
		return self._message
	
	@property
	def error_name(self):
		"""Property to access error name"""
		return self.get_error_name()
	
	@property
	def error_description(self):
		"""Property to access error description"""
		return self.get_error_description()

'''Definition of binding API version
'''
class BindingVersion(enum.IntEnum):
	MAJOR = 2
	MINOR = 5
	MICRO = 0

'''Definition Error Codes
'''
class ErrorCodes(enum.IntEnum):
	SUCCESS = 0
	NOTIMPLEMENTED = 1
	INVALIDPARAM = 2
	INVALIDCAST = 3
	BUFFERTOOSMALL = 4
	GENERICEXCEPTION = 5
	COULDNOTLOADLIBRARY = 6
	COULDNOTFINDLIBRARYEXPORT = 7
	INCOMPATIBLEBINARYVERSION = 8
	CALCULATIONABORTED = 10
	SHOULDNOTBECALLED = 11
	READERCLASSUNKNOWN = 100
	WRITERCLASSUNKNOWN = 101
	ITERATORINVALIDINDEX = 102
	INVALIDMODELRESOURCE = 103
	RESOURCENOTFOUND = 104
	INVALIDMODEL = 105
	INVALIDOBJECT = 106
	INVALIDMESHOBJECT = 107
	INVALIDCOMPONENTSOBJECT = 108
	INVALIDCOMPONENT = 109
	INVALIDBUILDITEM = 110
	INVALIDBASEMATERIALGROUP = 111
	INVALIDSLICESTACKRESOURCE = 112
	INVALIDTEXTURERESOURCE = 113
	INVALIDCOLORGROUP = 114
	INVALIDTEXTURE2DGROUP = 115
	INVALIDCOMPOSITEMATERIALS = 116
	INVALIDMULTIPROPERTYGROUP = 117
	INVALIDRESOURCEINDEX = 120
	ATTACHMENTNOTFOUND = 121
	FORBIDDENCYCLICREFERENCE = 130
	INVALIDATTACHMENTSTREAM = 131
	INVALIDPROPERTYCOUNT = 132
	UNKOWNPROGRESSIDENTIFIER = 140
	ELEMENTCOUNTEXCEEDSLIMIT = 141
	INVALIDRESOURCE = 142
	INVALIDLEVELSET = 143
	COULDNOTFINDTRIANGLESET = 144
	INVALIDTRIANGLESETINDEX = 145
	BEAMLATTICE_INVALID_OBJECTTYPE = 2000
	INVALIDKEYSTORE = 3000
	INVALIDKEYSTORECONSUMER = 3001
	KEYSTORECONSUMERNOTFOUND = 3002
	KEYSTORERESOURCEDATANOTFOUND = 3003
	SECURECONTEXTNOTREGISTERED = 3004
	INVALIDKEYSIZE = 3005
	INCOMPATIBLEPORTTYPES = 4000
	GRAPHISCYCLIC = 4001
	INPUTNOTSET = 4002
	INVALIDNODECONFIGURATION = 4003

'''Definition of Function Table
'''
class FunctionTable:
	lib3mf_getlibraryversion = None
	lib3mf_getprereleaseinformation = None
	lib3mf_getbuildinformation = None
	lib3mf_getspecificationversion = None
	lib3mf_createmodel = None
	lib3mf_release = None
	lib3mf_acquire = None
	lib3mf_setjournal = None
	lib3mf_getlasterror = None
	lib3mf_getsymbollookupmethod = None
	lib3mf_retrieveprogressmessage = None
	lib3mf_rgbatocolor = None
	lib3mf_floatrgbatocolor = None
	lib3mf_colortorgba = None
	lib3mf_colortofloatrgba = None
	lib3mf_getidentitytransform = None
	lib3mf_getuniformscaletransform = None
	lib3mf_getscaletransform = None
	lib3mf_gettranslationtransform = None
	lib3mf_base_classtypeid = None
	lib3mf_writer_writetofile = None
	lib3mf_writer_getstreamsize = None
	lib3mf_writer_writetobuffer = None
	lib3mf_writer_writetocallback = None
	lib3mf_writer_setprogresscallback = None
	lib3mf_writer_getdecimalprecision = None
	lib3mf_writer_setdecimalprecision = None
	lib3mf_writer_setstrictmodeactive = None
	lib3mf_writer_getstrictmodeactive = None
	lib3mf_writer_getwarning = None
	lib3mf_writer_getwarningcount = None
	lib3mf_writer_addkeywrappingcallback = None
	lib3mf_writer_setcontentencryptioncallback = None
	lib3mf_reader_readfromfile = None
	lib3mf_reader_readfrombuffer = None
	lib3mf_reader_readfromcallback = None
	lib3mf_reader_setprogresscallback = None
	lib3mf_reader_addrelationtoread = None
	lib3mf_reader_removerelationtoread = None
	lib3mf_reader_setstrictmodeactive = None
	lib3mf_reader_getstrictmodeactive = None
	lib3mf_reader_getwarning = None
	lib3mf_reader_getwarningcount = None
	lib3mf_reader_addkeywrappingcallback = None
	lib3mf_reader_setcontentencryptioncallback = None
	lib3mf_packagepart_getpath = None
	lib3mf_packagepart_setpath = None
	lib3mf_resource_getresourceid = None
	lib3mf_resource_getuniqueresourceid = None
	lib3mf_resource_packagepart = None
	lib3mf_resource_setpackagepart = None
	lib3mf_resource_getmodelresourceid = None
	lib3mf_resourceiterator_movenext = None
	lib3mf_resourceiterator_moveprevious = None
	lib3mf_resourceiterator_getcurrent = None
	lib3mf_resourceiterator_clone = None
	lib3mf_resourceiterator_count = None
	lib3mf_slicestackiterator_getcurrentslicestack = None
	lib3mf_objectiterator_getcurrentobject = None
	lib3mf_meshobjectiterator_getcurrentmeshobject = None
	lib3mf_componentsobjectiterator_getcurrentcomponentsobject = None
	lib3mf_texture2diterator_getcurrenttexture2d = None
	lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = None
	lib3mf_colorgroupiterator_getcurrentcolorgroup = None
	lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = None
	lib3mf_compositematerialsiterator_getcurrentcompositematerials = None
	lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = None
	lib3mf_image3diterator_getcurrentimage3d = None
	lib3mf_functioniterator_getcurrentfunction = None
	lib3mf_levelsetiterator_getcurrentlevelset = None
	lib3mf_metadata_getnamespace = None
	lib3mf_metadata_setnamespace = None
	lib3mf_metadata_getname = None
	lib3mf_metadata_setname = None
	lib3mf_metadata_getkey = None
	lib3mf_metadata_getmustpreserve = None
	lib3mf_metadata_setmustpreserve = None
	lib3mf_metadata_gettype = None
	lib3mf_metadata_settype = None
	lib3mf_metadata_getvalue = None
	lib3mf_metadata_setvalue = None
	lib3mf_metadatagroup_getmetadatacount = None
	lib3mf_metadatagroup_getmetadata = None
	lib3mf_metadatagroup_getmetadatabykey = None
	lib3mf_metadatagroup_removemetadatabyindex = None
	lib3mf_metadatagroup_removemetadata = None
	lib3mf_metadatagroup_addmetadata = None
	lib3mf_triangleset_setname = None
	lib3mf_triangleset_getname = None
	lib3mf_triangleset_setidentifier = None
	lib3mf_triangleset_getidentifier = None
	lib3mf_triangleset_addtriangle = None
	lib3mf_triangleset_removetriangle = None
	lib3mf_triangleset_clear = None
	lib3mf_triangleset_settrianglelist = None
	lib3mf_triangleset_gettrianglelist = None
	lib3mf_triangleset_addtrianglelist = None
	lib3mf_triangleset_merge = None
	lib3mf_triangleset_deleteset = None
	lib3mf_triangleset_duplicate = None
	lib3mf_object_gettype = None
	lib3mf_object_settype = None
	lib3mf_object_getname = None
	lib3mf_object_setname = None
	lib3mf_object_getpartnumber = None
	lib3mf_object_setpartnumber = None
	lib3mf_object_ismeshobject = None
	lib3mf_object_iscomponentsobject = None
	lib3mf_object_islevelsetobject = None
	lib3mf_object_isvalid = None
	lib3mf_object_setattachmentasthumbnail = None
	lib3mf_object_getthumbnailattachment = None
	lib3mf_object_clearthumbnailattachment = None
	lib3mf_object_getoutbox = None
	lib3mf_object_getuuid = None
	lib3mf_object_setuuid = None
	lib3mf_object_getmetadatagroup = None
	lib3mf_object_setslicesmeshresolution = None
	lib3mf_object_getslicesmeshresolution = None
	lib3mf_object_hasslices = None
	lib3mf_object_clearslicestack = None
	lib3mf_object_getslicestack = None
	lib3mf_object_assignslicestack = None
	lib3mf_meshobject_getvertexcount = None
	lib3mf_meshobject_gettrianglecount = None
	lib3mf_meshobject_getvertex = None
	lib3mf_meshobject_setvertex = None
	lib3mf_meshobject_addvertex = None
	lib3mf_meshobject_getvertices = None
	lib3mf_meshobject_gettriangle = None
	lib3mf_meshobject_settriangle = None
	lib3mf_meshobject_addtriangle = None
	lib3mf_meshobject_gettriangleindices = None
	lib3mf_meshobject_setobjectlevelproperty = None
	lib3mf_meshobject_getobjectlevelproperty = None
	lib3mf_meshobject_settriangleproperties = None
	lib3mf_meshobject_gettriangleproperties = None
	lib3mf_meshobject_setalltriangleproperties = None
	lib3mf_meshobject_getalltriangleproperties = None
	lib3mf_meshobject_clearallproperties = None
	lib3mf_meshobject_setgeometry = None
	lib3mf_meshobject_ismanifoldandoriented = None
	lib3mf_meshobject_beamlattice = None
	lib3mf_meshobject_getvolumedata = None
	lib3mf_meshobject_setvolumedata = None
	lib3mf_meshobject_addtriangleset = None
	lib3mf_meshobject_hastriangleset = None
	lib3mf_meshobject_findtriangleset = None
	lib3mf_meshobject_gettrianglesetcount = None
	lib3mf_meshobject_gettriangleset = None
	lib3mf_levelset_getfunction = None
	lib3mf_levelset_setfunction = None
	lib3mf_levelset_gettransform = None
	lib3mf_levelset_settransform = None
	lib3mf_levelset_getchannelname = None
	lib3mf_levelset_setchannelname = None
	lib3mf_levelset_setminfeaturesize = None
	lib3mf_levelset_getminfeaturesize = None
	lib3mf_levelset_setfallbackvalue = None
	lib3mf_levelset_getfallbackvalue = None
	lib3mf_levelset_setmeshbboxonly = None
	lib3mf_levelset_getmeshbboxonly = None
	lib3mf_levelset_setmesh = None
	lib3mf_levelset_getmesh = None
	lib3mf_levelset_getvolumedata = None
	lib3mf_levelset_setvolumedata = None
	lib3mf_beamlattice_getminlength = None
	lib3mf_beamlattice_setminlength = None
	lib3mf_beamlattice_getclipping = None
	lib3mf_beamlattice_setclipping = None
	lib3mf_beamlattice_getrepresentation = None
	lib3mf_beamlattice_setrepresentation = None
	lib3mf_beamlattice_getballoptions = None
	lib3mf_beamlattice_setballoptions = None
	lib3mf_beamlattice_getbeamcount = None
	lib3mf_beamlattice_getbeam = None
	lib3mf_beamlattice_addbeam = None
	lib3mf_beamlattice_setbeam = None
	lib3mf_beamlattice_setbeams = None
	lib3mf_beamlattice_getbeams = None
	lib3mf_beamlattice_getballcount = None
	lib3mf_beamlattice_getball = None
	lib3mf_beamlattice_addball = None
	lib3mf_beamlattice_setball = None
	lib3mf_beamlattice_setballs = None
	lib3mf_beamlattice_getballs = None
	lib3mf_beamlattice_getbeamsetcount = None
	lib3mf_beamlattice_addbeamset = None
	lib3mf_beamlattice_getbeamset = None
	lib3mf_functionreference_getfunctionresourceid = None
	lib3mf_functionreference_setfunctionresourceid = None
	lib3mf_functionreference_gettransform = None
	lib3mf_functionreference_settransform = None
	lib3mf_functionreference_getchannelname = None
	lib3mf_functionreference_setchannelname = None
	lib3mf_functionreference_setminfeaturesize = None
	lib3mf_functionreference_getminfeaturesize = None
	lib3mf_functionreference_setfallbackvalue = None
	lib3mf_functionreference_getfallbackvalue = None
	lib3mf_volumedatacomposite_getbasematerialgroup = None
	lib3mf_volumedatacomposite_setbasematerialgroup = None
	lib3mf_volumedatacomposite_getmaterialmappingcount = None
	lib3mf_volumedatacomposite_getmaterialmapping = None
	lib3mf_volumedatacomposite_addmaterialmapping = None
	lib3mf_volumedatacomposite_removematerialmapping = None
	lib3mf_volumedataproperty_getname = None
	lib3mf_volumedataproperty_setisrequired = None
	lib3mf_volumedataproperty_isrequired = None
	lib3mf_volumedata_getcomposite = None
	lib3mf_volumedata_createnewcomposite = None
	lib3mf_volumedata_removecomposite = None
	lib3mf_volumedata_getcolor = None
	lib3mf_volumedata_createnewcolor = None
	lib3mf_volumedata_removecolor = None
	lib3mf_volumedata_getpropertycount = None
	lib3mf_volumedata_getproperty = None
	lib3mf_volumedata_addpropertyfromfunction = None
	lib3mf_volumedata_removeproperty = None
	lib3mf_component_getobjectresource = None
	lib3mf_component_getobjectresourceid = None
	lib3mf_component_getuuid = None
	lib3mf_component_setuuid = None
	lib3mf_component_hastransform = None
	lib3mf_component_gettransform = None
	lib3mf_component_settransform = None
	lib3mf_componentsobject_addcomponent = None
	lib3mf_componentsobject_getcomponent = None
	lib3mf_componentsobject_getcomponentcount = None
	lib3mf_beamset_setname = None
	lib3mf_beamset_getname = None
	lib3mf_beamset_setidentifier = None
	lib3mf_beamset_getidentifier = None
	lib3mf_beamset_getreferencecount = None
	lib3mf_beamset_setreferences = None
	lib3mf_beamset_getreferences = None
	lib3mf_beamset_getballreferencecount = None
	lib3mf_beamset_setballreferences = None
	lib3mf_beamset_getballreferences = None
	lib3mf_basematerialgroup_getcount = None
	lib3mf_basematerialgroup_getallpropertyids = None
	lib3mf_basematerialgroup_addmaterial = None
	lib3mf_basematerialgroup_removematerial = None
	lib3mf_basematerialgroup_getname = None
	lib3mf_basematerialgroup_setname = None
	lib3mf_basematerialgroup_setdisplaycolor = None
	lib3mf_basematerialgroup_getdisplaycolor = None
	lib3mf_colorgroup_getcount = None
	lib3mf_colorgroup_getallpropertyids = None
	lib3mf_colorgroup_addcolor = None
	lib3mf_colorgroup_removecolor = None
	lib3mf_colorgroup_setcolor = None
	lib3mf_colorgroup_getcolor = None
	lib3mf_texture2dgroup_getcount = None
	lib3mf_texture2dgroup_getallpropertyids = None
	lib3mf_texture2dgroup_addtex2coord = None
	lib3mf_texture2dgroup_gettex2coord = None
	lib3mf_texture2dgroup_removetex2coord = None
	lib3mf_texture2dgroup_gettexture2d = None
	lib3mf_compositematerials_getcount = None
	lib3mf_compositematerials_getallpropertyids = None
	lib3mf_compositematerials_getbasematerialgroup = None
	lib3mf_compositematerials_addcomposite = None
	lib3mf_compositematerials_removecomposite = None
	lib3mf_compositematerials_getcomposite = None
	lib3mf_multipropertygroup_getcount = None
	lib3mf_multipropertygroup_getallpropertyids = None
	lib3mf_multipropertygroup_addmultiproperty = None
	lib3mf_multipropertygroup_setmultiproperty = None
	lib3mf_multipropertygroup_getmultiproperty = None
	lib3mf_multipropertygroup_removemultiproperty = None
	lib3mf_multipropertygroup_getlayercount = None
	lib3mf_multipropertygroup_addlayer = None
	lib3mf_multipropertygroup_getlayer = None
	lib3mf_multipropertygroup_removelayer = None
	lib3mf_image3d_getname = None
	lib3mf_image3d_setname = None
	lib3mf_image3d_isimagestack = None
	lib3mf_imagestack_getrowcount = None
	lib3mf_imagestack_setrowcount = None
	lib3mf_imagestack_getcolumncount = None
	lib3mf_imagestack_setcolumncount = None
	lib3mf_imagestack_getsheetcount = None
	lib3mf_imagestack_getsheet = None
	lib3mf_imagestack_setsheet = None
	lib3mf_imagestack_createemptysheet = None
	lib3mf_imagestack_createsheetfrombuffer = None
	lib3mf_imagestack_createsheetfromfile = None
	lib3mf_attachment_getpath = None
	lib3mf_attachment_setpath = None
	lib3mf_attachment_packagepart = None
	lib3mf_attachment_getrelationshiptype = None
	lib3mf_attachment_setrelationshiptype = None
	lib3mf_attachment_writetofile = None
	lib3mf_attachment_readfromfile = None
	lib3mf_attachment_readfromcallback = None
	lib3mf_attachment_getstreamsize = None
	lib3mf_attachment_writetobuffer = None
	lib3mf_attachment_readfrombuffer = None
	lib3mf_texture2d_getattachment = None
	lib3mf_texture2d_setattachment = None
	lib3mf_texture2d_getcontenttype = None
	lib3mf_texture2d_setcontenttype = None
	lib3mf_texture2d_gettilestyleuv = None
	lib3mf_texture2d_settilestyleuv = None
	lib3mf_texture2d_getfilter = None
	lib3mf_texture2d_setfilter = None
	lib3mf_implicitport_getidentifier = None
	lib3mf_implicitport_setidentifier = None
	lib3mf_implicitport_getdisplayname = None
	lib3mf_implicitport_setdisplayname = None
	lib3mf_implicitport_settype = None
	lib3mf_implicitport_gettype = None
	lib3mf_implicitport_getreference = None
	lib3mf_implicitport_setreference = None
	lib3mf_iterator_movenext = None
	lib3mf_iterator_moveprevious = None
	lib3mf_iterator_count = None
	lib3mf_implicitportiterator_getcurrent = None
	lib3mf_implicitnode_getidentifier = None
	lib3mf_implicitnode_setidentifier = None
	lib3mf_implicitnode_getdisplayname = None
	lib3mf_implicitnode_setdisplayname = None
	lib3mf_implicitnode_gettag = None
	lib3mf_implicitnode_settag = None
	lib3mf_implicitnode_getnodetype = None
	lib3mf_implicitnode_addinput = None
	lib3mf_implicitnode_getinputs = None
	lib3mf_implicitnode_addoutput = None
	lib3mf_implicitnode_getoutputs = None
	lib3mf_implicitnode_findinput = None
	lib3mf_implicitnode_findoutput = None
	lib3mf_implicitnode_aretypesvalid = None
	lib3mf_oneinputnode_getinputa = None
	lib3mf_oneinputnode_getoutputresult = None
	lib3mf_resourceidnode_setresource = None
	lib3mf_resourceidnode_getresource = None
	lib3mf_resourceidnode_getoutputvalue = None
	lib3mf_twoinputnode_getinputb = None
	lib3mf_selectnode_getinputb = None
	lib3mf_selectnode_getinputc = None
	lib3mf_selectnode_getinputd = None
	lib3mf_clampnode_getinputmin = None
	lib3mf_clampnode_getinputmax = None
	lib3mf_composevectornode_getinputx = None
	lib3mf_composevectornode_getinputy = None
	lib3mf_composevectornode_getinputz = None
	lib3mf_composevectornode_getoutputresult = None
	lib3mf_decomposevectornode_getinputa = None
	lib3mf_decomposevectornode_getoutputx = None
	lib3mf_decomposevectornode_getoutputy = None
	lib3mf_decomposevectornode_getoutputz = None
	lib3mf_composematrixnode_getinputm00 = None
	lib3mf_composematrixnode_getinputm01 = None
	lib3mf_composematrixnode_getinputm02 = None
	lib3mf_composematrixnode_getinputm03 = None
	lib3mf_composematrixnode_getinputm10 = None
	lib3mf_composematrixnode_getinputm11 = None
	lib3mf_composematrixnode_getinputm12 = None
	lib3mf_composematrixnode_getinputm13 = None
	lib3mf_composematrixnode_getinputm20 = None
	lib3mf_composematrixnode_getinputm21 = None
	lib3mf_composematrixnode_getinputm22 = None
	lib3mf_composematrixnode_getinputm23 = None
	lib3mf_composematrixnode_getinputm30 = None
	lib3mf_composematrixnode_getinputm31 = None
	lib3mf_composematrixnode_getinputm32 = None
	lib3mf_composematrixnode_getinputm33 = None
	lib3mf_composematrixnode_getoutputresult = None
	lib3mf_matrixfromrowsnode_getinputa = None
	lib3mf_matrixfromrowsnode_getinputb = None
	lib3mf_matrixfromrowsnode_getinputc = None
	lib3mf_matrixfromrowsnode_getinputd = None
	lib3mf_matrixfromrowsnode_getoutputresult = None
	lib3mf_matrixfromcolumnsnode_getinputa = None
	lib3mf_matrixfromcolumnsnode_getinputb = None
	lib3mf_matrixfromcolumnsnode_getinputc = None
	lib3mf_matrixfromcolumnsnode_getinputd = None
	lib3mf_matrixfromcolumnsnode_getoutputresult = None
	lib3mf_constantnode_setconstant = None
	lib3mf_constantnode_getconstant = None
	lib3mf_constantnode_getoutputvalue = None
	lib3mf_constvecnode_setvector = None
	lib3mf_constvecnode_getvector = None
	lib3mf_constvecnode_getoutputvector = None
	lib3mf_constmatnode_setmatrix = None
	lib3mf_constmatnode_getmatrix = None
	lib3mf_constmatnode_getoutputmatrix = None
	lib3mf_meshnode_getinputmesh = None
	lib3mf_meshnode_getinputpos = None
	lib3mf_meshnode_getoutputdistance = None
	lib3mf_unsignedmeshnode_getinputmesh = None
	lib3mf_unsignedmeshnode_getinputpos = None
	lib3mf_unsignedmeshnode_getoutputdistance = None
	lib3mf_beamlatticenode_getinputbeamlattice = None
	lib3mf_beamlatticenode_getinputpos = None
	lib3mf_beamlatticenode_getoutputdistance = None
	lib3mf_beamlatticenode_setaccuraterange = None
	lib3mf_beamlatticenode_getaccuraterange = None
	lib3mf_functiongradientnode_getinputfunctionid = None
	lib3mf_functiongradientnode_getinputpos = None
	lib3mf_functiongradientnode_getinputstep = None
	lib3mf_functiongradientnode_setscalaroutputname = None
	lib3mf_functiongradientnode_getscalaroutputname = None
	lib3mf_functiongradientnode_setvectorinputname = None
	lib3mf_functiongradientnode_getvectorinputname = None
	lib3mf_functiongradientnode_getoutputnormalizedgradient = None
	lib3mf_functiongradientnode_getoutputgradient = None
	lib3mf_functiongradientnode_getoutputmagnitude = None
	lib3mf_normalizedistancenode_getinputfunctionid = None
	lib3mf_normalizedistancenode_getinputpos = None
	lib3mf_normalizedistancenode_getinputstep = None
	lib3mf_normalizedistancenode_setscalaroutputname = None
	lib3mf_normalizedistancenode_getscalaroutputname = None
	lib3mf_normalizedistancenode_setvectorinputname = None
	lib3mf_normalizedistancenode_getvectorinputname = None
	lib3mf_normalizedistancenode_getoutputresult = None
	lib3mf_functioncallnode_getinputfunctionid = None
	lib3mf_nodeiterator_getcurrent = None
	lib3mf_function_getdisplayname = None
	lib3mf_function_setdisplayname = None
	lib3mf_function_addinput = None
	lib3mf_function_getinputs = None
	lib3mf_function_removeinput = None
	lib3mf_function_addoutput = None
	lib3mf_function_getoutputs = None
	lib3mf_function_removeoutput = None
	lib3mf_function_findinput = None
	lib3mf_function_findoutput = None
	lib3mf_implicitfunction_getidentifier = None
	lib3mf_implicitfunction_setidentifier = None
	lib3mf_implicitfunction_addnode = None
	lib3mf_implicitfunction_addsinnode = None
	lib3mf_implicitfunction_addcosnode = None
	lib3mf_implicitfunction_addtannode = None
	lib3mf_implicitfunction_addarcsinnode = None
	lib3mf_implicitfunction_addarccosnode = None
	lib3mf_implicitfunction_addarctan2node = None
	lib3mf_implicitfunction_addsinhnode = None
	lib3mf_implicitfunction_addcoshnode = None
	lib3mf_implicitfunction_addtanhnode = None
	lib3mf_implicitfunction_addroundnode = None
	lib3mf_implicitfunction_addceilnode = None
	lib3mf_implicitfunction_addfloornode = None
	lib3mf_implicitfunction_addsignnode = None
	lib3mf_implicitfunction_addfractnode = None
	lib3mf_implicitfunction_addabsnode = None
	lib3mf_implicitfunction_addexpnode = None
	lib3mf_implicitfunction_addlognode = None
	lib3mf_implicitfunction_addlog2node = None
	lib3mf_implicitfunction_addlog10node = None
	lib3mf_implicitfunction_addlengthnode = None
	lib3mf_implicitfunction_addtransposenode = None
	lib3mf_implicitfunction_addinversenode = None
	lib3mf_implicitfunction_addsqrtnode = None
	lib3mf_implicitfunction_addresourceidnode = None
	lib3mf_implicitfunction_addadditionnode = None
	lib3mf_implicitfunction_addsubtractionnode = None
	lib3mf_implicitfunction_addmultiplicationnode = None
	lib3mf_implicitfunction_adddivisionnode = None
	lib3mf_implicitfunction_adddotnode = None
	lib3mf_implicitfunction_addcrossnode = None
	lib3mf_implicitfunction_addmatvecmultiplicationnode = None
	lib3mf_implicitfunction_addminnode = None
	lib3mf_implicitfunction_addmaxnode = None
	lib3mf_implicitfunction_addfmodnode = None
	lib3mf_implicitfunction_addpownode = None
	lib3mf_implicitfunction_addselectnode = None
	lib3mf_implicitfunction_addclampnode = None
	lib3mf_implicitfunction_addcomposevectornode = None
	lib3mf_implicitfunction_addvectorfromscalarnode = None
	lib3mf_implicitfunction_adddecomposevectornode = None
	lib3mf_implicitfunction_addcomposematrixnode = None
	lib3mf_implicitfunction_addmatrixfromrowsnode = None
	lib3mf_implicitfunction_addmatrixfromcolumnsnode = None
	lib3mf_implicitfunction_addconstantnode = None
	lib3mf_implicitfunction_addconstvecnode = None
	lib3mf_implicitfunction_addconstmatnode = None
	lib3mf_implicitfunction_addmeshnode = None
	lib3mf_implicitfunction_addunsignedmeshnode = None
	lib3mf_implicitfunction_addbeamlatticenode = None
	lib3mf_implicitfunction_addfunctiongradientnode = None
	lib3mf_implicitfunction_addnormalizedistancenode = None
	lib3mf_implicitfunction_addfunctioncallnode = None
	lib3mf_implicitfunction_getnodes = None
	lib3mf_implicitfunction_removenode = None
	lib3mf_implicitfunction_addlink = None
	lib3mf_implicitfunction_addlinkbynames = None
	lib3mf_implicitfunction_clear = None
	lib3mf_implicitfunction_sortnodestopologically = None
	lib3mf_functionfromimage3d_getimage3d = None
	lib3mf_functionfromimage3d_setimage3d = None
	lib3mf_functionfromimage3d_setfilter = None
	lib3mf_functionfromimage3d_getfilter = None
	lib3mf_functionfromimage3d_settilestyles = None
	lib3mf_functionfromimage3d_gettilestyles = None
	lib3mf_functionfromimage3d_getoffset = None
	lib3mf_functionfromimage3d_setoffset = None
	lib3mf_functionfromimage3d_getscale = None
	lib3mf_functionfromimage3d_setscale = None
	lib3mf_builditem_getobjectresource = None
	lib3mf_builditem_getuuid = None
	lib3mf_builditem_setuuid = None
	lib3mf_builditem_getobjectresourceid = None
	lib3mf_builditem_hasobjecttransform = None
	lib3mf_builditem_getobjecttransform = None
	lib3mf_builditem_setobjecttransform = None
	lib3mf_builditem_getpartnumber = None
	lib3mf_builditem_setpartnumber = None
	lib3mf_builditem_getmetadatagroup = None
	lib3mf_builditem_getoutbox = None
	lib3mf_builditemiterator_movenext = None
	lib3mf_builditemiterator_moveprevious = None
	lib3mf_builditemiterator_getcurrent = None
	lib3mf_builditemiterator_clone = None
	lib3mf_builditemiterator_count = None
	lib3mf_slice_setvertices = None
	lib3mf_slice_getvertices = None
	lib3mf_slice_getvertexcount = None
	lib3mf_slice_addpolygon = None
	lib3mf_slice_getpolygoncount = None
	lib3mf_slice_setpolygonindices = None
	lib3mf_slice_getpolygonindices = None
	lib3mf_slice_getpolygonindexcount = None
	lib3mf_slice_getztop = None
	lib3mf_slicestack_getbottomz = None
	lib3mf_slicestack_getslicecount = None
	lib3mf_slicestack_getslice = None
	lib3mf_slicestack_addslice = None
	lib3mf_slicestack_getslicerefcount = None
	lib3mf_slicestack_addslicestackreference = None
	lib3mf_slicestack_getslicestackreference = None
	lib3mf_slicestack_collapseslicereferences = None
	lib3mf_slicestack_setownpath = None
	lib3mf_slicestack_getownpath = None
	lib3mf_consumer_getconsumerid = None
	lib3mf_consumer_getkeyid = None
	lib3mf_consumer_getkeyvalue = None
	lib3mf_accessright_getconsumer = None
	lib3mf_accessright_getwrappingalgorithm = None
	lib3mf_accessright_getmgfalgorithm = None
	lib3mf_accessright_getdigestmethod = None
	lib3mf_contentencryptionparams_getencryptionalgorithm = None
	lib3mf_contentencryptionparams_getkey = None
	lib3mf_contentencryptionparams_getinitializationvector = None
	lib3mf_contentencryptionparams_getauthenticationtag = None
	lib3mf_contentencryptionparams_setauthenticationtag = None
	lib3mf_contentencryptionparams_getadditionalauthenticationdata = None
	lib3mf_contentencryptionparams_getdescriptor = None
	lib3mf_contentencryptionparams_getkeyuuid = None
	lib3mf_resourcedata_getpath = None
	lib3mf_resourcedata_getencryptionalgorithm = None
	lib3mf_resourcedata_getcompression = None
	lib3mf_resourcedata_getadditionalauthenticationdata = None
	lib3mf_resourcedatagroup_getkeyuuid = None
	lib3mf_resourcedatagroup_addaccessright = None
	lib3mf_resourcedatagroup_findaccessrightbyconsumer = None
	lib3mf_resourcedatagroup_removeaccessright = None
	lib3mf_keystore_addconsumer = None
	lib3mf_keystore_getconsumercount = None
	lib3mf_keystore_getconsumer = None
	lib3mf_keystore_removeconsumer = None
	lib3mf_keystore_findconsumer = None
	lib3mf_keystore_getresourcedatagroupcount = None
	lib3mf_keystore_addresourcedatagroup = None
	lib3mf_keystore_getresourcedatagroup = None
	lib3mf_keystore_removeresourcedatagroup = None
	lib3mf_keystore_findresourcedatagroup = None
	lib3mf_keystore_addresourcedata = None
	lib3mf_keystore_removeresourcedata = None
	lib3mf_keystore_findresourcedata = None
	lib3mf_keystore_getresourcedatacount = None
	lib3mf_keystore_getresourcedata = None
	lib3mf_keystore_getuuid = None
	lib3mf_keystore_setuuid = None
	lib3mf_model_rootmodelpart = None
	lib3mf_model_findorcreatepackagepart = None
	lib3mf_model_setunit = None
	lib3mf_model_getunit = None
	lib3mf_model_getlanguage = None
	lib3mf_model_setlanguage = None
	lib3mf_model_querywriter = None
	lib3mf_model_queryreader = None
	lib3mf_model_getresourcebyid = None
	lib3mf_model_gettexture2dbyid = None
	lib3mf_model_getpropertytypebyid = None
	lib3mf_model_getbasematerialgroupbyid = None
	lib3mf_model_gettexture2dgroupbyid = None
	lib3mf_model_getcompositematerialsbyid = None
	lib3mf_model_getmultipropertygroupbyid = None
	lib3mf_model_getmeshobjectbyid = None
	lib3mf_model_getcomponentsobjectbyid = None
	lib3mf_model_getcolorgroupbyid = None
	lib3mf_model_getslicestackbyid = None
	lib3mf_model_getlevelsetbyid = None
	lib3mf_model_getbuilduuid = None
	lib3mf_model_setbuilduuid = None
	lib3mf_model_getbuilditems = None
	lib3mf_model_getoutbox = None
	lib3mf_model_getresources = None
	lib3mf_model_getobjects = None
	lib3mf_model_getmeshobjects = None
	lib3mf_model_getcomponentsobjects = None
	lib3mf_model_gettexture2ds = None
	lib3mf_model_getbasematerialgroups = None
	lib3mf_model_getcolorgroups = None
	lib3mf_model_gettexture2dgroups = None
	lib3mf_model_getcompositematerials = None
	lib3mf_model_getmultipropertygroups = None
	lib3mf_model_getslicestacks = None
	lib3mf_model_getimage3ds = None
	lib3mf_model_mergetomodel = None
	lib3mf_model_mergefrommodel = None
	lib3mf_model_addmeshobject = None
	lib3mf_model_addcomponentsobject = None
	lib3mf_model_addslicestack = None
	lib3mf_model_addtexture2dfromattachment = None
	lib3mf_model_addbasematerialgroup = None
	lib3mf_model_addcolorgroup = None
	lib3mf_model_addtexture2dgroup = None
	lib3mf_model_addcompositematerials = None
	lib3mf_model_addmultipropertygroup = None
	lib3mf_model_addimagestack = None
	lib3mf_model_getimagestackbyid = None
	lib3mf_model_addbuilditem = None
	lib3mf_model_removebuilditem = None
	lib3mf_model_getmetadatagroup = None
	lib3mf_model_addattachment = None
	lib3mf_model_removeattachment = None
	lib3mf_model_getattachment = None
	lib3mf_model_findattachment = None
	lib3mf_model_getattachmentcount = None
	lib3mf_model_haspackagethumbnailattachment = None
	lib3mf_model_createpackagethumbnailattachment = None
	lib3mf_model_getpackagethumbnailattachment = None
	lib3mf_model_removepackagethumbnailattachment = None
	lib3mf_model_addcustomcontenttype = None
	lib3mf_model_removecustomcontenttype = None
	lib3mf_model_setrandomnumbercallback = None
	lib3mf_model_getkeystore = None
	lib3mf_model_getfunctions = None
	lib3mf_model_addimplicitfunction = None
	lib3mf_model_addfunctionfromimage3d = None
	lib3mf_model_addvolumedata = None
	lib3mf_model_addlevelset = None
	lib3mf_model_getlevelsets = None
	lib3mf_model_removeresource = None

'''Definition of Enumerations
'''

'''Definition of base enumeration for ctypes
'''
class CTypesEnum(enum.IntEnum):
	def from_param(obj):
		return int(obj)

'''Definition of PropertyType
'''
class PropertyType(CTypesEnum):
	NoPropertyType = 0
	BaseMaterial = 1
	TexCoord = 2
	Colors = 3
	Composite = 4
	Multi = 5
'''Definition of SlicesMeshResolution
'''
class SlicesMeshResolution(CTypesEnum):
	Fullres = 0
	Lowres = 1
'''Definition of ModelUnit
'''
class ModelUnit(CTypesEnum):
	MicroMeter = 0
	MilliMeter = 1
	CentiMeter = 2
	Inch = 3
	Foot = 4
	Meter = 5
'''Definition of ObjectType
'''
class ObjectType(CTypesEnum):
	Other = 0
	Model = 1
	Support = 2
	SolidSupport = 3
	Surface = 4
'''Definition of TextureType
'''
class TextureType(CTypesEnum):
	Unknown = 0
	PNG = 1
	JPEG = 2
'''Definition of TextureTileStyle
'''
class TextureTileStyle(CTypesEnum):
	Wrap = 0
	Mirror = 1
	Clamp = 2
	NoTileStyle = 3
'''Definition of TextureFilter
'''
class TextureFilter(CTypesEnum):
	Auto = 0
	Linear = 1
	Nearest = 2
'''Definition of BeamLatticeCapMode
'''
class BeamLatticeCapMode(CTypesEnum):
	Sphere = 0
	HemiSphere = 1
	Butt = 2
'''Definition of BeamLatticeClipMode
'''
class BeamLatticeClipMode(CTypesEnum):
	NoClipMode = 0
	Inside = 1
	Outside = 2
'''Definition of BeamLatticeBallMode
'''
class BeamLatticeBallMode(CTypesEnum):
	BeamLatticeBallModeNone = 0
	Mixed = 1
	All = 2
'''Definition of ProgressIdentifier
'''
class ProgressIdentifier(CTypesEnum):
	QUERYCANCELED = 0
	DONE = 1
	CLEANUP = 2
	READSTREAM = 3
	EXTRACTOPCPACKAGE = 4
	READNONROOTMODELS = 5
	READROOTMODEL = 6
	READRESOURCES = 7
	READMESH = 8
	READSLICES = 9
	READBUILD = 10
	READCUSTOMATTACHMENT = 11
	READTEXTURETACHMENTS = 12
	CREATEOPCPACKAGE = 13
	WRITEMODELSTOSTREAM = 14
	WRITEROOTMODEL = 15
	WRITENONROOTMODELS = 16
	WRITEATTACHMENTS = 17
	WRITECONTENTTYPES = 18
	WRITENOBJECTS = 19
	WRITENODES = 20
	WRITETRIANGLES = 21
	WRITESLICES = 22
	WRITEKEYSTORE = 23
'''Definition of BlendMethod
'''
class BlendMethod(CTypesEnum):
	NoBlendMethod = 0
	Mix = 1
	Multiply = 2
'''Definition of ChannelName
'''
class ChannelName(CTypesEnum):
	Red = 0
	Green = 1
	Blue = 2
	Alpha = 3
'''Definition of CompositionMethod
'''
class CompositionMethod(CTypesEnum):
	WeightedSum = 0
	Multiply = 1
	Min = 2
	Max = 3
	Mask = 4
'''Definition of CompositionSpace
'''
class CompositionSpace(CTypesEnum):
	Raw = 0
	LinearColor = 1
'''Definition of ImplicitNodeType
'''
class ImplicitNodeType(CTypesEnum):
	Addition = 0
	Subtraction = 1
	Multiplication = 2
	Division = 3
	Constant = 4
	ConstVec = 5
	ConstMat = 6
	ComposeVector = 7
	DecomposeVector = 8
	ComposeMatrix = 9
	MatrixFromColumns = 10
	MatrixFromRows = 11
	Dot = 12
	Cross = 13
	MatVecMultiplication = 14
	Transpose = 15
	Inverse = 16
	Sinus = 17
	Cosinus = 18
	Tan = 19
	ArcSin = 20
	ArcCos = 21
	ArcTan = 22
	ArcTan2 = 23
	Min = 24
	Max = 25
	Abs = 26
	Fmod = 27
	Pow = 28
	Sqrt = 29
	Exp = 30
	Log = 31
	Log2 = 32
	Log10 = 33
	Select = 34
	Clamp = 35
	Sinh = 36
	Cosh = 37
	Tanh = 38
	Round = 39
	Ceil = 40
	Floor = 41
	Sign = 42
	Fract = 43
	FunctionCall = 44
	Mesh = 45
	Length = 46
	ConstResourceID = 47
	VectorFromScalar = 48
	UnsignedMesh = 49
	Mod = 50
	BeamLattice = 51
	FunctionGradient = 52
	NormalizeDistance = 53
'''Definition of ImplicitPortType
'''
class ImplicitPortType(CTypesEnum):
	Scalar = 0
	Vector = 1
	Matrix = 2
	ResourceID = 3
'''Definition of ImplicitNodeConfiguration
'''
class ImplicitNodeConfiguration(CTypesEnum):
	Default = 0
	ScalarToScalar = 1
	VectorToVector = 2
	MatrixToMatrix = 3
'''Definition of EncryptionAlgorithm
'''
class EncryptionAlgorithm(CTypesEnum):
	AES256_GCM = 1
'''Definition of WrappingAlgorithm
'''
class WrappingAlgorithm(CTypesEnum):
	RSA_OAEP = 0
'''Definition of MgfAlgorithm
'''
class MgfAlgorithm(CTypesEnum):
	MGF1_SHA1 = 160
	MGF1_SHA224 = 224
	MGF1_SHA256 = 256
	MGF1_SHA384 = 384
	MGF1_SHA512 = 512
'''Definition of DigestMethod
'''
class DigestMethod(CTypesEnum):
	SHA1 = 160
	SHA256 = 256
'''Definition of Compression
'''
class Compression(CTypesEnum):
	NoCompression = 0
	Deflate = 1

'''Definition of Structs
'''
'''Definition of Triangle
'''
class Triangle(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Indices", ctypes.c_uint32 * 3)
	]
'''Definition of TriangleProperties
'''
class TriangleProperties(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("ResourceID", ctypes.c_uint32), 
		("PropertyIDs", ctypes.c_uint32 * 3)
	]
'''Definition of Position
'''
class Position(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Coordinates", ctypes.c_float * 3)
	]
'''Definition of Position2D
'''
class Position2D(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Coordinates", ctypes.c_float * 2)
	]
'''Definition of CompositeConstituent
'''
class CompositeConstituent(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("PropertyID", ctypes.c_uint32), 
		("MixingRatio", ctypes.c_double)
	]
'''Definition of MultiPropertyLayer
'''
class MultiPropertyLayer(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("ResourceID", ctypes.c_uint32), 
		("TheBlendMethod", ctypes.c_int32)
	]
'''Definition of Tex2Coord
'''
class Tex2Coord(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("U", ctypes.c_double), 
		("V", ctypes.c_double)
	]
'''Definition of Transform
'''
class Transform(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Fields", (ctypes.c_float * 3) * 4)
	]
'''Definition of Box
'''
class Box(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("MinCoordinate", ctypes.c_float * 3), 
		("MaxCoordinate", ctypes.c_float * 3)
	]
'''Definition of Color
'''
class Color(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Red", ctypes.c_uint8), 
		("Green", ctypes.c_uint8), 
		("Blue", ctypes.c_uint8), 
		("Alpha", ctypes.c_uint8)
	]
'''Definition of Beam
'''
class Beam(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Indices", ctypes.c_uint32 * 2), 
		("Radii", ctypes.c_double * 2), 
		("CapModes", ctypes.c_int32 * 2)
	]
'''Definition of Ball
'''
class Ball(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Index", ctypes.c_uint32), 
		("Radius", ctypes.c_double)
	]
'''Definition of Vector
'''
class Vector(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Coordinates", ctypes.c_double * 3)
	]
'''Definition of Matrix4x4
'''
class Matrix4x4(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Field", (ctypes.c_double * 4) * 4)
	]

'''Definition of Function Types
'''
'''Definition of ProgressCallback
		A callback function
'''
ProgressCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_double, ProgressIdentifier, ctypes.c_void_p)
'''Definition of WriteCallback
		Callback to call for writing a data chunk
'''
WriteCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of ReadCallback
		Callback to call for reading a data chunk
'''
ReadCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of SeekCallback
		Callback to call for seeking in the stream
'''
SeekCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_void_p)
'''Definition of RandomNumberCallback
		Callback to generate random numbers
'''
RandomNumberCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
'''Definition of KeyWrappingCallback
		A callback used to wrap (encrypt) the content key available in keystore resource group
'''
KeyWrappingCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
'''Definition of ContentEncryptionCallback
		A callback to encrypt/decrypt content called on each resource encrypted. This might be called several times depending on content size. If Input is not available(either null or size is 0), clients must return the result of authenticated tag generation/validation.
'''
ContentEncryptionCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))


'''Wrapper Class Implementation
'''
class Wrapper:

	def __init__(self, libraryName = None, symbolLookupMethodAddress = None):
		ending = ''
		if platform.system() == 'Windows':
			ending = 'dll'
		elif platform.system() == 'Linux':
			ending = 'so'
		elif platform.system() == 'Darwin':
			ending = 'dylib'
		else:
			raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY)
		
		if (not libraryName) and (not symbolLookupMethodAddress):
			libraryName = os.path.join(os.path.dirname(os.path.realpath(__file__)),'lib3mf')
		
		if libraryName is not None:
			path = libraryName + '.' + ending
			try:
				self.lib = ctypes.CDLL(path)
			except Exception as e:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(e) + '| "'+path + '"' )
			
			self._loadFunctionTable()
		elif symbolLookupMethodAddress is not None:
				self.lib = FunctionTable()
				self._loadFunctionTableFromMethod(symbolLookupMethodAddress)
		else:
			raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(e))
		
		self._checkBinaryVersion()
	
	def _loadFunctionTableFromMethod(self, symbolLookupMethodAddress):
		try:
			symbolLookupMethodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			symbolLookupMethod = symbolLookupMethodType(int(symbolLookupMethodAddress))
			
			methodAddress = ctypes.c_void_p()
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getlibraryversion")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_getlibraryversion = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getprereleaseinformation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_getprereleaseinformation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getbuildinformation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_getbuildinformation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getspecificationversion")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_getspecificationversion = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_createmodel")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_createmodel = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_release")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_release = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_acquire")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_acquire = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_setjournal")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p)
			self.lib.lib3mf_setjournal = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getlasterror")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_getlasterror = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getsymbollookupmethod")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_getsymbollookupmethod = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_retrieveprogressmessage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ProgressIdentifier, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_retrieveprogressmessage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_rgbatocolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.POINTER(Color))
			self.lib.lib3mf_rgbatocolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_floatrgbatocolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Color))
			self.lib.lib3mf_floatrgbatocolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colortorgba")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_colortorgba = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colortofloatrgba")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float))
			self.lib.lib3mf_colortofloatrgba = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getidentitytransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(Transform))
			self.lib.lib3mf_getidentitytransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getuniformscaletransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_getuniformscaletransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_getscaletransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_getscaletransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_gettranslationtransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform))
			self.lib.lib3mf_gettranslationtransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_base_classtypeid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_base_classtypeid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetofile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_writer_writetofile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getstreamsize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_writer_getstreamsize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetobuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_writer_writetobuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_writetocallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, WriteCallback, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_writetocallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setprogresscallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ProgressCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_setprogresscallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getdecimalprecision")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_writer_getdecimalprecision = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setdecimalprecision")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_writer_setdecimalprecision = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_writer_setstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_writer_getstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getwarning")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_writer_getwarning = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_getwarningcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_writer_getwarningcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_addkeywrappingcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_addkeywrappingcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_writer_setcontentencryptioncallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p)
			self.lib.lib3mf_writer_setcontentencryptioncallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfromfile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_readfromfile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfrombuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_reader_readfrombuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_readfromcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_readfromcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setprogresscallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ProgressCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_setprogresscallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_addrelationtoread")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_addrelationtoread = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_removerelationtoread")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_reader_removerelationtoread = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_reader_setstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getstrictmodeactive")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_reader_getstrictmodeactive = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getwarning")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_reader_getwarning = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_getwarningcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_reader_getwarningcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_addkeywrappingcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_addkeywrappingcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_reader_setcontentencryptioncallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p)
			self.lib.lib3mf_reader_setcontentencryptioncallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_packagepart_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_packagepart_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_packagepart_setpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_packagepart_setpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getuniqueresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getuniqueresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_packagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resource_packagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_setpackagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_resource_setpackagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resource_getmodelresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_resource_getmodelresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_movenext")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_resourceiterator_movenext = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_moveprevious")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_resourceiterator_moveprevious = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_clone")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceiterator_clone = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceiterator_count")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_resourceiterator_count = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestackiterator_getcurrentslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_objectiterator_getcurrentobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_objectiterator_getcurrentobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobjectiterator_getcurrentmeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobjectiterator_getcurrentcomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2diterator_getcurrenttexture2d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroupiterator_getcurrentcolorgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerialsiterator_getcurrentcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_image3diterator_getcurrentimage3d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_image3diterator_getcurrentimage3d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functioniterator_getcurrentfunction")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functioniterator_getcurrentfunction = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelsetiterator_getcurrentlevelset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_levelsetiterator_getcurrentlevelset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getnamespace")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getnamespace = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setnamespace")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setnamespace = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getkey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getkey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getmustpreserve")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_metadata_getmustpreserve = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setmustpreserve")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_metadata_setmustpreserve = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_gettype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_gettype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_settype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_settype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_getvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_metadata_getvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadata_setvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_metadata_setvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadatacount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_metadatagroup_getmetadatacount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_getmetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_getmetadatabykey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_getmetadatabykey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_removemetadatabyindex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_metadatagroup_removemetadatabyindex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_removemetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_metadatagroup_removemetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_metadatagroup_addmetadata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_metadatagroup_addmetadata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_triangleset_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_triangleset_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_triangleset_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_triangleset_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_addtriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_triangleset_addtriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_removetriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_triangleset_removetriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_clear")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_triangleset_clear = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_settrianglelist")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_triangleset_settrianglelist = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_gettrianglelist")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_triangleset_gettrianglelist = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_addtrianglelist")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_triangleset_addtrianglelist = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_merge")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_triangleset_merge = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_deleteset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_triangleset_deleteset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_triangleset_duplicate")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_triangleset_duplicate = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_gettype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_object_gettype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_settype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ObjectType)
			self.lib.lib3mf_object_settype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_ismeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_ismeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_iscomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_iscomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_islevelsetobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_islevelsetobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_isvalid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_isvalid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setattachmentasthumbnail")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_object_setattachmentasthumbnail = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getthumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getthumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_clearthumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_object_clearthumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_object_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_object_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_object_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_setslicesmeshresolution")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, SlicesMeshResolution)
			self.lib.lib3mf_object_setslicesmeshresolution = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getslicesmeshresolution")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_object_getslicesmeshresolution = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_hasslices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_object_hasslices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_clearslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_object_clearslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_getslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_object_getslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_object_assignslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_object_assignslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_getvertexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettrianglecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_gettrianglecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_getvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_setvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_addvertex")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Position), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_addvertex = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position))
			self.lib.lib3mf_meshobject_getvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_gettriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_settriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_settriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_addtriangle")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Triangle), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_addtriangle = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangleindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_gettriangleindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setobjectlevelproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32)
			self.lib.lib3mf_meshobject_setobjectlevelproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getobjectlevelproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_meshobject_getobjectlevelproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_settriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_settriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_gettriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setalltriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_setalltriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getalltriangleproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(TriangleProperties))
			self.lib.lib3mf_meshobject_getalltriangleproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_clearallproperties")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_meshobject_clearallproperties = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setgeometry")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position), ctypes.c_uint64, ctypes.POINTER(Triangle))
			self.lib.lib3mf_meshobject_setgeometry = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_ismanifoldandoriented")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_meshobject_ismanifoldandoriented = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_beamlattice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_beamlattice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_getvolumedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_getvolumedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_setvolumedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_meshobject_setvolumedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_addtriangleset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_addtriangleset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_hastriangleset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_meshobject_hastriangleset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_findtriangleset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_findtriangleset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettrianglesetcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_meshobject_gettrianglesetcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshobject_gettriangleset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshobject_gettriangleset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getfunction")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_levelset_getfunction = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setfunction")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_levelset_setfunction = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_gettransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_levelset_gettransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_settransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_levelset_settransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getchannelname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_levelset_getchannelname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setchannelname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_levelset_setchannelname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setminfeaturesize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_levelset_setminfeaturesize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getminfeaturesize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_levelset_getminfeaturesize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setfallbackvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_levelset_setfallbackvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getfallbackvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_levelset_getfallbackvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setmeshbboxonly")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_levelset_setmeshbboxonly = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getmeshbboxonly")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_levelset_getmeshbboxonly = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setmesh")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_levelset_setmesh = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getmesh")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_levelset_getmesh = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_getvolumedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_levelset_getvolumedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_levelset_setvolumedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_levelset_setvolumedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getminlength")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_beamlattice_getminlength = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setminlength")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_beamlattice_setminlength = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getclipping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getclipping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setclipping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, BeamLatticeClipMode, ctypes.c_uint32)
			self.lib.lib3mf_beamlattice_setclipping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getrepresentation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getrepresentation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setrepresentation")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_beamlattice_setrepresentation = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballoptions")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_beamlattice_getballoptions = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setballoptions")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, BeamLatticeBallMode, ctypes.c_double)
			self.lib.lib3mf_beamlattice_setballoptions = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getbeamcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_getbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Beam), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_addbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setbeam")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_setbeam = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setbeams")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_setbeams = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeams")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Beam))
			self.lib.lib3mf_beamlattice_getbeams = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getballcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_getball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Ball), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_addball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setball")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_setball = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_setballs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_setballs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getballs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Ball))
			self.lib.lib3mf_beamlattice_getballs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamsetcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamlattice_getbeamsetcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_addbeamset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlattice_addbeamset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlattice_getbeamset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlattice_getbeamset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_getfunctionresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_functionreference_getfunctionresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_setfunctionresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_functionreference_setfunctionresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_gettransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_functionreference_gettransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_settransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_functionreference_settransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_getchannelname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_functionreference_getchannelname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_setchannelname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_functionreference_setchannelname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_setminfeaturesize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_functionreference_setminfeaturesize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_getminfeaturesize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_functionreference_getminfeaturesize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_setfallbackvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_functionreference_setfallbackvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionreference_getfallbackvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_functionreference_getfallbackvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_getbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedatacomposite_getbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_setbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_volumedatacomposite_setbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_getmaterialmappingcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_volumedatacomposite_getmaterialmappingcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_getmaterialmapping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedatacomposite_getmaterialmapping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_addmaterialmapping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedatacomposite_addmaterialmapping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedatacomposite_removematerialmapping")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_volumedatacomposite_removematerialmapping = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedataproperty_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_volumedataproperty_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedataproperty_setisrequired")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_bool)
			self.lib.lib3mf_volumedataproperty_setisrequired = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedataproperty_isrequired")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_volumedataproperty_isrequired = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_getcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_getcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_createnewcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_createnewcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_removecomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_volumedata_removecomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_getcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_getcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_createnewcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_createnewcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_removecolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_volumedata_removecolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_getpropertycount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_volumedata_getpropertycount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_getproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_getproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_addpropertyfromfunction")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_volumedata_addpropertyfromfunction = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_volumedata_removeproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_volumedata_removeproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getobjectresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_component_getobjectresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getobjectresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_component_getobjectresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_component_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_component_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_hastransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_component_hastransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_gettransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_component_gettransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_component_settransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_component_settransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_addcomponent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobject_addcomponent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_getcomponent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_componentsobject_getcomponent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_componentsobject_getcomponentcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_componentsobject_getcomponentcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_beamset_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_beamset_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_beamset_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_beamset_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getreferencecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getreferencecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_setreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getballreferencecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getballreferencecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_setballreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_setballreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamset_getballreferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_beamset_getballreferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_addmaterial")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_basematerialgroup_addmaterial = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_removematerial")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_basematerialgroup_removematerial = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_basematerialgroup_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p)
			self.lib.lib3mf_basematerialgroup_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_setdisplaycolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_basematerialgroup_setdisplaycolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_basematerialgroup_getdisplaycolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_basematerialgroup_getdisplaycolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_addcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_colorgroup_addcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_removecolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_colorgroup_removecolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_setcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_colorgroup_setcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_colorgroup_getcolor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color))
			self.lib.lib3mf_colorgroup_getcolor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_addtex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Tex2Coord), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_texture2dgroup_addtex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_gettex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Tex2Coord))
			self.lib.lib3mf_texture2dgroup_gettex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_removetex2coord")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_texture2dgroup_removetex2coord = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2dgroup_gettexture2d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2dgroup_gettexture2d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_compositematerials_getbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_addcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(CompositeConstituent), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_compositematerials_addcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_removecomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_compositematerials_removecomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_compositematerials_getcomposite")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(CompositeConstituent))
			self.lib.lib3mf_compositematerials_getcomposite = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getallpropertyids")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getallpropertyids = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_addmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_addmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_setmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_setmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getmultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getmultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_removemultiproperty")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_multipropertygroup_removemultiproperty = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getlayercount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_getlayercount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_addlayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(MultiPropertyLayer), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_multipropertygroup_addlayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_getlayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(MultiPropertyLayer))
			self.lib.lib3mf_multipropertygroup_getlayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_multipropertygroup_removelayer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_multipropertygroup_removelayer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_image3d_getname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_image3d_getname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_image3d_setname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_image3d_setname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_image3d_isimagestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_image3d_isimagestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_getrowcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_imagestack_getrowcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_setrowcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_imagestack_setrowcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_getcolumncount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_imagestack_getcolumncount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_setcolumncount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32)
			self.lib.lib3mf_imagestack_setcolumncount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_getsheetcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_imagestack_getsheetcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_getsheet")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_imagestack_getsheet = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_setsheet")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_void_p)
			self.lib.lib3mf_imagestack_setsheet = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_createemptysheet")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_imagestack_createemptysheet = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_createsheetfrombuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_imagestack_createsheetfrombuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_imagestack_createsheetfromfile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_imagestack_createsheetfromfile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_attachment_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_setpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_setpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_packagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_attachment_packagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getrelationshiptype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_attachment_getrelationshiptype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_setrelationshiptype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_setrelationshiptype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_writetofile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_writetofile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfromfile")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_attachment_readfromfile = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfromcallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p)
			self.lib.lib3mf_attachment_readfromcallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_getstreamsize")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_attachment_getstreamsize = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_writetobuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_attachment_writetobuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_attachment_readfrombuffer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_attachment_readfrombuffer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_texture2d_getattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_texture2d_setattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_getcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureType)
			self.lib.lib3mf_texture2d_setcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_gettilestyleuv")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_gettilestyleuv = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_settilestyleuv")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureTileStyle, TextureTileStyle)
			self.lib.lib3mf_texture2d_settilestyleuv = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_getfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_texture2d_getfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_texture2d_setfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureFilter)
			self.lib.lib3mf_texture2d_setfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitport_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitport_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_getdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitport_getdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_setdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitport_setdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_settype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ImplicitPortType)
			self.lib.lib3mf_implicitport_settype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_gettype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_implicitport_gettype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_getreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitport_getreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitport_setreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitport_setreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_iterator_movenext")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_iterator_movenext = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_iterator_moveprevious")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_iterator_moveprevious = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_iterator_count")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_iterator_count = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitportiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitportiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_getdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_getdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_setdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_setdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_gettag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_gettag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_settag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitnode_settag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_getnodetype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_implicitnode_getnodetype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_addinput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_addinput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_getinputs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_getinputs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_addoutput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_addoutput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_getoutputs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_getoutputs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_findinput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_findinput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_findoutput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitnode_findoutput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitnode_aretypesvalid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_implicitnode_aretypesvalid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_oneinputnode_getinputa")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_oneinputnode_getinputa = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_oneinputnode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_oneinputnode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceidnode_setresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_resourceidnode_setresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceidnode_getresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceidnode_getresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourceidnode_getoutputvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourceidnode_getoutputvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_twoinputnode_getinputb")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_twoinputnode_getinputb = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_selectnode_getinputb")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_selectnode_getinputb = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_selectnode_getinputc")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_selectnode_getinputc = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_selectnode_getinputd")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_selectnode_getinputd = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_clampnode_getinputmin")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_clampnode_getinputmin = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_clampnode_getinputmax")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_clampnode_getinputmax = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composevectornode_getinputx")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composevectornode_getinputx = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composevectornode_getinputy")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composevectornode_getinputy = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composevectornode_getinputz")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composevectornode_getinputz = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composevectornode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composevectornode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_decomposevectornode_getinputa")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_decomposevectornode_getinputa = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_decomposevectornode_getoutputx")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_decomposevectornode_getoutputx = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_decomposevectornode_getoutputy")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_decomposevectornode_getoutputy = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_decomposevectornode_getoutputz")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_decomposevectornode_getoutputz = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm00")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm00 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm01")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm01 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm02")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm02 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm03")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm03 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm10")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm10 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm11")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm11 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm12")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm12 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm13")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm13 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm20")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm20 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm21")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm21 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm22")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm22 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm23")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm23 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm30")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm30 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm31")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm31 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm32")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm32 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getinputm33")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getinputm33 = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_composematrixnode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_composematrixnode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromrowsnode_getinputa")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromrowsnode_getinputa = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromrowsnode_getinputb")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromrowsnode_getinputb = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromrowsnode_getinputc")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromrowsnode_getinputc = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromrowsnode_getinputd")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromrowsnode_getinputd = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromrowsnode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromrowsnode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromcolumnsnode_getinputa")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromcolumnsnode_getinputa = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromcolumnsnode_getinputb")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromcolumnsnode_getinputb = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromcolumnsnode_getinputc")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromcolumnsnode_getinputc = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromcolumnsnode_getinputd")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromcolumnsnode_getinputd = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_matrixfromcolumnsnode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_matrixfromcolumnsnode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constantnode_setconstant")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_constantnode_setconstant = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constantnode_getconstant")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_constantnode_getconstant = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constantnode_getoutputvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_constantnode_getoutputvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constvecnode_setvector")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Vector))
			self.lib.lib3mf_constvecnode_setvector = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constvecnode_getvector")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Vector))
			self.lib.lib3mf_constvecnode_getvector = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constvecnode_getoutputvector")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_constvecnode_getoutputvector = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constmatnode_setmatrix")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Matrix4x4))
			self.lib.lib3mf_constmatnode_setmatrix = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constmatnode_getmatrix")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Matrix4x4))
			self.lib.lib3mf_constmatnode_getmatrix = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_constmatnode_getoutputmatrix")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_constmatnode_getoutputmatrix = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshnode_getinputmesh")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshnode_getinputmesh = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshnode_getinputpos")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshnode_getinputpos = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_meshnode_getoutputdistance")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_meshnode_getoutputdistance = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_unsignedmeshnode_getinputmesh")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_unsignedmeshnode_getinputmesh = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_unsignedmeshnode_getinputpos")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_unsignedmeshnode_getinputpos = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_unsignedmeshnode_getoutputdistance")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_unsignedmeshnode_getoutputdistance = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlatticenode_getinputbeamlattice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlatticenode_getinputbeamlattice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlatticenode_getinputpos")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlatticenode_getinputpos = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlatticenode_getoutputdistance")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_beamlatticenode_getoutputdistance = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlatticenode_setaccuraterange")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_beamlatticenode_setaccuraterange = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_beamlatticenode_getaccuraterange")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_beamlatticenode_getaccuraterange = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getinputfunctionid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getinputfunctionid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getinputpos")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getinputpos = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getinputstep")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getinputstep = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_setscalaroutputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_functiongradientnode_setscalaroutputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getscalaroutputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_functiongradientnode_getscalaroutputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_setvectorinputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_functiongradientnode_setvectorinputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getvectorinputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_functiongradientnode_getvectorinputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getoutputnormalizedgradient")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getoutputnormalizedgradient = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getoutputgradient")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getoutputgradient = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functiongradientnode_getoutputmagnitude")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functiongradientnode_getoutputmagnitude = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getinputfunctionid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_normalizedistancenode_getinputfunctionid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getinputpos")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_normalizedistancenode_getinputpos = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getinputstep")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_normalizedistancenode_getinputstep = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_setscalaroutputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_normalizedistancenode_setscalaroutputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getscalaroutputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_normalizedistancenode_getscalaroutputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_setvectorinputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_normalizedistancenode_setvectorinputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getvectorinputname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_normalizedistancenode_getvectorinputname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_normalizedistancenode_getoutputresult")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_normalizedistancenode_getoutputresult = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functioncallnode_getinputfunctionid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functioncallnode_getinputfunctionid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_nodeiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_nodeiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_getdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_function_getdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_setdisplayname")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_function_setdisplayname = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_addinput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ImplicitPortType, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_addinput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_getinputs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_getinputs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_removeinput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_function_removeinput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_addoutput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ImplicitPortType, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_addoutput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_getoutputs")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_getoutputs = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_removeoutput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_function_removeoutput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_findinput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_findinput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_function_findoutput")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_function_findoutput = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_getidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_implicitfunction_getidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_setidentifier")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitfunction_setidentifier = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ImplicitNodeType, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addsinnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addsinnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addcosnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addcosnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addtannode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addtannode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addarcsinnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addarcsinnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addarccosnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addarccosnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addarctan2node")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addarctan2node = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addsinhnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addsinhnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addcoshnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addcoshnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addtanhnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addtanhnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addroundnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addroundnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addceilnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addceilnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addfloornode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addfloornode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addsignnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addsignnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addfractnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addfractnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addabsnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addabsnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addexpnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addexpnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlognode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addlognode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlog2node")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addlog2node = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlog10node")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addlog10node = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlengthnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addlengthnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addtransposenode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addtransposenode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addinversenode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addinversenode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addsqrtnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addsqrtnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addresourceidnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addresourceidnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addadditionnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addadditionnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addsubtractionnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addsubtractionnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmultiplicationnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmultiplicationnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_adddivisionnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_adddivisionnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_adddotnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_adddotnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addcrossnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addcrossnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmatvecmultiplicationnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmatvecmultiplicationnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addminnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addminnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmaxnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmaxnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addfmodnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addfmodnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addpownode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addpownode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addselectnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addselectnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addclampnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addclampnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addcomposevectornode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addcomposevectornode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addvectorfromscalarnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addvectorfromscalarnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_adddecomposevectornode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_adddecomposevectornode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addcomposematrixnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addcomposematrixnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmatrixfromrowsnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmatrixfromrowsnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmatrixfromcolumnsnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmatrixfromcolumnsnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addconstantnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addconstantnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addconstvecnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addconstvecnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addconstmatnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addconstmatnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addmeshnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addmeshnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addunsignedmeshnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addunsignedmeshnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addbeamlatticenode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addbeamlatticenode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addfunctiongradientnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addfunctiongradientnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addnormalizedistancenode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addnormalizedistancenode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addfunctioncallnode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_addfunctioncallnode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_getnodes")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_implicitfunction_getnodes = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_removenode")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_implicitfunction_removenode = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlink")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_implicitfunction_addlink = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_addlinkbynames")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p)
			self.lib.lib3mf_implicitfunction_addlinkbynames = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_clear")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_implicitfunction_clear = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_implicitfunction_sortnodestopologically")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_implicitfunction_sortnodestopologically = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_getimage3d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_functionfromimage3d_getimage3d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_setimage3d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_functionfromimage3d_setimage3d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_setfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureFilter)
			self.lib.lib3mf_functionfromimage3d_setfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_getfilter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_functionfromimage3d_getfilter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_settilestyles")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, TextureTileStyle, TextureTileStyle, TextureTileStyle)
			self.lib.lib3mf_functionfromimage3d_settilestyles = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_gettilestyles")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_functionfromimage3d_gettilestyles = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_getoffset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_functionfromimage3d_getoffset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_setoffset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_functionfromimage3d_setoffset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_getscale")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_functionfromimage3d_getscale = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_functionfromimage3d_setscale")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double)
			self.lib.lib3mf_functionfromimage3d_setscale = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjectresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditem_getobjectresource = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_builditem_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_builditem_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjectresourceid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_builditem_getobjectresourceid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_hasobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditem_hasobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_builditem_getobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setobjecttransform")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Transform))
			self.lib.lib3mf_builditem_setobjecttransform = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_builditem_getpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_setpartnumber")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_builditem_setpartnumber = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditem_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditem_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_builditem_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_movenext")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditemiterator_movenext = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_moveprevious")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_builditemiterator_moveprevious = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_getcurrent")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditemiterator_getcurrent = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_clone")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_builditemiterator_clone = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_builditemiterator_count")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_builditemiterator_count = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_setvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position2D))
			self.lib.lib3mf_slice_setvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getvertices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position2D))
			self.lib.lib3mf_slice_getvertices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getvertexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getvertexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_addpolygon")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_addpolygon = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygoncount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getpolygoncount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_setpolygonindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_slice_setpolygonindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygonindices")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_slice_getpolygonindices = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getpolygonindexcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slice_getpolygonindexcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slice_getztop")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_slice_getztop = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getbottomz")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_double))
			self.lib.lib3mf_slicestack_getbottomz = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicecount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slicestack_getslicecount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_getslice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_addslice")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_addslice = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicerefcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_slicestack_getslicerefcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_addslicestackreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_slicestack_addslicestackreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getslicestackreference")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_slicestack_getslicestackreference = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_collapseslicereferences")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_slicestack_collapseslicereferences = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_setownpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_slicestack_setownpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_slicestack_getownpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_slicestack_getownpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getconsumerid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getconsumerid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getkeyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getkeyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_consumer_getkeyvalue")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_consumer_getkeyvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_accessright_getconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getwrappingalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getwrappingalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getmgfalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getmgfalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_accessright_getdigestmethod")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_accessright_getdigestmethod = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getencryptionalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getkey")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getkey = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getinitializationvector")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getinitializationvector = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getauthenticationtag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_setauthenticationtag")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getadditionalauthenticationdata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getdescriptor")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_contentencryptionparams_getdescriptor = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_contentencryptionparams_getkeyuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_contentencryptionparams_getkeyuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getpath")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedata_getpath = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getencryptionalgorithm")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_resourcedata_getencryptionalgorithm = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getcompression")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_resourcedata_getcompression = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedata_getadditionalauthenticationdata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8))
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_getkeyuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_resourcedatagroup_getkeyuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_addaccessright")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, WrappingAlgorithm, MgfAlgorithm, DigestMethod, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedatagroup_addaccessright = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_findaccessrightbyconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_resourcedatagroup_removeaccessright")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_resourcedatagroup_removeaccessright = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getconsumercount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getconsumercount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findconsumer")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findconsumer = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatagroupcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getresourcedatagroupcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findresourcedatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findresourcedatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_addresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, EncryptionAlgorithm, Compression, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_addresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_removeresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_keystore_removeresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_findresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_findresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedatacount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.lib3mf_keystore_getresourcedatacount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getresourcedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_keystore_getresourcedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_getuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_keystore_getuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_keystore_setuuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_keystore_setuuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_rootmodelpart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_rootmodelpart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_findorcreatepackagepart")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_findorcreatepackagepart = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setunit")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ModelUnit)
			self.lib.lib3mf_model_setunit = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getunit")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_model_getunit = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getlanguage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_model_getlanguage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setlanguage")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_setlanguage = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_querywriter")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_querywriter = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_queryreader")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_queryreader = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getresourcebyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getresourcebyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getpropertytypebyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_int32))
			self.lib.lib3mf_model_getpropertytypebyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbasematerialgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbasematerialgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcompositematerialsbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcompositematerialsbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmultipropertygroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmultipropertygroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmeshobjectbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmeshobjectbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcomponentsobjectbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcomponentsobjectbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcolorgroupbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcolorgroupbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getslicestackbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getslicestackbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getlevelsetbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getlevelsetbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbuilduuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p)
			self.lib.lib3mf_model_getbuilduuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setbuilduuid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_setbuilduuid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbuilditems")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbuilditems = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getoutbox")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(Box))
			self.lib.lib3mf_model_getoutbox = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getresources")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getresources = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmeshobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmeshobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcomponentsobjects")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcomponentsobjects = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2ds")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2ds = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getbasematerialgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getbasematerialgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcolorgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcolorgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_gettexture2dgroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_gettexture2dgroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmultipropertygroups")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmultipropertygroups = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getslicestacks")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getslicestacks = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getimage3ds")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getimage3ds = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_mergetomodel")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_mergetomodel = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_mergefrommodel")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_mergefrommodel = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addmeshobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addmeshobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcomponentsobject")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcomponentsobject = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addslicestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addslicestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addtexture2dfromattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addtexture2dfromattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addbasematerialgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addbasematerialgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcolorgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcolorgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addtexture2dgroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addtexture2dgroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcompositematerials")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addcompositematerials = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addmultipropertygroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addmultipropertygroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addimagestack")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addimagestack = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getimagestackbyid")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getimagestackbyid = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addbuilditem")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addbuilditem = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removebuilditem")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_removebuilditem = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getmetadatagroup")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getmetadatagroup = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removeattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_removeattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_findattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_findattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getattachmentcount")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32))
			self.lib.lib3mf_model_getattachmentcount = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_haspackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.lib3mf_model_haspackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_createpackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_createpackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getpackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getpackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removepackagethumbnailattachment")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.lib3mf_model_removepackagethumbnailattachment = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addcustomcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p)
			self.lib.lib3mf_model_addcustomcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removecustomcontenttype")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_char_p)
			self.lib.lib3mf_model_removecustomcontenttype = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_setrandomnumbercallback")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, RandomNumberCallback, ctypes.c_void_p)
			self.lib.lib3mf_model_setrandomnumbercallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getkeystore")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getkeystore = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getfunctions")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getfunctions = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addimplicitfunction")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addimplicitfunction = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addfunctionfromimage3d")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addfunctionfromimage3d = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addvolumedata")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addvolumedata = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_addlevelset")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_addlevelset = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_getlevelsets")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p))
			self.lib.lib3mf_model_getlevelsets = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("lib3mf_model_removeresource")), methodAddress)
			if err != 0:
				raise ELib3MFException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_void_p)
			self.lib.lib3mf_model_removeresource = methodType(int(methodAddress.value))
			
		except AttributeError as ae:
			raise ELib3MFException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
		
	def _loadFunctionTable(self):
		try:
			self.lib.lib3mf_getlibraryversion.restype = ctypes.c_int32
			self.lib.lib3mf_getlibraryversion.argtypes = [ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_getprereleaseinformation.restype = ctypes.c_int32
			self.lib.lib3mf_getprereleaseinformation.argtypes = [ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_getbuildinformation.restype = ctypes.c_int32
			self.lib.lib3mf_getbuildinformation.argtypes = [ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_getspecificationversion.restype = ctypes.c_int32
			self.lib.lib3mf_getspecificationversion.argtypes = [ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_createmodel.restype = ctypes.c_int32
			self.lib.lib3mf_createmodel.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_release.restype = ctypes.c_int32
			self.lib.lib3mf_release.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_acquire.restype = ctypes.c_int32
			self.lib.lib3mf_acquire.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_setjournal.restype = ctypes.c_int32
			self.lib.lib3mf_setjournal.argtypes = [ctypes.c_char_p]
			
			self.lib.lib3mf_getlasterror.restype = ctypes.c_int32
			self.lib.lib3mf_getlasterror.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_getsymbollookupmethod.restype = ctypes.c_int32
			self.lib.lib3mf_getsymbollookupmethod.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_retrieveprogressmessage.restype = ctypes.c_int32
			self.lib.lib3mf_retrieveprogressmessage.argtypes = [ProgressIdentifier, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_rgbatocolor.restype = ctypes.c_int32
			self.lib.lib3mf_rgbatocolor.argtypes = [ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.c_uint8, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_floatrgbatocolor.restype = ctypes.c_int32
			self.lib.lib3mf_floatrgbatocolor.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colortorgba.restype = ctypes.c_int32
			self.lib.lib3mf_colortorgba.argtypes = [ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_colortofloatrgba.restype = ctypes.c_int32
			self.lib.lib3mf_colortofloatrgba.argtypes = [ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float), ctypes.POINTER(ctypes.c_float)]
			
			self.lib.lib3mf_getidentitytransform.restype = ctypes.c_int32
			self.lib.lib3mf_getidentitytransform.argtypes = [ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_getuniformscaletransform.restype = ctypes.c_int32
			self.lib.lib3mf_getuniformscaletransform.argtypes = [ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_getscaletransform.restype = ctypes.c_int32
			self.lib.lib3mf_getscaletransform.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_gettranslationtransform.restype = ctypes.c_int32
			self.lib.lib3mf_gettranslationtransform.argtypes = [ctypes.c_float, ctypes.c_float, ctypes.c_float, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_base_classtypeid.restype = ctypes.c_int32
			self.lib.lib3mf_base_classtypeid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_writer_writetofile.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetofile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_writer_getstreamsize.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getstreamsize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_writer_writetobuffer.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetobuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_writer_writetocallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_writetocallback.argtypes = [ctypes.c_void_p, WriteCallback, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_setprogresscallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setprogresscallback.argtypes = [ctypes.c_void_p, ProgressCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_getdecimalprecision.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getdecimalprecision.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_writer_setdecimalprecision.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setdecimalprecision.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_writer_setstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_writer_getstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_writer_getwarning.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getwarning.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_writer_getwarningcount.restype = ctypes.c_int32
			self.lib.lib3mf_writer_getwarningcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_writer_addkeywrappingcallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_addkeywrappingcallback.argtypes = [ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_writer_setcontentencryptioncallback.restype = ctypes.c_int32
			self.lib.lib3mf_writer_setcontentencryptioncallback.argtypes = [ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_readfromfile.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfromfile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_readfrombuffer.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfrombuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_reader_readfromcallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_readfromcallback.argtypes = [ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_setprogresscallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setprogresscallback.argtypes = [ctypes.c_void_p, ProgressCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_addrelationtoread.restype = ctypes.c_int32
			self.lib.lib3mf_reader_addrelationtoread.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_removerelationtoread.restype = ctypes.c_int32
			self.lib.lib3mf_reader_removerelationtoread.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_reader_setstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_reader_getstrictmodeactive.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getstrictmodeactive.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_reader_getwarning.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getwarning.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_uint32), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_reader_getwarningcount.restype = ctypes.c_int32
			self.lib.lib3mf_reader_getwarningcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_reader_addkeywrappingcallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_addkeywrappingcallback.argtypes = [ctypes.c_void_p, ctypes.c_char_p, KeyWrappingCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_reader_setcontentencryptioncallback.restype = ctypes.c_int32
			self.lib.lib3mf_reader_setcontentencryptioncallback.argtypes = [ctypes.c_void_p, ContentEncryptionCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_packagepart_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_packagepart_getpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_packagepart_setpath.restype = ctypes.c_int32
			self.lib.lib3mf_packagepart_setpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_resource_getresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resource_getuniqueresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getuniqueresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resource_packagepart.restype = ctypes.c_int32
			self.lib.lib3mf_resource_packagepart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resource_setpackagepart.restype = ctypes.c_int32
			self.lib.lib3mf_resource_setpackagepart.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_resource_getmodelresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_resource_getmodelresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_resourceiterator_movenext.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_movenext.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_resourceiterator_moveprevious.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_moveprevious.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_resourceiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceiterator_clone.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_clone.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceiterator_count.restype = ctypes.c_int32
			self.lib.lib3mf_resourceiterator_count.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_slicestackiterator_getcurrentslicestack.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_objectiterator_getcurrentobject.restype = ctypes.c_int32
			self.lib.lib3mf_objectiterator_getcurrentobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_meshobjectiterator_getcurrentmeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d.restype = ctypes.c_int32
			self.lib.lib3mf_texture2diterator_getcurrenttexture2d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_image3diterator_getcurrentimage3d.restype = ctypes.c_int32
			self.lib.lib3mf_image3diterator_getcurrentimage3d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functioniterator_getcurrentfunction.restype = ctypes.c_int32
			self.lib.lib3mf_functioniterator_getcurrentfunction.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_levelsetiterator_getcurrentlevelset.restype = ctypes.c_int32
			self.lib.lib3mf_levelsetiterator_getcurrentlevelset.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadata_getnamespace.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getnamespace.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setnamespace.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setnamespace.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getname.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setname.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getkey.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getkey.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getmustpreserve.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getmustpreserve.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_metadata_setmustpreserve.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setmustpreserve.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_metadata_gettype.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_gettype.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_settype.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_settype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_getvalue.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_getvalue.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_metadata_setvalue.restype = ctypes.c_int32
			self.lib.lib3mf_metadata_setvalue.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_metadatagroup_getmetadatacount.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadatacount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_metadatagroup_getmetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadata.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadatagroup_getmetadatabykey.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_getmetadatabykey.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_metadatagroup_removemetadatabyindex.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_removemetadatabyindex.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_metadatagroup_removemetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_removemetadata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_metadatagroup_addmetadata.restype = ctypes.c_int32
			self.lib.lib3mf_metadatagroup_addmetadata.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_triangleset_setname.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_triangleset_getname.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_triangleset_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_triangleset_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_triangleset_addtriangle.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_addtriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_triangleset_removetriangle.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_removetriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_triangleset_clear.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_clear.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_triangleset_settrianglelist.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_settrianglelist.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_triangleset_gettrianglelist.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_gettrianglelist.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_triangleset_addtrianglelist.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_addtrianglelist.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_triangleset_merge.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_merge.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_triangleset_deleteset.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_deleteset.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_triangleset_duplicate.restype = ctypes.c_int32
			self.lib.lib3mf_triangleset_duplicate.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_gettype.restype = ctypes.c_int32
			self.lib.lib3mf_object_gettype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_object_settype.restype = ctypes.c_int32
			self.lib.lib3mf_object_settype.argtypes = [ctypes.c_void_p, ObjectType]
			
			self.lib.lib3mf_object_getname.restype = ctypes.c_int32
			self.lib.lib3mf_object_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setname.restype = ctypes.c_int32
			self.lib.lib3mf_object_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_getpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_object_getpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_object_setpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_ismeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_object_ismeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_iscomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_object_iscomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_islevelsetobject.restype = ctypes.c_int32
			self.lib.lib3mf_object_islevelsetobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_isvalid.restype = ctypes.c_int32
			self.lib.lib3mf_object_isvalid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_setattachmentasthumbnail.restype = ctypes.c_int32
			self.lib.lib3mf_object_setattachmentasthumbnail.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_object_getthumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_object_getthumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_clearthumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_object_clearthumbnailattachment.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_object_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_object_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_object_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_object_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_object_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_object_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_object_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_object_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_setslicesmeshresolution.restype = ctypes.c_int32
			self.lib.lib3mf_object_setslicesmeshresolution.argtypes = [ctypes.c_void_p, SlicesMeshResolution]
			
			self.lib.lib3mf_object_getslicesmeshresolution.restype = ctypes.c_int32
			self.lib.lib3mf_object_getslicesmeshresolution.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_object_hasslices.restype = ctypes.c_int32
			self.lib.lib3mf_object_hasslices.argtypes = [ctypes.c_void_p, ctypes.c_bool, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_object_clearslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_clearslicestack.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_object_getslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_getslicestack.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_object_assignslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_object_assignslicestack.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_meshobject_getvertexcount.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertexcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_gettrianglecount.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettrianglecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_getvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertex.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_setvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setvertex.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_addvertex.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_addvertex.argtypes = [ctypes.c_void_p, ctypes.POINTER(Position), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_getvertices.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position)]
			
			self.lib.lib3mf_meshobject_gettriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_settriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_settriangle.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_addtriangle.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_addtriangle.argtypes = [ctypes.c_void_p, ctypes.POINTER(Triangle), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_gettriangleindices.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangleindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_setobjectlevelproperty.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setobjectlevelproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32]
			
			self.lib.lib3mf_meshobject_getobjectlevelproperty.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getobjectlevelproperty.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_meshobject_settriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_settriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_gettriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_setalltriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setalltriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_getalltriangleproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getalltriangleproperties.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(TriangleProperties)]
			
			self.lib.lib3mf_meshobject_clearallproperties.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_clearallproperties.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_meshobject_setgeometry.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setgeometry.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position), ctypes.c_uint64, ctypes.POINTER(Triangle)]
			
			self.lib.lib3mf_meshobject_ismanifoldandoriented.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_ismanifoldandoriented.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_meshobject_beamlattice.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_beamlattice.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobject_getvolumedata.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_getvolumedata.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobject_setvolumedata.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_setvolumedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_meshobject_addtriangleset.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_addtriangleset.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobject_hastriangleset.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_hastriangleset.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_meshobject_findtriangleset.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_findtriangleset.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshobject_gettrianglesetcount.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettrianglesetcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_meshobject_gettriangleset.restype = ctypes.c_int32
			self.lib.lib3mf_meshobject_gettriangleset.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_levelset_getfunction.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getfunction.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_levelset_setfunction.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setfunction.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_levelset_gettransform.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_gettransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_levelset_settransform.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_settransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_levelset_getchannelname.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getchannelname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_levelset_setchannelname.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setchannelname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_levelset_setminfeaturesize.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setminfeaturesize.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_levelset_getminfeaturesize.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getminfeaturesize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_levelset_setfallbackvalue.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setfallbackvalue.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_levelset_getfallbackvalue.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getfallbackvalue.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_levelset_setmeshbboxonly.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setmeshbboxonly.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_levelset_getmeshbboxonly.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getmeshbboxonly.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_levelset_setmesh.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setmesh.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_levelset_getmesh.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getmesh.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_levelset_getvolumedata.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_getvolumedata.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_levelset_setvolumedata.restype = ctypes.c_int32
			self.lib.lib3mf_levelset_setvolumedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_beamlattice_getminlength.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getminlength.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_beamlattice_setminlength.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setminlength.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_beamlattice_getclipping.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getclipping.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setclipping.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setclipping.argtypes = [ctypes.c_void_p, BeamLatticeClipMode, ctypes.c_uint32]
			
			self.lib.lib3mf_beamlattice_getrepresentation.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getrepresentation.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setrepresentation.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setrepresentation.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_beamlattice_getballoptions.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballoptions.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_beamlattice_setballoptions.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setballoptions.argtypes = [ctypes.c_void_p, BeamLatticeBallMode, ctypes.c_double]
			
			self.lib.lib3mf_beamlattice_getbeamcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_getbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeam.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_addbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addbeam.argtypes = [ctypes.c_void_p, ctypes.POINTER(Beam), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setbeam.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setbeam.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_setbeams.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setbeams.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_getbeams.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeams.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Beam)]
			
			self.lib.lib3mf_beamlattice_getballcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_getball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getball.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_addball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addball.argtypes = [ctypes.c_void_p, ctypes.POINTER(Ball), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_setball.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setball.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_setballs.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_setballs.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_getballs.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getballs.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Ball)]
			
			self.lib.lib3mf_beamlattice_getbeamsetcount.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamsetcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamlattice_addbeamset.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_addbeamset.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlattice_getbeamset.restype = ctypes.c_int32
			self.lib.lib3mf_beamlattice_getbeamset.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functionreference_getfunctionresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_getfunctionresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_functionreference_setfunctionresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_setfunctionresourceid.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_functionreference_gettransform.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_gettransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_functionreference_settransform.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_settransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_functionreference_getchannelname.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_getchannelname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_functionreference_setchannelname.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_setchannelname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_functionreference_setminfeaturesize.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_setminfeaturesize.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_functionreference_getminfeaturesize.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_getminfeaturesize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_functionreference_setfallbackvalue.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_setfallbackvalue.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_functionreference_getfallbackvalue.restype = ctypes.c_int32
			self.lib.lib3mf_functionreference_getfallbackvalue.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_volumedatacomposite_getbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_getbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedatacomposite_setbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_setbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_volumedatacomposite_getmaterialmappingcount.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_getmaterialmappingcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_volumedatacomposite_getmaterialmapping.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_getmaterialmapping.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedatacomposite_addmaterialmapping.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_addmaterialmapping.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedatacomposite_removematerialmapping.restype = ctypes.c_int32
			self.lib.lib3mf_volumedatacomposite_removematerialmapping.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_volumedataproperty_getname.restype = ctypes.c_int32
			self.lib.lib3mf_volumedataproperty_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_volumedataproperty_setisrequired.restype = ctypes.c_int32
			self.lib.lib3mf_volumedataproperty_setisrequired.argtypes = [ctypes.c_void_p, ctypes.c_bool]
			
			self.lib.lib3mf_volumedataproperty_isrequired.restype = ctypes.c_int32
			self.lib.lib3mf_volumedataproperty_isrequired.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_volumedata_getcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_getcomposite.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_createnewcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_createnewcomposite.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_removecomposite.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_removecomposite.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_volumedata_getcolor.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_getcolor.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_createnewcolor.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_createnewcolor.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_removecolor.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_removecolor.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_volumedata_getpropertycount.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_getpropertycount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_volumedata_getproperty.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_getproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_addpropertyfromfunction.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_addpropertyfromfunction.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_volumedata_removeproperty.restype = ctypes.c_int32
			self.lib.lib3mf_volumedata_removeproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_component_getobjectresource.restype = ctypes.c_int32
			self.lib.lib3mf_component_getobjectresource.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_component_getobjectresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_component_getobjectresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_component_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_component_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_component_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_component_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_component_hastransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_hastransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_component_gettransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_gettransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_component_settransform.restype = ctypes.c_int32
			self.lib.lib3mf_component_settransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_componentsobject_addcomponent.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_addcomponent.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobject_getcomponent.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_getcomponent.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_componentsobject_getcomponentcount.restype = ctypes.c_int32
			self.lib.lib3mf_componentsobject_getcomponentcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setname.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getname.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_beamset_getreferencecount.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getreferencecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getballreferencecount.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getballreferencecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_setballreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_setballreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_beamset_getballreferences.restype = ctypes.c_int32
			self.lib.lib3mf_beamset_getballreferences.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_addmaterial.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_addmaterial.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_basematerialgroup_removematerial.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_removematerial.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_basematerialgroup_getname.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_basematerialgroup_setname.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_setname.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p]
			
			self.lib.lib3mf_basematerialgroup_setdisplaycolor.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_setdisplaycolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_basematerialgroup_getdisplaycolor.restype = ctypes.c_int32
			self.lib.lib3mf_basematerialgroup_getdisplaycolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colorgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_addcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_addcolor.argtypes = [ctypes.c_void_p, ctypes.POINTER(Color), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_colorgroup_removecolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_removecolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_colorgroup_setcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_setcolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_colorgroup_getcolor.restype = ctypes.c_int32
			self.lib.lib3mf_colorgroup_getcolor.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Color)]
			
			self.lib.lib3mf_texture2dgroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_addtex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_addtex2coord.argtypes = [ctypes.c_void_p, ctypes.POINTER(Tex2Coord), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_texture2dgroup_gettex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_gettex2coord.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(Tex2Coord)]
			
			self.lib.lib3mf_texture2dgroup_removetex2coord.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_removetex2coord.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_texture2dgroup_gettexture2d.restype = ctypes.c_int32
			self.lib.lib3mf_texture2dgroup_gettexture2d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerials_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_getbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_compositematerials_addcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_addcomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(CompositeConstituent), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_compositematerials_removecomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_removecomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_compositematerials_getcomposite.restype = ctypes.c_int32
			self.lib.lib3mf_compositematerials_getcomposite.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(CompositeConstituent)]
			
			self.lib.lib3mf_multipropertygroup_getcount.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getallpropertyids.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getallpropertyids.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_addmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_addmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_setmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_setmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getmultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getmultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_removemultiproperty.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_removemultiproperty.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_multipropertygroup_getlayercount.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getlayercount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_addlayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_addlayer.argtypes = [ctypes.c_void_p, ctypes.POINTER(MultiPropertyLayer), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_multipropertygroup_getlayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_getlayer.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(MultiPropertyLayer)]
			
			self.lib.lib3mf_multipropertygroup_removelayer.restype = ctypes.c_int32
			self.lib.lib3mf_multipropertygroup_removelayer.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_image3d_getname.restype = ctypes.c_int32
			self.lib.lib3mf_image3d_getname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_image3d_setname.restype = ctypes.c_int32
			self.lib.lib3mf_image3d_setname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_image3d_isimagestack.restype = ctypes.c_int32
			self.lib.lib3mf_image3d_isimagestack.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_imagestack_getrowcount.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_getrowcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_imagestack_setrowcount.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_setrowcount.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_imagestack_getcolumncount.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_getcolumncount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_imagestack_setcolumncount.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_setcolumncount.argtypes = [ctypes.c_void_p, ctypes.c_uint32]
			
			self.lib.lib3mf_imagestack_getsheetcount.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_getsheetcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_imagestack_getsheet.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_getsheet.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_imagestack_setsheet.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_setsheet.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_void_p]
			
			self.lib.lib3mf_imagestack_createemptysheet.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_createemptysheet.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_imagestack_createsheetfrombuffer.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_createsheetfrombuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_imagestack_createsheetfromfile.restype = ctypes.c_int32
			self.lib.lib3mf_imagestack_createsheetfromfile.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_attachment_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_setpath.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_setpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_packagepart.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_packagepart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_attachment_getrelationshiptype.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getrelationshiptype.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_setrelationshiptype.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_setrelationshiptype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_writetofile.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_writetofile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_readfromfile.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfromfile.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_attachment_readfromcallback.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfromcallback.argtypes = [ctypes.c_void_p, ReadCallback, ctypes.c_uint64, SeekCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_attachment_getstreamsize.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_getstreamsize.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_attachment_writetobuffer.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_writetobuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_attachment_readfrombuffer.restype = ctypes.c_int32
			self.lib.lib3mf_attachment_readfrombuffer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_texture2d_getattachment.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_texture2d_setattachment.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_texture2d_getcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getcontenttype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_setcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setcontenttype.argtypes = [ctypes.c_void_p, TextureType]
			
			self.lib.lib3mf_texture2d_gettilestyleuv.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_gettilestyleuv.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_settilestyleuv.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_settilestyleuv.argtypes = [ctypes.c_void_p, TextureTileStyle, TextureTileStyle]
			
			self.lib.lib3mf_texture2d_getfilter.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_getfilter.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_texture2d_setfilter.restype = ctypes.c_int32
			self.lib.lib3mf_texture2d_setfilter.argtypes = [ctypes.c_void_p, TextureFilter]
			
			self.lib.lib3mf_implicitport_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitport_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitport_getdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_getdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitport_setdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_setdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitport_settype.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_settype.argtypes = [ctypes.c_void_p, ImplicitPortType]
			
			self.lib.lib3mf_implicitport_gettype.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_gettype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_implicitport_getreference.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_getreference.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitport_setreference.restype = ctypes.c_int32
			self.lib.lib3mf_implicitport_setreference.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_iterator_movenext.restype = ctypes.c_int32
			self.lib.lib3mf_iterator_movenext.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_iterator_moveprevious.restype = ctypes.c_int32
			self.lib.lib3mf_iterator_moveprevious.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_iterator_count.restype = ctypes.c_int32
			self.lib.lib3mf_iterator_count.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_implicitportiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_implicitportiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_getdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_getdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_setdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_setdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_gettag.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_gettag.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_settag.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_settag.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitnode_getnodetype.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_getnodetype.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_implicitnode_addinput.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_addinput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_getinputs.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_getinputs.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_addoutput.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_addoutput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_getoutputs.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_getoutputs.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_findinput.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_findinput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_findoutput.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_findoutput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitnode_aretypesvalid.restype = ctypes.c_int32
			self.lib.lib3mf_implicitnode_aretypesvalid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_oneinputnode_getinputa.restype = ctypes.c_int32
			self.lib.lib3mf_oneinputnode_getinputa.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_oneinputnode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_oneinputnode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceidnode_setresource.restype = ctypes.c_int32
			self.lib.lib3mf_resourceidnode_setresource.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_resourceidnode_getresource.restype = ctypes.c_int32
			self.lib.lib3mf_resourceidnode_getresource.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourceidnode_getoutputvalue.restype = ctypes.c_int32
			self.lib.lib3mf_resourceidnode_getoutputvalue.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_twoinputnode_getinputb.restype = ctypes.c_int32
			self.lib.lib3mf_twoinputnode_getinputb.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_selectnode_getinputb.restype = ctypes.c_int32
			self.lib.lib3mf_selectnode_getinputb.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_selectnode_getinputc.restype = ctypes.c_int32
			self.lib.lib3mf_selectnode_getinputc.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_selectnode_getinputd.restype = ctypes.c_int32
			self.lib.lib3mf_selectnode_getinputd.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_clampnode_getinputmin.restype = ctypes.c_int32
			self.lib.lib3mf_clampnode_getinputmin.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_clampnode_getinputmax.restype = ctypes.c_int32
			self.lib.lib3mf_clampnode_getinputmax.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composevectornode_getinputx.restype = ctypes.c_int32
			self.lib.lib3mf_composevectornode_getinputx.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composevectornode_getinputy.restype = ctypes.c_int32
			self.lib.lib3mf_composevectornode_getinputy.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composevectornode_getinputz.restype = ctypes.c_int32
			self.lib.lib3mf_composevectornode_getinputz.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composevectornode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_composevectornode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_decomposevectornode_getinputa.restype = ctypes.c_int32
			self.lib.lib3mf_decomposevectornode_getinputa.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_decomposevectornode_getoutputx.restype = ctypes.c_int32
			self.lib.lib3mf_decomposevectornode_getoutputx.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_decomposevectornode_getoutputy.restype = ctypes.c_int32
			self.lib.lib3mf_decomposevectornode_getoutputy.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_decomposevectornode_getoutputz.restype = ctypes.c_int32
			self.lib.lib3mf_decomposevectornode_getoutputz.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm00.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm00.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm01.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm01.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm02.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm02.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm03.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm03.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm10.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm10.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm11.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm11.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm12.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm12.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm13.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm13.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm20.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm20.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm21.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm21.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm22.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm22.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm23.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm23.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm30.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm30.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm31.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm31.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm32.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm32.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getinputm33.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getinputm33.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_composematrixnode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_composematrixnode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromrowsnode_getinputa.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromrowsnode_getinputa.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromrowsnode_getinputb.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromrowsnode_getinputb.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromrowsnode_getinputc.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromrowsnode_getinputc.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromrowsnode_getinputd.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromrowsnode_getinputd.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromrowsnode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromrowsnode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromcolumnsnode_getinputa.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromcolumnsnode_getinputa.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromcolumnsnode_getinputb.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromcolumnsnode_getinputb.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromcolumnsnode_getinputc.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromcolumnsnode_getinputc.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromcolumnsnode_getinputd.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromcolumnsnode_getinputd.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_matrixfromcolumnsnode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_matrixfromcolumnsnode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_constantnode_setconstant.restype = ctypes.c_int32
			self.lib.lib3mf_constantnode_setconstant.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_constantnode_getconstant.restype = ctypes.c_int32
			self.lib.lib3mf_constantnode_getconstant.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_constantnode_getoutputvalue.restype = ctypes.c_int32
			self.lib.lib3mf_constantnode_getoutputvalue.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_constvecnode_setvector.restype = ctypes.c_int32
			self.lib.lib3mf_constvecnode_setvector.argtypes = [ctypes.c_void_p, ctypes.POINTER(Vector)]
			
			self.lib.lib3mf_constvecnode_getvector.restype = ctypes.c_int32
			self.lib.lib3mf_constvecnode_getvector.argtypes = [ctypes.c_void_p, ctypes.POINTER(Vector)]
			
			self.lib.lib3mf_constvecnode_getoutputvector.restype = ctypes.c_int32
			self.lib.lib3mf_constvecnode_getoutputvector.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_constmatnode_setmatrix.restype = ctypes.c_int32
			self.lib.lib3mf_constmatnode_setmatrix.argtypes = [ctypes.c_void_p, ctypes.POINTER(Matrix4x4)]
			
			self.lib.lib3mf_constmatnode_getmatrix.restype = ctypes.c_int32
			self.lib.lib3mf_constmatnode_getmatrix.argtypes = [ctypes.c_void_p, ctypes.POINTER(Matrix4x4)]
			
			self.lib.lib3mf_constmatnode_getoutputmatrix.restype = ctypes.c_int32
			self.lib.lib3mf_constmatnode_getoutputmatrix.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshnode_getinputmesh.restype = ctypes.c_int32
			self.lib.lib3mf_meshnode_getinputmesh.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshnode_getinputpos.restype = ctypes.c_int32
			self.lib.lib3mf_meshnode_getinputpos.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_meshnode_getoutputdistance.restype = ctypes.c_int32
			self.lib.lib3mf_meshnode_getoutputdistance.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_unsignedmeshnode_getinputmesh.restype = ctypes.c_int32
			self.lib.lib3mf_unsignedmeshnode_getinputmesh.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_unsignedmeshnode_getinputpos.restype = ctypes.c_int32
			self.lib.lib3mf_unsignedmeshnode_getinputpos.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_unsignedmeshnode_getoutputdistance.restype = ctypes.c_int32
			self.lib.lib3mf_unsignedmeshnode_getoutputdistance.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlatticenode_getinputbeamlattice.restype = ctypes.c_int32
			self.lib.lib3mf_beamlatticenode_getinputbeamlattice.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlatticenode_getinputpos.restype = ctypes.c_int32
			self.lib.lib3mf_beamlatticenode_getinputpos.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlatticenode_getoutputdistance.restype = ctypes.c_int32
			self.lib.lib3mf_beamlatticenode_getoutputdistance.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_beamlatticenode_setaccuraterange.restype = ctypes.c_int32
			self.lib.lib3mf_beamlatticenode_setaccuraterange.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_beamlatticenode_getaccuraterange.restype = ctypes.c_int32
			self.lib.lib3mf_beamlatticenode_getaccuraterange.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_functiongradientnode_getinputfunctionid.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getinputfunctionid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functiongradientnode_getinputpos.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getinputpos.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functiongradientnode_getinputstep.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getinputstep.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functiongradientnode_setscalaroutputname.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_setscalaroutputname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_functiongradientnode_getscalaroutputname.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getscalaroutputname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_functiongradientnode_setvectorinputname.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_setvectorinputname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_functiongradientnode_getvectorinputname.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getvectorinputname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_functiongradientnode_getoutputnormalizedgradient.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getoutputnormalizedgradient.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functiongradientnode_getoutputgradient.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getoutputgradient.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functiongradientnode_getoutputmagnitude.restype = ctypes.c_int32
			self.lib.lib3mf_functiongradientnode_getoutputmagnitude.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_normalizedistancenode_getinputfunctionid.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getinputfunctionid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_normalizedistancenode_getinputpos.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getinputpos.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_normalizedistancenode_getinputstep.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getinputstep.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_normalizedistancenode_setscalaroutputname.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_setscalaroutputname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_normalizedistancenode_getscalaroutputname.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getscalaroutputname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_normalizedistancenode_setvectorinputname.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_setvectorinputname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_normalizedistancenode_getvectorinputname.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getvectorinputname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_normalizedistancenode_getoutputresult.restype = ctypes.c_int32
			self.lib.lib3mf_normalizedistancenode_getoutputresult.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functioncallnode_getinputfunctionid.restype = ctypes.c_int32
			self.lib.lib3mf_functioncallnode_getinputfunctionid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_nodeiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_nodeiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_getdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_function_getdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_function_setdisplayname.restype = ctypes.c_int32
			self.lib.lib3mf_function_setdisplayname.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_function_addinput.restype = ctypes.c_int32
			self.lib.lib3mf_function_addinput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ImplicitPortType, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_getinputs.restype = ctypes.c_int32
			self.lib.lib3mf_function_getinputs.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_removeinput.restype = ctypes.c_int32
			self.lib.lib3mf_function_removeinput.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_function_addoutput.restype = ctypes.c_int32
			self.lib.lib3mf_function_addoutput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ImplicitPortType, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_getoutputs.restype = ctypes.c_int32
			self.lib.lib3mf_function_getoutputs.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_removeoutput.restype = ctypes.c_int32
			self.lib.lib3mf_function_removeoutput.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_function_findinput.restype = ctypes.c_int32
			self.lib.lib3mf_function_findinput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_function_findoutput.restype = ctypes.c_int32
			self.lib.lib3mf_function_findoutput.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_getidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_getidentifier.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_implicitfunction_setidentifier.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_setidentifier.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitfunction_addnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addnode.argtypes = [ctypes.c_void_p, ImplicitNodeType, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addsinnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addsinnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addcosnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addcosnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addtannode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addtannode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addarcsinnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addarcsinnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addarccosnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addarccosnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addarctan2node.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addarctan2node.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addsinhnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addsinhnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addcoshnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addcoshnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addtanhnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addtanhnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addroundnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addroundnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addceilnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addceilnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addfloornode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addfloornode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addsignnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addsignnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addfractnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addfractnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addabsnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addabsnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addexpnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addexpnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addlognode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlognode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addlog2node.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlog2node.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addlog10node.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlog10node.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addlengthnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlengthnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addtransposenode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addtransposenode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addinversenode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addinversenode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addsqrtnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addsqrtnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addresourceidnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addresourceidnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addadditionnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addadditionnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addsubtractionnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addsubtractionnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmultiplicationnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmultiplicationnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_adddivisionnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_adddivisionnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_adddotnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_adddotnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addcrossnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addcrossnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmatvecmultiplicationnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmatvecmultiplicationnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addminnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addminnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmaxnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmaxnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addfmodnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addfmodnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addpownode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addpownode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addselectnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addselectnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addclampnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addclampnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ImplicitNodeConfiguration, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addcomposevectornode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addcomposevectornode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addvectorfromscalarnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addvectorfromscalarnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_adddecomposevectornode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_adddecomposevectornode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addcomposematrixnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addcomposematrixnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmatrixfromrowsnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmatrixfromrowsnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmatrixfromcolumnsnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmatrixfromcolumnsnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addconstantnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addconstantnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addconstvecnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addconstvecnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addconstmatnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addconstmatnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addmeshnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addmeshnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addunsignedmeshnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addunsignedmeshnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addbeamlatticenode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addbeamlatticenode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addfunctiongradientnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addfunctiongradientnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addnormalizedistancenode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addnormalizedistancenode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_addfunctioncallnode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addfunctioncallnode.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_getnodes.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_getnodes.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_implicitfunction_removenode.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_removenode.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_implicitfunction_addlink.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlink.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_implicitfunction_addlinkbynames.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_addlinkbynames.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p]
			
			self.lib.lib3mf_implicitfunction_clear.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_clear.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_implicitfunction_sortnodestopologically.restype = ctypes.c_int32
			self.lib.lib3mf_implicitfunction_sortnodestopologically.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_functionfromimage3d_getimage3d.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_getimage3d.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_functionfromimage3d_setimage3d.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_setimage3d.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_functionfromimage3d_setfilter.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_setfilter.argtypes = [ctypes.c_void_p, TextureFilter]
			
			self.lib.lib3mf_functionfromimage3d_getfilter.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_getfilter.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_functionfromimage3d_settilestyles.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_settilestyles.argtypes = [ctypes.c_void_p, TextureTileStyle, TextureTileStyle, TextureTileStyle]
			
			self.lib.lib3mf_functionfromimage3d_gettilestyles.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_gettilestyles.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32), ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_functionfromimage3d_getoffset.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_getoffset.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_functionfromimage3d_setoffset.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_setoffset.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_functionfromimage3d_getscale.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_getscale.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_functionfromimage3d_setscale.restype = ctypes.c_int32
			self.lib.lib3mf_functionfromimage3d_setscale.argtypes = [ctypes.c_void_p, ctypes.c_double]
			
			self.lib.lib3mf_builditem_getobjectresource.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjectresource.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditem_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_getobjectresourceid.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjectresourceid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_builditem_hasobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_hasobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditem_getobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_builditem_setobjecttransform.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setobjecttransform.argtypes = [ctypes.c_void_p, ctypes.POINTER(Transform)]
			
			self.lib.lib3mf_builditem_getpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_setpartnumber.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_setpartnumber.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_builditem_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditem_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_builditem_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_builditemiterator_movenext.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_movenext.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditemiterator_moveprevious.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_moveprevious.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_builditemiterator_getcurrent.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_getcurrent.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditemiterator_clone.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_clone.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_builditemiterator_count.restype = ctypes.c_int32
			self.lib.lib3mf_builditemiterator_count.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_setvertices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_setvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(Position2D)]
			
			self.lib.lib3mf_slice_getvertices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getvertices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(Position2D)]
			
			self.lib.lib3mf_slice_getvertexcount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getvertexcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_addpolygon.restype = ctypes.c_int32
			self.lib.lib3mf_slice_addpolygon.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_getpolygoncount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygoncount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_setpolygonindices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_setpolygonindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_slice_getpolygonindices.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygonindices.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_slice_getpolygonindexcount.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getpolygonindexcount.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slice_getztop.restype = ctypes.c_int32
			self.lib.lib3mf_slice_getztop.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_slicestack_getbottomz.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getbottomz.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_double)]
			
			self.lib.lib3mf_slicestack_getslicecount.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicecount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestack_getslice.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslice.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_addslice.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_addslice.argtypes = [ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_getslicerefcount.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicerefcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_slicestack_addslicestackreference.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_addslicestackreference.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_slicestack_getslicestackreference.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getslicestackreference.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_slicestack_collapseslicereferences.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_collapseslicereferences.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_slicestack_setownpath.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_setownpath.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_slicestack_getownpath.restype = ctypes.c_int32
			self.lib.lib3mf_slicestack_getownpath.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getconsumerid.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getconsumerid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getkeyid.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getkeyid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_consumer_getkeyvalue.restype = ctypes.c_int32
			self.lib.lib3mf_consumer_getkeyvalue.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_accessright_getconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getconsumer.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_accessright_getwrappingalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getwrappingalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_accessright_getmgfalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getmgfalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_accessright_getdigestmethod.restype = ctypes.c_int32
			self.lib.lib3mf_accessright_getdigestmethod.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getencryptionalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_contentencryptionparams_getkey.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getkey.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getinitializationvector.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getinitializationvector.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getauthenticationtag.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_setauthenticationtag.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_contentencryptionparams_getdescriptor.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getdescriptor.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_contentencryptionparams_getkeyuuid.restype = ctypes.c_int32
			self.lib.lib3mf_contentencryptionparams_getkeyuuid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_resourcedata_getpath.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getpath.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedata_getencryptionalgorithm.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getencryptionalgorithm.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_resourcedata_getcompression.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getcompression.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedata_getadditionalauthenticationdata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint8)]
			
			self.lib.lib3mf_resourcedatagroup_getkeyuuid.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_getkeyuuid.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_resourcedatagroup_addaccessright.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_addaccessright.argtypes = [ctypes.c_void_p, ctypes.c_void_p, WrappingAlgorithm, MgfAlgorithm, DigestMethod, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_resourcedatagroup_removeaccessright.restype = ctypes.c_int32
			self.lib.lib3mf_resourcedatagroup_removeaccessright.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_addconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addconsumer.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getconsumercount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getconsumercount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_getconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getconsumer.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeconsumer.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findconsumer.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findconsumer.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatagroupcount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatagroupcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_addresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findresourcedatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findresourcedatagroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_addresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_addresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, EncryptionAlgorithm, Compression, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint8), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_removeresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_removeresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_keystore_findresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_findresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getresourcedatacount.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedatacount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.lib3mf_keystore_getresourcedata.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getresourcedata.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_keystore_getuuid.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_getuuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_keystore_setuuid.restype = ctypes.c_int32
			self.lib.lib3mf_keystore_setuuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_rootmodelpart.restype = ctypes.c_int32
			self.lib.lib3mf_model_rootmodelpart.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_findorcreatepackagepart.restype = ctypes.c_int32
			self.lib.lib3mf_model_findorcreatepackagepart.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_setunit.restype = ctypes.c_int32
			self.lib.lib3mf_model_setunit.argtypes = [ctypes.c_void_p, ModelUnit]
			
			self.lib.lib3mf_model_getunit.restype = ctypes.c_int32
			self.lib.lib3mf_model_getunit.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_model_getlanguage.restype = ctypes.c_int32
			self.lib.lib3mf_model_getlanguage.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_model_setlanguage.restype = ctypes.c_int32
			self.lib.lib3mf_model_setlanguage.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_querywriter.restype = ctypes.c_int32
			self.lib.lib3mf_model_querywriter.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_queryreader.restype = ctypes.c_int32
			self.lib.lib3mf_model_queryreader.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getresourcebyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getresourcebyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getpropertytypebyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getpropertytypebyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_int32)]
			
			self.lib.lib3mf_model_getbasematerialgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbasematerialgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcompositematerialsbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcompositematerialsbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmultipropertygroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmultipropertygroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmeshobjectbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmeshobjectbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcomponentsobjectbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcomponentsobjectbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcolorgroupbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcolorgroupbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getslicestackbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getslicestackbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getlevelsetbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getlevelsetbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getbuilduuid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbuilduuid.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool), ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p]
			
			self.lib.lib3mf_model_setbuilduuid.restype = ctypes.c_int32
			self.lib.lib3mf_model_setbuilduuid.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_getbuilditems.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbuilditems.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getoutbox.restype = ctypes.c_int32
			self.lib.lib3mf_model_getoutbox.argtypes = [ctypes.c_void_p, ctypes.POINTER(Box)]
			
			self.lib.lib3mf_model_getresources.restype = ctypes.c_int32
			self.lib.lib3mf_model_getresources.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmeshobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmeshobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcomponentsobjects.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcomponentsobjects.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2ds.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2ds.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getbasematerialgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getbasematerialgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcolorgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcolorgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_gettexture2dgroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_gettexture2dgroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_model_getcompositematerials.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getmultipropertygroups.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmultipropertygroups.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getslicestacks.restype = ctypes.c_int32
			self.lib.lib3mf_model_getslicestacks.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getimage3ds.restype = ctypes.c_int32
			self.lib.lib3mf_model_getimage3ds.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_mergetomodel.restype = ctypes.c_int32
			self.lib.lib3mf_model_mergetomodel.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_mergefrommodel.restype = ctypes.c_int32
			self.lib.lib3mf_model_mergefrommodel.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_model_addmeshobject.restype = ctypes.c_int32
			self.lib.lib3mf_model_addmeshobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcomponentsobject.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcomponentsobject.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addslicestack.restype = ctypes.c_int32
			self.lib.lib3mf_model_addslicestack.argtypes = [ctypes.c_void_p, ctypes.c_double, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addtexture2dfromattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_addtexture2dfromattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addbasematerialgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addbasematerialgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcolorgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcolorgroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addtexture2dgroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addtexture2dgroup.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addcompositematerials.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcompositematerials.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addmultipropertygroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_addmultipropertygroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addimagestack.restype = ctypes.c_int32
			self.lib.lib3mf_model_addimagestack.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.c_uint32, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getimagestackbyid.restype = ctypes.c_int32
			self.lib.lib3mf_model_getimagestackbyid.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addbuilditem.restype = ctypes.c_int32
			self.lib.lib3mf_model_addbuilditem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(Transform), ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removebuilditem.restype = ctypes.c_int32
			self.lib.lib3mf_model_removebuilditem.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getmetadatagroup.restype = ctypes.c_int32
			self.lib.lib3mf_model_getmetadatagroup.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_addattachment.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removeattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_removeattachment.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_getattachment.argtypes = [ctypes.c_void_p, ctypes.c_uint32, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_findattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_findattachment.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getattachmentcount.restype = ctypes.c_int32
			self.lib.lib3mf_model_getattachmentcount.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.lib3mf_model_haspackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_haspackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.lib3mf_model_createpackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_createpackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getpackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_getpackagethumbnailattachment.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removepackagethumbnailattachment.restype = ctypes.c_int32
			self.lib.lib3mf_model_removepackagethumbnailattachment.argtypes = [ctypes.c_void_p]
			
			self.lib.lib3mf_model_addcustomcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_model_addcustomcontenttype.argtypes = [ctypes.c_void_p, ctypes.c_char_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_removecustomcontenttype.restype = ctypes.c_int32
			self.lib.lib3mf_model_removecustomcontenttype.argtypes = [ctypes.c_void_p, ctypes.c_char_p]
			
			self.lib.lib3mf_model_setrandomnumbercallback.restype = ctypes.c_int32
			self.lib.lib3mf_model_setrandomnumbercallback.argtypes = [ctypes.c_void_p, RandomNumberCallback, ctypes.c_void_p]
			
			self.lib.lib3mf_model_getkeystore.restype = ctypes.c_int32
			self.lib.lib3mf_model_getkeystore.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getfunctions.restype = ctypes.c_int32
			self.lib.lib3mf_model_getfunctions.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addimplicitfunction.restype = ctypes.c_int32
			self.lib.lib3mf_model_addimplicitfunction.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addfunctionfromimage3d.restype = ctypes.c_int32
			self.lib.lib3mf_model_addfunctionfromimage3d.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addvolumedata.restype = ctypes.c_int32
			self.lib.lib3mf_model_addvolumedata.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_addlevelset.restype = ctypes.c_int32
			self.lib.lib3mf_model_addlevelset.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_getlevelsets.restype = ctypes.c_int32
			self.lib.lib3mf_model_getlevelsets.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.lib3mf_model_removeresource.restype = ctypes.c_int32
			self.lib.lib3mf_model_removeresource.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
			
		except AttributeError as ae:
			raise ELib3MFException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
	
	def _checkBinaryVersion(self):
		nMajor, nMinor, _ = self.GetLibraryVersion()
		if (nMajor != BindingVersion.MAJOR) or (nMinor < BindingVersion.MINOR):
			raise ELib3MFException(ErrorCodes.INCOMPATIBLEBINARYVERSION)
	
	def checkError(self, instance, errorCode):
		ec = globals().get('ErrorCodes')
		if ec is None:
			# Interpreter shutdown: ErrorCodes may already be cleared; avoid noisy teardown
			return
		if errorCode != ec.SUCCESS.value:
			if instance:
				if instance._wrapper != self:
					raise ELib3MFException(ec.INVALIDCAST, 'invalid wrapper call')
			message,_ = self.GetLastError(instance)
			raise ELib3MFException(errorCode, message)
	
	def GetLibraryVersion(self, Major = None, Minor = None, Micro = None):
		pMajor = ctypes.c_uint32(Major if Major is not None else 0)
		pMinor = ctypes.c_uint32(Minor if Minor is not None else 0)
		pMicro = ctypes.c_uint32(Micro if Micro is not None else 0)
		self.checkError(None, self.lib.lib3mf_getlibraryversion(pMajor, pMinor, pMicro))
		
		return pMajor.value, pMinor.value, pMicro.value
	
	def GetPrereleaseInformation(self, PrereleaseInfo = None):
		pHasPrereleaseInfo = ctypes.c_bool()
		nPrereleaseInfoBufferSize = ctypes.c_uint64(len(PrereleaseInfo) if PrereleaseInfo else 0)
		nPrereleaseInfoNeededChars = ctypes.c_uint64(0)
		pPrereleaseInfoBuffer = ctypes.c_char_p(str.encode(PrereleaseInfo) if PrereleaseInfo else None)
		self.checkError(None, self.lib.lib3mf_getprereleaseinformation(pHasPrereleaseInfo, nPrereleaseInfoBufferSize, nPrereleaseInfoNeededChars, pPrereleaseInfoBuffer))
		nPrereleaseInfoBufferSize = ctypes.c_uint64(nPrereleaseInfoNeededChars.value)
		pPrereleaseInfoBuffer = (ctypes.c_char * (nPrereleaseInfoNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getprereleaseinformation(pHasPrereleaseInfo, nPrereleaseInfoBufferSize, nPrereleaseInfoNeededChars, pPrereleaseInfoBuffer))
		
		return pHasPrereleaseInfo.value, pPrereleaseInfoBuffer.value.decode()
	
	def GetBuildInformation(self, BuildInformation = None):
		pHasBuildInfo = ctypes.c_bool()
		nBuildInformationBufferSize = ctypes.c_uint64(len(BuildInformation) if BuildInformation else 0)
		nBuildInformationNeededChars = ctypes.c_uint64(0)
		pBuildInformationBuffer = ctypes.c_char_p(str.encode(BuildInformation) if BuildInformation else None)
		self.checkError(None, self.lib.lib3mf_getbuildinformation(pHasBuildInfo, nBuildInformationBufferSize, nBuildInformationNeededChars, pBuildInformationBuffer))
		nBuildInformationBufferSize = ctypes.c_uint64(nBuildInformationNeededChars.value)
		pBuildInformationBuffer = (ctypes.c_char * (nBuildInformationNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getbuildinformation(pHasBuildInfo, nBuildInformationBufferSize, nBuildInformationNeededChars, pBuildInformationBuffer))
		
		return pHasBuildInfo.value, pBuildInformationBuffer.value.decode()
	
	def GetSpecificationVersion(self, SpecificationURL, IsSupported = None, Major = None, Minor = None, Micro = None):
		pSpecificationURL = ctypes.c_char_p(str.encode(SpecificationURL))
		pIsSupported = ctypes.c_bool(IsSupported if IsSupported is not None else 0)
		pMajor = ctypes.c_uint32(Major if Major is not None else 0)
		pMinor = ctypes.c_uint32(Minor if Minor is not None else 0)
		pMicro = ctypes.c_uint32(Micro if Micro is not None else 0)
		self.checkError(None, self.lib.lib3mf_getspecificationversion(pSpecificationURL, pIsSupported, pMajor, pMinor, pMicro))
		
		return pIsSupported.value, pMajor.value, pMinor.value, pMicro.value
	
	def CreateModel(self):
		ModelHandle = ctypes.c_void_p()
		self.checkError(None, self.lib.lib3mf_createmodel(ModelHandle))
		if ModelHandle:
			ModelObject = self._polymorphicFactory(ModelHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ModelObject
	
	def Release(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.lib3mf_release(InstanceHandle))
		
	
	def Acquire(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.lib3mf_acquire(InstanceHandle))
		
	
	def SetJournal(self, JournalPath):
		pJournalPath = ctypes.c_char_p(str.encode(JournalPath))
		self.checkError(None, self.lib.lib3mf_setjournal(pJournalPath))
		
	
	def GetLastError(self, InstanceObject, LastErrorString = None):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		nLastErrorStringBufferSize = ctypes.c_uint64(len(LastErrorString) if LastErrorString else 0)
		nLastErrorStringNeededChars = ctypes.c_uint64(0)
		pLastErrorStringBuffer = ctypes.c_char_p(str.encode(LastErrorString) if LastErrorString else None)
		pHasLastError = ctypes.c_bool()
		self.checkError(None, self.lib.lib3mf_getlasterror(InstanceHandle, nLastErrorStringBufferSize, nLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError))
		nLastErrorStringBufferSize = ctypes.c_uint64(nLastErrorStringNeededChars.value)
		pLastErrorStringBuffer = (ctypes.c_char * (nLastErrorStringNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_getlasterror(InstanceHandle, nLastErrorStringBufferSize, nLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError))
		
		return pLastErrorStringBuffer.value.decode(), pHasLastError.value
	
	def GetSymbolLookupMethod(self):
		pSymbolLookupMethod = ctypes.c_void_p()
		self.checkError(None, self.lib.lib3mf_getsymbollookupmethod(pSymbolLookupMethod))
		
		return pSymbolLookupMethod.value
	
	def RetrieveProgressMessage(self, TheProgressIdentifier, ProgressMessage = None):
		nProgressMessageBufferSize = ctypes.c_uint64(len(ProgressMessage) if ProgressMessage else 0)
		nProgressMessageNeededChars = ctypes.c_uint64(0)
		pProgressMessageBuffer = ctypes.c_char_p(str.encode(ProgressMessage) if ProgressMessage else None)
		self.checkError(None, self.lib.lib3mf_retrieveprogressmessage(TheProgressIdentifier, nProgressMessageBufferSize, nProgressMessageNeededChars, pProgressMessageBuffer))
		nProgressMessageBufferSize = ctypes.c_uint64(nProgressMessageNeededChars.value)
		pProgressMessageBuffer = (ctypes.c_char * (nProgressMessageNeededChars.value))()
		self.checkError(None, self.lib.lib3mf_retrieveprogressmessage(TheProgressIdentifier, nProgressMessageBufferSize, nProgressMessageNeededChars, pProgressMessageBuffer))
		
		return pProgressMessageBuffer.value.decode()
	
	def RGBAToColor(self, Red, Green, Blue, Alpha):
		nRed = ctypes.c_uint8(Red)
		nGreen = ctypes.c_uint8(Green)
		nBlue = ctypes.c_uint8(Blue)
		nAlpha = ctypes.c_uint8(Alpha)
		pTheColor = Color()
		self.checkError(None, self.lib.lib3mf_rgbatocolor(nRed, nGreen, nBlue, nAlpha, pTheColor))
		
		return pTheColor
	
	def FloatRGBAToColor(self, Red, Green, Blue, Alpha):
		fRed = ctypes.c_float(Red)
		fGreen = ctypes.c_float(Green)
		fBlue = ctypes.c_float(Blue)
		fAlpha = ctypes.c_float(Alpha)
		pTheColor = Color()
		self.checkError(None, self.lib.lib3mf_floatrgbatocolor(fRed, fGreen, fBlue, fAlpha, pTheColor))
		
		return pTheColor
	
	def ColorToRGBA(self, TheColor, Red = None, Green = None, Blue = None, Alpha = None):
		pRed = ctypes.c_uint8(Red if Red is not None else 0)
		pGreen = ctypes.c_uint8(Green if Green is not None else 0)
		pBlue = ctypes.c_uint8(Blue if Blue is not None else 0)
		pAlpha = ctypes.c_uint8(Alpha if Alpha is not None else 0)
		self.checkError(None, self.lib.lib3mf_colortorgba(TheColor, pRed, pGreen, pBlue, pAlpha))
		
		return pRed.value, pGreen.value, pBlue.value, pAlpha.value
	
	def ColorToFloatRGBA(self, TheColor, Red = None, Green = None, Blue = None, Alpha = None):
		pRed = ctypes.c_float(Red if Red is not None else 0)
		pGreen = ctypes.c_float(Green if Green is not None else 0)
		pBlue = ctypes.c_float(Blue if Blue is not None else 0)
		pAlpha = ctypes.c_float(Alpha if Alpha is not None else 0)
		self.checkError(None, self.lib.lib3mf_colortofloatrgba(TheColor, pRed, pGreen, pBlue, pAlpha))
		
		return pRed.value, pGreen.value, pBlue.value, pAlpha.value
	
	def GetIdentityTransform(self):
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getidentitytransform(pTransform))
		
		return pTransform
	
	def GetUniformScaleTransform(self, Factor):
		fFactor = ctypes.c_float(Factor)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getuniformscaletransform(fFactor, pTransform))
		
		return pTransform
	
	def GetScaleTransform(self, FactorX, FactorY, FactorZ):
		fFactorX = ctypes.c_float(FactorX)
		fFactorY = ctypes.c_float(FactorY)
		fFactorZ = ctypes.c_float(FactorZ)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_getscaletransform(fFactorX, fFactorY, fFactorZ, pTransform))
		
		return pTransform
	
	def GetTranslationTransform(self, VectorX, VectorY, VectorZ):
		fVectorX = ctypes.c_float(VectorX)
		fVectorY = ctypes.c_float(VectorY)
		fVectorZ = ctypes.c_float(VectorZ)
		pTransform = Transform()
		self.checkError(None, self.lib.lib3mf_gettranslationtransform(fVectorX, fVectorY, fVectorZ, pTransform))
		
		return pTransform
	
	'''IMPORTANT: PolymorphicFactory method should not be used by application directly.
								It's designed to be used on Lib3MFHandle object only once.
								If it's used on any existing object as a form of dynamic cast then
								Wrapper.AcquireInstance(object) must be called after instantiating new object.
								This is important to keep reference count matching between application and library sides.
	'''
	def _polymorphicFactory(self, handle):
		class PolymorphicFactory():
			def getObjectById(self, classtypeid, handle, wrapper):
				methodName = 'getObjectById_' + format(classtypeid.value, '016X')
				method = getattr(self, methodName, lambda: 'Invalid class type id')
				return method(handle, wrapper)
			def getObjectById_856632D0BAF1D8B7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Base"
				return Base(handle, wrapper)
			def getObjectById_E76F642F363FD7E9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Writer"
				return Writer(handle, wrapper)
			def getObjectById_2D86831DA59FBE72(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Reader"
				return Reader(handle, wrapper)
			def getObjectById_0E55A826D377483E(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
				return PackagePart(handle, wrapper)
			def getObjectById_DFE3889D1B269CBB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Resource"
				return Resource(handle, wrapper)
			def getObjectById_460F3515E2621DBE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
				return ResourceIterator(handle, wrapper)
			def getObjectById_69684DB99FA813F6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
				return SliceStackIterator(handle, wrapper)
			def getObjectById_DE92510BD2112288(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
				return ObjectIterator(handle, wrapper)
			def getObjectById_F4196034E2B9FDE6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
				return MeshObjectIterator(handle, wrapper)
			def getObjectById_564DE4217ED7614A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
				return ComponentsObjectIterator(handle, wrapper)
			def getObjectById_4BD32B4870FFC03B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
				return Texture2DIterator(handle, wrapper)
			def getObjectById_65E6EDD9362C79CB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
				return BaseMaterialGroupIterator(handle, wrapper)
			def getObjectById_10274A1757C729C0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
				return ColorGroupIterator(handle, wrapper)
			def getObjectById_30D55F4DB88FE0CA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
				return Texture2DGroupIterator(handle, wrapper)
			def getObjectById_A99CC6C3F70FB6F9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
				return CompositeMaterialsIterator(handle, wrapper)
			def getObjectById_C2BDF5D8CBBDB1F0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
				return MultiPropertyGroupIterator(handle, wrapper)
			def getObjectById_C4B8EC00A82BF336(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Image3DIterator"
				return Image3DIterator(handle, wrapper)
			def getObjectById_40E9035363ACE65E(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FunctionIterator"
				return FunctionIterator(handle, wrapper)
			def getObjectById_A0C005C035D5371D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::LevelSetIterator"
				return LevelSetIterator(handle, wrapper)
			def getObjectById_D17716D063DE2C22(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
				return MetaData(handle, wrapper)
			def getObjectById_0C3B85369E9B25D3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
				return MetaDataGroup(handle, wrapper)
			def getObjectById_5950BB3EE8A82090(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::TriangleSet"
				return TriangleSet(handle, wrapper)
			def getObjectById_2DA2136F577A779C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Object"
				return Object(handle, wrapper)
			def getObjectById_3B3A6DC6EC610497(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
				return MeshObject(handle, wrapper)
			def getObjectById_E8A7D9C192EFD0E2(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::LevelSet"
				return LevelSet(handle, wrapper)
			def getObjectById_63B3B461B30B4BA5(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
				return BeamLattice(handle, wrapper)
			def getObjectById_4DF17E76926221C2(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FunctionReference"
				return FunctionReference(handle, wrapper)
			def getObjectById_D85B5B6143E787E3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataColor"
				return VolumeDataColor(handle, wrapper)
			def getObjectById_241FE6B4817C3FE4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MaterialMapping"
				return MaterialMapping(handle, wrapper)
			def getObjectById_46F1DAC40581B304(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataComposite"
				return VolumeDataComposite(handle, wrapper)
			def getObjectById_FC368AA44ACE42DA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataProperty"
				return VolumeDataProperty(handle, wrapper)
			def getObjectById_9200586FB91587A7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::VolumeData"
				return VolumeData(handle, wrapper)
			def getObjectById_4ECDB6A6F69F2BEB(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Component"
				return Component(handle, wrapper)
			def getObjectById_6522CF04EB283FED(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
				return ComponentsObject(handle, wrapper)
			def getObjectById_30CCDBE90E00B55B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
				return BeamSet(handle, wrapper)
			def getObjectById_B27D4656E16609FA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
				return BaseMaterialGroup(handle, wrapper)
			def getObjectById_D085FB2E49CDB5B1(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
				return ColorGroup(handle, wrapper)
			def getObjectById_BC1208397E37055D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
				return Texture2DGroup(handle, wrapper)
			def getObjectById_CE16224D688B86F2(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
				return CompositeMaterials(handle, wrapper)
			def getObjectById_B989E02E43158FE6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
				return MultiPropertyGroup(handle, wrapper)
			def getObjectById_BD938FF2D2663D61(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Image3D"
				return Image3D(handle, wrapper)
			def getObjectById_13A2561F0CFB712A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ImageStack"
				return ImageStack(handle, wrapper)
			def getObjectById_8CE7A1191A63A35D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
				return Attachment(handle, wrapper)
			def getObjectById_E0441CF976B36319(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
				return Texture2D(handle, wrapper)
			def getObjectById_D5C49B04AF1963CD(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPort"
				return ImplicitPort(handle, wrapper)
			def getObjectById_52F06268CD098EFE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Iterator"
				return Iterator(handle, wrapper)
			def getObjectById_C62268F2D7C7012C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPortIterator"
				return ImplicitPortIterator(handle, wrapper)
			def getObjectById_E72592A7725AB29B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ImplicitNode"
				return ImplicitNode(handle, wrapper)
			def getObjectById_B19B9FDA94B0A5E7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::OneInputNode"
				return OneInputNode(handle, wrapper)
			def getObjectById_D5AEA50A56306722(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SinNode"
				return SinNode(handle, wrapper)
			def getObjectById_59BC328F6FB5C5FF(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CosNode"
				return CosNode(handle, wrapper)
			def getObjectById_2614CC572AF350B7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::TanNode"
				return TanNode(handle, wrapper)
			def getObjectById_E554C8A7E72AAF4D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ArcSinNode"
				return ArcSinNode(handle, wrapper)
			def getObjectById_943AF6AE0EFD2B8A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ArcCosNode"
				return ArcCosNode(handle, wrapper)
			def getObjectById_E47D547615816BAD(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ArcTanNode"
				return ArcTanNode(handle, wrapper)
			def getObjectById_3C7756A456F2D089(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SinhNode"
				return SinhNode(handle, wrapper)
			def getObjectById_4A993F91E1DE256D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CoshNode"
				return CoshNode(handle, wrapper)
			def getObjectById_CF077B19B0B78E9D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::TanhNode"
				return TanhNode(handle, wrapper)
			def getObjectById_D9F5A53C657765AE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::RoundNode"
				return RoundNode(handle, wrapper)
			def getObjectById_627E211653E11D93(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CeilNode"
				return CeilNode(handle, wrapper)
			def getObjectById_392A0F4C041D249C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FloorNode"
				return FloorNode(handle, wrapper)
			def getObjectById_8A45165E6C9646D7(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SignNode"
				return SignNode(handle, wrapper)
			def getObjectById_53E62FD67F4D9A65(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FractNode"
				return FractNode(handle, wrapper)
			def getObjectById_6B641C7060040BE3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::AbsNode"
				return AbsNode(handle, wrapper)
			def getObjectById_3390243A8E2410F3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ExpNode"
				return ExpNode(handle, wrapper)
			def getObjectById_0070021D73AA89FD(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::LogNode"
				return LogNode(handle, wrapper)
			def getObjectById_E8C0ABF7C5DC7068(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Log2Node"
				return Log2Node(handle, wrapper)
			def getObjectById_87740AD53454E0DF(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Log10Node"
				return Log10Node(handle, wrapper)
			def getObjectById_D85889E2739A74B1(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::LengthNode"
				return LengthNode(handle, wrapper)
			def getObjectById_A808B7599C158CE6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::TransposeNode"
				return TransposeNode(handle, wrapper)
			def getObjectById_E8601F66A23A0540(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::InverseNode"
				return InverseNode(handle, wrapper)
			def getObjectById_9F831944A3DE31DA(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SqrtNode"
				return SqrtNode(handle, wrapper)
			def getObjectById_CA86A77C71CD3FAE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceIdNode"
				return ResourceIdNode(handle, wrapper)
			def getObjectById_7DE3951BA4C1064C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::TwoInputNode"
				return TwoInputNode(handle, wrapper)
			def getObjectById_57A2236998DF5248(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::AdditionNode"
				return AdditionNode(handle, wrapper)
			def getObjectById_6079B12FFF345D02(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SubtractionNode"
				return SubtractionNode(handle, wrapper)
			def getObjectById_A3C27CF54C2AA76C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MultiplicationNode"
				return MultiplicationNode(handle, wrapper)
			def getObjectById_B896B6413C08CF39(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::DivisionNode"
				return DivisionNode(handle, wrapper)
			def getObjectById_FE60932A66375FAD(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::DotNode"
				return DotNode(handle, wrapper)
			def getObjectById_106182D38CA5CFE3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::CrossNode"
				return CrossNode(handle, wrapper)
			def getObjectById_B6153EF5DE7E5E11(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ArcTan2Node"
				return ArcTan2Node(handle, wrapper)
			def getObjectById_7570C43B9721D0C0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MatVecMultiplicationNode"
				return MatVecMultiplicationNode(handle, wrapper)
			def getObjectById_846AFDE9A091E997(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MinNode"
				return MinNode(handle, wrapper)
			def getObjectById_073F910381BF250D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MaxNode"
				return MaxNode(handle, wrapper)
			def getObjectById_1EF703D298223F2A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FmodNode"
				return FmodNode(handle, wrapper)
			def getObjectById_EA57335849379F22(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ModNode"
				return ModNode(handle, wrapper)
			def getObjectById_7700AA17CA1AC0F8(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::PowNode"
				return PowNode(handle, wrapper)
			def getObjectById_1127ED71E05A9BD4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SelectNode"
				return SelectNode(handle, wrapper)
			def getObjectById_77AF68C971B1485F(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ClampNode"
				return ClampNode(handle, wrapper)
			def getObjectById_49C24B8840C01F7E(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComposeVectorNode"
				return ComposeVectorNode(handle, wrapper)
			def getObjectById_2E417B93351375E2(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::VectorFromScalarNode"
				return VectorFromScalarNode(handle, wrapper)
			def getObjectById_CC4F8D561CCE35D4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::DecomposeVectorNode"
				return DecomposeVectorNode(handle, wrapper)
			def getObjectById_9EF9EB54A53AA40D(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ComposeMatrixNode"
				return ComposeMatrixNode(handle, wrapper)
			def getObjectById_D6DFD0A7EB64AC33(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromRowsNode"
				return MatrixFromRowsNode(handle, wrapper)
			def getObjectById_0DCBEAFCF83F3AAC(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromColumnsNode"
				return MatrixFromColumnsNode(handle, wrapper)
			def getObjectById_3F8E5D082F966B1B(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ConstantNode"
				return ConstantNode(handle, wrapper)
			def getObjectById_9C9363B3F708D556(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ConstVecNode"
				return ConstVecNode(handle, wrapper)
			def getObjectById_F85C90EDCE6F90A4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ConstMatNode"
				return ConstMatNode(handle, wrapper)
			def getObjectById_53601FD432E3DEF4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::MeshNode"
				return MeshNode(handle, wrapper)
			def getObjectById_29985A628251A9CD(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::UnsignedMeshNode"
				return UnsignedMeshNode(handle, wrapper)
			def getObjectById_0F3A4EE98F7FEC0C(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BeamLatticeNode"
				return BeamLatticeNode(handle, wrapper)
			def getObjectById_0437E27AEF740121(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FunctionGradientNode"
				return FunctionGradientNode(handle, wrapper)
			def getObjectById_817D2E566E73AA8F(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::NormalizeDistanceNode"
				return NormalizeDistanceNode(handle, wrapper)
			def getObjectById_0765C17C952F24E3(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FunctionCallNode"
				return FunctionCallNode(handle, wrapper)
			def getObjectById_FC006BC888CAB4D0(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::NodeIterator"
				return NodeIterator(handle, wrapper)
			def getObjectById_9EFB2757CA1A5231(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Function"
				return Function(handle, wrapper)
			def getObjectById_6CE54469EEA83BC1(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ImplicitFunction"
				return ImplicitFunction(handle, wrapper)
			def getObjectById_9BD7D3C2026B8CE8(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::FunctionFromImage3D"
				return FunctionFromImage3D(handle, wrapper)
			def getObjectById_68FB2D5FFC4BA12A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
				return BuildItem(handle, wrapper)
			def getObjectById_A7D21BD364910860(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
				return BuildItemIterator(handle, wrapper)
			def getObjectById_2198BCF4D8DF9C40(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Slice"
				return Slice(handle, wrapper)
			def getObjectById_6594B031B6096238(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
				return SliceStack(handle, wrapper)
			def getObjectById_D9E46D5E6D8118EE(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
				return Consumer(handle, wrapper)
			def getObjectById_385C42FC5609498A(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
				return AccessRight(handle, wrapper)
			def getObjectById_7FB36B91D4CE4671(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
				return ContentEncryptionParams(handle, wrapper)
			def getObjectById_1A47A5E258E22EF9(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
				return ResourceData(handle, wrapper)
			def getObjectById_D59067227E428AA4(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
				return ResourceDataGroup(handle, wrapper)
			def getObjectById_1CC9E0CC082253C6(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
				return KeyStore(handle, wrapper)
			def getObjectById_5A8164ECEDB03F09(self, handle, wrapper): # First 64 bits of SHA1 of a string: "Lib3MF::Model"
				return Model(handle, wrapper)
		
		if not handle:
			return None
		pClassTypeId = ctypes.c_uint64()
		self.checkError(None, self.lib.lib3mf_base_classtypeid(handle, pClassTypeId))
		factory = PolymorphicFactory()
		return factory.getObjectById(pClassTypeId, handle, self)
	


''' Class Implementation for Base
'''
class Base:
	def __init__(self, handle, wrapper):
		if not handle or not wrapper:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM)
		self._handle = handle
		self._wrapper = wrapper
	
	def __del__(self):
		self._wrapper.Release(self)
	def ClassTypeId(self):
		pClassTypeId = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_base_classtypeid(self._handle, pClassTypeId))
		
		return pClassTypeId.value
	


''' Class Implementation for Writer
'''
class Writer(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def WriteToFile(self, Filename):
		pFilename = ctypes.c_char_p(str.encode(Filename))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetofile(self._handle, pFilename))
		
	
	def GetStreamSize(self):
		pStreamSize = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getstreamsize(self._handle, pStreamSize))
		
		return pStreamSize.value
	
	def WriteToBuffer(self, Buffer = None):
		nBufferCount = ctypes.c_uint64(len(Buffer) if Buffer else 0)
		nBufferNeededCount = ctypes.c_uint64(0)
		pBufferBuffer = (ctypes.c_uint8*(len(Buffer) if Buffer else 0))(*Buffer if Buffer else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		nBufferCount = ctypes.c_uint64(nBufferNeededCount.value)
		pBufferBuffer = (ctypes.c_uint8 * nBufferNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		
		return list(pBufferBuffer)
	
	def WriteToCallback(self, TheWriteCallbackFunc, TheSeekCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_writetocallback(self._handle, TheWriteCallbackFunc, TheSeekCallbackFunc, pUserData))
		
	
	def SetProgressCallback(self, ProgressCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setprogresscallback(self._handle, ProgressCallbackFunc, pUserData))
		
	
	def GetDecimalPrecision(self):
		pDecimalPrecision = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getdecimalprecision(self._handle, pDecimalPrecision))
		
		return pDecimalPrecision.value
	
	def SetDecimalPrecision(self, DecimalPrecision):
		nDecimalPrecision = ctypes.c_uint32(DecimalPrecision)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setdecimalprecision(self._handle, nDecimalPrecision))
		
	
	def SetStrictModeActive(self, StrictModeActive):
		bStrictModeActive = ctypes.c_bool(StrictModeActive)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setstrictmodeactive(self._handle, bStrictModeActive))
		
	
	def GetStrictModeActive(self):
		pStrictModeActive = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getstrictmodeactive(self._handle, pStrictModeActive))
		
		return pStrictModeActive.value
	
	def GetWarning(self, Index, ErrorCode = None):
		nIndex = ctypes.c_uint32(Index)
		pErrorCode = ctypes.c_uint32(ErrorCode if ErrorCode is not None else 0)
		nWarningBufferSize = ctypes.c_uint64(0)
		nWarningNeededChars = ctypes.c_uint64(0)
		pWarningBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		nWarningBufferSize = ctypes.c_uint64(nWarningNeededChars.value)
		pWarningBuffer = (ctypes.c_char * (nWarningNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		
		return pErrorCode.value, pWarningBuffer.value.decode()
	
	def GetWarningCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_getwarningcount(self._handle, pCount))
		
		return pCount.value
	
	def AddKeyWrappingCallback(self, ConsumerID, TheCallbackFunc, UserData):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_addkeywrappingcallback(self._handle, pConsumerID, TheCallbackFunc, pUserData))
		
	
	def SetContentEncryptionCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_writer_setcontentencryptioncallback(self._handle, TheCallbackFunc, pUserData))
		
	


''' Class Implementation for Reader
'''
class Reader(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def ReadFromFile(self, Filename):
		pFilename = ctypes.c_char_p(str.encode(Filename))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfromfile(self._handle, pFilename))
		
	
	def ReadFromBuffer(self, Buffer):
		nBufferCount = ctypes.c_uint64(len(Buffer))
		pBufferBuffer = (ctypes.c_uint8*len(Buffer))(*Buffer)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfrombuffer(self._handle, nBufferCount, pBufferBuffer))
		
	
	def ReadFromCallback(self, TheReadCallbackFunc, StreamSize, TheSeekCallbackFunc, UserData):
		nStreamSize = ctypes.c_uint64(StreamSize)
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_readfromcallback(self._handle, TheReadCallbackFunc, nStreamSize, TheSeekCallbackFunc, pUserData))
		
	
	def SetProgressCallback(self, ProgressCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setprogresscallback(self._handle, ProgressCallbackFunc, pUserData))
		
	
	def AddRelationToRead(self, RelationShipType):
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_addrelationtoread(self._handle, pRelationShipType))
		
	
	def RemoveRelationToRead(self, RelationShipType):
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_removerelationtoread(self._handle, pRelationShipType))
		
	
	def SetStrictModeActive(self, StrictModeActive):
		bStrictModeActive = ctypes.c_bool(StrictModeActive)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setstrictmodeactive(self._handle, bStrictModeActive))
		
	
	def GetStrictModeActive(self):
		pStrictModeActive = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getstrictmodeactive(self._handle, pStrictModeActive))
		
		return pStrictModeActive.value
	
	def GetWarning(self, Index, ErrorCode = None):
		nIndex = ctypes.c_uint32(Index)
		pErrorCode = ctypes.c_uint32(ErrorCode if ErrorCode is not None else 0)
		nWarningBufferSize = ctypes.c_uint64(0)
		nWarningNeededChars = ctypes.c_uint64(0)
		pWarningBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		nWarningBufferSize = ctypes.c_uint64(nWarningNeededChars.value)
		pWarningBuffer = (ctypes.c_char * (nWarningNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarning(self._handle, nIndex, pErrorCode, nWarningBufferSize, nWarningNeededChars, pWarningBuffer))
		
		return pErrorCode.value, pWarningBuffer.value.decode()
	
	def GetWarningCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_getwarningcount(self._handle, pCount))
		
		return pCount.value
	
	def AddKeyWrappingCallback(self, ConsumerID, TheCallbackFunc, UserData):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_addkeywrappingcallback(self._handle, pConsumerID, TheCallbackFunc, pUserData))
		
	
	def SetContentEncryptionCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_reader_setcontentencryptioncallback(self._handle, TheCallbackFunc, pUserData))
		
	


''' Class Implementation for PackagePart
'''
class PackagePart(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_packagepart_setpath(self._handle, pPath))
		
	


''' Class Implementation for Resource
'''
class Resource(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def GetUniqueResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getuniqueresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def PackagePart(self):
		PackagePartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_packagepart(self._handle, PackagePartHandle))
		if PackagePartHandle:
			PackagePartObject = self._wrapper._polymorphicFactory(PackagePartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PackagePartObject
	
	def SetPackagePart(self, PackagePartObject):
		PackagePartHandle = None
		if PackagePartObject:
			PackagePartHandle = PackagePartObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_setpackagepart(self._handle, PackagePartHandle))
		
	
	def GetModelResourceID(self):
		pModelResourceId = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resource_getmodelresourceid(self._handle, pModelResourceId))
		
		return pModelResourceId.value
	


''' Class Implementation for ResourceIterator
'''
class ResourceIterator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def MoveNext(self):
		pHasNext = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_movenext(self._handle, pHasNext))
		
		return pHasNext.value
	
	def MovePrevious(self):
		pHasPrevious = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_moveprevious(self._handle, pHasPrevious))
		
		return pHasPrevious.value
	
	def GetCurrent(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_getcurrent(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	
	def Clone(self):
		OutResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_clone(self._handle, OutResourceIteratorHandle))
		if OutResourceIteratorHandle:
			OutResourceIteratorObject = self._wrapper._polymorphicFactory(OutResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return OutResourceIteratorObject
	
	def Count(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceiterator_count(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for SliceStackIterator
'''
class SliceStackIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentSliceStack(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestackiterator_getcurrentslicestack(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ObjectIterator
'''
class ObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_objectiterator_getcurrentobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MeshObjectIterator
'''
class MeshObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentMeshObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobjectiterator_getcurrentmeshobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ComponentsObjectIterator
'''
class ComponentsObjectIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentComponentsObject(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobjectiterator_getcurrentcomponentsobject(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for Texture2DIterator
'''
class Texture2DIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentTexture2D(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2diterator_getcurrenttexture2d(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for BaseMaterialGroupIterator
'''
class BaseMaterialGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentBaseMaterialGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for ColorGroupIterator
'''
class ColorGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentColorGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroupiterator_getcurrentcolorgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for Texture2DGroupIterator
'''
class Texture2DGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentTexture2DGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for CompositeMaterialsIterator
'''
class CompositeMaterialsIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentCompositeMaterials(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerialsiterator_getcurrentcompositematerials(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MultiPropertyGroupIterator
'''
class MultiPropertyGroupIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentMultiPropertyGroup(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for Image3DIterator
'''
class Image3DIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentImage3D(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_image3diterator_getcurrentimage3d(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for FunctionIterator
'''
class FunctionIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentFunction(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functioniterator_getcurrentfunction(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for LevelSetIterator
'''
class LevelSetIterator(ResourceIterator):
	def __init__(self, handle, wrapper):
		ResourceIterator.__init__(self, handle, wrapper)
	def GetCurrentLevelSet(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelsetiterator_getcurrentlevelset(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	


''' Class Implementation for MetaData
'''
class MetaData(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetNameSpace(self):
		nNameSpaceBufferSize = ctypes.c_uint64(0)
		nNameSpaceNeededChars = ctypes.c_uint64(0)
		pNameSpaceBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getnamespace(self._handle, nNameSpaceBufferSize, nNameSpaceNeededChars, pNameSpaceBuffer))
		nNameSpaceBufferSize = ctypes.c_uint64(nNameSpaceNeededChars.value)
		pNameSpaceBuffer = (ctypes.c_char * (nNameSpaceNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getnamespace(self._handle, nNameSpaceBufferSize, nNameSpaceNeededChars, pNameSpaceBuffer))
		
		return pNameSpaceBuffer.value.decode()
	
	def SetNameSpace(self, NameSpace):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setnamespace(self._handle, pNameSpace))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setname(self._handle, pName))
		
	
	def GetKey(self):
		nKeyBufferSize = ctypes.c_uint64(0)
		nKeyNeededChars = ctypes.c_uint64(0)
		pKeyBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getkey(self._handle, nKeyBufferSize, nKeyNeededChars, pKeyBuffer))
		nKeyBufferSize = ctypes.c_uint64(nKeyNeededChars.value)
		pKeyBuffer = (ctypes.c_char * (nKeyNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getkey(self._handle, nKeyBufferSize, nKeyNeededChars, pKeyBuffer))
		
		return pKeyBuffer.value.decode()
	
	def GetMustPreserve(self):
		pMustPreserve = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getmustpreserve(self._handle, pMustPreserve))
		
		return pMustPreserve.value
	
	def SetMustPreserve(self, MustPreserve):
		bMustPreserve = ctypes.c_bool(MustPreserve)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setmustpreserve(self._handle, bMustPreserve))
		
	
	def GetType(self):
		nTypeBufferSize = ctypes.c_uint64(0)
		nTypeNeededChars = ctypes.c_uint64(0)
		pTypeBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_gettype(self._handle, nTypeBufferSize, nTypeNeededChars, pTypeBuffer))
		nTypeBufferSize = ctypes.c_uint64(nTypeNeededChars.value)
		pTypeBuffer = (ctypes.c_char * (nTypeNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_gettype(self._handle, nTypeBufferSize, nTypeNeededChars, pTypeBuffer))
		
		return pTypeBuffer.value.decode()
	
	def SetType(self, Type):
		pType = ctypes.c_char_p(str.encode(Type))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_settype(self._handle, pType))
		
	
	def GetValue(self):
		nValueBufferSize = ctypes.c_uint64(0)
		nValueNeededChars = ctypes.c_uint64(0)
		pValueBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getvalue(self._handle, nValueBufferSize, nValueNeededChars, pValueBuffer))
		nValueBufferSize = ctypes.c_uint64(nValueNeededChars.value)
		pValueBuffer = (ctypes.c_char * (nValueNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_getvalue(self._handle, nValueBufferSize, nValueNeededChars, pValueBuffer))
		
		return pValueBuffer.value.decode()
	
	def SetValue(self, Value):
		pValue = ctypes.c_char_p(str.encode(Value))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadata_setvalue(self._handle, pValue))
		
	


''' Class Implementation for MetaDataGroup
'''
class MetaDataGroup(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetMetaDataCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadatacount(self._handle, pCount))
		
		return pCount.value
	
	def GetMetaData(self, Index):
		nIndex = ctypes.c_uint32(Index)
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadata(self._handle, nIndex, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	
	def GetMetaDataByKey(self, NameSpace, Name):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		pName = ctypes.c_char_p(str.encode(Name))
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_getmetadatabykey(self._handle, pNameSpace, pName, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	
	def RemoveMetaDataByIndex(self, Index):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_removemetadatabyindex(self._handle, nIndex))
		
	
	def RemoveMetaData(self, TheMetaDataObject):
		TheMetaDataHandle = None
		if TheMetaDataObject:
			TheMetaDataHandle = TheMetaDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_removemetadata(self._handle, TheMetaDataHandle))
		
	
	def AddMetaData(self, NameSpace, Name, Value, Type, MustPreserve):
		pNameSpace = ctypes.c_char_p(str.encode(NameSpace))
		pName = ctypes.c_char_p(str.encode(Name))
		pValue = ctypes.c_char_p(str.encode(Value))
		pType = ctypes.c_char_p(str.encode(Type))
		bMustPreserve = ctypes.c_bool(MustPreserve)
		MetaDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_metadatagroup_addmetadata(self._handle, pNameSpace, pName, pValue, pType, bMustPreserve, MetaDataHandle))
		if MetaDataHandle:
			MetaDataObject = self._wrapper._polymorphicFactory(MetaDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataObject
	


''' Class Implementation for TriangleSet
'''
class TriangleSet(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_setname(self._handle, pName))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_setidentifier(self._handle, pIdentifier))
		
	
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def AddTriangle(self, TriangleIndex):
		nTriangleIndex = ctypes.c_uint32(TriangleIndex)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_addtriangle(self._handle, nTriangleIndex))
		
	
	def RemoveTriangle(self, TriangleIndex):
		nTriangleIndex = ctypes.c_uint32(TriangleIndex)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_removetriangle(self._handle, nTriangleIndex))
		
	
	def Clear(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_clear(self._handle))
		
	
	def SetTriangleList(self, TriangleIndices):
		nTriangleIndicesCount = ctypes.c_uint64(len(TriangleIndices))
		pTriangleIndicesBuffer = (ctypes.c_uint32*len(TriangleIndices))(*TriangleIndices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_settrianglelist(self._handle, nTriangleIndicesCount, pTriangleIndicesBuffer))
		
	
	def GetTriangleList(self, TriangleIndices = None):
		nTriangleIndicesCount = ctypes.c_uint64(len(TriangleIndices) if TriangleIndices else 0)
		nTriangleIndicesNeededCount = ctypes.c_uint64(0)
		pTriangleIndicesBuffer = (ctypes.c_uint32*(len(TriangleIndices) if TriangleIndices else 0))(*TriangleIndices if TriangleIndices else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_gettrianglelist(self._handle, nTriangleIndicesCount, nTriangleIndicesNeededCount, pTriangleIndicesBuffer))
		nTriangleIndicesCount = ctypes.c_uint64(nTriangleIndicesNeededCount.value)
		pTriangleIndicesBuffer = (ctypes.c_uint32 * nTriangleIndicesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_gettrianglelist(self._handle, nTriangleIndicesCount, nTriangleIndicesNeededCount, pTriangleIndicesBuffer))
		
		return list(pTriangleIndicesBuffer)
	
	def AddTriangleList(self, TriangleIndices):
		nTriangleIndicesCount = ctypes.c_uint64(len(TriangleIndices))
		pTriangleIndicesBuffer = (ctypes.c_uint32*len(TriangleIndices))(*TriangleIndices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_addtrianglelist(self._handle, nTriangleIndicesCount, pTriangleIndicesBuffer))
		
	
	def Merge(self, OtherTriangleSetObject, DeleteOther):
		OtherTriangleSetHandle = None
		if OtherTriangleSetObject:
			OtherTriangleSetHandle = OtherTriangleSetObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		bDeleteOther = ctypes.c_bool(DeleteOther)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_merge(self._handle, OtherTriangleSetHandle, bDeleteOther))
		
	
	def DeleteSet(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_deleteset(self._handle))
		
	
	def Duplicate(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		NewSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_triangleset_duplicate(self._handle, pIdentifier, NewSetHandle))
		if NewSetHandle:
			NewSetObject = self._wrapper._polymorphicFactory(NewSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NewSetObject
	


''' Class Implementation for Object
'''
class Object(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetType(self):
		pObjectType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_gettype(self._handle, pObjectType))
		
		return ObjectType(pObjectType.value)
	
	def SetType(self, ObjectType):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_settype(self._handle, ObjectType))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setname(self._handle, pName))
		
	
	def GetPartNumber(self):
		nPartNumberBufferSize = ctypes.c_uint64(0)
		nPartNumberNeededChars = ctypes.c_uint64(0)
		pPartNumberBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		nPartNumberBufferSize = ctypes.c_uint64(nPartNumberNeededChars.value)
		pPartNumberBuffer = (ctypes.c_char * (nPartNumberNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		
		return pPartNumberBuffer.value.decode()
	
	def SetPartNumber(self, PartNumber):
		pPartNumber = ctypes.c_char_p(str.encode(PartNumber))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setpartnumber(self._handle, pPartNumber))
		
	
	def IsMeshObject(self):
		pIsMeshObject = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_ismeshobject(self._handle, pIsMeshObject))
		
		return pIsMeshObject.value
	
	def IsComponentsObject(self):
		pIsComponentsObject = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_iscomponentsobject(self._handle, pIsComponentsObject))
		
		return pIsComponentsObject.value
	
	def IsLevelSetObject(self):
		pIsLevelSetObject = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_islevelsetobject(self._handle, pIsLevelSetObject))
		
		return pIsLevelSetObject.value
	
	def IsValid(self):
		pIsValid = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_isvalid(self._handle, pIsValid))
		
		return pIsValid.value
	
	def SetAttachmentAsThumbnail(self, AttachmentObject):
		AttachmentHandle = None
		if AttachmentObject:
			AttachmentHandle = AttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setattachmentasthumbnail(self._handle, AttachmentHandle))
		
	
	def GetThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getthumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			AttachmentObject = None
		
		return AttachmentObject
	
	def ClearThumbnailAttachment(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_clearthumbnailattachment(self._handle))
		
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	
	def GetUUID(self, HasUUID = None):
		pHasUUID = ctypes.c_bool(HasUUID if HasUUID is not None else 0)
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setuuid(self._handle, pUUID))
		
	
	def GetMetaDataGroup(self):
		MetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getmetadatagroup(self._handle, MetaDataGroupHandle))
		if MetaDataGroupHandle:
			MetaDataGroupObject = self._wrapper._polymorphicFactory(MetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataGroupObject
	
	def SetSlicesMeshResolution(self, MeshResolution):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_setslicesmeshresolution(self._handle, MeshResolution))
		
	
	def GetSlicesMeshResolution(self):
		pMeshResolution = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getslicesmeshresolution(self._handle, pMeshResolution))
		
		return SlicesMeshResolution(pMeshResolution.value)
	
	def HasSlices(self, Recursive):
		bRecursive = ctypes.c_bool(Recursive)
		pHasSlices = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_hasslices(self._handle, bRecursive, pHasSlices))
		
		return pHasSlices.value
	
	def ClearSliceStack(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_clearslicestack(self._handle))
		
	
	def GetSliceStack(self):
		SliceStackInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_getslicestack(self._handle, SliceStackInstanceHandle))
		if SliceStackInstanceHandle:
			SliceStackInstanceObject = self._wrapper._polymorphicFactory(SliceStackInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStackInstanceObject
	
	def AssignSliceStack(self, SliceStackInstanceObject):
		SliceStackInstanceHandle = None
		if SliceStackInstanceObject:
			SliceStackInstanceHandle = SliceStackInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_object_assignslicestack(self._handle, SliceStackInstanceHandle))
		
	


''' Class Implementation for MeshObject
'''
class MeshObject(Object):
	def __init__(self, handle, wrapper):
		Object.__init__(self, handle, wrapper)
	def GetVertexCount(self):
		pVertexCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertexcount(self._handle, pVertexCount))
		
		return pVertexCount.value
	
	def GetTriangleCount(self):
		pVertexCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettrianglecount(self._handle, pVertexCount))
		
		return pVertexCount.value
	
	def GetVertex(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pCoordinates = Position()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertex(self._handle, nIndex, pCoordinates))
		
		return pCoordinates
	
	def SetVertex(self, Index, Coordinates):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setvertex(self._handle, nIndex, Coordinates))
		
	
	def AddVertex(self, Coordinates):
		pNewIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_addvertex(self._handle, Coordinates, pNewIndex))
		
		return pNewIndex.value
	
	def GetVertices(self, Vertices = None):
		nVerticesCount = ctypes.c_uint64(len(Vertices) if Vertices else 0)
		nVerticesNeededCount = ctypes.c_uint64(0)
		pVerticesBuffer = (Position*(len(Vertices) if Vertices else 0))(*Vertices if Vertices else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		nVerticesCount = ctypes.c_uint64(nVerticesNeededCount.value)
		pVerticesBuffer = (Position * nVerticesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		
		return list(pVerticesBuffer)
	
	def GetTriangle(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pIndices = Triangle()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangle(self._handle, nIndex, pIndices))
		
		return pIndices
	
	def SetTriangle(self, Index, Indices):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_settriangle(self._handle, nIndex, Indices))
		
	
	def AddTriangle(self, Indices):
		pNewIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_addtriangle(self._handle, Indices, pNewIndex))
		
		return pNewIndex.value
	
	def GetTriangleIndices(self, Indices = None):
		nIndicesCount = ctypes.c_uint64(len(Indices) if Indices else 0)
		nIndicesNeededCount = ctypes.c_uint64(0)
		pIndicesBuffer = (Triangle*(len(Indices) if Indices else 0))(*Indices if Indices else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleindices(self._handle, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		nIndicesCount = ctypes.c_uint64(nIndicesNeededCount.value)
		pIndicesBuffer = (Triangle * nIndicesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleindices(self._handle, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		
		return list(pIndicesBuffer)
	
	def SetObjectLevelProperty(self, UniqueResourceID, PropertyID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setobjectlevelproperty(self._handle, nUniqueResourceID, nPropertyID))
		
	
	def GetObjectLevelProperty(self, UniqueResourceID = None, PropertyID = None):
		pUniqueResourceID = ctypes.c_uint32(UniqueResourceID if UniqueResourceID is not None else 0)
		pPropertyID = ctypes.c_uint32(PropertyID if PropertyID is not None else 0)
		pHasObjectLevelProperty = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getobjectlevelproperty(self._handle, pUniqueResourceID, pPropertyID, pHasObjectLevelProperty))
		
		return pUniqueResourceID.value, pPropertyID.value, pHasObjectLevelProperty.value
	
	def SetTriangleProperties(self, Index, Properties):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_settriangleproperties(self._handle, nIndex, Properties))
		
	
	def GetTriangleProperties(self, Index, Property = None):
		nIndex = ctypes.c_uint32(Index)
		pProperty = Property if Property is not None else TriangleProperties()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleproperties(self._handle, nIndex, pProperty))
		
		return pProperty
	
	def SetAllTriangleProperties(self, PropertiesArray):
		nPropertiesArrayCount = ctypes.c_uint64(len(PropertiesArray))
		pPropertiesArrayBuffer = (TriangleProperties*len(PropertiesArray))(*PropertiesArray)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setalltriangleproperties(self._handle, nPropertiesArrayCount, pPropertiesArrayBuffer))
		
	
	def GetAllTriangleProperties(self, PropertiesArray = None):
		nPropertiesArrayCount = ctypes.c_uint64(len(PropertiesArray) if PropertiesArray else 0)
		nPropertiesArrayNeededCount = ctypes.c_uint64(0)
		pPropertiesArrayBuffer = (TriangleProperties*(len(PropertiesArray) if PropertiesArray else 0))(*PropertiesArray if PropertiesArray else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getalltriangleproperties(self._handle, nPropertiesArrayCount, nPropertiesArrayNeededCount, pPropertiesArrayBuffer))
		nPropertiesArrayCount = ctypes.c_uint64(nPropertiesArrayNeededCount.value)
		pPropertiesArrayBuffer = (TriangleProperties * nPropertiesArrayNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getalltriangleproperties(self._handle, nPropertiesArrayCount, nPropertiesArrayNeededCount, pPropertiesArrayBuffer))
		
		return list(pPropertiesArrayBuffer)
	
	def ClearAllProperties(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_clearallproperties(self._handle))
		
	
	def SetGeometry(self, Vertices, Indices):
		nVerticesCount = ctypes.c_uint64(len(Vertices))
		pVerticesBuffer = (Position*len(Vertices))(*Vertices)
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (Triangle*len(Indices))(*Indices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setgeometry(self._handle, nVerticesCount, pVerticesBuffer, nIndicesCount, pIndicesBuffer))
		
	
	def IsManifoldAndOriented(self):
		pIsManifoldAndOriented = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_ismanifoldandoriented(self._handle, pIsManifoldAndOriented))
		
		return pIsManifoldAndOriented.value
	
	def BeamLattice(self):
		TheBeamLatticeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_beamlattice(self._handle, TheBeamLatticeHandle))
		if TheBeamLatticeHandle:
			TheBeamLatticeObject = self._wrapper._polymorphicFactory(TheBeamLatticeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheBeamLatticeObject
	
	def GetVolumeData(self):
		TheVolumeDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_getvolumedata(self._handle, TheVolumeDataHandle))
		if TheVolumeDataHandle:
			TheVolumeDataObject = self._wrapper._polymorphicFactory(TheVolumeDataHandle)
		else:
			TheVolumeDataObject = None
		
		return TheVolumeDataObject
	
	def SetVolumeData(self, TheVolumeDataObject):
		TheVolumeDataHandle = None
		if TheVolumeDataObject:
			TheVolumeDataHandle = TheVolumeDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_setvolumedata(self._handle, TheVolumeDataHandle))
		
	
	def AddTriangleSet(self, Identifier, Name):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pName = ctypes.c_char_p(str.encode(Name))
		TheTriangleSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_addtriangleset(self._handle, pIdentifier, pName, TheTriangleSetHandle))
		if TheTriangleSetHandle:
			TheTriangleSetObject = self._wrapper._polymorphicFactory(TheTriangleSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheTriangleSetObject
	
	def HasTriangleSet(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pTriangleSetExists = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_hastriangleset(self._handle, pIdentifier, pTriangleSetExists))
		
		return pTriangleSetExists.value
	
	def FindTriangleSet(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		TheTriangleSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_findtriangleset(self._handle, pIdentifier, TheTriangleSetHandle))
		if TheTriangleSetHandle:
			TheTriangleSetObject = self._wrapper._polymorphicFactory(TheTriangleSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheTriangleSetObject
	
	def GetTriangleSetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettrianglesetcount(self._handle, pCount))
		
		return pCount.value
	
	def GetTriangleSet(self, Index):
		nIndex = ctypes.c_uint32(Index)
		TheTriangleSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshobject_gettriangleset(self._handle, nIndex, TheTriangleSetHandle))
		if TheTriangleSetHandle:
			TheTriangleSetObject = self._wrapper._polymorphicFactory(TheTriangleSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheTriangleSetObject
	


''' Class Implementation for LevelSet
'''
class LevelSet(Object):
	def __init__(self, handle, wrapper):
		Object.__init__(self, handle, wrapper)
	def GetFunction(self):
		TheFunctionHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getfunction(self._handle, TheFunctionHandle))
		if TheFunctionHandle:
			TheFunctionObject = self._wrapper._polymorphicFactory(TheFunctionHandle)
		else:
			TheFunctionObject = None
		
		return TheFunctionObject
	
	def SetFunction(self, TheFunctionObject):
		TheFunctionHandle = None
		if TheFunctionObject:
			TheFunctionHandle = TheFunctionObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setfunction(self._handle, TheFunctionHandle))
		
	
	def GetTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_gettransform(self._handle, pTransform))
		
		return pTransform
	
	def SetTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_settransform(self._handle, Transform))
		
	
	def GetChannelName(self):
		nChannelNameBufferSize = ctypes.c_uint64(0)
		nChannelNameNeededChars = ctypes.c_uint64(0)
		pChannelNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getchannelname(self._handle, nChannelNameBufferSize, nChannelNameNeededChars, pChannelNameBuffer))
		nChannelNameBufferSize = ctypes.c_uint64(nChannelNameNeededChars.value)
		pChannelNameBuffer = (ctypes.c_char * (nChannelNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getchannelname(self._handle, nChannelNameBufferSize, nChannelNameNeededChars, pChannelNameBuffer))
		
		return pChannelNameBuffer.value.decode()
	
	def SetChannelName(self, ChannelName):
		pChannelName = ctypes.c_char_p(str.encode(ChannelName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setchannelname(self._handle, pChannelName))
		
	
	def SetMinFeatureSize(self, MinFeatureSize):
		dMinFeatureSize = ctypes.c_double(MinFeatureSize)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setminfeaturesize(self._handle, dMinFeatureSize))
		
	
	def GetMinFeatureSize(self):
		pMinFeatureSize = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getminfeaturesize(self._handle, pMinFeatureSize))
		
		return pMinFeatureSize.value
	
	def SetFallBackValue(self, FallBackValue):
		dFallBackValue = ctypes.c_double(FallBackValue)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setfallbackvalue(self._handle, dFallBackValue))
		
	
	def GetFallBackValue(self):
		pFallBackValue = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getfallbackvalue(self._handle, pFallBackValue))
		
		return pFallBackValue.value
	
	def SetMeshBBoxOnly(self, MeshBBoxOnly):
		bMeshBBoxOnly = ctypes.c_bool(MeshBBoxOnly)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setmeshbboxonly(self._handle, bMeshBBoxOnly))
		
	
	def GetMeshBBoxOnly(self):
		pMeshBBoxOnly = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getmeshbboxonly(self._handle, pMeshBBoxOnly))
		
		return pMeshBBoxOnly.value
	
	def SetMesh(self, TheMeshObject):
		TheMeshHandle = None
		if TheMeshObject:
			TheMeshHandle = TheMeshObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setmesh(self._handle, TheMeshHandle))
		
	
	def GetMesh(self):
		TheMeshHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getmesh(self._handle, TheMeshHandle))
		if TheMeshHandle:
			TheMeshObject = self._wrapper._polymorphicFactory(TheMeshHandle)
		else:
			TheMeshObject = None
		
		return TheMeshObject
	
	def GetVolumeData(self):
		TheVolumeDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_getvolumedata(self._handle, TheVolumeDataHandle))
		if TheVolumeDataHandle:
			TheVolumeDataObject = self._wrapper._polymorphicFactory(TheVolumeDataHandle)
		else:
			TheVolumeDataObject = None
		
		return TheVolumeDataObject
	
	def SetVolumeData(self, TheVolumeDataObject):
		TheVolumeDataHandle = None
		if TheVolumeDataObject:
			TheVolumeDataHandle = TheVolumeDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_levelset_setvolumedata(self._handle, TheVolumeDataHandle))
		
	


''' Class Implementation for BeamLattice
'''
class BeamLattice(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetMinLength(self):
		pMinLength = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getminlength(self._handle, pMinLength))
		
		return pMinLength.value
	
	def SetMinLength(self, MinLength):
		dMinLength = ctypes.c_double(MinLength)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setminlength(self._handle, dMinLength))
		
	
	def GetClipping(self, ClipMode = None, UniqueResourceID = None):
		pClipMode = ctypes.c_int32(ClipMode if ClipMode else 0)
		pUniqueResourceID = ctypes.c_uint32(UniqueResourceID if UniqueResourceID is not None else 0)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getclipping(self._handle, pClipMode, pUniqueResourceID))
		
		return pClipMode.value, pUniqueResourceID.value
	
	def SetClipping(self, ClipMode, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setclipping(self._handle, ClipMode, nUniqueResourceID))
		
	
	def GetRepresentation(self, UniqueResourceID = None):
		pHasRepresentation = ctypes.c_bool()
		pUniqueResourceID = ctypes.c_uint32(UniqueResourceID if UniqueResourceID is not None else 0)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getrepresentation(self._handle, pHasRepresentation, pUniqueResourceID))
		
		return pHasRepresentation.value, pUniqueResourceID.value
	
	def SetRepresentation(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setrepresentation(self._handle, nUniqueResourceID))
		
	
	def GetBallOptions(self, BallMode = None, BallRadius = None):
		pBallMode = ctypes.c_int32(BallMode if BallMode else 0)
		pBallRadius = ctypes.c_double(BallRadius if BallRadius is not None else 0)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballoptions(self._handle, pBallMode, pBallRadius))
		
		return pBallMode.value, pBallRadius.value
	
	def SetBallOptions(self, BallMode, BallRadius):
		dBallRadius = ctypes.c_double(BallRadius)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setballoptions(self._handle, BallMode, dBallRadius))
		
	
	def GetBeamCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamcount(self._handle, pCount))
		
		return pCount.value
	
	def GetBeam(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pBeamInfo = Beam()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeam(self._handle, nIndex, pBeamInfo))
		
		return pBeamInfo
	
	def AddBeam(self, BeamInfo):
		pIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addbeam(self._handle, BeamInfo, pIndex))
		
		return pIndex.value
	
	def SetBeam(self, Index, BeamInfo):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setbeam(self._handle, nIndex, BeamInfo))
		
	
	def SetBeams(self, BeamInfo):
		nBeamInfoCount = ctypes.c_uint64(len(BeamInfo))
		pBeamInfoBuffer = (Beam*len(BeamInfo))(*BeamInfo)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setbeams(self._handle, nBeamInfoCount, pBeamInfoBuffer))
		
	
	def GetBeams(self, BeamInfo = None):
		nBeamInfoCount = ctypes.c_uint64(len(BeamInfo) if BeamInfo else 0)
		nBeamInfoNeededCount = ctypes.c_uint64(0)
		pBeamInfoBuffer = (Beam*(len(BeamInfo) if BeamInfo else 0))(*BeamInfo if BeamInfo else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeams(self._handle, nBeamInfoCount, nBeamInfoNeededCount, pBeamInfoBuffer))
		nBeamInfoCount = ctypes.c_uint64(nBeamInfoNeededCount.value)
		pBeamInfoBuffer = (Beam * nBeamInfoNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeams(self._handle, nBeamInfoCount, nBeamInfoNeededCount, pBeamInfoBuffer))
		
		return list(pBeamInfoBuffer)
	
	def GetBallCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballcount(self._handle, pCount))
		
		return pCount.value
	
	def GetBall(self, Index):
		nIndex = ctypes.c_uint32(Index)
		pBallInfo = Ball()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getball(self._handle, nIndex, pBallInfo))
		
		return pBallInfo
	
	def AddBall(self, BallInfo):
		pIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addball(self._handle, BallInfo, pIndex))
		
		return pIndex.value
	
	def SetBall(self, Index, BallInfo):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setball(self._handle, nIndex, BallInfo))
		
	
	def SetBalls(self, BallInfo):
		nBallInfoCount = ctypes.c_uint64(len(BallInfo))
		pBallInfoBuffer = (Ball*len(BallInfo))(*BallInfo)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_setballs(self._handle, nBallInfoCount, pBallInfoBuffer))
		
	
	def GetBalls(self, BallInfo = None):
		nBallInfoCount = ctypes.c_uint64(len(BallInfo) if BallInfo else 0)
		nBallInfoNeededCount = ctypes.c_uint64(0)
		pBallInfoBuffer = (Ball*(len(BallInfo) if BallInfo else 0))(*BallInfo if BallInfo else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballs(self._handle, nBallInfoCount, nBallInfoNeededCount, pBallInfoBuffer))
		nBallInfoCount = ctypes.c_uint64(nBallInfoNeededCount.value)
		pBallInfoBuffer = (Ball * nBallInfoNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getballs(self._handle, nBallInfoCount, nBallInfoNeededCount, pBallInfoBuffer))
		
		return list(pBallInfoBuffer)
	
	def GetBeamSetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamsetcount(self._handle, pCount))
		
		return pCount.value
	
	def AddBeamSet(self):
		BeamSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_addbeamset(self._handle, BeamSetHandle))
		if BeamSetHandle:
			BeamSetObject = self._wrapper._polymorphicFactory(BeamSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BeamSetObject
	
	def GetBeamSet(self, Index):
		nIndex = ctypes.c_uint32(Index)
		BeamSetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlattice_getbeamset(self._handle, nIndex, BeamSetHandle))
		if BeamSetHandle:
			BeamSetObject = self._wrapper._polymorphicFactory(BeamSetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BeamSetObject
	


''' Class Implementation for FunctionReference
'''
class FunctionReference(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetFunctionResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_getfunctionresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def SetFunctionResourceID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_setfunctionresourceid(self._handle, nUniqueResourceID))
		
	
	def GetTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_gettransform(self._handle, pTransform))
		
		return pTransform
	
	def SetTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_settransform(self._handle, Transform))
		
	
	def GetChannelName(self):
		nChannelNameBufferSize = ctypes.c_uint64(0)
		nChannelNameNeededChars = ctypes.c_uint64(0)
		pChannelNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_getchannelname(self._handle, nChannelNameBufferSize, nChannelNameNeededChars, pChannelNameBuffer))
		nChannelNameBufferSize = ctypes.c_uint64(nChannelNameNeededChars.value)
		pChannelNameBuffer = (ctypes.c_char * (nChannelNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_getchannelname(self._handle, nChannelNameBufferSize, nChannelNameNeededChars, pChannelNameBuffer))
		
		return pChannelNameBuffer.value.decode()
	
	def SetChannelName(self, ChannelName):
		pChannelName = ctypes.c_char_p(str.encode(ChannelName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_setchannelname(self._handle, pChannelName))
		
	
	def SetMinFeatureSize(self, MinFeatureSize):
		dMinFeatureSize = ctypes.c_double(MinFeatureSize)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_setminfeaturesize(self._handle, dMinFeatureSize))
		
	
	def GetMinFeatureSize(self):
		pMinFeatureSize = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_getminfeaturesize(self._handle, pMinFeatureSize))
		
		return pMinFeatureSize.value
	
	def SetFallBackValue(self, FallBackValue):
		dFallBackValue = ctypes.c_double(FallBackValue)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_setfallbackvalue(self._handle, dFallBackValue))
		
	
	def GetFallBackValue(self):
		pFallBackValue = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionreference_getfallbackvalue(self._handle, pFallBackValue))
		
		return pFallBackValue.value
	


''' Class Implementation for VolumeDataColor
'''
class VolumeDataColor(FunctionReference):
	def __init__(self, handle, wrapper):
		FunctionReference.__init__(self, handle, wrapper)


''' Class Implementation for MaterialMapping
'''
class MaterialMapping(FunctionReference):
	def __init__(self, handle, wrapper):
		FunctionReference.__init__(self, handle, wrapper)


''' Class Implementation for VolumeDataComposite
'''
class VolumeDataComposite(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetBaseMaterialGroup(self):
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_getbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def SetBaseMaterialGroup(self, BaseMaterialGroupInstanceObject):
		BaseMaterialGroupInstanceHandle = None
		if BaseMaterialGroupInstanceObject:
			BaseMaterialGroupInstanceHandle = BaseMaterialGroupInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_setbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		
	
	def GetMaterialMappingCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_getmaterialmappingcount(self._handle, pCount))
		
		return pCount.value
	
	def GetMaterialMapping(self, Index):
		nIndex = ctypes.c_uint32(Index)
		TheMaterialMappingHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_getmaterialmapping(self._handle, nIndex, TheMaterialMappingHandle))
		if TheMaterialMappingHandle:
			TheMaterialMappingObject = self._wrapper._polymorphicFactory(TheMaterialMappingHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheMaterialMappingObject
	
	def AddMaterialMapping(self, Transform):
		TheMaterialMappingHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_addmaterialmapping(self._handle, Transform, TheMaterialMappingHandle))
		if TheMaterialMappingHandle:
			TheMaterialMappingObject = self._wrapper._polymorphicFactory(TheMaterialMappingHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheMaterialMappingObject
	
	def RemoveMaterialMapping(self, Index):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedatacomposite_removematerialmapping(self._handle, nIndex))
		
	


''' Class Implementation for VolumeDataProperty
'''
class VolumeDataProperty(FunctionReference):
	def __init__(self, handle, wrapper):
		FunctionReference.__init__(self, handle, wrapper)
	def GetName(self):
		nPropertyNameBufferSize = ctypes.c_uint64(0)
		nPropertyNameNeededChars = ctypes.c_uint64(0)
		pPropertyNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedataproperty_getname(self._handle, nPropertyNameBufferSize, nPropertyNameNeededChars, pPropertyNameBuffer))
		nPropertyNameBufferSize = ctypes.c_uint64(nPropertyNameNeededChars.value)
		pPropertyNameBuffer = (ctypes.c_char * (nPropertyNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedataproperty_getname(self._handle, nPropertyNameBufferSize, nPropertyNameNeededChars, pPropertyNameBuffer))
		
		return pPropertyNameBuffer.value.decode()
	
	def SetIsRequired(self, IsRequired):
		bIsRequired = ctypes.c_bool(IsRequired)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedataproperty_setisrequired(self._handle, bIsRequired))
		
	
	def IsRequired(self):
		pIsRequired = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedataproperty_isrequired(self._handle, pIsRequired))
		
		return pIsRequired.value
	


''' Class Implementation for VolumeData
'''
class VolumeData(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetComposite(self):
		TheCompositeDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_getcomposite(self._handle, TheCompositeDataHandle))
		if TheCompositeDataHandle:
			TheCompositeDataObject = self._wrapper._polymorphicFactory(TheCompositeDataHandle)
		else:
			TheCompositeDataObject = None
		
		return TheCompositeDataObject
	
	def CreateNewComposite(self):
		TheCompositeDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_createnewcomposite(self._handle, TheCompositeDataHandle))
		if TheCompositeDataHandle:
			TheCompositeDataObject = self._wrapper._polymorphicFactory(TheCompositeDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheCompositeDataObject
	
	def RemoveComposite(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_removecomposite(self._handle))
		
	
	def GetColor(self):
		TheColorDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_getcolor(self._handle, TheColorDataHandle))
		if TheColorDataHandle:
			TheColorDataObject = self._wrapper._polymorphicFactory(TheColorDataHandle)
		else:
			TheColorDataObject = None
		
		return TheColorDataObject
	
	def CreateNewColor(self, TheFunctionObject):
		TheFunctionHandle = None
		if TheFunctionObject:
			TheFunctionHandle = TheFunctionObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheColorDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_createnewcolor(self._handle, TheFunctionHandle, TheColorDataHandle))
		if TheColorDataHandle:
			TheColorDataObject = self._wrapper._polymorphicFactory(TheColorDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheColorDataObject
	
	def RemoveColor(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_removecolor(self._handle))
		
	
	def GetPropertyCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_getpropertycount(self._handle, pCount))
		
		return pCount.value
	
	def GetProperty(self, Index):
		nIndex = ctypes.c_uint32(Index)
		TheVolumeDataPropertyHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_getproperty(self._handle, nIndex, TheVolumeDataPropertyHandle))
		if TheVolumeDataPropertyHandle:
			TheVolumeDataPropertyObject = self._wrapper._polymorphicFactory(TheVolumeDataPropertyHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheVolumeDataPropertyObject
	
	def AddPropertyFromFunction(self, Name, TheFunctionObject):
		pName = ctypes.c_char_p(str.encode(Name))
		TheFunctionHandle = None
		if TheFunctionObject:
			TheFunctionHandle = TheFunctionObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheVolumeDataPropertyHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_addpropertyfromfunction(self._handle, pName, TheFunctionHandle, TheVolumeDataPropertyHandle))
		if TheVolumeDataPropertyHandle:
			TheVolumeDataPropertyObject = self._wrapper._polymorphicFactory(TheVolumeDataPropertyHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheVolumeDataPropertyObject
	
	def RemoveProperty(self, Index):
		nIndex = ctypes.c_uint32(Index)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_volumedata_removeproperty(self._handle, nIndex))
		
	


''' Class Implementation for Component
'''
class Component(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetObjectResource(self):
		ObjectResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getobjectresource(self._handle, ObjectResourceHandle))
		if ObjectResourceHandle:
			ObjectResourceObject = self._wrapper._polymorphicFactory(ObjectResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ObjectResourceObject
	
	def GetObjectResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getobjectresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def GetUUID(self, HasUUID = None):
		pHasUUID = ctypes.c_bool(HasUUID if HasUUID is not None else 0)
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_setuuid(self._handle, pUUID))
		
	
	def HasTransform(self):
		pHasTransform = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_hastransform(self._handle, pHasTransform))
		
		return pHasTransform.value
	
	def GetTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_gettransform(self._handle, pTransform))
		
		return pTransform
	
	def SetTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_component_settransform(self._handle, Transform))
		
	


''' Class Implementation for ComponentsObject
'''
class ComponentsObject(Object):
	def __init__(self, handle, wrapper):
		Object.__init__(self, handle, wrapper)
	def AddComponent(self, ObjectResourceObject, Transform):
		ObjectResourceHandle = None
		if ObjectResourceObject:
			ObjectResourceHandle = ObjectResourceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ComponentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_addcomponent(self._handle, ObjectResourceHandle, Transform, ComponentInstanceHandle))
		if ComponentInstanceHandle:
			ComponentInstanceObject = self._wrapper._polymorphicFactory(ComponentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentInstanceObject
	
	def GetComponent(self, Index):
		nIndex = ctypes.c_uint32(Index)
		ComponentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_getcomponent(self._handle, nIndex, ComponentInstanceHandle))
		if ComponentInstanceHandle:
			ComponentInstanceObject = self._wrapper._polymorphicFactory(ComponentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentInstanceObject
	
	def GetComponentCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_componentsobject_getcomponentcount(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for BeamSet
'''
class BeamSet(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setname(self._handle, pName))
		
	
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setidentifier(self._handle, pIdentifier))
		
	
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def GetReferenceCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferencecount(self._handle, pCount))
		
		return pCount.value
	
	def SetReferences(self, References):
		nReferencesCount = ctypes.c_uint64(len(References))
		pReferencesBuffer = (ctypes.c_uint32*len(References))(*References)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setreferences(self._handle, nReferencesCount, pReferencesBuffer))
		
	
	def GetReferences(self, References = None):
		nReferencesCount = ctypes.c_uint64(len(References) if References else 0)
		nReferencesNeededCount = ctypes.c_uint64(0)
		pReferencesBuffer = (ctypes.c_uint32*(len(References) if References else 0))(*References if References else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferences(self._handle, nReferencesCount, nReferencesNeededCount, pReferencesBuffer))
		nReferencesCount = ctypes.c_uint64(nReferencesNeededCount.value)
		pReferencesBuffer = (ctypes.c_uint32 * nReferencesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getreferences(self._handle, nReferencesCount, nReferencesNeededCount, pReferencesBuffer))
		
		return list(pReferencesBuffer)
	
	def GetBallReferenceCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferencecount(self._handle, pCount))
		
		return pCount.value
	
	def SetBallReferences(self, BallReferences):
		nBallReferencesCount = ctypes.c_uint64(len(BallReferences))
		pBallReferencesBuffer = (ctypes.c_uint32*len(BallReferences))(*BallReferences)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_setballreferences(self._handle, nBallReferencesCount, pBallReferencesBuffer))
		
	
	def GetBallReferences(self, BallReferences = None):
		nBallReferencesCount = ctypes.c_uint64(len(BallReferences) if BallReferences else 0)
		nBallReferencesNeededCount = ctypes.c_uint64(0)
		pBallReferencesBuffer = (ctypes.c_uint32*(len(BallReferences) if BallReferences else 0))(*BallReferences if BallReferences else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferences(self._handle, nBallReferencesCount, nBallReferencesNeededCount, pBallReferencesBuffer))
		nBallReferencesCount = ctypes.c_uint64(nBallReferencesNeededCount.value)
		pBallReferencesBuffer = (ctypes.c_uint32 * nBallReferencesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamset_getballreferences(self._handle, nBallReferencesCount, nBallReferencesNeededCount, pBallReferencesBuffer))
		
		return list(pBallReferencesBuffer)
	


''' Class Implementation for BaseMaterialGroup
'''
class BaseMaterialGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self, PropertyIDs = None):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def AddMaterial(self, Name, DisplayColor):
		pName = ctypes.c_char_p(str.encode(Name))
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_addmaterial(self._handle, pName, DisplayColor, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveMaterial(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_removematerial(self._handle, nPropertyID))
		
	
	def GetName(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getname(self._handle, nPropertyID, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getname(self._handle, nPropertyID, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, PropertyID, Name):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_setname(self._handle, nPropertyID, pName))
		
	
	def SetDisplayColor(self, PropertyID, TheColor):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_setdisplaycolor(self._handle, nPropertyID, TheColor))
		
	
	def GetDisplayColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pTheColor = Color()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_basematerialgroup_getdisplaycolor(self._handle, nPropertyID, pTheColor))
		
		return pTheColor
	


''' Class Implementation for ColorGroup
'''
class ColorGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self, PropertyIDs = None):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def AddColor(self, TheColor):
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_addcolor(self._handle, TheColor, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_removecolor(self._handle, nPropertyID))
		
	
	def SetColor(self, PropertyID, TheColor):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_setcolor(self._handle, nPropertyID, TheColor))
		
	
	def GetColor(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pTheColor = Color()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_colorgroup_getcolor(self._handle, nPropertyID, pTheColor))
		
		return pTheColor
	


''' Class Implementation for Texture2DGroup
'''
class Texture2DGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self, PropertyIDs = None):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def AddTex2Coord(self, UVCoordinate):
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_addtex2coord(self._handle, UVCoordinate, pPropertyID))
		
		return pPropertyID.value
	
	def GetTex2Coord(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		pUVCoordinate = Tex2Coord()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_gettex2coord(self._handle, nPropertyID, pUVCoordinate))
		
		return pUVCoordinate
	
	def RemoveTex2Coord(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_removetex2coord(self._handle, nPropertyID))
		
	
	def GetTexture2D(self):
		Texture2DInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2dgroup_gettexture2d(self._handle, Texture2DInstanceHandle))
		if Texture2DInstanceHandle:
			Texture2DInstanceObject = self._wrapper._polymorphicFactory(Texture2DInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DInstanceObject
	


''' Class Implementation for CompositeMaterials
'''
class CompositeMaterials(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self, PropertyIDs = None):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def GetBaseMaterialGroup(self):
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def AddComposite(self, Composite):
		nCompositeCount = ctypes.c_uint64(len(Composite))
		pCompositeBuffer = (CompositeConstituent*len(Composite))(*Composite)
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_addcomposite(self._handle, nCompositeCount, pCompositeBuffer, pPropertyID))
		
		return pPropertyID.value
	
	def RemoveComposite(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_removecomposite(self._handle, nPropertyID))
		
	
	def GetComposite(self, PropertyID, Composite = None):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nCompositeCount = ctypes.c_uint64(len(Composite) if Composite else 0)
		nCompositeNeededCount = ctypes.c_uint64(0)
		pCompositeBuffer = (CompositeConstituent*(len(Composite) if Composite else 0))(*Composite if Composite else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcomposite(self._handle, nPropertyID, nCompositeCount, nCompositeNeededCount, pCompositeBuffer))
		nCompositeCount = ctypes.c_uint64(nCompositeNeededCount.value)
		pCompositeBuffer = (CompositeConstituent * nCompositeNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_compositematerials_getcomposite(self._handle, nPropertyID, nCompositeCount, nCompositeNeededCount, pCompositeBuffer))
		
		return list(pCompositeBuffer)
	


''' Class Implementation for MultiPropertyGroup
'''
class MultiPropertyGroup(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getcount(self._handle, pCount))
		
		return pCount.value
	
	def GetAllPropertyIDs(self, PropertyIDs = None):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getallpropertyids(self._handle, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def AddMultiProperty(self, PropertyIDs):
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs))
		pPropertyIDsBuffer = (ctypes.c_uint32*len(PropertyIDs))(*PropertyIDs)
		pPropertyID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_addmultiproperty(self._handle, nPropertyIDsCount, pPropertyIDsBuffer, pPropertyID))
		
		return pPropertyID.value
	
	def SetMultiProperty(self, PropertyID, PropertyIDs):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs))
		pPropertyIDsBuffer = (ctypes.c_uint32*len(PropertyIDs))(*PropertyIDs)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_setmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, pPropertyIDsBuffer))
		
	
	def GetMultiProperty(self, PropertyID, PropertyIDs = None):
		nPropertyID = ctypes.c_uint32(PropertyID)
		nPropertyIDsCount = ctypes.c_uint64(len(PropertyIDs) if PropertyIDs else 0)
		nPropertyIDsNeededCount = ctypes.c_uint64(0)
		pPropertyIDsBuffer = (ctypes.c_uint32*(len(PropertyIDs) if PropertyIDs else 0))(*PropertyIDs if PropertyIDs else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		nPropertyIDsCount = ctypes.c_uint64(nPropertyIDsNeededCount.value)
		pPropertyIDsBuffer = (ctypes.c_uint32 * nPropertyIDsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getmultiproperty(self._handle, nPropertyID, nPropertyIDsCount, nPropertyIDsNeededCount, pPropertyIDsBuffer))
		
		return list(pPropertyIDsBuffer)
	
	def RemoveMultiProperty(self, PropertyID):
		nPropertyID = ctypes.c_uint32(PropertyID)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_removemultiproperty(self._handle, nPropertyID))
		
	
	def GetLayerCount(self):
		pCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getlayercount(self._handle, pCount))
		
		return pCount.value
	
	def AddLayer(self, TheLayer):
		pLayerIndex = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_addlayer(self._handle, TheLayer, pLayerIndex))
		
		return pLayerIndex.value
	
	def GetLayer(self, LayerIndex):
		nLayerIndex = ctypes.c_uint32(LayerIndex)
		pTheLayer = MultiPropertyLayer()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_getlayer(self._handle, nLayerIndex, pTheLayer))
		
		return pTheLayer
	
	def RemoveLayer(self, LayerIndex):
		nLayerIndex = ctypes.c_uint32(LayerIndex)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_multipropertygroup_removelayer(self._handle, nLayerIndex))
		
	


''' Class Implementation for Image3D
'''
class Image3D(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetName(self):
		nNameBufferSize = ctypes.c_uint64(0)
		nNameNeededChars = ctypes.c_uint64(0)
		pNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_image3d_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		nNameBufferSize = ctypes.c_uint64(nNameNeededChars.value)
		pNameBuffer = (ctypes.c_char * (nNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_image3d_getname(self._handle, nNameBufferSize, nNameNeededChars, pNameBuffer))
		
		return pNameBuffer.value.decode()
	
	def SetName(self, Name):
		pName = ctypes.c_char_p(str.encode(Name))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_image3d_setname(self._handle, pName))
		
	
	def IsImageStack(self):
		pIsImageStack = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_image3d_isimagestack(self._handle, pIsImageStack))
		
		return pIsImageStack.value
	


''' Class Implementation for ImageStack
'''
class ImageStack(Image3D):
	def __init__(self, handle, wrapper):
		Image3D.__init__(self, handle, wrapper)
	def GetRowCount(self):
		pRowCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_getrowcount(self._handle, pRowCount))
		
		return pRowCount.value
	
	def SetRowCount(self, RowCount):
		nRowCount = ctypes.c_uint32(RowCount)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_setrowcount(self._handle, nRowCount))
		
	
	def GetColumnCount(self):
		pColumnCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_getcolumncount(self._handle, pColumnCount))
		
		return pColumnCount.value
	
	def SetColumnCount(self, ColumnCount):
		nColumnCount = ctypes.c_uint32(ColumnCount)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_setcolumncount(self._handle, nColumnCount))
		
	
	def GetSheetCount(self):
		pSheetCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_getsheetcount(self._handle, pSheetCount))
		
		return pSheetCount.value
	
	def GetSheet(self, Index):
		nIndex = ctypes.c_uint32(Index)
		SheetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_getsheet(self._handle, nIndex, SheetHandle))
		if SheetHandle:
			SheetObject = self._wrapper._polymorphicFactory(SheetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SheetObject
	
	def SetSheet(self, Index, SheetObject):
		nIndex = ctypes.c_uint32(Index)
		SheetHandle = None
		if SheetObject:
			SheetHandle = SheetObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_setsheet(self._handle, nIndex, SheetHandle))
		
	
	def CreateEmptySheet(self, Index, Path):
		nIndex = ctypes.c_uint32(Index)
		pPath = ctypes.c_char_p(str.encode(Path))
		SheetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_createemptysheet(self._handle, nIndex, pPath, SheetHandle))
		if SheetHandle:
			SheetObject = self._wrapper._polymorphicFactory(SheetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SheetObject
	
	def CreateSheetFromBuffer(self, Index, Path, Data):
		nIndex = ctypes.c_uint32(Index)
		pPath = ctypes.c_char_p(str.encode(Path))
		nDataCount = ctypes.c_uint64(len(Data))
		pDataBuffer = (ctypes.c_uint8*len(Data))(*Data)
		SheetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_createsheetfrombuffer(self._handle, nIndex, pPath, nDataCount, pDataBuffer, SheetHandle))
		if SheetHandle:
			SheetObject = self._wrapper._polymorphicFactory(SheetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SheetObject
	
	def CreateSheetFromFile(self, Index, Path, FileName):
		nIndex = ctypes.c_uint32(Index)
		pPath = ctypes.c_char_p(str.encode(Path))
		pFileName = ctypes.c_char_p(str.encode(FileName))
		SheetHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_imagestack_createsheetfromfile(self._handle, nIndex, pPath, pFileName, SheetHandle))
		if SheetHandle:
			SheetObject = self._wrapper._polymorphicFactory(SheetHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SheetObject
	


''' Class Implementation for Attachment
'''
class Attachment(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_setpath(self._handle, pPath))
		
	
	def PackagePart(self):
		PackagePartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_packagepart(self._handle, PackagePartHandle))
		if PackagePartHandle:
			PackagePartObject = self._wrapper._polymorphicFactory(PackagePartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PackagePartObject
	
	def GetRelationShipType(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getrelationshiptype(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getrelationshiptype(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	
	def SetRelationShipType(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_setrelationshiptype(self._handle, pPath))
		
	
	def WriteToFile(self, FileName):
		pFileName = ctypes.c_char_p(str.encode(FileName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetofile(self._handle, pFileName))
		
	
	def ReadFromFile(self, FileName):
		pFileName = ctypes.c_char_p(str.encode(FileName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfromfile(self._handle, pFileName))
		
	
	def ReadFromCallback(self, TheReadCallbackFunc, StreamSize, TheSeekCallbackFunc, UserData):
		nStreamSize = ctypes.c_uint64(StreamSize)
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfromcallback(self._handle, TheReadCallbackFunc, nStreamSize, TheSeekCallbackFunc, pUserData))
		
	
	def GetStreamSize(self):
		pStreamSize = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_getstreamsize(self._handle, pStreamSize))
		
		return pStreamSize.value
	
	def WriteToBuffer(self, Buffer = None):
		nBufferCount = ctypes.c_uint64(len(Buffer) if Buffer else 0)
		nBufferNeededCount = ctypes.c_uint64(0)
		pBufferBuffer = (ctypes.c_uint8*(len(Buffer) if Buffer else 0))(*Buffer if Buffer else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		nBufferCount = ctypes.c_uint64(nBufferNeededCount.value)
		pBufferBuffer = (ctypes.c_uint8 * nBufferNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_writetobuffer(self._handle, nBufferCount, nBufferNeededCount, pBufferBuffer))
		
		return list(pBufferBuffer)
	
	def ReadFromBuffer(self, Buffer):
		nBufferCount = ctypes.c_uint64(len(Buffer))
		pBufferBuffer = (ctypes.c_uint8*len(Buffer))(*Buffer)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_attachment_readfrombuffer(self._handle, nBufferCount, pBufferBuffer))
		
	


''' Class Implementation for Texture2D
'''
class Texture2D(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentObject
	
	def SetAttachment(self, AttachmentObject):
		AttachmentHandle = None
		if AttachmentObject:
			AttachmentHandle = AttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setattachment(self._handle, AttachmentHandle))
		
	
	def GetContentType(self):
		pContentType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getcontenttype(self._handle, pContentType))
		
		return TextureType(pContentType.value)
	
	def SetContentType(self, ContentType):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setcontenttype(self._handle, ContentType))
		
	
	def GetTileStyleUV(self, TileStyleU = None, TileStyleV = None):
		pTileStyleU = ctypes.c_int32(TileStyleU if TileStyleU else 0)
		pTileStyleV = ctypes.c_int32(TileStyleV if TileStyleV else 0)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_gettilestyleuv(self._handle, pTileStyleU, pTileStyleV))
		
		return pTileStyleU.value, pTileStyleV.value
	
	def SetTileStyleUV(self, TileStyleU, TileStyleV):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_settilestyleuv(self._handle, TileStyleU, TileStyleV))
		
	
	def GetFilter(self):
		pFilter = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_getfilter(self._handle, pFilter))
		
		return TextureFilter(pFilter.value)
	
	def SetFilter(self, Filter):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_texture2d_setfilter(self._handle, Filter))
		
	


''' Class Implementation for ImplicitPort
'''
class ImplicitPort(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_setidentifier(self._handle, pIdentifier))
		
	
	def GetDisplayName(self):
		nDisplayNameBufferSize = ctypes.c_uint64(0)
		nDisplayNameNeededChars = ctypes.c_uint64(0)
		pDisplayNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		nDisplayNameBufferSize = ctypes.c_uint64(nDisplayNameNeededChars.value)
		pDisplayNameBuffer = (ctypes.c_char * (nDisplayNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		
		return pDisplayNameBuffer.value.decode()
	
	def SetDisplayName(self, DisplayName):
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_setdisplayname(self._handle, pDisplayName))
		
	
	def SetType(self, ImplicitPortType):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_settype(self._handle, ImplicitPortType))
		
	
	def GetType(self):
		pImplicitPortType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_gettype(self._handle, pImplicitPortType))
		
		return ImplicitPortType(pImplicitPortType.value)
	
	def GetReference(self):
		nReferenceBufferSize = ctypes.c_uint64(0)
		nReferenceNeededChars = ctypes.c_uint64(0)
		pReferenceBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getreference(self._handle, nReferenceBufferSize, nReferenceNeededChars, pReferenceBuffer))
		nReferenceBufferSize = ctypes.c_uint64(nReferenceNeededChars.value)
		pReferenceBuffer = (ctypes.c_char * (nReferenceNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_getreference(self._handle, nReferenceBufferSize, nReferenceNeededChars, pReferenceBuffer))
		
		return pReferenceBuffer.value.decode()
	
	def SetReference(self, Reference):
		pReference = ctypes.c_char_p(str.encode(Reference))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitport_setreference(self._handle, pReference))
		
	


''' Class Implementation for Iterator
'''
class Iterator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def MoveNext(self):
		pHasNext = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_iterator_movenext(self._handle, pHasNext))
		
		return pHasNext.value
	
	def MovePrevious(self):
		pHasPrevious = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_iterator_moveprevious(self._handle, pHasPrevious))
		
		return pHasPrevious.value
	
	def Count(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_iterator_count(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for ImplicitPortIterator
'''
class ImplicitPortIterator(Iterator):
	def __init__(self, handle, wrapper):
		Iterator.__init__(self, handle, wrapper)
	def GetCurrent(self):
		PortHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitportiterator_getcurrent(self._handle, PortHandle))
		if PortHandle:
			PortObject = self._wrapper._polymorphicFactory(PortHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PortObject
	


''' Class Implementation for ImplicitNode
'''
class ImplicitNode(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_setidentifier(self._handle, pIdentifier))
		
	
	def GetDisplayName(self):
		nDisplayNameBufferSize = ctypes.c_uint64(0)
		nDisplayNameNeededChars = ctypes.c_uint64(0)
		pDisplayNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		nDisplayNameBufferSize = ctypes.c_uint64(nDisplayNameNeededChars.value)
		pDisplayNameBuffer = (ctypes.c_char * (nDisplayNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		
		return pDisplayNameBuffer.value.decode()
	
	def SetDisplayName(self, DisplayName):
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_setdisplayname(self._handle, pDisplayName))
		
	
	def GetTag(self):
		nTagBufferSize = ctypes.c_uint64(0)
		nTagNeededChars = ctypes.c_uint64(0)
		pTagBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_gettag(self._handle, nTagBufferSize, nTagNeededChars, pTagBuffer))
		nTagBufferSize = ctypes.c_uint64(nTagNeededChars.value)
		pTagBuffer = (ctypes.c_char * (nTagNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_gettag(self._handle, nTagBufferSize, nTagNeededChars, pTagBuffer))
		
		return pTagBuffer.value.decode()
	
	def SetTag(self, Tag):
		pTag = ctypes.c_char_p(str.encode(Tag))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_settag(self._handle, pTag))
		
	
	def GetNodeType(self):
		pType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getnodetype(self._handle, pType))
		
		return ImplicitNodeType(pType.value)
	
	def AddInput(self, Identifier, DisplayName):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		PortHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_addinput(self._handle, pIdentifier, pDisplayName, PortHandle))
		if PortHandle:
			PortObject = self._wrapper._polymorphicFactory(PortHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PortObject
	
	def GetInputs(self):
		IteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getinputs(self._handle, IteratorHandle))
		if IteratorHandle:
			IteratorObject = self._wrapper._polymorphicFactory(IteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return IteratorObject
	
	def AddOutput(self, Identifier, DisplayName):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		PortHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_addoutput(self._handle, pIdentifier, pDisplayName, PortHandle))
		if PortHandle:
			PortObject = self._wrapper._polymorphicFactory(PortHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PortObject
	
	def GetOutputs(self):
		IteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_getoutputs(self._handle, IteratorHandle))
		if IteratorHandle:
			IteratorObject = self._wrapper._polymorphicFactory(IteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return IteratorObject
	
	def FindInput(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		InputHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_findinput(self._handle, pIdentifier, InputHandle))
		if InputHandle:
			InputObject = self._wrapper._polymorphicFactory(InputHandle)
		else:
			InputObject = None
		
		return InputObject
	
	def FindOutput(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		OutputHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_findoutput(self._handle, pIdentifier, OutputHandle))
		if OutputHandle:
			OutputObject = self._wrapper._polymorphicFactory(OutputHandle)
		else:
			OutputObject = None
		
		return OutputObject
	
	def AreTypesValid(self):
		pValid = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitnode_aretypesvalid(self._handle, pValid))
		
		return pValid.value
	


''' Class Implementation for OneInputNode
'''
class OneInputNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputA(self):
		InputHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_oneinputnode_getinputa(self._handle, InputHandle))
		if InputHandle:
			InputObject = self._wrapper._polymorphicFactory(InputHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return InputObject
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_oneinputnode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for SinNode
'''
class SinNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for CosNode
'''
class CosNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for TanNode
'''
class TanNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ArcSinNode
'''
class ArcSinNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ArcCosNode
'''
class ArcCosNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ArcTanNode
'''
class ArcTanNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for SinhNode
'''
class SinhNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for CoshNode
'''
class CoshNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for TanhNode
'''
class TanhNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for RoundNode
'''
class RoundNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for CeilNode
'''
class CeilNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for FloorNode
'''
class FloorNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for SignNode
'''
class SignNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for FractNode
'''
class FractNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for AbsNode
'''
class AbsNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ExpNode
'''
class ExpNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for LogNode
'''
class LogNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for Log2Node
'''
class Log2Node(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for Log10Node
'''
class Log10Node(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for LengthNode
'''
class LengthNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for TransposeNode
'''
class TransposeNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for InverseNode
'''
class InverseNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for SqrtNode
'''
class SqrtNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ResourceIdNode
'''
class ResourceIdNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def SetResource(self, ResourceObject):
		ResourceHandle = None
		if ResourceObject:
			ResourceHandle = ResourceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceidnode_setresource(self._handle, ResourceHandle))
		
	
	def GetResource(self):
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceidnode_getresource(self._handle, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	
	def GetOutputValue(self):
		ValueHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourceidnode_getoutputvalue(self._handle, ValueHandle))
		if ValueHandle:
			ValueObject = self._wrapper._polymorphicFactory(ValueHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ValueObject
	


''' Class Implementation for TwoInputNode
'''
class TwoInputNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)
	def GetInputB(self):
		BHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_twoinputnode_getinputb(self._handle, BHandle))
		if BHandle:
			BObject = self._wrapper._polymorphicFactory(BHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BObject
	


''' Class Implementation for AdditionNode
'''
class AdditionNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for SubtractionNode
'''
class SubtractionNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for MultiplicationNode
'''
class MultiplicationNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for DivisionNode
'''
class DivisionNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for DotNode
'''
class DotNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for CrossNode
'''
class CrossNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ArcTan2Node
'''
class ArcTan2Node(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for MatVecMultiplicationNode
'''
class MatVecMultiplicationNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for MinNode
'''
class MinNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for MaxNode
'''
class MaxNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for FmodNode
'''
class FmodNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for ModNode
'''
class ModNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for PowNode
'''
class PowNode(TwoInputNode):
	def __init__(self, handle, wrapper):
		TwoInputNode.__init__(self, handle, wrapper)


''' Class Implementation for SelectNode
'''
class SelectNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)
	def GetInputB(self):
		BHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_selectnode_getinputb(self._handle, BHandle))
		if BHandle:
			BObject = self._wrapper._polymorphicFactory(BHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BObject
	
	def GetInputC(self):
		CHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_selectnode_getinputc(self._handle, CHandle))
		if CHandle:
			CObject = self._wrapper._polymorphicFactory(CHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return CObject
	
	def GetInputD(self):
		DHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_selectnode_getinputd(self._handle, DHandle))
		if DHandle:
			DObject = self._wrapper._polymorphicFactory(DHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return DObject
	


''' Class Implementation for ClampNode
'''
class ClampNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)
	def GetInputMin(self):
		MinHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_clampnode_getinputmin(self._handle, MinHandle))
		if MinHandle:
			MinObject = self._wrapper._polymorphicFactory(MinHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MinObject
	
	def GetInputMax(self):
		MaxHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_clampnode_getinputmax(self._handle, MaxHandle))
		if MaxHandle:
			MaxObject = self._wrapper._polymorphicFactory(MaxHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MaxObject
	


''' Class Implementation for ComposeVectorNode
'''
class ComposeVectorNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputX(self):
		XHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composevectornode_getinputx(self._handle, XHandle))
		if XHandle:
			XObject = self._wrapper._polymorphicFactory(XHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return XObject
	
	def GetInputY(self):
		YHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composevectornode_getinputy(self._handle, YHandle))
		if YHandle:
			YObject = self._wrapper._polymorphicFactory(YHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return YObject
	
	def GetInputZ(self):
		ZHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composevectornode_getinputz(self._handle, ZHandle))
		if ZHandle:
			ZObject = self._wrapper._polymorphicFactory(ZHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ZObject
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composevectornode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for VectorFromScalarNode
'''
class VectorFromScalarNode(OneInputNode):
	def __init__(self, handle, wrapper):
		OneInputNode.__init__(self, handle, wrapper)


''' Class Implementation for DecomposeVectorNode
'''
class DecomposeVectorNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputA(self):
		AHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_decomposevectornode_getinputa(self._handle, AHandle))
		if AHandle:
			AObject = self._wrapper._polymorphicFactory(AHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AObject
	
	def GetOutputX(self):
		XHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_decomposevectornode_getoutputx(self._handle, XHandle))
		if XHandle:
			XObject = self._wrapper._polymorphicFactory(XHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return XObject
	
	def GetOutputY(self):
		YHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_decomposevectornode_getoutputy(self._handle, YHandle))
		if YHandle:
			YObject = self._wrapper._polymorphicFactory(YHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return YObject
	
	def GetOutputZ(self):
		ZHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_decomposevectornode_getoutputz(self._handle, ZHandle))
		if ZHandle:
			ZObject = self._wrapper._polymorphicFactory(ZHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ZObject
	


''' Class Implementation for ComposeMatrixNode
'''
class ComposeMatrixNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputM00(self):
		M00Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm00(self._handle, M00Handle))
		if M00Handle:
			M00Object = self._wrapper._polymorphicFactory(M00Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M00Object
	
	def GetInputM01(self):
		M01Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm01(self._handle, M01Handle))
		if M01Handle:
			M01Object = self._wrapper._polymorphicFactory(M01Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M01Object
	
	def GetInputM02(self):
		M02Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm02(self._handle, M02Handle))
		if M02Handle:
			M02Object = self._wrapper._polymorphicFactory(M02Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M02Object
	
	def GetInputM03(self):
		M03Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm03(self._handle, M03Handle))
		if M03Handle:
			M03Object = self._wrapper._polymorphicFactory(M03Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M03Object
	
	def GetInputM10(self):
		M10Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm10(self._handle, M10Handle))
		if M10Handle:
			M10Object = self._wrapper._polymorphicFactory(M10Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M10Object
	
	def GetInputM11(self):
		M11Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm11(self._handle, M11Handle))
		if M11Handle:
			M11Object = self._wrapper._polymorphicFactory(M11Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M11Object
	
	def GetInputM12(self):
		M12Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm12(self._handle, M12Handle))
		if M12Handle:
			M12Object = self._wrapper._polymorphicFactory(M12Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M12Object
	
	def GetInputM13(self):
		M13Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm13(self._handle, M13Handle))
		if M13Handle:
			M13Object = self._wrapper._polymorphicFactory(M13Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M13Object
	
	def GetInputM20(self):
		M20Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm20(self._handle, M20Handle))
		if M20Handle:
			M20Object = self._wrapper._polymorphicFactory(M20Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M20Object
	
	def GetInputM21(self):
		M21Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm21(self._handle, M21Handle))
		if M21Handle:
			M21Object = self._wrapper._polymorphicFactory(M21Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M21Object
	
	def GetInputM22(self):
		M22Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm22(self._handle, M22Handle))
		if M22Handle:
			M22Object = self._wrapper._polymorphicFactory(M22Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M22Object
	
	def GetInputM23(self):
		M23Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm23(self._handle, M23Handle))
		if M23Handle:
			M23Object = self._wrapper._polymorphicFactory(M23Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M23Object
	
	def GetInputM30(self):
		M30Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm30(self._handle, M30Handle))
		if M30Handle:
			M30Object = self._wrapper._polymorphicFactory(M30Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M30Object
	
	def GetInputM31(self):
		M31Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm31(self._handle, M31Handle))
		if M31Handle:
			M31Object = self._wrapper._polymorphicFactory(M31Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M31Object
	
	def GetInputM32(self):
		M32Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm32(self._handle, M32Handle))
		if M32Handle:
			M32Object = self._wrapper._polymorphicFactory(M32Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M32Object
	
	def GetInputM33(self):
		M33Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getinputm33(self._handle, M33Handle))
		if M33Handle:
			M33Object = self._wrapper._polymorphicFactory(M33Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return M33Object
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_composematrixnode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for MatrixFromRowsNode
'''
class MatrixFromRowsNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputA(self):
		Row0Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromrowsnode_getinputa(self._handle, Row0Handle))
		if Row0Handle:
			Row0Object = self._wrapper._polymorphicFactory(Row0Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Row0Object
	
	def GetInputB(self):
		Row1Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromrowsnode_getinputb(self._handle, Row1Handle))
		if Row1Handle:
			Row1Object = self._wrapper._polymorphicFactory(Row1Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Row1Object
	
	def GetInputC(self):
		Row2Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromrowsnode_getinputc(self._handle, Row2Handle))
		if Row2Handle:
			Row2Object = self._wrapper._polymorphicFactory(Row2Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Row2Object
	
	def GetInputD(self):
		Row3Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromrowsnode_getinputd(self._handle, Row3Handle))
		if Row3Handle:
			Row3Object = self._wrapper._polymorphicFactory(Row3Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Row3Object
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromrowsnode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for MatrixFromColumnsNode
'''
class MatrixFromColumnsNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputA(self):
		Column0Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromcolumnsnode_getinputa(self._handle, Column0Handle))
		if Column0Handle:
			Column0Object = self._wrapper._polymorphicFactory(Column0Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Column0Object
	
	def GetInputB(self):
		Column1Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromcolumnsnode_getinputb(self._handle, Column1Handle))
		if Column1Handle:
			Column1Object = self._wrapper._polymorphicFactory(Column1Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Column1Object
	
	def GetInputC(self):
		Column2Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromcolumnsnode_getinputc(self._handle, Column2Handle))
		if Column2Handle:
			Column2Object = self._wrapper._polymorphicFactory(Column2Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Column2Object
	
	def GetInputD(self):
		Column3Handle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromcolumnsnode_getinputd(self._handle, Column3Handle))
		if Column3Handle:
			Column3Object = self._wrapper._polymorphicFactory(Column3Handle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Column3Object
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_matrixfromcolumnsnode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for ConstantNode
'''
class ConstantNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def SetConstant(self, Value):
		dValue = ctypes.c_double(Value)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constantnode_setconstant(self._handle, dValue))
		
	
	def GetConstant(self):
		pValue = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constantnode_getconstant(self._handle, pValue))
		
		return pValue.value
	
	def GetOutputValue(self):
		ValueHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constantnode_getoutputvalue(self._handle, ValueHandle))
		if ValueHandle:
			ValueObject = self._wrapper._polymorphicFactory(ValueHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ValueObject
	


''' Class Implementation for ConstVecNode
'''
class ConstVecNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def SetVector(self, Value):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constvecnode_setvector(self._handle, Value))
		
	
	def GetVector(self):
		pValue = Vector()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constvecnode_getvector(self._handle, pValue))
		
		return pValue
	
	def GetOutputVector(self):
		VectorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constvecnode_getoutputvector(self._handle, VectorHandle))
		if VectorHandle:
			VectorObject = self._wrapper._polymorphicFactory(VectorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return VectorObject
	


''' Class Implementation for ConstMatNode
'''
class ConstMatNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def SetMatrix(self, Value):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constmatnode_setmatrix(self._handle, Value))
		
	
	def GetMatrix(self):
		pValue = Matrix4x4()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constmatnode_getmatrix(self._handle, pValue))
		
		return pValue
	
	def GetOutputMatrix(self):
		MatrixHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_constmatnode_getoutputmatrix(self._handle, MatrixHandle))
		if MatrixHandle:
			MatrixObject = self._wrapper._polymorphicFactory(MatrixHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MatrixObject
	


''' Class Implementation for MeshNode
'''
class MeshNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputMesh(self):
		MeshHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshnode_getinputmesh(self._handle, MeshHandle))
		if MeshHandle:
			MeshObject = self._wrapper._polymorphicFactory(MeshHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObject
	
	def GetInputPos(self):
		PosHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshnode_getinputpos(self._handle, PosHandle))
		if PosHandle:
			PosObject = self._wrapper._polymorphicFactory(PosHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PosObject
	
	def GetOutputDistance(self):
		DistanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_meshnode_getoutputdistance(self._handle, DistanceHandle))
		if DistanceHandle:
			DistanceObject = self._wrapper._polymorphicFactory(DistanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return DistanceObject
	


''' Class Implementation for UnsignedMeshNode
'''
class UnsignedMeshNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputMesh(self):
		MeshHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_unsignedmeshnode_getinputmesh(self._handle, MeshHandle))
		if MeshHandle:
			MeshObject = self._wrapper._polymorphicFactory(MeshHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObject
	
	def GetInputPos(self):
		PosHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_unsignedmeshnode_getinputpos(self._handle, PosHandle))
		if PosHandle:
			PosObject = self._wrapper._polymorphicFactory(PosHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PosObject
	
	def GetOutputDistance(self):
		DistanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_unsignedmeshnode_getoutputdistance(self._handle, DistanceHandle))
		if DistanceHandle:
			DistanceObject = self._wrapper._polymorphicFactory(DistanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return DistanceObject
	


''' Class Implementation for BeamLatticeNode
'''
class BeamLatticeNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputBeamLattice(self):
		BeamLatticeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlatticenode_getinputbeamlattice(self._handle, BeamLatticeHandle))
		if BeamLatticeHandle:
			BeamLatticeObject = self._wrapper._polymorphicFactory(BeamLatticeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BeamLatticeObject
	
	def GetInputPos(self):
		PosHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlatticenode_getinputpos(self._handle, PosHandle))
		if PosHandle:
			PosObject = self._wrapper._polymorphicFactory(PosHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PosObject
	
	def GetOutputDistance(self):
		DistanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlatticenode_getoutputdistance(self._handle, DistanceHandle))
		if DistanceHandle:
			DistanceObject = self._wrapper._polymorphicFactory(DistanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return DistanceObject
	
	def SetAccurateRange(self, AccurateRange):
		dAccurateRange = ctypes.c_double(AccurateRange)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlatticenode_setaccuraterange(self._handle, dAccurateRange))
		
	
	def GetAccurateRange(self):
		pAccurateRange = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_beamlatticenode_getaccuraterange(self._handle, pAccurateRange))
		
		return pAccurateRange.value
	


''' Class Implementation for FunctionGradientNode
'''
class FunctionGradientNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputFunctionID(self):
		FunctionHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getinputfunctionid(self._handle, FunctionHandle))
		if FunctionHandle:
			FunctionObject = self._wrapper._polymorphicFactory(FunctionHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return FunctionObject
	
	def GetInputPos(self):
		PosHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getinputpos(self._handle, PosHandle))
		if PosHandle:
			PosObject = self._wrapper._polymorphicFactory(PosHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PosObject
	
	def GetInputStep(self):
		StepHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getinputstep(self._handle, StepHandle))
		if StepHandle:
			StepObject = self._wrapper._polymorphicFactory(StepHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return StepObject
	
	def SetScalarOutputName(self, ScalarOutputName):
		pScalarOutputName = ctypes.c_char_p(str.encode(ScalarOutputName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_setscalaroutputname(self._handle, pScalarOutputName))
		
	
	def GetScalarOutputName(self):
		nScalarOutputNameBufferSize = ctypes.c_uint64(0)
		nScalarOutputNameNeededChars = ctypes.c_uint64(0)
		pScalarOutputNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getscalaroutputname(self._handle, nScalarOutputNameBufferSize, nScalarOutputNameNeededChars, pScalarOutputNameBuffer))
		nScalarOutputNameBufferSize = ctypes.c_uint64(nScalarOutputNameNeededChars.value)
		pScalarOutputNameBuffer = (ctypes.c_char * (nScalarOutputNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getscalaroutputname(self._handle, nScalarOutputNameBufferSize, nScalarOutputNameNeededChars, pScalarOutputNameBuffer))
		
		return pScalarOutputNameBuffer.value.decode()
	
	def SetVectorInputName(self, VectorInputName):
		pVectorInputName = ctypes.c_char_p(str.encode(VectorInputName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_setvectorinputname(self._handle, pVectorInputName))
		
	
	def GetVectorInputName(self):
		nVectorInputNameBufferSize = ctypes.c_uint64(0)
		nVectorInputNameNeededChars = ctypes.c_uint64(0)
		pVectorInputNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getvectorinputname(self._handle, nVectorInputNameBufferSize, nVectorInputNameNeededChars, pVectorInputNameBuffer))
		nVectorInputNameBufferSize = ctypes.c_uint64(nVectorInputNameNeededChars.value)
		pVectorInputNameBuffer = (ctypes.c_char * (nVectorInputNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getvectorinputname(self._handle, nVectorInputNameBufferSize, nVectorInputNameNeededChars, pVectorInputNameBuffer))
		
		return pVectorInputNameBuffer.value.decode()
	
	def GetOutputNormalizedGradient(self):
		NormalizedGradientHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getoutputnormalizedgradient(self._handle, NormalizedGradientHandle))
		if NormalizedGradientHandle:
			NormalizedGradientObject = self._wrapper._polymorphicFactory(NormalizedGradientHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NormalizedGradientObject
	
	def GetOutputGradient(self):
		GradientHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getoutputgradient(self._handle, GradientHandle))
		if GradientHandle:
			GradientObject = self._wrapper._polymorphicFactory(GradientHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return GradientObject
	
	def GetOutputMagnitude(self):
		MagnitudeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functiongradientnode_getoutputmagnitude(self._handle, MagnitudeHandle))
		if MagnitudeHandle:
			MagnitudeObject = self._wrapper._polymorphicFactory(MagnitudeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MagnitudeObject
	


''' Class Implementation for NormalizeDistanceNode
'''
class NormalizeDistanceNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputFunctionID(self):
		FunctionHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getinputfunctionid(self._handle, FunctionHandle))
		if FunctionHandle:
			FunctionObject = self._wrapper._polymorphicFactory(FunctionHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return FunctionObject
	
	def GetInputPos(self):
		PosHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getinputpos(self._handle, PosHandle))
		if PosHandle:
			PosObject = self._wrapper._polymorphicFactory(PosHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PosObject
	
	def GetInputStep(self):
		StepHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getinputstep(self._handle, StepHandle))
		if StepHandle:
			StepObject = self._wrapper._polymorphicFactory(StepHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return StepObject
	
	def SetScalarOutputName(self, ScalarOutputName):
		pScalarOutputName = ctypes.c_char_p(str.encode(ScalarOutputName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_setscalaroutputname(self._handle, pScalarOutputName))
		
	
	def GetScalarOutputName(self):
		nScalarOutputNameBufferSize = ctypes.c_uint64(0)
		nScalarOutputNameNeededChars = ctypes.c_uint64(0)
		pScalarOutputNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getscalaroutputname(self._handle, nScalarOutputNameBufferSize, nScalarOutputNameNeededChars, pScalarOutputNameBuffer))
		nScalarOutputNameBufferSize = ctypes.c_uint64(nScalarOutputNameNeededChars.value)
		pScalarOutputNameBuffer = (ctypes.c_char * (nScalarOutputNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getscalaroutputname(self._handle, nScalarOutputNameBufferSize, nScalarOutputNameNeededChars, pScalarOutputNameBuffer))
		
		return pScalarOutputNameBuffer.value.decode()
	
	def SetVectorInputName(self, VectorInputName):
		pVectorInputName = ctypes.c_char_p(str.encode(VectorInputName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_setvectorinputname(self._handle, pVectorInputName))
		
	
	def GetVectorInputName(self):
		nVectorInputNameBufferSize = ctypes.c_uint64(0)
		nVectorInputNameNeededChars = ctypes.c_uint64(0)
		pVectorInputNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getvectorinputname(self._handle, nVectorInputNameBufferSize, nVectorInputNameNeededChars, pVectorInputNameBuffer))
		nVectorInputNameBufferSize = ctypes.c_uint64(nVectorInputNameNeededChars.value)
		pVectorInputNameBuffer = (ctypes.c_char * (nVectorInputNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getvectorinputname(self._handle, nVectorInputNameBufferSize, nVectorInputNameNeededChars, pVectorInputNameBuffer))
		
		return pVectorInputNameBuffer.value.decode()
	
	def GetOutputResult(self):
		ResultHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_normalizedistancenode_getoutputresult(self._handle, ResultHandle))
		if ResultHandle:
			ResultObject = self._wrapper._polymorphicFactory(ResultHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResultObject
	


''' Class Implementation for FunctionCallNode
'''
class FunctionCallNode(ImplicitNode):
	def __init__(self, handle, wrapper):
		ImplicitNode.__init__(self, handle, wrapper)
	def GetInputFunctionID(self):
		FunctionHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functioncallnode_getinputfunctionid(self._handle, FunctionHandle))
		if FunctionHandle:
			FunctionObject = self._wrapper._polymorphicFactory(FunctionHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return FunctionObject
	


''' Class Implementation for NodeIterator
'''
class NodeIterator(Iterator):
	def __init__(self, handle, wrapper):
		Iterator.__init__(self, handle, wrapper)
	def GetCurrent(self):
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_nodeiterator_getcurrent(self._handle, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	


''' Class Implementation for Function
'''
class Function(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetDisplayName(self):
		nDisplayNameBufferSize = ctypes.c_uint64(0)
		nDisplayNameNeededChars = ctypes.c_uint64(0)
		pDisplayNameBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		nDisplayNameBufferSize = ctypes.c_uint64(nDisplayNameNeededChars.value)
		pDisplayNameBuffer = (ctypes.c_char * (nDisplayNameNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_getdisplayname(self._handle, nDisplayNameBufferSize, nDisplayNameNeededChars, pDisplayNameBuffer))
		
		return pDisplayNameBuffer.value.decode()
	
	def SetDisplayName(self, DisplayName):
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_setdisplayname(self._handle, pDisplayName))
		
	
	def AddInput(self, Identifier, DisplayName, Type):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		PortHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_addinput(self._handle, pIdentifier, pDisplayName, Type, PortHandle))
		if PortHandle:
			PortObject = self._wrapper._polymorphicFactory(PortHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PortObject
	
	def GetInputs(self):
		IteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_getinputs(self._handle, IteratorHandle))
		if IteratorHandle:
			IteratorObject = self._wrapper._polymorphicFactory(IteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return IteratorObject
	
	def RemoveInput(self, InputObject):
		InputHandle = None
		if InputObject:
			InputHandle = InputObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_removeinput(self._handle, InputHandle))
		
	
	def AddOutput(self, Identifier, DisplayName, Type):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		PortHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_addoutput(self._handle, pIdentifier, pDisplayName, Type, PortHandle))
		if PortHandle:
			PortObject = self._wrapper._polymorphicFactory(PortHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PortObject
	
	def GetOutputs(self):
		IteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_getoutputs(self._handle, IteratorHandle))
		if IteratorHandle:
			IteratorObject = self._wrapper._polymorphicFactory(IteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return IteratorObject
	
	def RemoveOutput(self, OutputObject):
		OutputHandle = None
		if OutputObject:
			OutputHandle = OutputObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_removeoutput(self._handle, OutputHandle))
		
	
	def FindInput(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		InputHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_findinput(self._handle, pIdentifier, InputHandle))
		if InputHandle:
			InputObject = self._wrapper._polymorphicFactory(InputHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return InputObject
	
	def FindOutput(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		OutputHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_function_findoutput(self._handle, pIdentifier, OutputHandle))
		if OutputHandle:
			OutputObject = self._wrapper._polymorphicFactory(OutputHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return OutputObject
	


''' Class Implementation for ImplicitFunction
'''
class ImplicitFunction(Function):
	def __init__(self, handle, wrapper):
		Function.__init__(self, handle, wrapper)
	def GetIdentifier(self):
		nIdentifierBufferSize = ctypes.c_uint64(0)
		nIdentifierNeededChars = ctypes.c_uint64(0)
		pIdentifierBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		nIdentifierBufferSize = ctypes.c_uint64(nIdentifierNeededChars.value)
		pIdentifierBuffer = (ctypes.c_char * (nIdentifierNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_getidentifier(self._handle, nIdentifierBufferSize, nIdentifierNeededChars, pIdentifierBuffer))
		
		return pIdentifierBuffer.value.decode()
	
	def SetIdentifier(self, Identifier):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_setidentifier(self._handle, pIdentifier))
		
	
	def AddNode(self, NodeType, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addnode(self._handle, NodeType, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSinNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addsinnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddCosNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addcosnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddTanNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addtannode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddArcSinNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addarcsinnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddArcCosNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addarccosnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddArcTan2Node(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addarctan2node(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSinhNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addsinhnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddCoshNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addcoshnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddTanhNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addtanhnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddRoundNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addroundnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddCeilNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addceilnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddFloorNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addfloornode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSignNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addsignnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddFractNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addfractnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddAbsNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addabsnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddExpNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addexpnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddLogNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlognode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddLog2Node(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlog2node(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddLog10Node(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlog10node(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddLengthNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlengthnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddTransposeNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addtransposenode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddInverseNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addinversenode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSqrtNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addsqrtnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddResourceIdNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addresourceidnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddAdditionNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addadditionnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSubtractionNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addsubtractionnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMultiplicationNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmultiplicationnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddDivisionNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_adddivisionnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddDotNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_adddotnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddCrossNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addcrossnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMatVecMultiplicationNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmatvecmultiplicationnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMinNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addminnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMaxNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmaxnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddFmodNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addfmodnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddPowNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addpownode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddSelectNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addselectnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddClampNode(self, Identifier, Configuration, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addclampnode(self._handle, pIdentifier, Configuration, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddComposeVectorNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addcomposevectornode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddVectorFromScalarNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addvectorfromscalarnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddDecomposeVectorNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_adddecomposevectornode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddComposeMatrixNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addcomposematrixnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMatrixFromRowsNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmatrixfromrowsnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMatrixFromColumnsNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmatrixfromcolumnsnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddConstantNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addconstantnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddConstVecNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addconstvecnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddConstMatNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addconstmatnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddMeshNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addmeshnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddUnsignedMeshNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addunsignedmeshnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddBeamLatticeNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addbeamlatticenode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddFunctionGradientNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addfunctiongradientnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddNormalizeDistanceNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addnormalizedistancenode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def AddFunctionCallNode(self, Identifier, DisplayName, Tag):
		pIdentifier = ctypes.c_char_p(str.encode(Identifier))
		pDisplayName = ctypes.c_char_p(str.encode(DisplayName))
		pTag = ctypes.c_char_p(str.encode(Tag))
		NodeHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addfunctioncallnode(self._handle, pIdentifier, pDisplayName, pTag, NodeHandle))
		if NodeHandle:
			NodeObject = self._wrapper._polymorphicFactory(NodeHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return NodeObject
	
	def GetNodes(self):
		IteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_getnodes(self._handle, IteratorHandle))
		if IteratorHandle:
			IteratorObject = self._wrapper._polymorphicFactory(IteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return IteratorObject
	
	def RemoveNode(self, NodeObject):
		NodeHandle = None
		if NodeObject:
			NodeHandle = NodeObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_removenode(self._handle, NodeHandle))
		
	
	def AddLink(self, SourceObject, TargetObject):
		SourceHandle = None
		if SourceObject:
			SourceHandle = SourceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TargetHandle = None
		if TargetObject:
			TargetHandle = TargetObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlink(self._handle, SourceHandle, TargetHandle))
		
	
	def AddLinkByNames(self, Source, Target):
		pSource = ctypes.c_char_p(str.encode(Source))
		pTarget = ctypes.c_char_p(str.encode(Target))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_addlinkbynames(self._handle, pSource, pTarget))
		
	
	def Clear(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_clear(self._handle))
		
	
	def SortNodesTopologically(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_implicitfunction_sortnodestopologically(self._handle))
		
	


''' Class Implementation for FunctionFromImage3D
'''
class FunctionFromImage3D(Function):
	def __init__(self, handle, wrapper):
		Function.__init__(self, handle, wrapper)
	def GetImage3D(self):
		Image3DHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_getimage3d(self._handle, Image3DHandle))
		if Image3DHandle:
			Image3DObject = self._wrapper._polymorphicFactory(Image3DHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Image3DObject
	
	def SetImage3D(self, Image3DObject):
		Image3DHandle = None
		if Image3DObject:
			Image3DHandle = Image3DObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_setimage3d(self._handle, Image3DHandle))
		
	
	def SetFilter(self, Filter):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_setfilter(self._handle, Filter))
		
	
	def GetFilter(self):
		pFilter = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_getfilter(self._handle, pFilter))
		
		return TextureFilter(pFilter.value)
	
	def SetTileStyles(self, TileStyleU, TileStyleV, TileStyleW):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_settilestyles(self._handle, TileStyleU, TileStyleV, TileStyleW))
		
	
	def GetTileStyles(self, TileStyleU = None, TileStyleV = None, TileStyleW = None):
		pTileStyleU = ctypes.c_int32(TileStyleU if TileStyleU else 0)
		pTileStyleV = ctypes.c_int32(TileStyleV if TileStyleV else 0)
		pTileStyleW = ctypes.c_int32(TileStyleW if TileStyleW else 0)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_gettilestyles(self._handle, pTileStyleU, pTileStyleV, pTileStyleW))
		
		return pTileStyleU.value, pTileStyleV.value, pTileStyleW.value
	
	def GetOffset(self):
		pOffset = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_getoffset(self._handle, pOffset))
		
		return pOffset.value
	
	def SetOffset(self, Offset):
		dOffset = ctypes.c_double(Offset)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_setoffset(self._handle, dOffset))
		
	
	def GetScale(self):
		pScale = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_getscale(self._handle, pScale))
		
		return pScale.value
	
	def SetScale(self, Scale):
		dScale = ctypes.c_double(Scale)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_functionfromimage3d_setscale(self._handle, dScale))
		
	


''' Class Implementation for BuildItem
'''
class BuildItem(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetObjectResource(self):
		ObjectResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjectresource(self._handle, ObjectResourceHandle))
		if ObjectResourceHandle:
			ObjectResourceObject = self._wrapper._polymorphicFactory(ObjectResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ObjectResourceObject
	
	def GetUUID(self, HasUUID = None):
		pHasUUID = ctypes.c_bool(HasUUID if HasUUID is not None else 0)
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setuuid(self._handle, pUUID))
		
	
	def GetObjectResourceID(self):
		pUniqueResourceID = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjectresourceid(self._handle, pUniqueResourceID))
		
		return pUniqueResourceID.value
	
	def HasObjectTransform(self):
		pHasTransform = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_hasobjecttransform(self._handle, pHasTransform))
		
		return pHasTransform.value
	
	def GetObjectTransform(self):
		pTransform = Transform()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getobjecttransform(self._handle, pTransform))
		
		return pTransform
	
	def SetObjectTransform(self, Transform):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setobjecttransform(self._handle, Transform))
		
	
	def GetPartNumber(self):
		nPartNumberBufferSize = ctypes.c_uint64(0)
		nPartNumberNeededChars = ctypes.c_uint64(0)
		pPartNumberBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		nPartNumberBufferSize = ctypes.c_uint64(nPartNumberNeededChars.value)
		pPartNumberBuffer = (ctypes.c_char * (nPartNumberNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getpartnumber(self._handle, nPartNumberBufferSize, nPartNumberNeededChars, pPartNumberBuffer))
		
		return pPartNumberBuffer.value.decode()
	
	def SetPartNumber(self, SetPartnumber):
		pSetPartnumber = ctypes.c_char_p(str.encode(SetPartnumber))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_setpartnumber(self._handle, pSetPartnumber))
		
	
	def GetMetaDataGroup(self):
		MetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getmetadatagroup(self._handle, MetaDataGroupHandle))
		if MetaDataGroupHandle:
			MetaDataGroupObject = self._wrapper._polymorphicFactory(MetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MetaDataGroupObject
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditem_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	


''' Class Implementation for BuildItemIterator
'''
class BuildItemIterator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def MoveNext(self):
		pHasNext = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_movenext(self._handle, pHasNext))
		
		return pHasNext.value
	
	def MovePrevious(self):
		pHasPrevious = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_moveprevious(self._handle, pHasPrevious))
		
		return pHasPrevious.value
	
	def GetCurrent(self):
		BuildItemHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_getcurrent(self._handle, BuildItemHandle))
		if BuildItemHandle:
			BuildItemObject = self._wrapper._polymorphicFactory(BuildItemHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemObject
	
	def Clone(self):
		OutBuildItemIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_clone(self._handle, OutBuildItemIteratorHandle))
		if OutBuildItemIteratorHandle:
			OutBuildItemIteratorObject = self._wrapper._polymorphicFactory(OutBuildItemIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return OutBuildItemIteratorObject
	
	def Count(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_builditemiterator_count(self._handle, pCount))
		
		return pCount.value
	


''' Class Implementation for Slice
'''
class Slice(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def SetVertices(self, Vertices):
		nVerticesCount = ctypes.c_uint64(len(Vertices))
		pVerticesBuffer = (Position2D*len(Vertices))(*Vertices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_setvertices(self._handle, nVerticesCount, pVerticesBuffer))
		
	
	def GetVertices(self, Vertices = None):
		nVerticesCount = ctypes.c_uint64(len(Vertices) if Vertices else 0)
		nVerticesNeededCount = ctypes.c_uint64(0)
		pVerticesBuffer = (Position2D*(len(Vertices) if Vertices else 0))(*Vertices if Vertices else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		nVerticesCount = ctypes.c_uint64(nVerticesNeededCount.value)
		pVerticesBuffer = (Position2D * nVerticesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertices(self._handle, nVerticesCount, nVerticesNeededCount, pVerticesBuffer))
		
		return list(pVerticesBuffer)
	
	def GetVertexCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getvertexcount(self._handle, pCount))
		
		return pCount.value
	
	def AddPolygon(self, Indices):
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (ctypes.c_uint32*len(Indices))(*Indices)
		pIndex = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_addpolygon(self._handle, nIndicesCount, pIndicesBuffer, pIndex))
		
		return pIndex.value
	
	def GetPolygonCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygoncount(self._handle, pCount))
		
		return pCount.value
	
	def SetPolygonIndices(self, Index, Indices):
		nIndex = ctypes.c_uint64(Index)
		nIndicesCount = ctypes.c_uint64(len(Indices))
		pIndicesBuffer = (ctypes.c_uint32*len(Indices))(*Indices)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_setpolygonindices(self._handle, nIndex, nIndicesCount, pIndicesBuffer))
		
	
	def GetPolygonIndices(self, Index, Indices = None):
		nIndex = ctypes.c_uint64(Index)
		nIndicesCount = ctypes.c_uint64(len(Indices) if Indices else 0)
		nIndicesNeededCount = ctypes.c_uint64(0)
		pIndicesBuffer = (ctypes.c_uint32*(len(Indices) if Indices else 0))(*Indices if Indices else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindices(self._handle, nIndex, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		nIndicesCount = ctypes.c_uint64(nIndicesNeededCount.value)
		pIndicesBuffer = (ctypes.c_uint32 * nIndicesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindices(self._handle, nIndex, nIndicesCount, nIndicesNeededCount, pIndicesBuffer))
		
		return list(pIndicesBuffer)
	
	def GetPolygonIndexCount(self, Index):
		nIndex = ctypes.c_uint64(Index)
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getpolygonindexcount(self._handle, nIndex, pCount))
		
		return pCount.value
	
	def GetZTop(self):
		pZTop = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slice_getztop(self._handle, pZTop))
		
		return pZTop.value
	


''' Class Implementation for SliceStack
'''
class SliceStack(Resource):
	def __init__(self, handle, wrapper):
		Resource.__init__(self, handle, wrapper)
	def GetBottomZ(self):
		pZBottom = ctypes.c_double()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getbottomz(self._handle, pZBottom))
		
		return pZBottom.value
	
	def GetSliceCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicecount(self._handle, pCount))
		
		return pCount.value
	
	def GetSlice(self, SliceIndex):
		nSliceIndex = ctypes.c_uint64(SliceIndex)
		TheSliceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslice(self._handle, nSliceIndex, TheSliceHandle))
		if TheSliceHandle:
			TheSliceObject = self._wrapper._polymorphicFactory(TheSliceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceObject
	
	def AddSlice(self, ZTop):
		dZTop = ctypes.c_double(ZTop)
		TheSliceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_addslice(self._handle, dZTop, TheSliceHandle))
		if TheSliceHandle:
			TheSliceObject = self._wrapper._polymorphicFactory(TheSliceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceObject
	
	def GetSliceRefCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicerefcount(self._handle, pCount))
		
		return pCount.value
	
	def AddSliceStackReference(self, TheSliceStackObject):
		TheSliceStackHandle = None
		if TheSliceStackObject:
			TheSliceStackHandle = TheSliceStackObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_addslicestackreference(self._handle, TheSliceStackHandle))
		
	
	def GetSliceStackReference(self, SliceRefIndex):
		nSliceRefIndex = ctypes.c_uint64(SliceRefIndex)
		TheSliceStackHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getslicestackreference(self._handle, nSliceRefIndex, TheSliceStackHandle))
		if TheSliceStackHandle:
			TheSliceStackObject = self._wrapper._polymorphicFactory(TheSliceStackHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheSliceStackObject
	
	def CollapseSliceReferences(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_collapseslicereferences(self._handle))
		
	
	def SetOwnPath(self, Path):
		pPath = ctypes.c_char_p(str.encode(Path))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_setownpath(self._handle, pPath))
		
	
	def GetOwnPath(self):
		nPathBufferSize = ctypes.c_uint64(0)
		nPathNeededChars = ctypes.c_uint64(0)
		pPathBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getownpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		nPathBufferSize = ctypes.c_uint64(nPathNeededChars.value)
		pPathBuffer = (ctypes.c_char * (nPathNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_slicestack_getownpath(self._handle, nPathBufferSize, nPathNeededChars, pPathBuffer))
		
		return pPathBuffer.value.decode()
	


''' Class Implementation for Consumer
'''
class Consumer(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetConsumerID(self):
		nConsumerIDBufferSize = ctypes.c_uint64(0)
		nConsumerIDNeededChars = ctypes.c_uint64(0)
		pConsumerIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getconsumerid(self._handle, nConsumerIDBufferSize, nConsumerIDNeededChars, pConsumerIDBuffer))
		nConsumerIDBufferSize = ctypes.c_uint64(nConsumerIDNeededChars.value)
		pConsumerIDBuffer = (ctypes.c_char * (nConsumerIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getconsumerid(self._handle, nConsumerIDBufferSize, nConsumerIDNeededChars, pConsumerIDBuffer))
		
		return pConsumerIDBuffer.value.decode()
	
	def GetKeyID(self):
		nKeyIDBufferSize = ctypes.c_uint64(0)
		nKeyIDNeededChars = ctypes.c_uint64(0)
		pKeyIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyid(self._handle, nKeyIDBufferSize, nKeyIDNeededChars, pKeyIDBuffer))
		nKeyIDBufferSize = ctypes.c_uint64(nKeyIDNeededChars.value)
		pKeyIDBuffer = (ctypes.c_char * (nKeyIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyid(self._handle, nKeyIDBufferSize, nKeyIDNeededChars, pKeyIDBuffer))
		
		return pKeyIDBuffer.value.decode()
	
	def GetKeyValue(self):
		nKeyValueBufferSize = ctypes.c_uint64(0)
		nKeyValueNeededChars = ctypes.c_uint64(0)
		pKeyValueBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyvalue(self._handle, nKeyValueBufferSize, nKeyValueNeededChars, pKeyValueBuffer))
		nKeyValueBufferSize = ctypes.c_uint64(nKeyValueNeededChars.value)
		pKeyValueBuffer = (ctypes.c_char * (nKeyValueNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_consumer_getkeyvalue(self._handle, nKeyValueBufferSize, nKeyValueNeededChars, pKeyValueBuffer))
		
		return pKeyValueBuffer.value.decode()
	


''' Class Implementation for AccessRight
'''
class AccessRight(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetConsumer(self):
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getconsumer(self._handle, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def GetWrappingAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getwrappingalgorithm(self._handle, pAlgorithm))
		
		return WrappingAlgorithm(pAlgorithm.value)
	
	def GetMgfAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getmgfalgorithm(self._handle, pAlgorithm))
		
		return MgfAlgorithm(pAlgorithm.value)
	
	def GetDigestMethod(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_accessright_getdigestmethod(self._handle, pAlgorithm))
		
		return DigestMethod(pAlgorithm.value)
	


''' Class Implementation for ContentEncryptionParams
'''
class ContentEncryptionParams(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetEncryptionAlgorithm(self):
		pAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getencryptionalgorithm(self._handle, pAlgorithm))
		
		return EncryptionAlgorithm(pAlgorithm.value)
	
	def GetKey(self, ByteData = None):
		nByteDataCount = ctypes.c_uint64(len(ByteData) if ByteData else 0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*(len(ByteData) if ByteData else 0))(*ByteData if ByteData else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkey(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkey(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return list(pByteDataBuffer)
	
	def GetInitializationVector(self, ByteData = None):
		nByteDataCount = ctypes.c_uint64(len(ByteData) if ByteData else 0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*(len(ByteData) if ByteData else 0))(*ByteData if ByteData else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getinitializationvector(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getinitializationvector(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return list(pByteDataBuffer)
	
	def GetAuthenticationTag(self, ByteData = None):
		nByteDataCount = ctypes.c_uint64(len(ByteData) if ByteData else 0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*(len(ByteData) if ByteData else 0))(*ByteData if ByteData else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getauthenticationtag(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getauthenticationtag(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return list(pByteDataBuffer)
	
	def SetAuthenticationTag(self, ByteData):
		nByteDataCount = ctypes.c_uint64(len(ByteData))
		pByteDataBuffer = (ctypes.c_uint8*len(ByteData))(*ByteData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_setauthenticationtag(self._handle, nByteDataCount, pByteDataBuffer))
		
	
	def GetAdditionalAuthenticationData(self, ByteData = None):
		nByteDataCount = ctypes.c_uint64(len(ByteData) if ByteData else 0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*(len(ByteData) if ByteData else 0))(*ByteData if ByteData else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return list(pByteDataBuffer)
	
	def GetDescriptor(self):
		pDescriptor = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getdescriptor(self._handle, pDescriptor))
		
		return pDescriptor.value
	
	def GetKeyUUID(self):
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_contentencryptionparams_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pUUIDBuffer.value.decode()
	


''' Class Implementation for ResourceData
'''
class ResourceData(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetPath(self):
		PathHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getpath(self._handle, PathHandle))
		if PathHandle:
			PathObject = self._wrapper._polymorphicFactory(PathHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return PathObject
	
	def GetEncryptionAlgorithm(self):
		pEncryptionAlgorithm = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getencryptionalgorithm(self._handle, pEncryptionAlgorithm))
		
		return EncryptionAlgorithm(pEncryptionAlgorithm.value)
	
	def GetCompression(self):
		pCompression = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getcompression(self._handle, pCompression))
		
		return Compression(pCompression.value)
	
	def GetAdditionalAuthenticationData(self, ByteData = None):
		nByteDataCount = ctypes.c_uint64(len(ByteData) if ByteData else 0)
		nByteDataNeededCount = ctypes.c_uint64(0)
		pByteDataBuffer = (ctypes.c_uint8*(len(ByteData) if ByteData else 0))(*ByteData if ByteData else [])
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		nByteDataCount = ctypes.c_uint64(nByteDataNeededCount.value)
		pByteDataBuffer = (ctypes.c_uint8 * nByteDataNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedata_getadditionalauthenticationdata(self._handle, nByteDataCount, nByteDataNeededCount, pByteDataBuffer))
		
		return list(pByteDataBuffer)
	


''' Class Implementation for ResourceDataGroup
'''
class ResourceDataGroup(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetKeyUUID(self):
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_getkeyuuid(self._handle, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pUUIDBuffer.value.decode()
	
	def AddAccessRight(self, ConsumerObject, WrappingAlgorithm, MgfAlgorithm, DigestMethod):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheAccessRightHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_addaccessright(self._handle, ConsumerHandle, WrappingAlgorithm, MgfAlgorithm, DigestMethod, TheAccessRightHandle))
		if TheAccessRightHandle:
			TheAccessRightObject = self._wrapper._polymorphicFactory(TheAccessRightHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheAccessRightObject
	
	def FindAccessRightByConsumer(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		TheAccessRightHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_findaccessrightbyconsumer(self._handle, ConsumerHandle, TheAccessRightHandle))
		if TheAccessRightHandle:
			TheAccessRightObject = self._wrapper._polymorphicFactory(TheAccessRightHandle)
		else:
			TheAccessRightObject = None
		
		return TheAccessRightObject
	
	def RemoveAccessRight(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_resourcedatagroup_removeaccessright(self._handle, ConsumerHandle))
		
	


''' Class Implementation for KeyStore
'''
class KeyStore(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def AddConsumer(self, ConsumerID, KeyID, KeyValue):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		pKeyID = ctypes.c_char_p(str.encode(KeyID))
		pKeyValue = ctypes.c_char_p(str.encode(KeyValue))
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addconsumer(self._handle, pConsumerID, pKeyID, pKeyValue, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def GetConsumerCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getconsumercount(self._handle, pCount))
		
		return pCount.value
	
	def GetConsumer(self, ConsumerIndex):
		nConsumerIndex = ctypes.c_uint64(ConsumerIndex)
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getconsumer(self._handle, nConsumerIndex, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ConsumerObject
	
	def RemoveConsumer(self, ConsumerObject):
		ConsumerHandle = None
		if ConsumerObject:
			ConsumerHandle = ConsumerObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeconsumer(self._handle, ConsumerHandle))
		
	
	def FindConsumer(self, ConsumerID):
		pConsumerID = ctypes.c_char_p(str.encode(ConsumerID))
		ConsumerHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findconsumer(self._handle, pConsumerID, ConsumerHandle))
		if ConsumerHandle:
			ConsumerObject = self._wrapper._polymorphicFactory(ConsumerHandle)
		else:
			ConsumerObject = None
		
		return ConsumerObject
	
	def GetResourceDataGroupCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatagroupcount(self._handle, pCount))
		
		return pCount.value
	
	def AddResourceDataGroup(self):
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addresourcedatagroup(self._handle, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataGroupObject
	
	def GetResourceDataGroup(self, ResourceDataIndex):
		nResourceDataIndex = ctypes.c_uint64(ResourceDataIndex)
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatagroup(self._handle, nResourceDataIndex, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataGroupObject
	
	def RemoveResourceDataGroup(self, ResourceDataGroupObject):
		ResourceDataGroupHandle = None
		if ResourceDataGroupObject:
			ResourceDataGroupHandle = ResourceDataGroupObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeresourcedatagroup(self._handle, ResourceDataGroupHandle))
		
	
	def FindResourceDataGroup(self, PartPathObject):
		PartPathHandle = None
		if PartPathObject:
			PartPathHandle = PartPathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ResourceDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findresourcedatagroup(self._handle, PartPathHandle, ResourceDataGroupHandle))
		if ResourceDataGroupHandle:
			ResourceDataGroupObject = self._wrapper._polymorphicFactory(ResourceDataGroupHandle)
		else:
			ResourceDataGroupObject = None
		
		return ResourceDataGroupObject
	
	def AddResourceData(self, ResourceDataGroupObject, PartPathObject, Algorithm, Compression, AdditionalAuthenticationData):
		ResourceDataGroupHandle = None
		if ResourceDataGroupObject:
			ResourceDataGroupHandle = ResourceDataGroupObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		PartPathHandle = None
		if PartPathObject:
			PartPathHandle = PartPathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		nAdditionalAuthenticationDataCount = ctypes.c_uint64(len(AdditionalAuthenticationData))
		pAdditionalAuthenticationDataBuffer = (ctypes.c_uint8*len(AdditionalAuthenticationData))(*AdditionalAuthenticationData)
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_addresourcedata(self._handle, ResourceDataGroupHandle, PartPathHandle, Algorithm, Compression, nAdditionalAuthenticationDataCount, pAdditionalAuthenticationDataBuffer, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataObject
	
	def RemoveResourceData(self, ResourceDataObject):
		ResourceDataHandle = None
		if ResourceDataObject:
			ResourceDataHandle = ResourceDataObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_removeresourcedata(self._handle, ResourceDataHandle))
		
	
	def FindResourceData(self, ResourcePathObject):
		ResourcePathHandle = None
		if ResourcePathObject:
			ResourcePathHandle = ResourcePathObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_findresourcedata(self._handle, ResourcePathHandle, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			ResourceDataObject = None
		
		return ResourceDataObject
	
	def GetResourceDataCount(self):
		pCount = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedatacount(self._handle, pCount))
		
		return pCount.value
	
	def GetResourceData(self, ResourceDataIndex):
		nResourceDataIndex = ctypes.c_uint64(ResourceDataIndex)
		ResourceDataHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getresourcedata(self._handle, nResourceDataIndex, ResourceDataHandle))
		if ResourceDataHandle:
			ResourceDataObject = self._wrapper._polymorphicFactory(ResourceDataHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceDataObject
	
	def GetUUID(self, HasUUID = None):
		pHasUUID = ctypes.c_bool(HasUUID if HasUUID is not None else 0)
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_getuuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_keystore_setuuid(self._handle, pUUID))
		
	


''' Class Implementation for Model
'''
class Model(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def RootModelPart(self):
		RootModelPartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_rootmodelpart(self._handle, RootModelPartHandle))
		if RootModelPartHandle:
			RootModelPartObject = self._wrapper._polymorphicFactory(RootModelPartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return RootModelPartObject
	
	def FindOrCreatePackagePart(self, AbsolutePath):
		pAbsolutePath = ctypes.c_char_p(str.encode(AbsolutePath))
		ModelPartHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_findorcreatepackagepart(self._handle, pAbsolutePath, ModelPartHandle))
		if ModelPartHandle:
			ModelPartObject = self._wrapper._polymorphicFactory(ModelPartHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ModelPartObject
	
	def SetUnit(self, Unit):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setunit(self._handle, Unit))
		
	
	def GetUnit(self):
		pUnit = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getunit(self._handle, pUnit))
		
		return ModelUnit(pUnit.value)
	
	def GetLanguage(self):
		nLanguageBufferSize = ctypes.c_uint64(0)
		nLanguageNeededChars = ctypes.c_uint64(0)
		pLanguageBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlanguage(self._handle, nLanguageBufferSize, nLanguageNeededChars, pLanguageBuffer))
		nLanguageBufferSize = ctypes.c_uint64(nLanguageNeededChars.value)
		pLanguageBuffer = (ctypes.c_char * (nLanguageNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlanguage(self._handle, nLanguageBufferSize, nLanguageNeededChars, pLanguageBuffer))
		
		return pLanguageBuffer.value.decode()
	
	def SetLanguage(self, Language):
		pLanguage = ctypes.c_char_p(str.encode(Language))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setlanguage(self._handle, pLanguage))
		
	
	def QueryWriter(self, WriterClass):
		pWriterClass = ctypes.c_char_p(str.encode(WriterClass))
		WriterInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_querywriter(self._handle, pWriterClass, WriterInstanceHandle))
		if WriterInstanceHandle:
			WriterInstanceObject = self._wrapper._polymorphicFactory(WriterInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return WriterInstanceObject
	
	def QueryReader(self, ReaderClass):
		pReaderClass = ctypes.c_char_p(str.encode(ReaderClass))
		ReaderInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_queryreader(self._handle, pReaderClass, ReaderInstanceHandle))
		if ReaderInstanceHandle:
			ReaderInstanceObject = self._wrapper._polymorphicFactory(ReaderInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ReaderInstanceObject
	
	def GetResourceByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ResourceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getresourcebyid(self._handle, nUniqueResourceID, ResourceHandle))
		if ResourceHandle:
			ResourceObject = self._wrapper._polymorphicFactory(ResourceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceObject
	
	def GetTexture2DByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		TextureInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dbyid(self._handle, nUniqueResourceID, TextureInstanceHandle))
		if TextureInstanceHandle:
			TextureInstanceObject = self._wrapper._polymorphicFactory(TextureInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TextureInstanceObject
	
	def GetPropertyTypeByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		pThePropertyType = ctypes.c_int32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getpropertytypebyid(self._handle, nUniqueResourceID, pThePropertyType))
		
		return PropertyType(pThePropertyType.value)
	
	def GetBaseMaterialGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbasematerialgroupbyid(self._handle, nUniqueResourceID, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def GetTexture2DGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		Texture2DGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dgroupbyid(self._handle, nUniqueResourceID, Texture2DGroupInstanceHandle))
		if Texture2DGroupInstanceHandle:
			Texture2DGroupInstanceObject = self._wrapper._polymorphicFactory(Texture2DGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DGroupInstanceObject
	
	def GetCompositeMaterialsByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		CompositeMaterialsInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcompositematerialsbyid(self._handle, nUniqueResourceID, CompositeMaterialsInstanceHandle))
		if CompositeMaterialsInstanceHandle:
			CompositeMaterialsInstanceObject = self._wrapper._polymorphicFactory(CompositeMaterialsInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return CompositeMaterialsInstanceObject
	
	def GetMultiPropertyGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		MultiPropertyGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmultipropertygroupbyid(self._handle, nUniqueResourceID, MultiPropertyGroupInstanceHandle))
		if MultiPropertyGroupInstanceHandle:
			MultiPropertyGroupInstanceObject = self._wrapper._polymorphicFactory(MultiPropertyGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MultiPropertyGroupInstanceObject
	
	def GetMeshObjectByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		MeshObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmeshobjectbyid(self._handle, nUniqueResourceID, MeshObjectInstanceHandle))
		if MeshObjectInstanceHandle:
			MeshObjectInstanceObject = self._wrapper._polymorphicFactory(MeshObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObjectInstanceObject
	
	def GetComponentsObjectByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ComponentsObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcomponentsobjectbyid(self._handle, nUniqueResourceID, ComponentsObjectInstanceHandle))
		if ComponentsObjectInstanceHandle:
			ComponentsObjectInstanceObject = self._wrapper._polymorphicFactory(ComponentsObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentsObjectInstanceObject
	
	def GetColorGroupByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ColorGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcolorgroupbyid(self._handle, nUniqueResourceID, ColorGroupInstanceHandle))
		if ColorGroupInstanceHandle:
			ColorGroupInstanceObject = self._wrapper._polymorphicFactory(ColorGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ColorGroupInstanceObject
	
	def GetSliceStackByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		SliceStacInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getslicestackbyid(self._handle, nUniqueResourceID, SliceStacInstanceHandle))
		if SliceStacInstanceHandle:
			SliceStacInstanceObject = self._wrapper._polymorphicFactory(SliceStacInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStacInstanceObject
	
	def GetLevelSetByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		LevelSetObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlevelsetbyid(self._handle, nUniqueResourceID, LevelSetObjectInstanceHandle))
		if LevelSetObjectInstanceHandle:
			LevelSetObjectInstanceObject = self._wrapper._polymorphicFactory(LevelSetObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return LevelSetObjectInstanceObject
	
	def GetBuildUUID(self, HasUUID = None):
		pHasUUID = ctypes.c_bool(HasUUID if HasUUID is not None else 0)
		nUUIDBufferSize = ctypes.c_uint64(0)
		nUUIDNeededChars = ctypes.c_uint64(0)
		pUUIDBuffer = ctypes.c_char_p(None)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilduuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		nUUIDBufferSize = ctypes.c_uint64(nUUIDNeededChars.value)
		pUUIDBuffer = (ctypes.c_char * (nUUIDNeededChars.value))()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilduuid(self._handle, pHasUUID, nUUIDBufferSize, nUUIDNeededChars, pUUIDBuffer))
		
		return pHasUUID.value, pUUIDBuffer.value.decode()
	
	def SetBuildUUID(self, UUID):
		pUUID = ctypes.c_char_p(str.encode(UUID))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setbuilduuid(self._handle, pUUID))
		
	
	def GetBuildItems(self):
		BuildItemIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbuilditems(self._handle, BuildItemIteratorHandle))
		if BuildItemIteratorHandle:
			BuildItemIteratorObject = self._wrapper._polymorphicFactory(BuildItemIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemIteratorObject
	
	def GetOutbox(self):
		pOutbox = Box()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getoutbox(self._handle, pOutbox))
		
		return pOutbox
	
	def GetResources(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getresources(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetMeshObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmeshobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetComponentsObjects(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcomponentsobjects(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetTexture2Ds(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2ds(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetBaseMaterialGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getbasematerialgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetColorGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcolorgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetTexture2DGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_gettexture2dgroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetCompositeMaterials(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getcompositematerials(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetMultiPropertyGroups(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmultipropertygroups(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetSliceStacks(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getslicestacks(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def GetImage3Ds(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getimage3ds(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def MergeToModel(self):
		MergedModelInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_mergetomodel(self._handle, MergedModelInstanceHandle))
		if MergedModelInstanceHandle:
			MergedModelInstanceObject = self._wrapper._polymorphicFactory(MergedModelInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MergedModelInstanceObject
	
	def MergeFromModel(self, ModelInstanceObject):
		ModelInstanceHandle = None
		if ModelInstanceObject:
			ModelInstanceHandle = ModelInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_mergefrommodel(self._handle, ModelInstanceHandle))
		
	
	def AddMeshObject(self):
		MeshObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addmeshobject(self._handle, MeshObjectInstanceHandle))
		if MeshObjectInstanceHandle:
			MeshObjectInstanceObject = self._wrapper._polymorphicFactory(MeshObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MeshObjectInstanceObject
	
	def AddComponentsObject(self):
		ComponentsObjectInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcomponentsobject(self._handle, ComponentsObjectInstanceHandle))
		if ComponentsObjectInstanceHandle:
			ComponentsObjectInstanceObject = self._wrapper._polymorphicFactory(ComponentsObjectInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ComponentsObjectInstanceObject
	
	def AddSliceStack(self, ZBottom):
		dZBottom = ctypes.c_double(ZBottom)
		SliceStackInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addslicestack(self._handle, dZBottom, SliceStackInstanceHandle))
		if SliceStackInstanceHandle:
			SliceStackInstanceObject = self._wrapper._polymorphicFactory(SliceStackInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return SliceStackInstanceObject
	
	def AddTexture2DFromAttachment(self, TextureAttachmentObject):
		TextureAttachmentHandle = None
		if TextureAttachmentObject:
			TextureAttachmentHandle = TextureAttachmentObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		Texture2DInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addtexture2dfromattachment(self._handle, TextureAttachmentHandle, Texture2DInstanceHandle))
		if Texture2DInstanceHandle:
			Texture2DInstanceObject = self._wrapper._polymorphicFactory(Texture2DInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DInstanceObject
	
	def AddBaseMaterialGroup(self):
		BaseMaterialGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addbasematerialgroup(self._handle, BaseMaterialGroupInstanceHandle))
		if BaseMaterialGroupInstanceHandle:
			BaseMaterialGroupInstanceObject = self._wrapper._polymorphicFactory(BaseMaterialGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BaseMaterialGroupInstanceObject
	
	def AddColorGroup(self):
		ColorGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcolorgroup(self._handle, ColorGroupInstanceHandle))
		if ColorGroupInstanceHandle:
			ColorGroupInstanceObject = self._wrapper._polymorphicFactory(ColorGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ColorGroupInstanceObject
	
	def AddTexture2DGroup(self, Texture2DInstanceObject):
		Texture2DInstanceHandle = None
		if Texture2DInstanceObject:
			Texture2DInstanceHandle = Texture2DInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		Texture2DGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addtexture2dgroup(self._handle, Texture2DInstanceHandle, Texture2DGroupInstanceHandle))
		if Texture2DGroupInstanceHandle:
			Texture2DGroupInstanceObject = self._wrapper._polymorphicFactory(Texture2DGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return Texture2DGroupInstanceObject
	
	def AddCompositeMaterials(self, BaseMaterialGroupInstanceObject):
		BaseMaterialGroupInstanceHandle = None
		if BaseMaterialGroupInstanceObject:
			BaseMaterialGroupInstanceHandle = BaseMaterialGroupInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		CompositeMaterialsInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcompositematerials(self._handle, BaseMaterialGroupInstanceHandle, CompositeMaterialsInstanceHandle))
		if CompositeMaterialsInstanceHandle:
			CompositeMaterialsInstanceObject = self._wrapper._polymorphicFactory(CompositeMaterialsInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return CompositeMaterialsInstanceObject
	
	def AddMultiPropertyGroup(self):
		MultiPropertyGroupInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addmultipropertygroup(self._handle, MultiPropertyGroupInstanceHandle))
		if MultiPropertyGroupInstanceHandle:
			MultiPropertyGroupInstanceObject = self._wrapper._polymorphicFactory(MultiPropertyGroupInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return MultiPropertyGroupInstanceObject
	
	def AddImageStack(self, ColumnCount, RowCount, SheetCount):
		nColumnCount = ctypes.c_uint32(ColumnCount)
		nRowCount = ctypes.c_uint32(RowCount)
		nSheetCount = ctypes.c_uint32(SheetCount)
		InstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addimagestack(self._handle, nColumnCount, nRowCount, nSheetCount, InstanceHandle))
		if InstanceHandle:
			InstanceObject = self._wrapper._polymorphicFactory(InstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return InstanceObject
	
	def GetImageStackByID(self, UniqueResourceID):
		nUniqueResourceID = ctypes.c_uint32(UniqueResourceID)
		ImageStackInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getimagestackbyid(self._handle, nUniqueResourceID, ImageStackInstanceHandle))
		if ImageStackInstanceHandle:
			ImageStackInstanceObject = self._wrapper._polymorphicFactory(ImageStackInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ImageStackInstanceObject
	
	def AddBuildItem(self, ObjectObject, Transform):
		ObjectHandle = None
		if ObjectObject:
			ObjectHandle = ObjectObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		BuildItemInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addbuilditem(self._handle, ObjectHandle, Transform, BuildItemInstanceHandle))
		if BuildItemInstanceHandle:
			BuildItemInstanceObject = self._wrapper._polymorphicFactory(BuildItemInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return BuildItemInstanceObject
	
	def RemoveBuildItem(self, BuildItemInstanceObject):
		BuildItemInstanceHandle = None
		if BuildItemInstanceObject:
			BuildItemInstanceHandle = BuildItemInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removebuilditem(self._handle, BuildItemInstanceHandle))
		
	
	def GetMetaDataGroup(self):
		TheMetaDataGroupHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getmetadatagroup(self._handle, TheMetaDataGroupHandle))
		if TheMetaDataGroupHandle:
			TheMetaDataGroupObject = self._wrapper._polymorphicFactory(TheMetaDataGroupHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheMetaDataGroupObject
	
	def AddAttachment(self, URI, RelationShipType):
		pURI = ctypes.c_char_p(str.encode(URI))
		pRelationShipType = ctypes.c_char_p(str.encode(RelationShipType))
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addattachment(self._handle, pURI, pRelationShipType, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def RemoveAttachment(self, AttachmentInstanceObject):
		AttachmentInstanceHandle = None
		if AttachmentInstanceObject:
			AttachmentInstanceHandle = AttachmentInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removeattachment(self._handle, AttachmentInstanceHandle))
		
	
	def GetAttachment(self, Index):
		nIndex = ctypes.c_uint32(Index)
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getattachment(self._handle, nIndex, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def FindAttachment(self, URI):
		pURI = ctypes.c_char_p(str.encode(URI))
		AttachmentInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_findattachment(self._handle, pURI, AttachmentInstanceHandle))
		if AttachmentInstanceHandle:
			AttachmentInstanceObject = self._wrapper._polymorphicFactory(AttachmentInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentInstanceObject
	
	def GetAttachmentCount(self):
		pAttachmentCount = ctypes.c_uint32()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getattachmentcount(self._handle, pAttachmentCount))
		
		return pAttachmentCount.value
	
	def HasPackageThumbnailAttachment(self):
		pHasThumbnail = ctypes.c_bool()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_haspackagethumbnailattachment(self._handle, pHasThumbnail))
		
		return pHasThumbnail.value
	
	def CreatePackageThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_createpackagethumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return AttachmentObject
	
	def GetPackageThumbnailAttachment(self):
		AttachmentHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getpackagethumbnailattachment(self._handle, AttachmentHandle))
		if AttachmentHandle:
			AttachmentObject = self._wrapper._polymorphicFactory(AttachmentHandle)
		else:
			AttachmentObject = None
		
		return AttachmentObject
	
	def RemovePackageThumbnailAttachment(self):
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removepackagethumbnailattachment(self._handle))
		
	
	def AddCustomContentType(self, Extension, ContentType):
		pExtension = ctypes.c_char_p(str.encode(Extension))
		pContentType = ctypes.c_char_p(str.encode(ContentType))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addcustomcontenttype(self._handle, pExtension, pContentType))
		
	
	def RemoveCustomContentType(self, Extension):
		pExtension = ctypes.c_char_p(str.encode(Extension))
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removecustomcontenttype(self._handle, pExtension))
		
	
	def SetRandomNumberCallback(self, TheCallbackFunc, UserData):
		pUserData = ctypes.c_void_p(UserData)
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_setrandomnumbercallback(self._handle, TheCallbackFunc, pUserData))
		
	
	def GetKeyStore(self):
		KeyStoreHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getkeystore(self._handle, KeyStoreHandle))
		if KeyStoreHandle:
			KeyStoreObject = self._wrapper._polymorphicFactory(KeyStoreHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return KeyStoreObject
	
	def GetFunctions(self):
		TheResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getfunctions(self._handle, TheResourceIteratorHandle))
		if TheResourceIteratorHandle:
			TheResourceIteratorObject = self._wrapper._polymorphicFactory(TheResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return TheResourceIteratorObject
	
	def AddImplicitFunction(self):
		FunctionInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addimplicitfunction(self._handle, FunctionInstanceHandle))
		if FunctionInstanceHandle:
			FunctionInstanceObject = self._wrapper._polymorphicFactory(FunctionInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return FunctionInstanceObject
	
	def AddFunctionFromImage3D(self, Image3DInstanceObject):
		Image3DInstanceHandle = None
		if Image3DInstanceObject:
			Image3DInstanceHandle = Image3DInstanceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		FunctionInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addfunctionfromimage3d(self._handle, Image3DInstanceHandle, FunctionInstanceHandle))
		if FunctionInstanceHandle:
			FunctionInstanceObject = self._wrapper._polymorphicFactory(FunctionInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return FunctionInstanceObject
	
	def AddVolumeData(self):
		VolumeDataInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addvolumedata(self._handle, VolumeDataInstanceHandle))
		if VolumeDataInstanceHandle:
			VolumeDataInstanceObject = self._wrapper._polymorphicFactory(VolumeDataInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return VolumeDataInstanceObject
	
	def AddLevelSet(self):
		LevelSetInstanceHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_addlevelset(self._handle, LevelSetInstanceHandle))
		if LevelSetInstanceHandle:
			LevelSetInstanceObject = self._wrapper._polymorphicFactory(LevelSetInstanceHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return LevelSetInstanceObject
	
	def GetLevelSets(self):
		ResourceIteratorHandle = ctypes.c_void_p()
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_getlevelsets(self._handle, ResourceIteratorHandle))
		if ResourceIteratorHandle:
			ResourceIteratorObject = self._wrapper._polymorphicFactory(ResourceIteratorHandle)
		else:
			raise ELib3MFException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return ResourceIteratorObject
	
	def RemoveResource(self, ResourceObject):
		ResourceHandle = None
		if ResourceObject:
			ResourceHandle = ResourceObject._handle
		else:
			raise ELib3MFException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self._wrapper.checkError(self, self._wrapper.lib.lib3mf_model_removeresource(self._handle, ResourceHandle))
		
	
		
