/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class RemoveRequiredActionStepProvider
implements WorkflowStepProvider {
    public static String REQUIRED_ACTION_KEY = "action";
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(RemoveRequiredActionStepProvider.class);

    public RemoveRequiredActionStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void run(WorkflowExecutionContext context) {
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user != null) {
            try {
                UserModel.RequiredAction action = UserModel.RequiredAction.valueOf((String)((String)this.stepModel.getConfig().getFirst((Object)REQUIRED_ACTION_KEY)));
                this.log.debugv("Removing required action {0} from user {1})", (Object)action, (Object)user.getId());
                user.removeRequiredAction(action);
            }
            catch (IllegalArgumentException e) {
                this.log.warnv("Invalid required action {0} configured in RemoveRequiredActionStepProvider", this.stepModel.getConfig().getFirst((Object)REQUIRED_ACTION_KEY));
            }
        }
    }

    public void close() {
    }
}

