/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.process.WaitableProcessHandle;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

final class WaitableProcessHandleImpl
implements WaitableProcessHandle {
    private final Process process;
    private final Path command;
    private final List<String> arguments;

    WaitableProcessHandleImpl(Process process, Path command, List<String> arguments) {
        this.process = process;
        this.command = command;
        this.arguments = arguments;
    }

    @Override
    public Path command() {
        return this.command;
    }

    @Override
    public List<String> arguments() {
        return this.arguments;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.process.waitFor(timeout, unit);
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    @Override
    public long pid() {
        return this.process.pid();
    }

    @Override
    public Optional<ProcessHandle> parent() {
        return this.process.toHandle().parent();
    }

    @Override
    public Stream<ProcessHandle> children() {
        return this.process.toHandle().children();
    }

    @Override
    public Stream<ProcessHandle> descendants() {
        return this.process.toHandle().descendants();
    }

    @Override
    public ProcessHandle.Info info() {
        return this.process.toHandle().info();
    }

    @Override
    public CompletableFuture<ProcessHandle> onExit() {
        return this.process.toHandle().onExit();
    }

    @Override
    public boolean supportsNormalTermination() {
        return this.process.supportsNormalTermination();
    }

    @Override
    public boolean destroy() {
        return this.process.toHandle().destroy();
    }

    @Override
    public boolean destroyForcibly() {
        return this.process.toHandle().destroyForcibly();
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int hashCode() {
        return this.process.toHandle().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof WaitableProcessHandleImpl)) return false;
        WaitableProcessHandleImpl wph = (WaitableProcessHandleImpl)other;
        if (!this.process.equals(wph.process)) return false;
        return true;
    }

    @Override
    public int compareTo(ProcessHandle other) {
        return this.compareTo((WaitableProcessHandleImpl)other);
    }

    @Override
    int compareTo(WaitableProcessHandleImpl other) {
        return Long.compare(this.pid(), other.pid());
    }

    public String toString() {
        return this.process.toHandle().toString();
    }
}

