/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.pcollections.HashTreePSet;
import org.pcollections.MapPSet;

public class PCollectionsImmutableSet<E>
implements ImmutableSet<E> {
    private final MapPSet<E> underlying;

    public static <E> PCollectionsImmutableSet<E> empty() {
        return new PCollectionsImmutableSet<E>(HashTreePSet.empty());
    }

    public static <E> PCollectionsImmutableSet<E> singleton(E e) {
        return new PCollectionsImmutableSet<E>(HashTreePSet.singleton(e));
    }

    public PCollectionsImmutableSet(MapPSet<E> set) {
        this.underlying = Objects.requireNonNull(set);
    }

    @Override
    public ImmutableSet<E> added(E e) {
        return new PCollectionsImmutableSet<E>(this.underlying().plus(e));
    }

    @Override
    public ImmutableSet<E> removed(E e) {
        return new PCollectionsImmutableSet<E>(this.underlying().minus(e));
    }

    @Override
    public int size() {
        return this.underlying().size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlying().iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.underlying().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying().toArray((Object[])a);
    }

    @Override
    public boolean add(E e) {
        return this.underlying().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.underlying().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.underlying().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.underlying().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.underlying().removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.underlying().removeIf(filter);
    }

    @Override
    public void clear() {
        this.underlying().clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.underlying().spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.underlying().stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.underlying().parallelStream();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCollectionsImmutableSet that = (PCollectionsImmutableSet)o;
        return Objects.equals(this.underlying(), that.underlying());
    }

    @Override
    public int hashCode() {
        return this.underlying().hashCode();
    }

    public String toString() {
        return "PCollectionsImmutableSet{underlying=" + String.valueOf(this.underlying()) + "}";
    }

    MapPSet<E> underlying() {
        return this.underlying;
    }
}

