/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class Orientation {
    public String saveName;
    private M3 rotationMatrix = new M3();
    private float xTrans;
    private float yTrans;
    private float zoom;
    private float rotationRadius;
    private P3 center = new P3();
    private P3 navCenter = new P3();
    private float xNav = Float.NaN;
    private float yNav = Float.NaN;
    private float navDepth = Float.NaN;
    private float cameraDepth = Float.NaN;
    private float cameraX = Float.NaN;
    private float cameraY = Float.NaN;
    private boolean windowCenteredFlag;
    private boolean navigationMode;
    private String moveToText;
    private float[] pymolView;
    private Viewer vwr;

    public String toString() {
        return "[Orientation " + this.saveName + " " + this.rotationRadius + "]";
    }

    public Orientation(Viewer vwr, boolean asDefault, float[] pymolView) {
        this.vwr = vwr;
        if (pymolView != null) {
            this.pymolView = pymolView;
            this.moveToText = "moveTo -1.0 PyMOL " + Escape.eAF(pymolView);
            return;
        }
        vwr.finalizeTransformParameters();
        if (asDefault) {
            M3 rot = (M3)vwr.ms.getInfoM("defaultOrientationMatrix");
            if (rot == null) {
                this.rotationMatrix.setScale(1.0f);
            } else {
                this.rotationMatrix.setM3(rot);
            }
        } else {
            vwr.tm.getRotation(this.rotationMatrix);
        }
        this.xTrans = vwr.tm.getTranslationXPercent();
        this.yTrans = vwr.tm.getTranslationYPercent();
        this.zoom = vwr.tm.getZoomSetting();
        this.center.setT(vwr.tm.fixedRotationCenter);
        this.windowCenteredFlag = vwr.tm.isWindowCentered();
        this.rotationRadius = vwr.getFloat(0x2200002C);
        this.navigationMode = vwr.getBoolean(603979889);
        this.moveToText = vwr.tm.getMoveToText(-1.0f, false);
        if (this.navigationMode) {
            this.xNav = vwr.tm.getNavigationOffsetPercent('X');
            this.yNav = vwr.tm.getNavigationOffsetPercent('Y');
            this.navDepth = vwr.tm.navigationDepthPercent;
            this.navCenter = P3.newP(vwr.tm.navigationCenter);
        }
        if (vwr.tm.camera.z != 0.0f) {
            this.cameraDepth = vwr.tm.getCameraDepth();
            this.cameraX = vwr.tm.camera.x;
            this.cameraY = vwr.tm.camera.y;
        }
    }

    public String getMoveToText(boolean asCommand) {
        return asCommand ? "   " + this.moveToText + "\n  save orientation " + PT.esc(this.saveName.substring(12)) + ";\n" : this.moveToText;
    }

    public boolean restore(float timeSeconds, boolean isAll) {
        if (isAll) {
            this.vwr.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            this.vwr.setBooleanProperty("navigationMode", this.navigationMode);
            if (this.pymolView == null) {
                this.vwr.moveTo(this.vwr.eval, timeSeconds, this.center, null, Float.NaN, this.rotationMatrix, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth, this.cameraDepth, this.cameraX, this.cameraY);
            } else {
                this.vwr.tm.moveToPyMOL(this.vwr.eval, timeSeconds, this.pymolView);
            }
        } else {
            this.vwr.tm.setRotation(this.rotationMatrix);
        }
        return true;
    }
}

