/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.InterpolatorEnum;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorUInt32;

public class WarpImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected WarpImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.WarpImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(WarpImageFilter warpImageFilter) {
        return warpImageFilter == null ? 0L : warpImageFilter.swigCPtr;
    }

    protected static long swigRelease(WarpImageFilter warpImageFilter) {
        long l = 0L;
        if (warpImageFilter != null) {
            if (!warpImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = warpImageFilter.swigCPtr;
            warpImageFilter.swigCMemOwn = false;
            warpImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_WarpImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public WarpImageFilter() {
        this(SimpleITKJNI.new_WarpImageFilter(), true);
    }

    public void setInterpolator(InterpolatorEnum interpolatorEnum) {
        SimpleITKJNI.WarpImageFilter_setInterpolator(this.swigCPtr, this, interpolatorEnum.swigValue());
    }

    public InterpolatorEnum getInterpolator() {
        return InterpolatorEnum.swigToEnum(SimpleITKJNI.WarpImageFilter_getInterpolator(this.swigCPtr, this));
    }

    public void setOutputSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.WarpImageFilter_setOutputSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getOutputSize() {
        return new VectorUInt32(SimpleITKJNI.WarpImageFilter_getOutputSize(this.swigCPtr, this), true);
    }

    public void setOutputOrigin(VectorDouble vectorDouble) {
        SimpleITKJNI.WarpImageFilter_setOutputOrigin(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputOrigin() {
        return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputOrigin(this.swigCPtr, this), true);
    }

    public void setOutputSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.WarpImageFilter_setOutputSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputSpacing() {
        return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputSpacing(this.swigCPtr, this), true);
    }

    public void setOutputDirection(VectorDouble vectorDouble) {
        SimpleITKJNI.WarpImageFilter_setOutputDirection(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputDirection() {
        return new VectorDouble(SimpleITKJNI.WarpImageFilter_getOutputDirection(this.swigCPtr, this), true);
    }

    public void setEdgePaddingValue(double d) {
        SimpleITKJNI.WarpImageFilter_setEdgePaddingValue(this.swigCPtr, this, d);
    }

    public double getEdgePaddingValue() {
        return SimpleITKJNI.WarpImageFilter_getEdgePaddingValue(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.WarpImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.WarpImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image, Image image2) {
        return new Image(SimpleITKJNI.WarpImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(image2), image2), true);
    }

    public void setOutputParameteresFromImage(Image image) {
        SimpleITKJNI.WarpImageFilter_setOutputParameteresFromImage(this.swigCPtr, this, Image.getCPtr(image), image);
    }
}

