/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.k1.settings.KotlinScriptingSettingsImpl;
import org.jetbrains.kotlin.idea.core.script.shared.ScriptDefinitionSourcesKt;
import org.jetbrains.kotlin.idea.core.script.shared.definition.BundledScriptDefinitionKt;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001c\u001a\u00020\tJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\nH\u0002J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\tH\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0019H\u0002J\b\u0010+\u001a\u00020 H\u0002J\b\u0010,\u001a\u00020 H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\nH\u0014J\b\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020 H\u0014J\u0010\u00101\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0016\u00102\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "definitionsBySource", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "activatedDefinitionSources", "", "failedContributorsHashes", "", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "definitions", "currentDefinitions", "Lkotlin/sequences/Sequence;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "reloadDefinitions", "reloadDefinitionsBy", "source", "reorderDefinitions", "getDefaultDefinition", "withLocks", "", "block", "Lkotlin/Function0;", "getOrLoadDefinitions", "allDefinitionSourcesContributedToCache", "", "reloadDefinitionsInternal", "sources", "safeGetDefinitions", "isEmbeddedScript", "code", "associateFileExtensionsIfNeeded", "dispose", "getSources", "getKotlinScriptingSettings", "Lorg/jetbrains/kotlin/idea/core/script/k1/settings/KotlinScriptingSettingsImpl;", "applyDefinitionsUpdate", "isScratchFile", "executeUnderReadLock", "Companion", "kotlin.base.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n200#2,2:292\n200#2,3:298\n202#2:302\n1285#3,2:294\n1299#3,2:296\n1302#3:301\n774#3:303\n865#3,2:304\n1869#3,2:307\n1056#3:309\n1563#3:310\n1634#3,3:311\n1869#3,2:314\n2756#3:316\n1056#3:318\n1869#3,2:319\n1#4:306\n1#4:317\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager\n*L\n176#1:292,2\n178#1:298,3\n176#1:302\n177#1:294,2\n177#1:296,2\n177#1:301\n234#1:303\n234#1:304,2\n138#1:307,2\n141#1:309\n179#1:310\n179#1:311,3\n193#1:314,2\n199#1:316\n200#1:318\n248#1:319,2\n199#1:317\n*E\n"})
public class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ScriptDefinitionsSource, List<ScriptDefinition>> definitionsBySource;
    @NotNull
    private final Set<ScriptDefinitionsSource> activatedDefinitionSources;
    @NotNull
    private final Set<Integer> failedContributorsHashes;
    @NotNull
    private final ReentrantLock definitionsLock;
    @Nullable
    private volatile List<? extends ScriptDefinition> definitions;

    public ScriptDefinitionsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.definitionsBySource = new LinkedHashMap();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.activatedDefinitionSources = keySetView;
        ConcurrentHashMap.KeySetView keySetView2 = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView2, (String)"newKeySet(...)");
        this.failedContributorsHashes = keySetView2;
        this.definitionsLock = new ReentrantLock();
    }

    @Override
    @NotNull
    public Sequence<ScriptDefinition> getCurrentDefinitions() {
        KotlinScriptingSettingsImpl scriptingSettings = this.getKotlinScriptingSettings();
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getOrLoadDefinitions()), arg_0 -> ScriptDefinitionsManager._get_currentDefinitions_$lambda$0(scriptingSettings, arg_0));
    }

    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.getOrLoadDefinitions();
        if (this.isScratchFile(script)) {
            scriptDefinition = this.getDefaultDefinition();
        } else {
            scriptDefinition = super.findDefinition(script);
            if (scriptDefinition == null) {
                scriptDefinition = this.isEmbeddedScript(script) ? this.getDefaultDefinition() : null;
            }
        }
        ScriptDefinition definition = scriptDefinition;
        return definition;
    }

    @NotNull
    public final List<ScriptDefinition> reloadDefinitions() {
        return this.reloadDefinitionsInternal(this.getSources());
    }

    @NotNull
    public final List<ScriptDefinition> reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.reloadDefinitionsInternal(CollectionsKt.listOf((Object)source));
    }

    @NotNull
    public final List<ScriptDefinition> reorderDefinitions() {
        if (this.definitions == null) {
            return CollectionsKt.emptyList();
        }
        KotlinScriptingSettingsImpl scriptingSettings = this.getKotlinScriptingSettings();
        this.withLocks((Function0<Unit>)((Function0)() -> ScriptDefinitionsManager.reorderDefinitions$lambda$0(this, scriptingSettings)));
        this.applyDefinitionsUpdate();
        List list2 = this.definitions;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return BundledScriptDefinitionKt.getDefaultDefinition(this.project);
    }

    private final void withLocks(Function0<Unit> block) {
        this.executeUnderReadLock((Function0<Unit>)((Function0)() -> ScriptDefinitionsManager.withLocks$lambda$0(this, block)));
    }

    private final List<ScriptDefinition> getOrLoadDefinitions() {
        List<ScriptDefinition> list2;
        if (this.definitions == null || !this.allDefinitionSourcesContributedToCache()) {
            list2 = this.reloadDefinitionsInternal(this.getSources());
        } else {
            list2 = this.definitions;
            if (list2 == null) {
                throw new IllegalStateException("'definitions' became null after they weren't".toString());
            }
        }
        return list2;
    }

    private final boolean allDefinitionSourcesContributedToCache() {
        return this.activatedDefinitionSources.containsAll((Collection)this.getSources());
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinition> reloadDefinitionsInternal(List<? extends ScriptDefinitionsSource> sources) {
        void $this$associateWithTo$iv$iv;
        Ref.ObjectRef loadedDefinitions = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillisWithResult = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$associateWith$iv = sources;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ScriptDefinitionsSource scriptDefinitionsSource = (ScriptDefinitionsSource)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            boolean $i$f$measureTimeMillisWithResult2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl3 = false;
            List<ScriptDefinition> result$iv2 = this.safeGetDefinitions((ScriptDefinitionsSource)it);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv2), result$iv2);
            long ms = ((Number)pair.component1()).longValue();
            List definitions2 = (List)pair.component2();
            ScriptingLoggerKt.scriptingDebugLog$default(null, () -> ScriptDefinitionsManager.reloadDefinitionsInternal$lambda$0$0$1(ms, (ScriptDefinitionsSource)it, definitions2), 1, null);
            List list2 = definitions2;
            map2.put(t, list2);
        }
        Map result$iv3 = destination$iv$iv;
        Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv3);
        long ms = ((Number)pair.component1()).longValue();
        Map newDefinitionsBySource = (Map)pair.component2();
        ScriptingLoggerKt.scriptingDebugLog$default(null, () -> ScriptDefinitionsManager.reloadDefinitionsInternal$lambda$1(ms), 1, null);
        KotlinScriptingSettingsImpl scriptingSettings = this.getKotlinScriptingSettings();
        this.withLocks((Function0<Unit>)((Function0)() -> ScriptDefinitionsManager.reloadDefinitionsInternal$lambda$2(this, newDefinitionsBySource, loadedDefinitions, scriptingSettings)));
        this.activatedDefinitionSources.addAll((Collection<ScriptDefinitionsSource>)sources);
        this.applyDefinitionsUpdate();
        List list3 = (List)loadedDefinitions.element;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final List<ScriptDefinition> safeGetDefinitions(ScriptDefinitionsSource $this$safeGetDefinitions) {
        if (!this.failedContributorsHashes.contains($this$safeGetDefinitions.hashCode())) {
            try {
                return SequencesKt.toList($this$safeGetDefinitions.getDefinitions());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.failedContributorsHashes.add($this$safeGetDefinitions.hashCode());
                Object object = t.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = t.getMessage();
                }
                ScriptingLoggerKt.scriptingErrorLog("Cannot load script definitions from " + $this$safeGetDefinitions + ": " + (String)object, t);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isEmbeddedScript(SourceCode code) {
        VirtualFileScriptSource virtualFileScriptSource = code instanceof VirtualFileScriptSource ? (VirtualFileScriptSource)code : null;
        if (virtualFileScriptSource == null) {
            return false;
        }
        VirtualFileScriptSource scriptSource = virtualFileScriptSource;
        VirtualFile virtualFile = scriptSource.getVirtualFile();
        return virtualFile instanceof VirtualFileWindow && Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)KotlinFileType.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void associateFileExtensionsIfNeeded() {
        void $this$filterTo$iv$iv;
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Iterable $this$filter$iv = SequencesKt.toSet(this.getKnownFilenameExtensions());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType fileTypeByExtension;
            boolean notKnown;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager.getFileTypeByFileName("xxx." + it), (String)"getFileTypeByFileName(...)");
            boolean bl2 = notKnown = !Intrinsics.areEqual((Object)fileTypeByExtension, (Object)KotlinFileType.INSTANCE);
            if (notKnown) {
                ScriptingLoggerKt.scriptingWarnLog("extension " + it + " file type [" + fileTypeByExtension.getName() + "] is not registered as " + KotlinFileType.INSTANCE.getName());
            }
            if (!notKnown) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set newExtensions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)newExtensions).isEmpty()) {
            ScriptingLoggerKt.scriptingWarnLog("extensions " + newExtensions + " is about to be registered as " + KotlinFileType.INSTANCE.getName());
            ApplicationManager.getApplication().invokeLater(() -> ScriptDefinitionsManager.associateFileExtensionsIfNeeded$lambda$1(newExtensions, fileTypeManager));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
        this.definitionsBySource.clear();
        this.definitions = null;
        this.activatedDefinitionSources.clear();
        this.failedContributorsHashes.clear();
    }

    @NotNull
    protected List<ScriptDefinitionsSource> getSources() {
        List fromNewEp = ScriptDefinitionSourcesKt.getSCRIPT_DEFINITIONS_SOURCES().getExtensions((AreaInstance)this.project);
        return CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Object)CollectionsKt.last((List)fromNewEp));
    }

    @NotNull
    protected KotlinScriptingSettingsImpl getKotlinScriptingSettings() {
        return KotlinScriptingSettingsImpl.Companion.getInstance(this.project);
    }

    protected void applyDefinitionsUpdate() {
        this.associateFileExtensionsIfNeeded();
        ScriptConfigurationManager.Companion.getInstance(this.project).updateScriptDefinitionReferences();
    }

    protected boolean isScratchFile(@NotNull SourceCode script) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (script instanceof VirtualFileScriptSource) {
            virtualFile = ((VirtualFileScriptSource)script).getVirtualFile();
        } else {
            String string = script.getLocationId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(it);
            } else {
                virtualFile = null;
            }
        }
        VirtualFile virtualFile2 = virtualFile;
        return virtualFile2 != null && ScratchFileService.getInstance().getRootType(virtualFile2) instanceof ScratchRootType;
    }

    protected void executeUnderReadLock(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ActionsKt.runReadAction(() -> ScriptDefinitionsManager.executeUnderReadLock$lambda$0(block));
    }

    private static final boolean _get_currentDefinitions_$lambda$0(KotlinScriptingSettingsImpl $scriptingSettings, ScriptDefinition it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $scriptingSettings.isScriptDefinitionEnabled(it);
    }

    private static final Unit reorderDefinitions$lambda$0(ScriptDefinitionsManager this$0, KotlinScriptingSettingsImpl $scriptingSettings) {
        List<? extends ScriptDefinition> list2 = this$0.definitions;
        if (list2 != null) {
            List<? extends ScriptDefinition> list3 = list2;
            boolean bl = false;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                boolean bl2 = false;
                it.setOrder($scriptingSettings.getScriptDefinitionOrder(it));
            }
            Iterable $this$sortedBy$iv = list3;
            boolean $i$f$sortedBy = false;
            this$0.definitions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ScriptDefinition p0 = (ScriptDefinition)((Object)a);
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getOrder());
                    p0 = (ScriptDefinition)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrder()));
                }
            });
        }
        this$0.clearCache();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit withLocks$lambda$0(ScriptDefinitionsManager this$0, Function0 $block) {
        Lock lock = this$0.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            $block.invoke();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final String reloadDefinitionsInternal$lambda$0$0$1(long $ms, ScriptDefinitionsSource $it, List $definitions) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $definitions;
        String string = $it.getClass().getName();
        long l = $ms;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptDefinition scriptDefinition = (ScriptDefinition)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        return "Loaded definitions: time = " + l + " ms, source = " + string + ", definitions = " + (List)collection;
    }

    private static final String reloadDefinitionsInternal$lambda$1(long $ms) {
        return "Definitions loading total time: " + $ms + " ms";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit reloadDefinitionsInternal$lambda$2(ScriptDefinitionsManager this$0, Map $newDefinitionsBySource, Ref.ObjectRef $loadedDefinitions, KotlinScriptingSettingsImpl $scriptingSettings) {
        void it;
        void $this$sortedBy$iv;
        List list2;
        Iterator $this$onEach$iv;
        Iterator iterator2;
        Iterable $this$forEach$iv;
        if (this$0.definitionsBySource.isEmpty()) {
            $this$forEach$iv = this$0.getSources();
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ScriptDefinitionsSource it2 = (ScriptDefinitionsSource)element$iv;
                boolean bl = false;
                this$0.definitionsBySource.put(it2, CollectionsKt.emptyList());
            }
        }
        this$0.definitionsBySource.putAll($newDefinitionsBySource);
        $this$forEach$iv = AddToStdlibKt.flattenTo((Iterable)this$0.definitionsBySource.values(), (Collection)new ArrayList());
        Ref.ObjectRef objectRef = $loadedDefinitions;
        boolean $i$f$onEach = false;
        Iterator $this$onEach_u24lambda_u240$iv = iterator2 = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator3 = $this$onEach_u24lambda_u240$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            ScriptDefinition it3 = (ScriptDefinition)((Object)element$iv);
            boolean bl2 = false;
            it3.setOrder($scriptingSettings.getScriptDefinitionOrder(it3));
        }
        $this$onEach$iv = iterator2;
        boolean $i$f$sortedBy22 = false;
        List $i$f$sortedBy22 = list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ScriptDefinition p0 = (ScriptDefinition)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getOrder());
                p0 = (ScriptDefinition)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrder()));
            }
        });
        boolean bl3 = false;
        boolean bl4 = !((Collection)it).isEmpty();
        objectRef.element = bl4 ? list2 : null;
        this$0.definitions = (List)$loadedDefinitions.element;
        this$0.clearCache();
        return Unit.INSTANCE;
    }

    private static final void associateFileExtensionsIfNeeded$lambda$1(Set $newExtensions, FileTypeManager $fileTypeManager) {
        ActionsKt.runWriteAction(() -> ScriptDefinitionsManager.associateFileExtensionsIfNeeded$lambda$1$0($newExtensions, $fileTypeManager));
    }

    private static final Unit associateFileExtensionsIfNeeded$lambda$1$0(Set $newExtensions, FileTypeManager $fileTypeManager) {
        Iterable $this$forEach$iv = $newExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $fileTypeManager.associateExtension((FileType)KotlinFileType.INSTANCE, it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit executeUnderReadLock$lambda$0(Function0 $block) {
        $block.invoke();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting.k1"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,291:1\n30#2,2:292\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDefinitionsManager$Companion\n*L\n59#1:292,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.k1.ScriptDefinitionsManager");
            return (ScriptDefinitionsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

