/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.xmlb.XmlSerializer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.base.plugin.KotlinCompilerVersionProvider;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IncompatibleJdkVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettingsKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.compiler.configuration.NewCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.OutdatedCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.ParsingError;
import org.jetbrains.kotlin.idea.compiler.configuration.UnsupportedJpsVersionError;

@Service(value={Service.Level.PROJECT})
@State(name="KotlinJpsPluginSettings", storages={@Storage(value="kotlinc.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0006\u0010\u0011\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/BaseKotlinCompilerSettings;", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createSettings", "setVersion", "", "jpsVersion", "", "externalSystemId", "getState", "Lorg/jdom/Element;", "onStateDeserialized", "state", "dropExplicitVersion", "Companion", "intellij.kotlin.base.plugin"})
public final class KotlinJpsPluginSettings
extends BaseKotlinCompilerSettings<JpsPluginSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KotlinVersion MIN_KOTLIN_VERSION_JDK_25 = IdeKotlinVersion.Companion.get("2.1.10").getKotlinVersion();
    @NotNull
    private static final KotlinVersion jpsMinimumSupportedVersion = IdeKotlinVersion.Companion.get("1.7.0").getKotlinVersion();
    @NotNull
    private static final KotlinVersion jpsMaximumSupportedVersion = LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)((LanguageVersion)ArraysKt.last((Object[])LanguageVersion.values())));

    public KotlinJpsPluginSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected JpsPluginSettings createSettings() {
        return new JpsPluginSettings();
    }

    public final void setVersion(@NotNull String jpsVersion, @NotNull String externalSystemId) {
        Intrinsics.checkNotNullParameter((Object)jpsVersion, (String)"jpsVersion");
        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
        if (Intrinsics.areEqual((Object)jpsVersion, (Object)((JpsPluginSettings)this.getSettings()).getVersion())) {
            return;
        }
        this.update(arg_0 -> KotlinJpsPluginSettings.setVersion$lambda$0(jpsVersion, externalSystemId, arg_0));
    }

    public static /* synthetic */ void setVersion$default(KotlinJpsPluginSettings kotlinJpsPluginSettings, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        kotlinJpsPluginSettings.setVersion(string, string2);
    }

    @Override
    @NotNull
    public Element getState() {
        if (StringsKt.contains$default((CharSequence)((JpsPluginSettings)this.getSettings()).getVersion(), (CharSequence)"-release", (boolean)false, (int)2, null)) {
            this.update(KotlinJpsPluginSettings::getState$lambda$0);
        }
        return super.getState();
    }

    @Override
    protected void onStateDeserialized(@NotNull JpsPluginSettings state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (StringsKt.contains$default((CharSequence)state.getVersion(), (CharSequence)"-release", (boolean)false, (int)2, null)) {
            state.setVersion("");
        }
    }

    public final void dropExplicitVersion() {
        KotlinJpsPluginSettings.setVersion$default(this, "", null, 2, null);
    }

    private static final Unit setVersion$lambda$0(String $jpsVersion, String $externalSystemId, JpsPluginSettings $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setVersion($jpsVersion);
        $this$update.setExternalSystemId($externalSystemId);
        return Unit.INSTANCE;
    }

    private static final Unit getState$lambda$0(JpsPluginSettings $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setVersion("");
        return Unit.INSTANCE;
    }

    @NotNull
    public static final String getRawBundledVersion() {
        return Companion.getRawBundledVersion();
    }

    @NotNull
    public static final String getFallbackVersionForOutdatedCompiler() {
        return Companion.getFallbackVersionForOutdatedCompiler();
    }

    @NotNull
    public static final IdeKotlinVersion getBundledVersion() {
        return Companion.getBundledVersion();
    }

    @NotNull
    public static final KotlinVersion getJpsMinimumSupportedVersion() {
        return Companion.getJpsMinimumSupportedVersion();
    }

    @NotNull
    public static final KotlinVersion getJpsMaximumSupportedVersion() {
        return Companion.getJpsMaximumSupportedVersion();
    }

    @JvmStatic
    @NotNull
    public static final KotlinJpsPluginSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J$\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J5\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001d2#\u0010*\u001a\u001f\u0012\u0015\u0012\u00130\u0007\u00a2\u0006\u000e\b,\u0012\n\b-\u0012\u0006\b\n0.8/\u0012\u0004\u0012\u00020\u001b0+J&\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u0007J\u0018\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0007H\u0002J\u0015\u00106\u001a\u00020$2\u0006\u00105\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\u0016\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion;", "", "<init>", "()V", "MIN_KOTLIN_VERSION_JDK_25", "Lkotlin/KotlinVersion;", "rawBundledVersion", "", "getRawBundledVersion$annotations", "getRawBundledVersion", "()Ljava/lang/String;", "fallbackVersionForOutdatedCompiler", "getFallbackVersionForOutdatedCompiler$annotations", "getFallbackVersionForOutdatedCompiler", "bundledVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getBundledVersion$annotations", "getBundledVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "jpsMinimumSupportedVersion", "getJpsMinimumSupportedVersion$annotations", "getJpsMinimumSupportedVersion", "()Lkotlin/KotlinVersion;", "jpsMaximumSupportedVersion", "getJpsMaximumSupportedVersion$annotations", "getJpsMaximumSupportedVersion", "validateSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "jpsVersion", "getInstance", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "checkJpsVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/UnsupportedJpsVersionError;", "fromFile", "", "readFromKotlincXmlOrIpr", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "path", "Ljava/nio/file/Path;", "supportedJpsVersion", "onUnsupportedVersion", "Lkotlin/Function1;", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "importKotlinJpsVersionFromExternalBuildSystem", "rawVersion", "isDelegatedToExtBuild", "externalSystemId", "downloadKotlinJpsInBackground", "version", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$intellij_kotlin_base_plugin", "validateExternalSystemId", "intellij.kotlin.base.plugin"})
    @SourceDebugExtension(value={"SMAP\nKotlinJpsPluginSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJpsPluginSettings.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n30#2,2:376\n1#3:378\n669#4,11:379\n*S KotlinDebug\n*F\n+ 1 KotlinJpsPluginSettings.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion\n*L\n110#1:376,2\n194#1:379,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRawBundledVersion() {
            return this.getBundledVersion().getRawVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getRawBundledVersion$annotations() {
        }

        @NotNull
        public final String getFallbackVersionForOutdatedCompiler() {
            return "1.7.22";
        }

        @JvmStatic
        public static /* synthetic */ void getFallbackVersionForOutdatedCompiler$annotations() {
        }

        @NotNull
        public final IdeKotlinVersion getBundledVersion() {
            return KotlinPluginLayout.getStandaloneCompilerVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getBundledVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMinimumSupportedVersion() {
            return jpsMinimumSupportedVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMinimumSupportedVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMaximumSupportedVersion() {
            return jpsMaximumSupportedVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMaximumSupportedVersion$annotations() {
        }

        public final void validateSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            KotlinJpsPluginSettings jpsPluginSettings = this.getInstance(project);
            if (((CharSequence)((JpsPluginSettings)jpsPluginSettings.getSettings()).getVersion()).length() == 0 && this.getBundledVersion().getBuildNumber() == null) {
                KotlinJpsPluginSettings.setVersion$default(jpsPluginSettings, this.getRawBundledVersion(), null, 2, null);
            }
        }

        @NotNull
        public final String jpsVersion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return KotlinJpsPluginSettingsKt.getVersionWithFallback((JpsPluginSettings)this.getInstance(project).getSettings());
        }

        @JvmStatic
        @NotNull
        public final KotlinJpsPluginSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinJpsPluginSettings> serviceClass$iv = KotlinJpsPluginSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinJpsPluginSettings)object;
        }

        @Nls
        @Nullable
        public final UnsupportedJpsVersionError checkJpsVersion(@NotNull String jpsVersion, @NotNull Project project, boolean fromFile) {
            KotlinVersion parsedKotlinVersion;
            Intrinsics.checkNotNullParameter((Object)jpsVersion, (String)"jpsVersion");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            IdeKotlinVersion ideKotlinVersion = IdeKotlinVersion.Companion.opt(jpsVersion);
            Object object = parsedKotlinVersion = ideKotlinVersion != null ? ideKotlinVersion.getKotlinVersion() : null;
            if (parsedKotlinVersion == null) {
                String string;
                if (fromFile) {
                    Object[] objectArray = new Object[]{jpsVersion, "kotlinc.xml"};
                    string = KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0.from.1", objectArray);
                } else {
                    Object[] objectArray = new Object[]{jpsVersion};
                    string = KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0", objectArray);
                }
                return new ParsingError(string);
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMinimumSupportedVersion()) < 0) {
                Object[] objectArray = new Object[]{this.getJpsMinimumSupportedVersion(), jpsVersion};
                return new OutdatedCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.minimum.supported.version.not.satisfied", objectArray));
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMaximumSupportedVersion()) > 0) {
                Object[] objectArray = new Object[]{this.getJpsMaximumSupportedVersion(), jpsVersion};
                return new NewCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.maximum.supported.version.not.satisfied", objectArray));
            }
            for (Module module : ProjectUtil.getModules((Project)project)) {
                IdeKotlinVersion moduleKotlinVersion;
                Sdk sdk2 = ProjectStructureUtils.getSdk(module);
                if (sdk2 == null) continue;
                Sdk sdk3 = sdk2;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk3);
                sdk2 = javaSdkVersion;
                if (javaSdkVersion == null) {
                    continue;
                }
                Sdk jdkVersion = sdk2;
                IdeKotlinVersion ideKotlinVersion2 = KotlinCompilerVersionProvider.Companion.getVersion(module);
                if (ideKotlinVersion2 == null || (ideKotlinVersion2 = ideKotlinVersion2.getKotlinVersion()) == null) {
                    ideKotlinVersion2 = moduleKotlinVersion = parsedKotlinVersion;
                }
                if (!jdkVersion.isAtLeast(JavaSdkVersion.JDK_25) || moduleKotlinVersion.compareTo(MIN_KOTLIN_VERSION_JDK_25) >= 0) continue;
                Object[] objectArray = new Object[]{moduleKotlinVersion, MIN_KOTLIN_VERSION_JDK_25.toString()};
                return new IncompatibleJdkVersion(KotlinBasePluginBundle.message("kotlin.jps.jdk.unsupported.message", objectArray));
            }
            return null;
        }

        public static /* synthetic */ UnsupportedJpsVersionError checkJpsVersion$default(Companion companion, String string, Project project, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.checkJpsVersion(string, project, bl);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final JpsPluginSettings readFromKotlincXmlOrIpr(@NotNull Path path2) {
            JpsPluginSettings jpsPluginSettings;
            Object v1;
            Element element;
            block7: {
                void $this$singleOrNull$iv;
                Object object;
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                try {
                    object = JDOMUtil.load((Path)path2);
                }
                catch (NoSuchFileException ex) {
                    return null;
                }
                catch (JDOMException ex) {
                    return null;
                }
                element = object;
                Intrinsics.checkNotNull((Object)element);
                Element root = element;
                List list2 = root.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
                object = list2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)KotlinJpsPluginSettings.class.getSimpleName())) continue;
                    if (found$iv) {
                        v1 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            element = v1;
            if (element != null) {
                JpsPluginSettings jpsPluginSettings2;
                Element xmlElement = element;
                boolean bl = false;
                JpsPluginSettings $this$readFromKotlincXmlOrIpr_u24lambda_u241_u240 = jpsPluginSettings2 = new JpsPluginSettings();
                boolean bl2 = false;
                XmlSerializer.deserializeInto((Object)$this$readFromKotlincXmlOrIpr_u24lambda_u241_u240, (Element)xmlElement);
                jpsPluginSettings = jpsPluginSettings2;
            } else {
                jpsPluginSettings = null;
            }
            return jpsPluginSettings;
        }

        @Nullable
        public final String supportedJpsVersion(@NotNull Project project, @NotNull Function1<? super String, Unit> onUnsupportedVersion) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(onUnsupportedVersion, (String)"onUnsupportedVersion");
            String version = this.jpsVersion(project);
            UnsupportedJpsVersionError error = this.checkJpsVersion(version, project, true);
            if (error instanceof OutdatedCompilerVersion) {
                string = this.getFallbackVersionForOutdatedCompiler();
            } else if (error instanceof NewCompilerVersion || error instanceof ParsingError || error instanceof IncompatibleJdkVersion) {
                onUnsupportedVersion.invoke((Object)error.getMessage());
                string = null;
            } else if (error == null) {
                string = version;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public final void importKotlinJpsVersionFromExternalBuildSystem(@NotNull Project project, @NotNull String rawVersion, boolean isDelegatedToExtBuild, @NotNull String externalSystemId) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
            KotlinJpsPluginSettings instance = this.getInstance(project);
            String externalSystemIdValidated = this.validateExternalSystemId(externalSystemId);
            if (Intrinsics.areEqual((Object)rawVersion, (Object)this.getRawBundledVersion())) {
                ActionsKt.runInEdt$default(null, () -> Companion.importKotlinJpsVersionFromExternalBuildSystem$lambda$0(instance, rawVersion, externalSystemIdValidated), (int)1, null);
                return;
            }
            Object[] error = org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings$Companion.checkJpsVersion$default(this, rawVersion, project, false, 4, null);
            Object[] objectArray = error;
            if (objectArray instanceof OutdatedCompilerVersion) {
                string = this.getFallbackVersionForOutdatedCompiler();
            } else if (objectArray instanceof NewCompilerVersion || objectArray instanceof ParsingError || objectArray instanceof IncompatibleJdkVersion) {
                string = this.getRawBundledVersion();
            } else if (objectArray == null) {
                string = rawVersion;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String version = string;
            if (error != null && !isDelegatedToExtBuild) {
                objectArray = new Object[]{version, error.getMessage()};
                KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion(project, KotlinBasePluginBundle.message("notification.title.unsupported.kotlin.jps.plugin.version", new Object[0]), KotlinBasePluginBundle.message("notification.content.bundled.version.0.will.be.used.reason.1", objectArray));
            }
            if ((objectArray = error) instanceof ParsingError || objectArray instanceof NewCompilerVersion) {
                instance.dropExplicitVersion();
                return;
            }
            if (objectArray instanceof IncompatibleJdkVersion) {
                if (isDelegatedToExtBuild) {
                    KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJdkVersion(project, ((IncompatibleJdkVersion)error).getMessage());
                    return;
                }
            } else if (objectArray != null && !(objectArray instanceof OutdatedCompilerVersion)) {
                throw new NoWhenBranchMatchedException();
            }
            if (!this.shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$intellij_kotlin_base_plugin(IdeKotlinVersion.Companion.get(version))) {
                instance.dropExplicitVersion();
                return;
            }
            if (((CharSequence)((JpsPluginSettings)instance.getSettings()).getExternalSystemId()).length() > 0 && !Intrinsics.areEqual((Object)externalSystemIdValidated, (Object)((JpsPluginSettings)instance.getSettings()).getExternalSystemId()) && IdeKotlinVersion.Companion.get(version).compare(((JpsPluginSettings)instance.getSettings()).getVersion()) < 0) {
                return;
            }
            if (!isDelegatedToExtBuild) {
                this.downloadKotlinJpsInBackground(project, version);
            }
            ActionsKt.runInEdt$default(null, () -> Companion.importKotlinJpsVersionFromExternalBuildSystem$lambda$1(instance, version, externalSystemIdValidated), (int)1, null);
        }

        private final void downloadKotlinJpsInBackground(Project project, String version) {
            String string = KotlinBasePluginBundle.message("progress.text.downloading.kotlinc.dist", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, version, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $version;
                {
                    this.$project = $project;
                    this.$version = $version;
                    super($project, $super_call_param$1, true);
                }

                public boolean isHeadless() {
                    return false;
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    KotlinArtifactsDownloader.INSTANCE.lazyDownloadMissingJpsPluginDependencies(this.$project, this.$version, indicator, (Function1<? super String, Unit>)((Function1)arg_0 -> downloadKotlinJpsInBackground.1.run$lambda$0(this.$project, arg_0)));
                }

                private static final Unit run$lambda$0(Project $project, String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion($project, KotlinBasePluginBundle.message("kotlin.dist.downloading.failed", new Object[0]), it);
                    return Unit.INSTANCE;
                }
            });
        }

        public final boolean shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$intellij_kotlin_base_plugin(@NotNull IdeKotlinVersion version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if (!(this.getJpsMinimumSupportedVersion().compareTo(IdeKotlinVersion.Companion.get("1.7.10").getKotlinVersion()) < 0)) {
                boolean $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = false;
                String $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem" + " makes sense when minimum supported version is lower than 1.7.20. If minimum supported version is already 1.7.20 then you can drop this function.";
                throw new IllegalStateException($i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22.toString());
            }
            if (!(version.getKotlinVersion().compareTo(this.getJpsMinimumSupportedVersion()) >= 0)) {
                boolean $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = false;
                String $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = version.getKotlinVersion() + " is lower than " + Companion.getJpsMinimumSupportedVersion();
                throw new IllegalArgumentException($i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32.toString());
            }
            IdeKotlinVersion kt160 = IdeKotlinVersion.Companion.get("1.6.0");
            IdeKotlinVersion kt170 = IdeKotlinVersion.Companion.get("1.7.0");
            return version.compareTo(kt170) > 0 || version.compareTo(kt160) >= 0 && version.isRelease() && version.getBuildNumber() == null;
        }

        private final String validateExternalSystemId(String externalSystemId) {
            return Registry.Companion.getInstance().isLoaded() && Registry.Companion.is("kotlin.jps.cache.external.system.id") ? externalSystemId : "";
        }

        private static final Unit importKotlinJpsVersionFromExternalBuildSystem$lambda$0(KotlinJpsPluginSettings $instance, String $rawVersion, String $externalSystemIdValidated) {
            ActionsKt.runWriteAction(() -> Companion.importKotlinJpsVersionFromExternalBuildSystem$lambda$0$0($instance, $rawVersion, $externalSystemIdValidated));
            return Unit.INSTANCE;
        }

        private static final Unit importKotlinJpsVersionFromExternalBuildSystem$lambda$0$0(KotlinJpsPluginSettings $instance, String $rawVersion, String $externalSystemIdValidated) {
            $instance.setVersion($rawVersion, $externalSystemIdValidated);
            return Unit.INSTANCE;
        }

        private static final Unit importKotlinJpsVersionFromExternalBuildSystem$lambda$1(KotlinJpsPluginSettings $instance, String $version, String $externalSystemIdValidated) {
            ActionsKt.runWriteAction(() -> Companion.importKotlinJpsVersionFromExternalBuildSystem$lambda$1$0($instance, $version, $externalSystemIdValidated));
            return Unit.INSTANCE;
        }

        private static final Unit importKotlinJpsVersionFromExternalBuildSystem$lambda$1$0(KotlinJpsPluginSettings $instance, String $version, String $externalSystemIdValidated) {
            $instance.setVersion($version, $externalSystemIdValidated);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

