/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;
import org.jetbrains.jps.model.module.JpsModule;

public final class JavaBackwardReferenceIndexBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance(JavaBackwardReferenceIndexBuilder.class);
    public static final String BUILDER_ID = "compiler.ref.index";
    private static final String MESSAGE_TYPE = "processed module";
    private final Set<ModuleBuildTarget> myCompiledTargets = ConcurrentHashMap.newKeySet();

    public JavaBackwardReferenceIndexBuilder() {
        super(BuilderCategory.CLASS_POST_PROCESSOR);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = JpsBuildBundle.message("builder.name.backward.references.indexer", new Object[0]);
        if (string == null) {
            JavaBackwardReferenceIndexBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void buildStarted(CompileContext context) {
        JavaBackwardReferenceIndexWriter.initialize(context);
    }

    @Override
    public void buildFinished(CompileContext context) {
        if (JavaBackwardReferenceIndexWriter.getInstance() != null) {
            BuildTargetIndex targetIndex = context.getProjectDescriptor().getBuildTargetIndex();
            for (JpsModule module : context.getProjectDescriptor().getProject().getModules()) {
                boolean allAreDummyOrCompiled = true;
                for (ModuleBasedTarget<?> target : targetIndex.getModuleBasedTargets(module, BuildTargetRegistry.ModuleTargetSelector.ALL)) {
                    if (!(target instanceof ModuleBuildTarget) || this.myCompiledTargets.contains(target) || targetIndex.isDummy(target)) continue;
                    allAreDummyOrCompiled = false;
                }
                if (!allAreDummyOrCompiled) continue;
                context.processMessage(new CustomBuilderMessage(BUILDER_ID, MESSAGE_TYPE, module.getName()));
            }
            this.myCompiledTargets.clear();
        }
        JavaBackwardReferenceIndexWriter.closeIfNeeded(false);
    }

    @Override
    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            JavaBackwardReferenceIndexBuilder.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws IOException {
        JavaBackwardReferenceIndexWriter writer = JavaBackwardReferenceIndexWriter.getInstance();
        if (writer != null) {
            Throwable cause = writer.getRebuildRequestCause();
            if (cause != null) {
                LOG.error("compiler reference index will be deleted", cause);
                JavaBackwardReferenceIndexWriter.closeIfNeeded(true);
            }
            if (dirtyFilesHolder.hasRemovedFiles()) {
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    writer.processDeleted(dirtyFilesHolder.getRemoved(target));
                }
            }
            for (ModuleBuildTarget target : chunk.getTargets()) {
                if (!context.getScope().isWholeTargetAffected(target)) continue;
                this.myCompiledTargets.add(target);
            }
            writer.force();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/backwardRefs/JavaBackwardReferenceIndexBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

