/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.model.listing;

import ghidra.util.exception.UsrException;

/**
 * <CODE>CircularDependencyException</CODE> is thrown in cases where
 * an action would cause the program's module structure to have a
 * "cycle", that is to have two module which are both ancestors and
 * descendants of each other.
 */
public class CircularDependencyException extends UsrException {

	/**
	 * Constructor
	 */
    public CircularDependencyException() {
        super("Reference is invalid.");
    }

	/**
	 * Constructor
	 * @param msg detailed message
	 */
    public CircularDependencyException(String msg) {
        super(msg);
    }
}
