/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.Table;
import java.util.Objects;

public class ObjectKey
implements Comparable<ObjectKey> {
    private final Table table;
    private final long key;
    private final int hash;

    public ObjectKey(Table table, long key) {
        this.table = table;
        this.key = key;
        this.hash = Objects.hash(System.identityHashCode(table), key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectKey)) {
            return false;
        }
        ObjectKey that = (ObjectKey)obj;
        if (this.table != that.table) {
            return false;
        }
        return this.key == that.key;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(ObjectKey that) {
        if (this.table != that.table) {
            return System.identityHashCode(this.table) - System.identityHashCode(that.table);
        }
        int result = Long.compareUnsigned(this.key, that.key);
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

