/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.validator;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Validator;

public class SelfSignedValidator
implements Validator {
    private static final String CERT_DATE_PROP = "org.knopflerfish.framework.validator.date";
    private Date validationDate;

    public SelfSignedValidator(FrameworkContext fw) throws ParseException {
        String d = fw.props.getProperty(CERT_DATE_PROP);
        this.validationDate = d != null ? DateFormat.getDateInstance(3).parse(d) : null;
    }

    @Override
    public boolean validateCertificateChain(List<X509Certificate> chain) {
        try {
            for (X509Certificate cert : chain) {
                if (this.validationDate != null) {
                    cert.checkValidity(this.validationDate);
                    continue;
                }
                cert.checkValidity();
            }
        }
        catch (CertificateException _ignore) {
            return false;
        }
        return true;
    }
}

