/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth.code;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.oauth.code.IOAuthCodeResponseHandler;

public class OAuthCodeResponseHandler
implements IOAuthCodeResponseHandler {
    private static final String PARAM_CODE = "code";
    private static final String PARAM_ERROR = "error";
    private static HttpServer httpServer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String SUCCESSFUL_ANSWER_FOR_AUTH = "Auth has been completed";
    private static final String FAILED_ANSWER_FOR_AUTH = "Errors encountered during authorization";
    private final int port;
    @NotNull
    private final String callbackEndpoint;

    public OAuthCodeResponseHandler(int port, @NotNull String callbackEndpoint) {
        this.port = port;
        this.callbackEndpoint = callbackEndpoint;
    }

    @Override
    public void initServer() throws IOException {
        try {
            httpServer = HttpServer.create(new InetSocketAddress(this.port), 1);
        }
        catch (IOException e) {
            throw new IOException("Can't create callback server");
        }
        httpServer.setExecutor(new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
        httpServer.start();
    }

    @Override
    public Future<String> requestCode() {
        return this.executor.submit(() -> {
            AtomicReference result = new AtomicReference();
            AtomicBoolean hasErrors = new AtomicBoolean(false);
            httpServer.createContext(this.callbackEndpoint, exchange -> {
                String answer;
                String query = exchange.getRequestURI().getQuery();
                Map<String, String> params = OAuthCodeResponseHandler.getResponseParams(query);
                String code = params.get(PARAM_CODE);
                if (CommonUtils.isNotEmpty(code)) {
                    result.set(code);
                    answer = SUCCESSFUL_ANSWER_FOR_AUTH;
                } else {
                    hasErrors.set(true);
                    String error = params.get(PARAM_ERROR);
                    if (CommonUtils.isNotEmpty(error)) {
                        result.set(error);
                    }
                    answer = FAILED_ANSWER_FOR_AUTH;
                }
                exchange.sendResponseHeaders(200, answer.getBytes().length);
                exchange.getResponseBody().write(answer.getBytes());
                exchange.close();
            });
            while (result.get() == null) {
                Thread.onSpinWait();
            }
            httpServer.removeContext(this.callbackEndpoint);
            if (hasErrors.get()) {
                throw new IOException("Error receiving code " + (String)result.get());
            }
            return (String)result.get();
        });
    }

    @Override
    public void addStabContext() {
        httpServer.createContext(this.callbackEndpoint, exchange -> {
            exchange.sendResponseHeaders(200, 0L);
            httpServer.removeContext(this.callbackEndpoint);
            exchange.close();
        });
    }

    @Override
    public void close() throws IOException {
        if (httpServer != null) {
            httpServer.stop(0);
        }
        this.executor.shutdown();
    }

    @NotNull
    public static Map<String, String> getResponseParams(@NotNull String query) {
        return Stream.of(query.split("&")).map(kv -> kv.split("=", 2)).collect(Collectors.toMap(kv -> kv[0], kv -> kv[((String[])kv).length - 1]));
    }
}

