/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGrantee;
import org.jkiss.dbeaver.ext.altibase.model.AltibasePrivUser;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AltibaseRole
extends AltibaseGrantee
implements DBARole {
    private final UserPrivCache userPrivCache = new UserPrivCache();

    public AltibaseRole(AltibaseDataSource dataSource, ResultSet resultSet) {
        super(dataSource, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME"));
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Association
    public Collection<AltibasePrivUser> getUserPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.userPrivCache.getAllObjects(monitor, this);
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.userPrivCache.clearCache();
        return super.refreshObject(monitor);
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return null;
    }

    static class UserPrivCache
    extends JDBCObjectCache<AltibaseRole, AltibasePrivUser> {
        UserPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseRole owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT ge.user_name AS grantee_name , gr.user_name AS grantor_name FROM system_.sys_users_ ge , system_.sys_users_ gr , system_.sys_users_ u , system_.sys_user_roles_ r WHERE u.user_name = ? AND u.user_id = r.role_id AND r.grantee_id = ge.user_id AND r.grantor_id = gr.user_id ORDER BY grantee_name, grantor_name");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected AltibasePrivUser fetchObject(@NotNull JDBCSession session, @NotNull AltibaseRole owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibasePrivUser((AltibaseGrantee)owner, (ResultSet)resultSet);
        }
    }
}

