/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.ExceptionInfoEditor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

public class CodeAttributeEditor
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
LocalVariableTargetElementVisitor {
    private static final boolean DEBUG = false;
    private static final int LABEL_FLAG = 0x20000000;
    private final boolean updateFrameSizes;
    private final boolean shrinkInstructions;
    private int codeLength;
    private boolean modified;
    private boolean simple;
    private Map labels = new HashMap();
    public Instruction[] preOffsetInsertions = new Instruction[8096];
    public Instruction[] preInsertions = new Instruction[8096];
    public Instruction[] replacements = new Instruction[8096];
    public Instruction[] postInsertions = new Instruction[8096];
    public boolean[] deleted = new boolean[8096];
    private int[] newInstructionOffsets = new int[8096];
    private int newOffset;
    private boolean lengthIncreased;
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeEditor() {
        this(true, true);
    }

    public CodeAttributeEditor(boolean updateFrameSizes, boolean shrinkInstructions) {
        this.updateFrameSizes = updateFrameSizes;
        this.shrinkInstructions = shrinkInstructions;
    }

    public void reset(int codeLength) {
        this.labels.clear();
        if (this.preInsertions.length < codeLength) {
            this.preOffsetInsertions = new Instruction[codeLength];
            this.preInsertions = new Instruction[codeLength];
            this.replacements = new Instruction[codeLength];
            this.postInsertions = new Instruction[codeLength];
            this.deleted = new boolean[codeLength];
        } else {
            Arrays.fill(this.preOffsetInsertions, 0, codeLength, null);
            Arrays.fill(this.preInsertions, 0, codeLength, null);
            Arrays.fill(this.replacements, 0, codeLength, null);
            Arrays.fill(this.postInsertions, 0, codeLength, null);
            Arrays.fill(this.deleted, 0, codeLength, false);
        }
        this.codeLength = codeLength;
        this.modified = false;
        this.simple = true;
    }

    public void extend(int codeLength) {
        if (this.preInsertions.length < codeLength) {
            this.preOffsetInsertions = ArrayUtil.extendArray(this.preOffsetInsertions, codeLength);
            this.preInsertions = ArrayUtil.extendArray(this.preInsertions, codeLength);
            this.replacements = ArrayUtil.extendArray(this.replacements, codeLength);
            this.postInsertions = ArrayUtil.extendArray(this.postInsertions, codeLength);
            this.deleted = ArrayUtil.extendArray(this.deleted, codeLength);
        } else {
            Arrays.fill(this.preOffsetInsertions, this.codeLength, codeLength, null);
            Arrays.fill(this.preInsertions, this.codeLength, codeLength, null);
            Arrays.fill(this.replacements, this.codeLength, codeLength, null);
            Arrays.fill(this.postInsertions, this.codeLength, codeLength, null);
            Arrays.fill(this.deleted, this.codeLength, codeLength, false);
        }
        this.codeLength = codeLength;
    }

    public void insertBeforeOffset(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.preOffsetInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeOffset(int instructionOffset, Instruction[] instructions) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction instruction = new CompositeInstruction(instructions);
        this.preOffsetInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeInstruction(int instructionOffset, Instruction[] instructions) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction instruction = new CompositeInstruction(instructions);
        this.preInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void replaceInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
    }

    public void replaceInstruction(int instructionOffset, Instruction[] instructions) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction instruction = new CompositeInstruction(instructions);
        this.replacements[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
    }

    public void insertAfterInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertAfterInstruction(int instructionOffset, Instruction[] instructions) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction instruction = new CompositeInstruction(instructions);
        this.postInsertions[instructionOffset] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void deleteInstruction(int instructionOffset) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[instructionOffset] = true;
        this.modified = true;
        this.simple = false;
    }

    public void undeleteInstruction(int instructionOffset) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[instructionOffset] = false;
    }

    public void clearModifications(int instructionOffset) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.preOffsetInsertions[instructionOffset] = null;
        this.preInsertions[instructionOffset] = null;
        this.replacements[instructionOffset] = null;
        this.postInsertions[instructionOffset] = null;
        this.deleted[instructionOffset] = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isModified(int instructionOffset) {
        return this.preOffsetInsertions[instructionOffset] != null || this.preInsertions[instructionOffset] != null || this.replacements[instructionOffset] != null || this.postInsertions[instructionOffset] != null || this.deleted[instructionOffset];
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while editing code:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.modified) {
            if (this.canPerformSimpleReplacements(codeAttribute)) {
                this.performSimpleReplacements(codeAttribute);
            } else {
                codeAttribute.u4codeLength = this.updateInstructions(clazz, method, codeAttribute);
                codeAttribute.exceptionsAccept(clazz, method, this);
                codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
                codeAttribute.attributesAccept(clazz, method, this);
            }
            this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.updateFrameSizes) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
    }

    private boolean canPerformSimpleReplacements(CodeAttribute codeAttribute) {
        if (!this.simple) {
            return false;
        }
        byte[] code = codeAttribute.code;
        int codeLength = codeAttribute.u4codeLength;
        for (int offset = 0; offset < codeLength; ++offset) {
            Instruction replacementInstruction = this.replacements[offset];
            if (replacementInstruction == null || replacementInstruction.length(offset) == InstructionFactory.create(code, offset).length(offset)) continue;
            return false;
        }
        return true;
    }

    private void performSimpleReplacements(CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        for (int offset = 0; offset < codeLength; ++offset) {
            Instruction replacementInstruction = this.replacements[offset];
            if (replacementInstruction == null) continue;
            replacementInstruction.write(codeAttribute, offset);
        }
    }

    private int updateInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        byte[] oldCode = codeAttribute.code;
        int oldLength = codeAttribute.u4codeLength;
        if (this.newInstructionOffsets.length < oldLength + 1) {
            this.newInstructionOffsets = new int[oldLength + 1];
        }
        int newLength = this.mapInstructions(oldCode, oldLength);
        if (this.lengthIncreased) {
            codeAttribute.code = new byte[newLength];
        }
        this.instructionWriter.reset(newLength);
        this.moveInstructions(clazz, method, codeAttribute, oldCode, oldLength);
        return newLength;
    }

    private int mapInstructions(byte[] oldCode, int oldLength) {
        this.newOffset = 0;
        this.lengthIncreased = false;
        int oldOffset = 0;
        do {
            Instruction instruction = InstructionFactory.create(oldCode, oldOffset);
            this.mapInstruction(oldOffset, instruction);
            oldOffset += instruction.length(oldOffset);
            if (this.newOffset <= oldOffset) continue;
            this.lengthIncreased = true;
        } while (oldOffset < oldLength);
        this.newInstructionOffsets[oldOffset] = this.newOffset;
        return this.newOffset;
    }

    private void mapInstruction(int oldOffset, Instruction instruction) {
        Instruction replacementInstruction;
        Instruction preOffsetInstruction = this.preOffsetInsertions[oldOffset];
        if (preOffsetInstruction != null) {
            this.newOffset += preOffsetInstruction.length(this.newOffset);
        }
        this.newInstructionOffsets[oldOffset] = this.newOffset;
        Instruction preInstruction = this.preInsertions[oldOffset];
        if (preInstruction != null) {
            this.newOffset += preInstruction.length(this.newOffset);
        }
        if ((replacementInstruction = this.replacements[oldOffset]) != null) {
            this.newOffset += replacementInstruction.length(this.newOffset);
        } else if (!this.deleted[oldOffset]) {
            this.newOffset += instruction.length(this.newOffset);
        }
        Instruction postInstruction = this.postInsertions[oldOffset];
        if (postInstruction != null) {
            this.newOffset += postInstruction.length(this.newOffset);
        }
    }

    private void moveInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, byte[] oldCode, int oldLength) {
        Instruction instruction;
        this.newOffset = 0;
        int oldOffset = 0;
        do {
            instruction = InstructionFactory.create(oldCode, oldOffset);
            this.moveInstruction(clazz, method, codeAttribute, oldOffset, instruction);
        } while ((oldOffset += instruction.length(oldOffset)) < oldLength);
    }

    private void moveInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int oldOffset, Instruction instruction) {
        Instruction replacementInstruction;
        Instruction preInstruction;
        Instruction preOffsetInstruction = this.preOffsetInsertions[oldOffset];
        if (preOffsetInstruction != null) {
            preOffsetInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
        }
        if ((preInstruction = this.preInsertions[oldOffset]) != null) {
            preInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
        }
        if ((replacementInstruction = this.replacements[oldOffset]) != null) {
            replacementInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
        } else if (!this.deleted[oldOffset]) {
            instruction.accept(clazz, method, codeAttribute, oldOffset, this);
        }
        Instruction postInstruction = this.postInsertions[oldOffset];
        if (postInstruction != null) {
            postInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        this.instructionWriter.visitSimpleInstruction(clazz, method, codeAttribute, this.newOffset, simpleInstruction);
        this.newOffset += simpleInstruction.length(this.newOffset);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.instructionWriter.visitConstantInstruction(clazz, method, codeAttribute, this.newOffset, constantInstruction);
        this.newOffset += constantInstruction.length(this.newOffset);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        this.instructionWriter.visitVariableInstruction(clazz, method, codeAttribute, this.newOffset, variableInstruction);
        this.newOffset += variableInstruction.length(this.newOffset);
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.newBranchOffset(offset, branchInstruction.branchOffset, this.newOffset);
        this.instructionWriter.visitBranchInstruction(clazz, method, codeAttribute, this.newOffset, branchInstruction);
        this.newOffset += branchInstruction.length(this.newOffset);
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.defaultOffset = this.newBranchOffset(offset, tableSwitchInstruction.defaultOffset, this.newOffset);
        this.newJumpOffsets(offset, tableSwitchInstruction.jumpOffsets, this.newOffset);
        this.instructionWriter.visitTableSwitchInstruction(clazz, method, codeAttribute, this.newOffset, tableSwitchInstruction);
        this.newOffset += tableSwitchInstruction.length(this.newOffset);
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.defaultOffset = this.newBranchOffset(offset, lookUpSwitchInstruction.defaultOffset, this.newOffset);
        this.newJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets, this.newOffset);
        this.instructionWriter.visitLookUpSwitchInstruction(clazz, method, codeAttribute, this.newOffset, lookUpSwitchInstruction);
        this.newOffset += lookUpSwitchInstruction.length(this.newOffset);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.newInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.newInstructionOffset(exceptionInfo.u2endPC);
        exceptionInfo.u2handlerPC = this.newInstructionOffset(exceptionInfo.u2handlerPC);
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
        int stackMapFrameOffset;
        int offsetDelta = stackMapFrameOffset = this.newInstructionOffset(offset);
        if (this.expectedStackMapFrameOffset >= 0) {
            offsetDelta -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = stackMapFrameOffset + 1;
        }
        stackMapFrame.u2offsetDelta = offsetDelta;
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.newInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.newInstructionOffset(lineNumberInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2length = this.newBranchOffset(localVariableInfo.u2startPC, localVariableInfo.u2length);
        localVariableInfo.u2startPC = this.newInstructionOffset(localVariableInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2length = this.newBranchOffset(localVariableTypeInfo.u2startPC, localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC);
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        typeAnnotation.targetInfoAccept(clazz, this);
    }

    @Override
    public void visitAnyTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TargetInfo targetInfo) {
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.targetElementsAccept(clazz, method, codeAttribute, typeAnnotation, this);
    }

    @Override
    public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
        offsetTargetInfo.u2offset = this.newInstructionOffset(offsetTargetInfo.u2offset);
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        localVariableTargetElement.u2length = this.newBranchOffset(localVariableTargetElement.u2startPC, localVariableTargetElement.u2length);
        localVariableTargetElement.u2startPC = this.newInstructionOffset(localVariableTargetElement.u2startPC);
    }

    private void newJumpOffsets(int oldInstructionOffset, int[] oldJumpOffsets, int newInstructionOffset) {
        for (int index = 0; index < oldJumpOffsets.length; ++index) {
            oldJumpOffsets[index] = this.newBranchOffset(oldInstructionOffset, oldJumpOffsets[index], newInstructionOffset);
        }
    }

    private int newBranchOffset(int oldInstructionOffset, int oldBranchOffset) {
        return this.newInstructionOffset(oldInstructionOffset + oldBranchOffset) - this.newInstructionOffset(oldInstructionOffset);
    }

    private int newBranchOffset(int oldInstructionOffset, int oldBranchOffset, int newInstructionOffset) {
        int oldBranchTargetOffset = CodeAttributeEditor.isLabel(oldBranchOffset) ? oldBranchOffset : oldInstructionOffset + oldBranchOffset;
        return this.newInstructionOffset(oldBranchTargetOffset) - newInstructionOffset;
    }

    private int newInstructionOffset(int oldInstructionOffset) {
        if (CodeAttributeEditor.isLabel(oldInstructionOffset)) {
            int labelIdentifier = CodeAttributeEditor.labelIdentifier(oldInstructionOffset);
            Label label = (Label)this.labels.get(labelIdentifier);
            if (label == null) {
                throw new IllegalArgumentException("Reference to unknown label identifier [" + labelIdentifier + "]");
            }
            return label.newOffset;
        }
        if (oldInstructionOffset < 0 || oldInstructionOffset > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + oldInstructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        return this.newInstructionOffsets[oldInstructionOffset];
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfos, int exceptionInfoCount) {
        int newIndex = 0;
        for (int index = 0; index < exceptionInfoCount; ++index) {
            ExceptionInfo exceptionInfo = exceptionInfos[index];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfos[newIndex++] = exceptionInfo;
        }
        return newIndex;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfos, int lineNumberInfoCount, int codeLength) {
        int newIndex = 0;
        for (int index = 0; index < lineNumberInfoCount; ++index) {
            LineNumberInfo lineNumberInfo = lineNumberInfos[index];
            int startPC = lineNumberInfo.u2startPC;
            if (startPC >= codeLength || index != 0 && startPC <= lineNumberInfos[index - 1].u2startPC) continue;
            lineNumberInfos[newIndex++] = lineNumberInfo;
        }
        return newIndex;
    }

    public Label label() {
        return this.label(this.labels.size());
    }

    public Label label(int identifier) {
        Label label = new Label(identifier);
        this.labels.put(new Integer(identifier), label);
        return label;
    }

    public Label catch_(int startOffset, int endOffset, int catchType) {
        return this.catch_(this.labels.size(), startOffset, endOffset, catchType);
    }

    public Label catch_(int identifier, int startOffset, int endOffset, int catchType) {
        Catch catch_ = new Catch(identifier, startOffset, endOffset, catchType);
        this.labels.put(new Integer(identifier), catch_);
        return catch_;
    }

    private static boolean isLabel(int instructionOffset) {
        return (instructionOffset & 0xFF000000) == 0x20000000;
    }

    private static int labelIdentifier(int instructionOffset) {
        return instructionOffset & 0xDFFFFFFF;
    }

    private static class Catch
    extends Label {
        private final int startOfffset;
        private final int endOffset;
        private final int catchType;

        public Catch(int identifier, int startOffset, int endOffset, int catchType) {
            super(identifier);
            this.startOfffset = startOffset;
            this.endOffset = endOffset;
            this.catchType = catchType;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] code, int offset) {
        }

        @Override
        protected void readInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't read catch instruction");
        }

        @Override
        protected void writeInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't write catch instruction");
        }

        @Override
        public int length(int offset) {
            return super.length(offset);
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
            if (instructionVisitor.getClass() != CodeAttributeEditor.class) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
            new ExceptionInfoEditor(codeAttribute).prependException(new ExceptionInfo(this.startOfffset, this.endOffset, this.offset(), this.catchType));
        }

        @Override
        public String toString() {
            return "catch " + (CodeAttributeEditor.isLabel(this.startOfffset) ? "label_" : "") + this.startOfffset + ", " + (CodeAttributeEditor.isLabel(this.endOffset) ? "label_" : "") + this.endOffset + ", #" + this.catchType;
        }
    }

    public static class Label
    extends Instruction {
        protected final int identifier;
        private int newOffset;

        public Label(int identifier) {
            this.identifier = identifier;
        }

        public int offset() {
            return 0x20000000 | this.identifier;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] code, int offset) {
        }

        @Override
        protected void readInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't read label instruction");
        }

        @Override
        protected void writeInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't write label instruction");
        }

        @Override
        public int length(int offset) {
            this.newOffset = offset;
            return 0;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
            if (instructionVisitor.getClass() != CodeAttributeEditor.class) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
        }

        public String toString() {
            return "label_" + this.offset();
        }
    }

    private class CompositeInstruction
    extends Instruction {
        private Instruction[] instructions;

        private CompositeInstruction(Instruction[] instructions) {
            this.instructions = instructions;
        }

        @Override
        public Instruction shrink() {
            for (int index = 0; index < this.instructions.length; ++index) {
                this.instructions[index] = this.instructions[index].shrink();
            }
            return this;
        }

        @Override
        public void write(byte[] code, int offset) {
            for (int index = 0; index < this.instructions.length; ++index) {
                Instruction instruction = this.instructions[index];
                instruction.write(code, offset);
                offset += instruction.length(offset);
            }
        }

        @Override
        protected void readInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't read composite instruction");
        }

        @Override
        protected void writeInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't write composite instruction");
        }

        @Override
        public int length(int offset) {
            int newOffset = offset;
            for (int index = 0; index < this.instructions.length; ++index) {
                newOffset += this.instructions[index].length(newOffset);
            }
            return newOffset - offset;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
            if (instructionVisitor != CodeAttributeEditor.this) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
            for (int index = 0; index < this.instructions.length; ++index) {
                Instruction instruction = this.instructions[index];
                instruction.accept(clazz, method, codeAttribute, offset, CodeAttributeEditor.this);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int index = 0; index < this.instructions.length; ++index) {
                stringBuffer.append(this.instructions[index].toString()).append("; ");
            }
            return stringBuffer.toString();
        }
    }
}

