﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/m2/MainframeModernization_EXPORTS.h>
#include <aws/m2/model/ApplicationDeploymentLifecycle.h>
#include <aws/m2/model/ApplicationLifecycle.h>
#include <aws/m2/model/ApplicationVersionLifecycle.h>
#include <aws/m2/model/EngineType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MainframeModernization {
namespace Model {

/**
 * <p>A subset of the possible application attributes. Used in the application
 * list.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ApplicationSummary">AWS
 * API Reference</a></p>
 */
class ApplicationSummary {
 public:
  AWS_MAINFRAMEMODERNIZATION_API ApplicationSummary() = default;
  AWS_MAINFRAMEMODERNIZATION_API ApplicationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAINFRAMEMODERNIZATION_API ApplicationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAINFRAMEMODERNIZATION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the application.</p>
   */
  inline const Aws::String& GetApplicationArn() const { return m_applicationArn; }
  inline bool ApplicationArnHasBeenSet() const { return m_applicationArnHasBeenSet; }
  template <typename ApplicationArnT = Aws::String>
  void SetApplicationArn(ApplicationArnT&& value) {
    m_applicationArnHasBeenSet = true;
    m_applicationArn = std::forward<ApplicationArnT>(value);
  }
  template <typename ApplicationArnT = Aws::String>
  ApplicationSummary& WithApplicationArn(ApplicationArnT&& value) {
    SetApplicationArn(std::forward<ApplicationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the application.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  ApplicationSummary& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the application.</p>
   */
  inline int GetApplicationVersion() const { return m_applicationVersion; }
  inline bool ApplicationVersionHasBeenSet() const { return m_applicationVersionHasBeenSet; }
  inline void SetApplicationVersion(int value) {
    m_applicationVersionHasBeenSet = true;
    m_applicationVersion = value;
  }
  inline ApplicationSummary& WithApplicationVersion(int value) {
    SetApplicationVersion(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the application was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ApplicationSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates either an ongoing deployment or if the application has ever
   * deployed successfully.</p>
   */
  inline ApplicationDeploymentLifecycle GetDeploymentStatus() const { return m_deploymentStatus; }
  inline bool DeploymentStatusHasBeenSet() const { return m_deploymentStatusHasBeenSet; }
  inline void SetDeploymentStatus(ApplicationDeploymentLifecycle value) {
    m_deploymentStatusHasBeenSet = true;
    m_deploymentStatus = value;
  }
  inline ApplicationSummary& WithDeploymentStatus(ApplicationDeploymentLifecycle value) {
    SetDeploymentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the application.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  ApplicationSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the target platform for this application.</p>
   */
  inline EngineType GetEngineType() const { return m_engineType; }
  inline bool EngineTypeHasBeenSet() const { return m_engineTypeHasBeenSet; }
  inline void SetEngineType(EngineType value) {
    m_engineTypeHasBeenSet = true;
    m_engineType = value;
  }
  inline ApplicationSummary& WithEngineType(EngineType value) {
    SetEngineType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the runtime environment that hosts this
   * application.</p>
   */
  inline const Aws::String& GetEnvironmentId() const { return m_environmentId; }
  inline bool EnvironmentIdHasBeenSet() const { return m_environmentIdHasBeenSet; }
  template <typename EnvironmentIdT = Aws::String>
  void SetEnvironmentId(EnvironmentIdT&& value) {
    m_environmentIdHasBeenSet = true;
    m_environmentId = std::forward<EnvironmentIdT>(value);
  }
  template <typename EnvironmentIdT = Aws::String>
  ApplicationSummary& WithEnvironmentId(EnvironmentIdT&& value) {
    SetEnvironmentId(std::forward<EnvironmentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when you last started the application. Null until the
   * application runs for the first time.</p>
   */
  inline const Aws::Utils::DateTime& GetLastStartTime() const { return m_lastStartTime; }
  inline bool LastStartTimeHasBeenSet() const { return m_lastStartTimeHasBeenSet; }
  template <typename LastStartTimeT = Aws::Utils::DateTime>
  void SetLastStartTime(LastStartTimeT&& value) {
    m_lastStartTimeHasBeenSet = true;
    m_lastStartTime = std::forward<LastStartTimeT>(value);
  }
  template <typename LastStartTimeT = Aws::Utils::DateTime>
  ApplicationSummary& WithLastStartTime(LastStartTimeT&& value) {
    SetLastStartTime(std::forward<LastStartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the application.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ApplicationSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the role associated with the
   * application.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  ApplicationSummary& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the application.</p>
   */
  inline ApplicationLifecycle GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ApplicationLifecycle value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ApplicationSummary& WithStatus(ApplicationLifecycle value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the status of the latest version of the application.</p>
   */
  inline ApplicationVersionLifecycle GetVersionStatus() const { return m_versionStatus; }
  inline bool VersionStatusHasBeenSet() const { return m_versionStatusHasBeenSet; }
  inline void SetVersionStatus(ApplicationVersionLifecycle value) {
    m_versionStatusHasBeenSet = true;
    m_versionStatus = value;
  }
  inline ApplicationSummary& WithVersionStatus(ApplicationVersionLifecycle value) {
    SetVersionStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationArn;

  Aws::String m_applicationId;

  int m_applicationVersion{0};

  Aws::Utils::DateTime m_creationTime{};

  ApplicationDeploymentLifecycle m_deploymentStatus{ApplicationDeploymentLifecycle::NOT_SET};

  Aws::String m_description;

  EngineType m_engineType{EngineType::NOT_SET};

  Aws::String m_environmentId;

  Aws::Utils::DateTime m_lastStartTime{};

  Aws::String m_name;

  Aws::String m_roleArn;

  ApplicationLifecycle m_status{ApplicationLifecycle::NOT_SET};

  ApplicationVersionLifecycle m_versionStatus{ApplicationVersionLifecycle::NOT_SET};
  bool m_applicationArnHasBeenSet = false;
  bool m_applicationIdHasBeenSet = false;
  bool m_applicationVersionHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_deploymentStatusHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_engineTypeHasBeenSet = false;
  bool m_environmentIdHasBeenSet = false;
  bool m_lastStartTimeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_versionStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
