﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicediscovery/ServiceDiscovery_EXPORTS.h>
#include <aws/servicediscovery/model/HealthStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ServiceDiscovery {
namespace Model {
class GetInstancesHealthStatusResult {
 public:
  AWS_SERVICEDISCOVERY_API GetInstancesHealthStatusResult() = default;
  AWS_SERVICEDISCOVERY_API GetInstancesHealthStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SERVICEDISCOVERY_API GetInstancesHealthStatusResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A complex type that contains the IDs and the health status of the instances
   * that you specified in the <code>GetInstancesHealthStatus</code> request.</p>
   */
  inline const Aws::Map<Aws::String, HealthStatus>& GetStatus() const { return m_status; }
  template <typename StatusT = Aws::Map<Aws::String, HealthStatus>>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::Map<Aws::String, HealthStatus>>
  GetInstancesHealthStatusResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  inline GetInstancesHealthStatusResult& AddStatus(Aws::String key, HealthStatus value) {
    m_statusHasBeenSet = true;
    m_status.emplace(key, value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If more than <code>MaxResults</code> instances match the specified criteria,
   * you can submit another <code>GetInstancesHealthStatus</code> request to get the
   * next group of results. Specify the value of <code>NextToken</code> from the
   * previous response in the next request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetInstancesHealthStatusResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetInstancesHealthStatusResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Map<Aws::String, HealthStatus> m_status;
  bool m_statusHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceDiscovery
}  // namespace Aws
