﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Information about an Amazon RDS DB cluster snapshot.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsRdsDbClusterSnapshotDetails">AWS
 * API Reference</a></p>
 */
class AwsRdsDbClusterSnapshotDetails {
 public:
  AWS_SECURITYHUB_API AwsRdsDbClusterSnapshotDetails() = default;
  AWS_SECURITYHUB_API AwsRdsDbClusterSnapshotDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsRdsDbClusterSnapshotDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A list of Availability Zones where instances in the DB cluster can be
   * created.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAvailabilityZones() const { return m_availabilityZones; }
  inline bool AvailabilityZonesHasBeenSet() const { return m_availabilityZonesHasBeenSet; }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  void SetAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones = std::forward<AvailabilityZonesT>(value);
  }
  template <typename AvailabilityZonesT = Aws::Vector<Aws::String>>
  AwsRdsDbClusterSnapshotDetails& WithAvailabilityZones(AvailabilityZonesT&& value) {
    SetAvailabilityZones(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  template <typename AvailabilityZonesT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& AddAvailabilityZones(AvailabilityZonesT&& value) {
    m_availabilityZonesHasBeenSet = true;
    m_availabilityZones.emplace_back(std::forward<AvailabilityZonesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates when the snapshot was taken.</p> <p>For more information about the
   * validation and formatting of timestamp fields in Security Hub, see <a
   * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
   */
  inline const Aws::String& GetSnapshotCreateTime() const { return m_snapshotCreateTime; }
  inline bool SnapshotCreateTimeHasBeenSet() const { return m_snapshotCreateTimeHasBeenSet; }
  template <typename SnapshotCreateTimeT = Aws::String>
  void SetSnapshotCreateTime(SnapshotCreateTimeT&& value) {
    m_snapshotCreateTimeHasBeenSet = true;
    m_snapshotCreateTime = std::forward<SnapshotCreateTimeT>(value);
  }
  template <typename SnapshotCreateTimeT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithSnapshotCreateTime(SnapshotCreateTimeT&& value) {
    SetSnapshotCreateTime(std::forward<SnapshotCreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the database engine that you want to use for this DB
   * instance.</p>
   */
  inline const Aws::String& GetEngine() const { return m_engine; }
  inline bool EngineHasBeenSet() const { return m_engineHasBeenSet; }
  template <typename EngineT = Aws::String>
  void SetEngine(EngineT&& value) {
    m_engineHasBeenSet = true;
    m_engine = std::forward<EngineT>(value);
  }
  template <typename EngineT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithEngine(EngineT&& value) {
    SetEngine(std::forward<EngineT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the allocated storage size in gibibytes (GiB).</p>
   */
  inline int GetAllocatedStorage() const { return m_allocatedStorage; }
  inline bool AllocatedStorageHasBeenSet() const { return m_allocatedStorageHasBeenSet; }
  inline void SetAllocatedStorage(int value) {
    m_allocatedStorageHasBeenSet = true;
    m_allocatedStorage = value;
  }
  inline AwsRdsDbClusterSnapshotDetails& WithAllocatedStorage(int value) {
    SetAllocatedStorage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of this DB cluster snapshot.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The port number on which the DB instances in the DB cluster accept
   * connections.</p>
   */
  inline int GetPort() const { return m_port; }
  inline bool PortHasBeenSet() const { return m_portHasBeenSet; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline AwsRdsDbClusterSnapshotDetails& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The VPC ID that is associated with the DB cluster snapshot.</p>
   */
  inline const Aws::String& GetVpcId() const { return m_vpcId; }
  inline bool VpcIdHasBeenSet() const { return m_vpcIdHasBeenSet; }
  template <typename VpcIdT = Aws::String>
  void SetVpcId(VpcIdT&& value) {
    m_vpcIdHasBeenSet = true;
    m_vpcId = std::forward<VpcIdT>(value);
  }
  template <typename VpcIdT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithVpcId(VpcIdT&& value) {
    SetVpcId(std::forward<VpcIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates when the DB cluster was created, in Universal Coordinated Time
   * (UTC).</p> <p>For more information about the validation and formatting of
   * timestamp fields in Security Hub, see <a
   * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
   */
  inline const Aws::String& GetClusterCreateTime() const { return m_clusterCreateTime; }
  inline bool ClusterCreateTimeHasBeenSet() const { return m_clusterCreateTimeHasBeenSet; }
  template <typename ClusterCreateTimeT = Aws::String>
  void SetClusterCreateTime(ClusterCreateTimeT&& value) {
    m_clusterCreateTimeHasBeenSet = true;
    m_clusterCreateTime = std::forward<ClusterCreateTimeT>(value);
  }
  template <typename ClusterCreateTimeT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithClusterCreateTime(ClusterCreateTimeT&& value) {
    SetClusterCreateTime(std::forward<ClusterCreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the master user for the DB cluster.</p>
   */
  inline const Aws::String& GetMasterUsername() const { return m_masterUsername; }
  inline bool MasterUsernameHasBeenSet() const { return m_masterUsernameHasBeenSet; }
  template <typename MasterUsernameT = Aws::String>
  void SetMasterUsername(MasterUsernameT&& value) {
    m_masterUsernameHasBeenSet = true;
    m_masterUsername = std::forward<MasterUsernameT>(value);
  }
  template <typename MasterUsernameT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithMasterUsername(MasterUsernameT&& value) {
    SetMasterUsername(std::forward<MasterUsernameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the database engine to use.</p>
   */
  inline const Aws::String& GetEngineVersion() const { return m_engineVersion; }
  inline bool EngineVersionHasBeenSet() const { return m_engineVersionHasBeenSet; }
  template <typename EngineVersionT = Aws::String>
  void SetEngineVersion(EngineVersionT&& value) {
    m_engineVersionHasBeenSet = true;
    m_engineVersion = std::forward<EngineVersionT>(value);
  }
  template <typename EngineVersionT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithEngineVersion(EngineVersionT&& value) {
    SetEngineVersion(std::forward<EngineVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The license model information for this DB cluster snapshot.</p>
   */
  inline const Aws::String& GetLicenseModel() const { return m_licenseModel; }
  inline bool LicenseModelHasBeenSet() const { return m_licenseModelHasBeenSet; }
  template <typename LicenseModelT = Aws::String>
  void SetLicenseModel(LicenseModelT&& value) {
    m_licenseModelHasBeenSet = true;
    m_licenseModel = std::forward<LicenseModelT>(value);
  }
  template <typename LicenseModelT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithLicenseModel(LicenseModelT&& value) {
    SetLicenseModel(std::forward<LicenseModelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of DB cluster snapshot.</p>
   */
  inline const Aws::String& GetSnapshotType() const { return m_snapshotType; }
  inline bool SnapshotTypeHasBeenSet() const { return m_snapshotTypeHasBeenSet; }
  template <typename SnapshotTypeT = Aws::String>
  void SetSnapshotType(SnapshotTypeT&& value) {
    m_snapshotTypeHasBeenSet = true;
    m_snapshotType = std::forward<SnapshotTypeT>(value);
  }
  template <typename SnapshotTypeT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithSnapshotType(SnapshotTypeT&& value) {
    SetSnapshotType(std::forward<SnapshotTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the percentage of the estimated data that has been transferred.</p>
   */
  inline int GetPercentProgress() const { return m_percentProgress; }
  inline bool PercentProgressHasBeenSet() const { return m_percentProgressHasBeenSet; }
  inline void SetPercentProgress(int value) {
    m_percentProgressHasBeenSet = true;
    m_percentProgress = value;
  }
  inline AwsRdsDbClusterSnapshotDetails& WithPercentProgress(int value) {
    SetPercentProgress(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the DB cluster is encrypted.</p>
   */
  inline bool GetStorageEncrypted() const { return m_storageEncrypted; }
  inline bool StorageEncryptedHasBeenSet() const { return m_storageEncryptedHasBeenSet; }
  inline void SetStorageEncrypted(bool value) {
    m_storageEncryptedHasBeenSet = true;
    m_storageEncrypted = value;
  }
  inline AwsRdsDbClusterSnapshotDetails& WithStorageEncrypted(bool value) {
    SetStorageEncrypted(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the KMS master key that is used to encrypt the database instances
   * in the DB cluster.</p>
   */
  inline const Aws::String& GetKmsKeyId() const { return m_kmsKeyId; }
  inline bool KmsKeyIdHasBeenSet() const { return m_kmsKeyIdHasBeenSet; }
  template <typename KmsKeyIdT = Aws::String>
  void SetKmsKeyId(KmsKeyIdT&& value) {
    m_kmsKeyIdHasBeenSet = true;
    m_kmsKeyId = std::forward<KmsKeyIdT>(value);
  }
  template <typename KmsKeyIdT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithKmsKeyId(KmsKeyIdT&& value) {
    SetKmsKeyId(std::forward<KmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The DB cluster identifier.</p>
   */
  inline const Aws::String& GetDbClusterIdentifier() const { return m_dbClusterIdentifier; }
  inline bool DbClusterIdentifierHasBeenSet() const { return m_dbClusterIdentifierHasBeenSet; }
  template <typename DbClusterIdentifierT = Aws::String>
  void SetDbClusterIdentifier(DbClusterIdentifierT&& value) {
    m_dbClusterIdentifierHasBeenSet = true;
    m_dbClusterIdentifier = std::forward<DbClusterIdentifierT>(value);
  }
  template <typename DbClusterIdentifierT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithDbClusterIdentifier(DbClusterIdentifierT&& value) {
    SetDbClusterIdentifier(std::forward<DbClusterIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the DB cluster snapshot.</p>
   */
  inline const Aws::String& GetDbClusterSnapshotIdentifier() const { return m_dbClusterSnapshotIdentifier; }
  inline bool DbClusterSnapshotIdentifierHasBeenSet() const { return m_dbClusterSnapshotIdentifierHasBeenSet; }
  template <typename DbClusterSnapshotIdentifierT = Aws::String>
  void SetDbClusterSnapshotIdentifier(DbClusterSnapshotIdentifierT&& value) {
    m_dbClusterSnapshotIdentifierHasBeenSet = true;
    m_dbClusterSnapshotIdentifier = std::forward<DbClusterSnapshotIdentifierT>(value);
  }
  template <typename DbClusterSnapshotIdentifierT = Aws::String>
  AwsRdsDbClusterSnapshotDetails& WithDbClusterSnapshotIdentifier(DbClusterSnapshotIdentifierT&& value) {
    SetDbClusterSnapshotIdentifier(std::forward<DbClusterSnapshotIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether mapping of IAM accounts to database accounts is enabled.</p>
   */
  inline bool GetIamDatabaseAuthenticationEnabled() const { return m_iamDatabaseAuthenticationEnabled; }
  inline bool IamDatabaseAuthenticationEnabledHasBeenSet() const { return m_iamDatabaseAuthenticationEnabledHasBeenSet; }
  inline void SetIamDatabaseAuthenticationEnabled(bool value) {
    m_iamDatabaseAuthenticationEnabledHasBeenSet = true;
    m_iamDatabaseAuthenticationEnabled = value;
  }
  inline AwsRdsDbClusterSnapshotDetails& WithIamDatabaseAuthenticationEnabled(bool value) {
    SetIamDatabaseAuthenticationEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Contains the name and values of a manual DB cluster snapshot attribute. </p>
   */
  inline const Aws::Vector<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>& GetDbClusterSnapshotAttributes() const {
    return m_dbClusterSnapshotAttributes;
  }
  inline bool DbClusterSnapshotAttributesHasBeenSet() const { return m_dbClusterSnapshotAttributesHasBeenSet; }
  template <typename DbClusterSnapshotAttributesT = Aws::Vector<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>>
  void SetDbClusterSnapshotAttributes(DbClusterSnapshotAttributesT&& value) {
    m_dbClusterSnapshotAttributesHasBeenSet = true;
    m_dbClusterSnapshotAttributes = std::forward<DbClusterSnapshotAttributesT>(value);
  }
  template <typename DbClusterSnapshotAttributesT = Aws::Vector<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>>
  AwsRdsDbClusterSnapshotDetails& WithDbClusterSnapshotAttributes(DbClusterSnapshotAttributesT&& value) {
    SetDbClusterSnapshotAttributes(std::forward<DbClusterSnapshotAttributesT>(value));
    return *this;
  }
  template <typename DbClusterSnapshotAttributesT = AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute>
  AwsRdsDbClusterSnapshotDetails& AddDbClusterSnapshotAttributes(DbClusterSnapshotAttributesT&& value) {
    m_dbClusterSnapshotAttributesHasBeenSet = true;
    m_dbClusterSnapshotAttributes.emplace_back(std::forward<DbClusterSnapshotAttributesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_availabilityZones;
  bool m_availabilityZonesHasBeenSet = false;

  Aws::String m_snapshotCreateTime;
  bool m_snapshotCreateTimeHasBeenSet = false;

  Aws::String m_engine;
  bool m_engineHasBeenSet = false;

  int m_allocatedStorage{0};
  bool m_allocatedStorageHasBeenSet = false;

  Aws::String m_status;
  bool m_statusHasBeenSet = false;

  int m_port{0};
  bool m_portHasBeenSet = false;

  Aws::String m_vpcId;
  bool m_vpcIdHasBeenSet = false;

  Aws::String m_clusterCreateTime;
  bool m_clusterCreateTimeHasBeenSet = false;

  Aws::String m_masterUsername;
  bool m_masterUsernameHasBeenSet = false;

  Aws::String m_engineVersion;
  bool m_engineVersionHasBeenSet = false;

  Aws::String m_licenseModel;
  bool m_licenseModelHasBeenSet = false;

  Aws::String m_snapshotType;
  bool m_snapshotTypeHasBeenSet = false;

  int m_percentProgress{0};
  bool m_percentProgressHasBeenSet = false;

  bool m_storageEncrypted{false};
  bool m_storageEncryptedHasBeenSet = false;

  Aws::String m_kmsKeyId;
  bool m_kmsKeyIdHasBeenSet = false;

  Aws::String m_dbClusterIdentifier;
  bool m_dbClusterIdentifierHasBeenSet = false;

  Aws::String m_dbClusterSnapshotIdentifier;
  bool m_dbClusterSnapshotIdentifierHasBeenSet = false;

  bool m_iamDatabaseAuthenticationEnabled{false};
  bool m_iamDatabaseAuthenticationEnabledHasBeenSet = false;

  Aws::Vector<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> m_dbClusterSnapshotAttributes;
  bool m_dbClusterSnapshotAttributesHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
