﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/Redshift_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {

/**
 * <p>Describes a cluster security group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSecurityGroupMembership">AWS
 * API Reference</a></p>
 */
class ClusterSecurityGroupMembership {
 public:
  AWS_REDSHIFT_API ClusterSecurityGroupMembership() = default;
  AWS_REDSHIFT_API ClusterSecurityGroupMembership(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_REDSHIFT_API ClusterSecurityGroupMembership& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the cluster security group.</p>
   */
  inline const Aws::String& GetClusterSecurityGroupName() const { return m_clusterSecurityGroupName; }
  inline bool ClusterSecurityGroupNameHasBeenSet() const { return m_clusterSecurityGroupNameHasBeenSet; }
  template <typename ClusterSecurityGroupNameT = Aws::String>
  void SetClusterSecurityGroupName(ClusterSecurityGroupNameT&& value) {
    m_clusterSecurityGroupNameHasBeenSet = true;
    m_clusterSecurityGroupName = std::forward<ClusterSecurityGroupNameT>(value);
  }
  template <typename ClusterSecurityGroupNameT = Aws::String>
  ClusterSecurityGroupMembership& WithClusterSecurityGroupName(ClusterSecurityGroupNameT&& value) {
    SetClusterSecurityGroupName(std::forward<ClusterSecurityGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the cluster security group.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  ClusterSecurityGroupMembership& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clusterSecurityGroupName;
  bool m_clusterSecurityGroupNameHasBeenSet = false;

  Aws::String m_status;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
