﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/ListedHostKey.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class ListHostKeysResult {
 public:
  AWS_TRANSFER_API ListHostKeysResult() = default;
  AWS_TRANSFER_API ListHostKeysResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API ListHostKeysResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns a token that you can use to call <code>ListHostKeys</code> again and
   * receive additional results, if there are any.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListHostKeysResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns the server identifier that contains the listed host keys.</p>
   */
  inline const Aws::String& GetServerId() const { return m_serverId; }
  template <typename ServerIdT = Aws::String>
  void SetServerId(ServerIdT&& value) {
    m_serverIdHasBeenSet = true;
    m_serverId = std::forward<ServerIdT>(value);
  }
  template <typename ServerIdT = Aws::String>
  ListHostKeysResult& WithServerId(ServerIdT&& value) {
    SetServerId(std::forward<ServerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns an array, where each item contains the details of a host key.</p>
   */
  inline const Aws::Vector<ListedHostKey>& GetHostKeys() const { return m_hostKeys; }
  template <typename HostKeysT = Aws::Vector<ListedHostKey>>
  void SetHostKeys(HostKeysT&& value) {
    m_hostKeysHasBeenSet = true;
    m_hostKeys = std::forward<HostKeysT>(value);
  }
  template <typename HostKeysT = Aws::Vector<ListedHostKey>>
  ListHostKeysResult& WithHostKeys(HostKeysT&& value) {
    SetHostKeys(std::forward<HostKeysT>(value));
    return *this;
  }
  template <typename HostKeysT = ListedHostKey>
  ListHostKeysResult& AddHostKeys(HostKeysT&& value) {
    m_hostKeysHasBeenSet = true;
    m_hostKeys.emplace_back(std::forward<HostKeysT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListHostKeysResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_serverId;
  bool m_serverIdHasBeenSet = false;

  Aws::Vector<ListedHostKey> m_hostKeys;
  bool m_hostKeysHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
