/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.solr.handler.sql.SolrRel;

class SolrSort
extends Sort
implements SolrRel {
    SolrSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new SolrSort(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List sortCollations = this.collation.getFieldCollations();
        if (!sortCollations.isEmpty()) {
            List fields = this.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : sortCollations) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                String direction = "asc";
                if (fieldCollation.getDirection().equals((Object)RelFieldCollation.Direction.DESCENDING)) {
                    direction = "desc";
                }
                implementor.addOrder(name, direction);
            }
        }
        if (this.fetch != null) {
            implementor.setLimit(((RexLiteral)this.fetch).getValue().toString());
        }
        if (this.offset != null && this.offset instanceof RexLiteral) {
            implementor.setOffset(((RexLiteral)this.offset).getValue2().toString());
        }
    }
}

