/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Collections;
import org.apache.solr.core.PluginInfo;

public class MetricsConfig {
    private final PluginInfo[] metricReporters;
    private final PluginInfo counterSupplier;
    private final PluginInfo meterSupplier;
    private final PluginInfo timerSupplier;
    private final PluginInfo histogramSupplier;
    private final Object nullNumber;
    private final Object notANumber;
    private final Object nullString;
    private final Object nullObject;
    private final boolean enabled;
    private final CacheConfig cacheConfig;
    private static final PluginInfo[] NO_OP_REPORTERS = new PluginInfo[0];
    public static final String NOOP_IMPL_CLASS = "__noop__";
    private static final PluginInfo NO_OP_PLUGIN = new PluginInfo("typeUnused", Collections.singletonMap("class", "__noop__"), null, null);

    private MetricsConfig(boolean enabled, PluginInfo[] metricReporters, PluginInfo counterSupplier, PluginInfo meterSupplier, PluginInfo timerSupplier, PluginInfo histogramSupplier, Object nullNumber, Object notANumber, Object nullString, Object nullObject, CacheConfig cacheConfig) {
        this.enabled = enabled;
        this.metricReporters = metricReporters;
        this.counterSupplier = counterSupplier;
        this.meterSupplier = meterSupplier;
        this.timerSupplier = timerSupplier;
        this.histogramSupplier = histogramSupplier;
        this.nullNumber = nullNumber;
        this.notANumber = notANumber;
        this.nullString = nullString;
        this.nullObject = nullObject;
        this.cacheConfig = cacheConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public PluginInfo[] getMetricReporters() {
        if (this.enabled) {
            return this.metricReporters;
        }
        return NO_OP_REPORTERS;
    }

    public Object getNullNumber() {
        return this.nullNumber;
    }

    public Object getNotANumber() {
        return this.notANumber;
    }

    public Object getNullString() {
        return this.nullString;
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public PluginInfo getCounterSupplier() {
        if (this.enabled) {
            return this.counterSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getMeterSupplier() {
        if (this.enabled) {
            return this.meterSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getTimerSupplier() {
        if (this.enabled) {
            return this.timerSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public PluginInfo getHistogramSupplier() {
        if (this.enabled) {
            return this.histogramSupplier;
        }
        return NO_OP_PLUGIN;
    }

    public static class CacheConfig {
        public Integer threadsIntervalSeconds;

        public CacheConfig(Integer threadsIntervalSeconds) {
            this.threadsIntervalSeconds = threadsIntervalSeconds;
        }
    }

    public static class MetricsConfigBuilder {
        private PluginInfo[] metricReporterPlugins = new PluginInfo[0];
        private PluginInfo counterSupplier;
        private PluginInfo meterSupplier;
        private PluginInfo timerSupplier;
        private PluginInfo histogramSupplier;
        private Object nullNumber = null;
        private Object notANumber = null;
        private Object nullString = null;
        private Object nullObject = null;
        private boolean enabled = true;
        private CacheConfig cacheConfig = null;

        public MetricsConfigBuilder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public MetricsConfigBuilder setCacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        public MetricsConfigBuilder setMetricReporterPlugins(PluginInfo[] metricReporterPlugins) {
            this.metricReporterPlugins = metricReporterPlugins != null ? metricReporterPlugins : new PluginInfo[]{};
            return this;
        }

        public MetricsConfigBuilder setCounterSupplier(PluginInfo info) {
            this.counterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setMeterSupplier(PluginInfo info) {
            this.meterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setTimerSupplier(PluginInfo info) {
            this.timerSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setHistogramSupplier(PluginInfo info) {
            this.histogramSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setNullNumber(Object nullNumber) {
            this.nullNumber = nullNumber;
            return this;
        }

        public MetricsConfigBuilder setNotANumber(Object notANumber) {
            this.notANumber = notANumber;
            return this;
        }

        public MetricsConfigBuilder setNullString(Object nullString) {
            this.nullString = nullString;
            return this;
        }

        public MetricsConfigBuilder setNullObject(Object nullObject) {
            this.nullObject = nullObject;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.enabled, this.metricReporterPlugins, this.counterSupplier, this.meterSupplier, this.timerSupplier, this.histogramSupplier, this.nullNumber, this.notANumber, this.nullString, this.nullObject, this.cacheConfig);
        }
    }
}

