/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.sym;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.util.InternCache;
import tools.jackson.core.util.Named;

public abstract class PropertyNameMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final InternCache INTERNER = InternCache.instance;
    public static final int MATCH_END_OBJECT = -1;
    public static final int MATCH_UNKNOWN_NAME = -2;
    public static final int MATCH_ODD_TOKEN = -3;
    protected final String[] _nameLookup;
    protected final PropertyNameMatcher _backupMatcher;
    protected final Locale _locale;

    protected PropertyNameMatcher(Locale locale, PropertyNameMatcher backup, String[] nameLookup) {
        this._locale = locale;
        this._backupMatcher = backup;
        this._nameLookup = nameLookup;
    }

    public abstract int matchName(String var1);

    public abstract int matchByQuad(int var1);

    public abstract int matchByQuad(int var1, int var2);

    public abstract int matchByQuad(int var1, int var2, int var3);

    public abstract int matchByQuad(int[] var1, int var2);

    public final String[] nameLookup() {
        return this._nameLookup;
    }

    protected int matchSecondary(String toMatch) {
        if (this._backupMatcher == null) {
            return -2;
        }
        return this._backupMatcher.matchName(toMatch.toLowerCase(this._locale));
    }

    protected static final int _hash(int h, int mask) {
        return h + (h >> 3) & mask;
    }

    protected static int _findSize(int size) {
        int result;
        if (size <= 5) {
            return 8;
        }
        if (size <= 11) {
            return 16;
        }
        if (size <= 23) {
            return 32;
        }
        int needed = size + (size >> 2) + (size >> 4);
        for (result = 64; result < needed; result += result) {
        }
        return result;
    }

    public static List<String> stringsFromNames(List<Named> properties, boolean alreadyInterned) {
        ArrayList<String> result = new ArrayList<String>(properties.size());
        for (Named n : properties) {
            result.add(PropertyNameMatcher._fromName(n, alreadyInterned));
        }
        return result;
    }

    protected static String _fromName(Named n, boolean alreadyInterned) {
        if (n == null) {
            return null;
        }
        String name = n.getName();
        return alreadyInterned ? name : INTERNER.intern(name);
    }

    protected static List<String> _lc(Locale locale, List<String> src) {
        ArrayList<String> lcd = new ArrayList<String>(src.size());
        for (String n : src) {
            lcd.add(n == null ? null : n.toLowerCase(locale));
        }
        return lcd;
    }
}

