/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIkpdnrnf {
    int messageType;
    int errorCode;
    long registrationId;
    byte[] notificationQueue;
    byte[] consumerName;
    String consumerNameString;
    T4CConnection connection;
    T4CMAREngine mar;
    static final int STOP_TFN_KPDNRNF = 4;
    static final int CONS_CLOSE_ERR = 24035;
    static final int DEST_CLOSE_ERR = 24010;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    T4CTTIkpdnrnf(T4CConnection connection) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$4, null, connection);
            }
            this.notificationQueue = null;
            this.consumerName = null;
            this.consumerNameString = null;
            this.connection = null;
            this.mar = connection.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public void receive() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int consumerNameLength;
            int notificationQueueLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.messageType = (int)this.mar.unmarshalUB4();
            this.errorCode = (int)this.mar.unmarshalUB4();
            this.registrationId = this.mar.unmarshalUB4();
            if (this.messageType == 4) {
                int jdbcRegId = PhysicalConnection.ntfManager.getJDBCRegId(this.registrationId);
                NTFJMSRegistration registration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(jdbcRegId);
                registration.setState(NotificationRegistration.RegistrationState.DISABLED);
            }
            if ((notificationQueueLength = (int)this.mar.unmarshalUB4()) > 0) {
                this.notificationQueue = new byte[notificationQueueLength];
                int[] intAr = new int[1];
                this.mar.unmarshalCLR(this.notificationQueue, 0, intAr, this.notificationQueue.length);
                notificationQueueLength = intAr[0];
            }
            if ((consumerNameLength = (int)this.mar.unmarshalUB4()) > 0) {
                this.consumerName = new byte[consumerNameLength];
                int[] intAr = new int[1];
                this.mar.unmarshalCLR(this.consumerName, 0, intAr, this.consumerName.length);
                consumerNameLength = intAr[0];
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getNotificationQueue() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$1, this, new Object[0]);
            }
            String string = this.mar.conv.CharBytesToString(this.notificationQueue, this.notificationQueue.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public long getRegistrationId() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$2, this, new Object[0]);
            }
            long l2 = this.registrationId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$2, this, l2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$2, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getConsumerName() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.consumerName == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, string);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            String string = this.mar.conv.CharBytesToString(this.consumerName, this.consumerName.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIkpdnrnf.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = T4CTTIkpdnrnf.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIkpdnrnf.class.getDeclaredMethod("getConsumerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIkpdnrnf.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIkpdnrnf.class.getDeclaredMethod("getNotificationQueue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIkpdnrnf.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

