/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.LinterInitializer;
import schemacrawler.tools.lint.LinterProvider;
import schemacrawler.tools.lint.NoOpLinter;
import schemacrawler.tools.registry.BasePluginRegistry;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class LinterRegistry
extends BasePluginRegistry
implements LinterInitializer {
    private static final Logger LOGGER = Logger.getLogger(LinterRegistry.class.getName());
    private static final Linter NO_OP_LINTER = new NoOpLinter();
    private static LinterRegistry linterRegistrySingleton;
    private final Map<String, LinterProvider> linterRegistry = LinterRegistry.loadLinterRegistry();

    public static LinterRegistry getLinterRegistry() {
        if (linterRegistrySingleton == null) {
            linterRegistrySingleton = new LinterRegistry();
            linterRegistrySingleton.log();
        }
        return linterRegistrySingleton;
    }

    private static Map<String, LinterProvider> loadLinterRegistry() {
        HashMap<String, LinterProvider> linterRegistry = new HashMap<String, LinterProvider>();
        try {
            ServiceLoader<LinterProvider> serviceLoader = ServiceLoader.load(LinterProvider.class, LinterRegistry.class.getClassLoader());
            for (LinterProvider linterProvider : serviceLoader) {
                String linterId = linterProvider.getLinterId();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Loading linter, %s", new Object[]{linterId}));
                linterRegistry.put(linterId, linterProvider);
            }
        }
        catch (Exception e) {
            throw new InternalRuntimeException("Could not load linter registry", (Throwable)e);
        }
        return linterRegistry;
    }

    private LinterRegistry() {
    }

    public String getName() {
        return "Linters";
    }

    @Override
    public Set<String> getRegisteredLinters() {
        return new HashSet<String>(this.linterRegistry.keySet());
    }

    public Collection<PropertyName> getRegisteredPlugins() {
        ArrayList<PropertyName> linters = new ArrayList<PropertyName>();
        for (LinterProvider linterInfo : this.linterRegistry.values()) {
            linters.add(linterInfo.getPropertyName());
        }
        Collections.sort(linters);
        return linters;
    }

    public boolean hasLinter(String linterId) {
        return this.linterRegistry.containsKey(linterId);
    }

    @Override
    public Linter newLinter(String linterId, LintCollector lintCollector) {
        Objects.requireNonNull(lintCollector, "No lint collector provided");
        if (!this.hasLinter(linterId)) {
            LOGGER.log(Level.WARNING, (Supplier<String>)new StringFormat("Could not instantiate linter with id <%s>", new Object[]{linterId}));
            return NO_OP_LINTER;
        }
        LinterProvider linterProvider = this.linterRegistry.get(linterId);
        return linterProvider.newLinter(lintCollector);
    }
}

