/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.ermodel.associations.ImplicitAssociation;
import schemacrawler.ermodel.associations.ImplicitAssociationsAnalyzer;
import schemacrawler.ermodel.associations.ImplicitAssociationsAnalyzerBuilder;
import schemacrawler.ermodel.associations.ImplicitColumnReference;
import schemacrawler.ermodel.implementation.MutableERModel;
import schemacrawler.ermodel.implementation.MutableEntity;
import schemacrawler.ermodel.implementation.MutableEntitySubtype;
import schemacrawler.ermodel.implementation.MutableManyToManyRelationship;
import schemacrawler.ermodel.implementation.MutableTableReferenceRelationship;
import schemacrawler.ermodel.implementation.TableEntityModelInferrer;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Builder;
import us.fatehi.utility.string.StringFormat;

public class ERModelBuilder
implements Builder<ERModel> {
    private static final Logger LOGGER = Logger.getLogger(ERModelBuilder.class.getName());
    private final Catalog catalog;
    final MutableERModel erModel;
    final Map<NamedObjectKey, TableEntityModelInferrer> inferrerMap;
    final Map<NamedObjectKey, MutableEntity> entityMap;
    final ImplicitAssociationsAnalyzer implicitAssociationsAnalyzer;

    public ERModelBuilder(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.inferrerMap = new HashMap<NamedObjectKey, TableEntityModelInferrer>();
        this.entityMap = new HashMap<NamedObjectKey, MutableEntity>();
        this.erModel = new MutableERModel();
        this.implicitAssociationsAnalyzer = ImplicitAssociationsAnalyzerBuilder.builder(catalog.getTables()).withIdMatcher().withExtensionTableMatcher().build();
    }

    @Override
    public ERModel build() {
        for (Table table : this.catalog.getTables()) {
            this.erModel.addTable(table);
            if (MetaDataUtility.isPartial(table)) continue;
            this.lookupOrCreateEntity(table);
            TableEntityModelInferrer modelInferrer = this.getModelInferrer(table);
            if (modelInferrer.inferBridgeTable()) {
                MutableManyToManyRelationship rel = new MutableManyToManyRelationship(table);
                ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(table.getForeignKeys());
                if (foreignKeys.size() != 2) continue;
                Table leftTable = ((ForeignKey)foreignKeys.get(0)).getPrimaryKeyTable();
                rel.setLeftEntity(this.lookupOrCreateEntity(leftTable));
                Table rightTable = ((ForeignKey)foreignKeys.get(1)).getPrimaryKeyTable();
                rel.setRightEntity(this.lookupOrCreateEntity(rightTable));
                this.erModel.addRelationship(rel);
                continue;
            }
            for (ForeignKey fk : table.getImportedForeignKeys()) {
                MutableTableReferenceRelationship rel = this.createRelationship(fk);
                this.erModel.addRelationship(rel);
            }
        }
        Collection<ImplicitColumnReference> implicitReferences = this.implicitAssociationsAnalyzer.analyzeTables();
        for (ImplicitColumnReference implicitReference : implicitReferences) {
            ImplicitAssociation implicitAssociation = new ImplicitAssociation(implicitReference);
            MutableTableReferenceRelationship rel = this.createRelationship(implicitAssociation);
            this.erModel.addImplicitRelationship(rel);
        }
        return this.erModel;
    }

    private MutableTableReferenceRelationship createRelationship(TableReference tableReference) {
        Table leftTable = tableReference.getForeignKeyTable();
        TableEntityModelInferrer modelInferrer = this.getModelInferrer(leftTable);
        if (modelInferrer.inferBridgeTable()) {
            LOGGER.log(Level.FINE, new StringFormat("Relationship <%s> not built from bridge table <%s>", tableReference, leftTable));
            return null;
        }
        MutableTableReferenceRelationship rel = new MutableTableReferenceRelationship(tableReference);
        RelationshipCardinality cardinality = modelInferrer.inferCardinality(tableReference);
        rel.setCardinality(cardinality);
        MutableEntity leftEntity = this.lookupOrCreateEntity(leftTable);
        Table rightTable = tableReference.getPrimaryKeyTable();
        MutableEntity rightEntity = this.lookupOrCreateEntity(rightTable);
        if (leftEntity == null || rightEntity == null) {
            LOGGER.log(Level.FINE, new StringFormat("Relationship <%s> cannot be built from <%s> -> <%s>", tableReference, leftTable, rightTable));
            return null;
        }
        rel.setEntities(leftEntity, rightEntity);
        return rel;
    }

    private TableEntityModelInferrer getModelInferrer(Table table) {
        return this.inferrerMap.computeIfAbsent(table.key(), key -> new TableEntityModelInferrer(table));
    }

    private MutableEntity lookupOrCreateEntity(Table table) {
        MutableEntity entity;
        if (table == null) {
            return null;
        }
        NamedObjectKey tableKey = table.key();
        if (this.entityMap.containsKey(tableKey)) {
            return this.entityMap.get(tableKey);
        }
        TableEntityModelInferrer modelInferrer = this.getModelInferrer(table);
        EntityType entityType = modelInferrer.inferEntityType();
        switch (entityType) {
            case subtype: {
                MutableEntity mutableEntity = new MutableEntitySubtype(table);
                break;
            }
            default: {
                MutableEntity mutableEntity = entity = new MutableEntity(table, entityType);
            }
        }
        if (entity instanceof MutableEntitySubtype) {
            MutableEntity subEntity = entity;
            Table superTypeTable = modelInferrer.inferSuperType().orElse(null);
            if (superTypeTable != null) {
                ((MutableEntitySubtype)subEntity).setSupertype(this.lookupOrCreateEntity(superTypeTable));
            }
        }
        this.entityMap.put(tableKey, entity);
        this.erModel.addEntity(entity);
        return entity;
    }
}

