/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

@CoreFunctions(defineModule="binascii")
public final class BinasciiModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BinasciiModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="unhexlify", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data"})
    @ArgumentClinic(name="data", conversionClass=AsciiBufferConverter.class)
    @GenerateNodeFactory
    static abstract class UnhexlifyNode
    extends A2bHexNode {
        UnhexlifyNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.UnhexlifyNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="hexlify", minNumOfPositionalArgs=1, parameterNames={"data", "sep", "bytes_per_sep"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="bytes_per_sep", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1")})
    @GenerateNodeFactory
    static abstract class HexlifyNode
    extends B2aHexNode {
        HexlifyNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.HexlifyNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="crc_hqx", minNumOfPositionalArgs=2, parameterNames={"data", "crc"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="crc", conversion=ArgumentClinic.ClinicConversion.Long)})
    @GenerateNodeFactory
    static abstract class CrcHqxNode
    extends PythonBinaryClinicBuiltinNode {
        CrcHqxNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static long b2a(VirtualFrame frame, Object buffer, long crc, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            try {
                long l = PythonUtils.crcHqx((int)crc, bufferLib.getInternalOrCopiedByteArray(buffer), 0, bufferLib.getBufferLength(buffer));
                return l;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.CrcHqxNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="crc32", minNumOfPositionalArgs=1, parameterNames={"data", "crc"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="crc", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class Crc32Node
    extends PythonBinaryClinicBuiltinNode {
        Crc32Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static long b2a(VirtualFrame frame, Object buffer, long crc, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            try {
                long l = PythonUtils.crc32((int)crc, bufferLib.getInternalOrCopiedByteArray(buffer), 0, bufferLib.getBufferLength(buffer));
                return l;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.Crc32NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="b2a_hex", minNumOfPositionalArgs=1, parameterNames={"data", "sep", "bytes_per_sep"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="bytes_per_sep", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1")})
    @GenerateNodeFactory
    static abstract class B2aHexNode
    extends PythonTernaryClinicBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

        B2aHexNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static PBytes b2a(VirtualFrame frame, Object buffer, Object sep, int bytesPerSep, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (sep != PNone.NO_VALUE || bytesPerSep != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.NotImplementedError);
            }
            try {
                PBytes pBytes = B2aHexNode.b2a(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer), language);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PBytes b2a(byte[] bytes, int length, PythonLanguage language) {
            byte[] output = new byte[length * 2];
            for (int i = 0; i < length; ++i) {
                int v = bytes[i] & 0xFF;
                output[i * 2] = HEX_DIGITS[v >> 4];
                output[i * 2 + 1] = HEX_DIGITS[v & 0xF];
            }
            return PFactory.createBytes(language, output);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.B2aHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="b2a_base64", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data"}, keywordOnlyNames={"newline"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="newline", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class B2aBase64Node
    extends PythonClinicBuiltinNode {
        B2aBase64Node() {
        }

        @CompilerDirectives.TruffleBoundary
        private PBytes b2a(byte[] data, int lenght, boolean newline, PythonLanguage language) {
            ByteBuffer encoded;
            try {
                encoded = Base64.getEncoder().encode(ByteBuffer.wrap(data, 0, lenght));
            }
            catch (IllegalArgumentException e) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, e);
            }
            if (newline) {
                byte[] encodedWithNL = Arrays.copyOf(encoded.array(), encoded.limit() + 1);
                encodedWithNL[encodedWithNL.length - 1] = 10;
                return PFactory.createBytes(language, encodedWithNL);
            }
            return PFactory.createBytes(language, encoded.array(), encoded.limit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        PBytes b2aBuffer(VirtualFrame frame, Object buffer, boolean newline, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind PythonLanguage language) {
            try {
                PBytes pBytes = this.b2a(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer), newline, language);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.B2aBase64NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="a2b_hex", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data"})
    @ArgumentClinic(name="data", conversionClass=AsciiBufferConverter.class)
    @GenerateNodeFactory
    static abstract class A2bHexNode
    extends PythonUnaryClinicBuiltinNode {
        A2bHexNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        PBytes a2b(VirtualFrame frame, Object buffer, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind PythonLanguage language) {
            try {
                byte[] bytes = this.a2b(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer));
                PBytes pBytes = PFactory.createBytes(language, bytes);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private byte[] a2b(byte[] bytes, int length) {
            if (length % 2 != 0) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, ErrorMessages.ODD_LENGTH_STRING);
            }
            byte[] output = new byte[length / 2];
            for (int i = 0; i < length / 2; ++i) {
                output[i] = (byte)(this.digitValue((char)bytes[i * 2]) * 16 + this.digitValue((char)bytes[i * 2 + 1]));
            }
            return output;
        }

        private int digitValue(char b) {
            if (b >= '0' && b <= '9') {
                return b - 48;
            }
            if (b >= 'a' && b <= 'f') {
                return b - 97 + 10;
            }
            if (b >= 'A' && b <= 'F') {
                return b - 65 + 10;
            }
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, ErrorMessages.NON_HEX_DIGIT_FOUND);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.A2bHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="a2b_base64", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"data"}, keywordOnlyNames={"strict_mode"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversionClass=AsciiBufferConverter.class), @ArgumentClinic(name="strict_mode", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class A2bBase64Node
    extends PythonBinaryClinicBuiltinNode {
        A2bBase64Node() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        PBytes doConvert(VirtualFrame frame, Object buffer, boolean strictMode, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind PythonLanguage language) {
            try {
                ByteSequenceStorage storage = this.b64decode(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer), strictMode);
                PBytes pBytes = PFactory.createBytes(language, storage);
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private ByteSequenceStorage b64decode(byte[] data, int dataLen, boolean strictMode) {
            try {
                int base64chars = 0;
                int lastBase64Char = -1;
                int padding = 0;
                for (int i = 0; i < dataLen; ++i) {
                    byte c = data[i];
                    if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 43 || c == 47) {
                        lastBase64Char = i;
                        ++base64chars;
                        padding = 0;
                        continue;
                    }
                    if (c == 61) {
                        ++padding;
                        continue;
                    }
                    if (!strictMode) continue;
                    throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, ErrorMessages.ONLY_BASE64_DATA_IS_ALLOWED);
                }
                int expectedPadding = 0;
                if (base64chars % 4 == 1) {
                    throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, ErrorMessages.INVALID_BASE64_ENCODED_STRING);
                }
                if (base64chars % 4 == 2) {
                    expectedPadding = 2;
                } else if (base64chars % 4 == 3) {
                    expectedPadding = 1;
                }
                if (padding < expectedPadding) {
                    throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, ErrorMessages.INCORRECT_PADDING);
                }
                int decodeLen = lastBase64Char + 1;
                int correctedPadding = 0;
                for (int i = decodeLen; correctedPadding < expectedPadding && i < dataLen; ++i) {
                    if (data[i] != 61) continue;
                    ++correctedPadding;
                    decodeLen = i + 1;
                }
                Base64.Decoder decoder = strictMode ? Base64.getDecoder() : Base64.getMimeDecoder();
                ByteBuffer result = decoder.decode(ByteBuffer.wrap(data, 0, decodeLen));
                return new ByteSequenceStorage(result.array(), result.limit());
            }
            catch (IllegalArgumentException e) {
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.BinasciiError, e);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BinasciiModuleBuiltinsClinicProviders.A2bBase64NodeClinicProviderGen.INSTANCE;
        }
    }

    static abstract class AsciiBufferConverter
    extends ArgumentCastNode {
        AsciiBufferConverter() {
        }

        @Specialization(guards={"acquireLib.hasBuffer(value)"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object doObject(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="value") PythonBufferAcquireLibrary acquireLib) {
            return acquireLib.acquireReadonly(value, frame, context, context.getLanguage(inliningTarget), indirectCallData);
        }

        @Specialization(guards={"isAscii(value, getCodeRangeNode)"})
        static Object asciiString(TruffleString value, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return new AsciiStringBuffer(value);
        }

        @Specialization(guards={"!isAscii(value, getCodeRangeNode)"})
        static Object nonAsciiString(TruffleString value, @Bind Node inliningTarget, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.STRING_ARG_SHOULD_CONTAIN_ONLY_ASCII);
        }

        @Specialization
        static Object string(PString value, @Bind Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached InlinedConditionProfile asciiProfile) {
            TruffleString ts = cast.execute(inliningTarget, value);
            if (asciiProfile.profile(inliningTarget, PGuards.isAscii(ts, getCodeRangeNode))) {
                return AsciiBufferConverter.asciiString(ts, getCodeRangeNode);
            }
            return AsciiBufferConverter.nonAsciiString(ts, inliningTarget, getCodeRangeNode);
        }

        @Fallback
        static Object error(Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_SHOULD_BE_BYTES_BUFFER_OR_ASCII_NOT_P, value);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static AsciiBufferConverter create() {
            return BinasciiModuleBuiltinsFactory.AsciiBufferConverterNodeGen.create();
        }

        @ExportLibrary(value=PythonBufferAccessLibrary.class)
        static final class AsciiStringBuffer {
            private final TruffleString str;

            AsciiStringBuffer(TruffleString str) {
                assert (str.getCodeRangeUncached(PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII);
                this.str = str;
            }

            @ExportMessage
            boolean isBuffer() {
                return true;
            }

            @ExportMessage
            int getBufferLength(@Cached TruffleString.CodePointLengthNode codePointLengthNode) {
                return codePointLengthNode.execute((AbstractTruffleString)this.str, PythonUtils.TS_ENCODING);
            }

            @ExportMessage
            byte readByte(int byteOffset, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
                int ch = codePointAtIndexNode.execute((AbstractTruffleString)this.str, byteOffset, PythonUtils.TS_ENCODING);
                assert (0 <= ch && ch < 128);
                return (byte)ch;
            }
        }
    }
}

