"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var traceParser_exports = {};
__export(traceParser_exports, {
  ZipTraceLoaderBackend: () => ZipTraceLoaderBackend
});
module.exports = __toCommonJS(traceParser_exports);
var import_url = __toESM(require("url"));
var import_zipFile = require("../../utils/zipFile");
class ZipTraceLoaderBackend {
  constructor(traceFile) {
    this._traceFile = traceFile;
    this._zipFile = new import_zipFile.ZipFile(traceFile);
  }
  isLive() {
    return false;
  }
  traceURL() {
    return import_url.default.pathToFileURL(this._traceFile).toString();
  }
  async entryNames() {
    return await this._zipFile.entries();
  }
  async hasEntry(entryName) {
    const entries = await this.entryNames();
    return entries.includes(entryName);
  }
  async readText(entryName) {
    try {
      const buffer = await this._zipFile.read(entryName);
      return buffer.toString("utf-8");
    } catch {
    }
  }
  async readBlob(entryName) {
    try {
      const buffer = await this._zipFile.read(entryName);
      return new Blob([new Uint8Array(buffer)]);
    } catch {
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZipTraceLoaderBackend
});
