/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.types.PyPositionalVariadicType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyUnpackedTupleTypeImpl
implements PyUnpackedTupleType {
    public static final PyUnpackedTupleType UNSPECIFIED = new PyUnpackedTupleTypeImpl(Collections.singletonList(null), true);
    private final List<PyType> myElementTypes;
    private final boolean myIsHomogeneous;

    public PyUnpackedTupleTypeImpl(@NotNull List<? extends PyType> elementTypes, boolean isUnbound) {
        if (elementTypes == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (isUnbound) {
            if (elementTypes.size() != 1) {
                throw new IllegalArgumentException("Unbounded unpacked tuple type can have only one type parameter");
            }
            if (elementTypes.get(0) instanceof PyPositionalVariadicType) {
                throw new IllegalArgumentException("Unbounded unpacked tuple type of a TypeVarTuple or another unpacked tuple type is now allowed");
            }
            this.myElementTypes = new ArrayList<PyType>(elementTypes);
        } else {
            this.myElementTypes = PyUnpackedTupleTypeImpl.unpackElementTypes(elementTypes).toList();
        }
        this.myIsHomogeneous = isUnbound;
    }

    @NotNull
    private static Stream<PyType> unpackElementTypes(@NotNull List<? extends PyType> types) {
        if (types == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(1);
        }
        Stream<PyType> stream = types.stream().flatMap(type -> {
            PyUnpackedTupleType unpackedTupleType;
            if (type instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)type).isUnbound()) {
                return PyUnpackedTupleTypeImpl.unpackElementTypes(unpackedTupleType.getElementTypes());
            }
            return Stream.of(type);
        });
        if (stream == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(2);
        }
        return stream;
    }

    @NotNull
    public static PyUnpackedTupleType create(@NotNull List<? extends PyType> elementTypes) {
        if (elementTypes == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(3);
        }
        return new PyUnpackedTupleTypeImpl(elementTypes, false);
    }

    @NotNull
    public static PyUnpackedTupleType createUnbound(@Nullable PyType type) {
        return new PyUnpackedTupleTypeImpl(Collections.singletonList(type), true);
    }

    @NotNull
    public String getName() {
        StringBuilder res = new StringBuilder("*tuple[");
        StringUtil.join(this.myElementTypes, type -> type != null ? type.getName() : "Any", (String)", ", (StringBuilder)res);
        if (this.isUnbound()) {
            res.append(", ...");
        }
        res.append("]");
        String string = res.toString();
        if (string == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<PyType> getElementTypes() {
        List<PyType> list = Collections.unmodifiableList(this.myElementTypes);
        if (list == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isUnbound() {
        return this.myIsHomogeneous;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyUnpackedTupleTypeImpl type = (PyUnpackedTupleTypeImpl)o;
        return this.myIsHomogeneous == type.myIsHomogeneous && Objects.equals(this.myElementTypes, type.myElementTypes);
    }

    public int hashCode() {
        return Objects.hash(this.myElementTypes, this.myIsHomogeneous);
    }

    public String toString() {
        return "PyUnpackedTupleType: " + this.getName();
    }

    @Nullable
    public PyTupleType asTupleType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(6);
        }
        if (this.isUnbound()) {
            return PyTupleType.createHomogeneous(anchor, this.getElementTypes().get(0));
        }
        return PyTupleType.create(anchor, this.getElementTypes());
    }

    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        if (visitor == null) {
            PyUnpackedTupleTypeImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof PyTypeVisitorExt) {
            PyTypeVisitorExt visitorExt = (PyTypeVisitorExt)visitor;
            return (T)visitorExt.visitPyUnpackedTupleType(this);
        }
        return (T)visitor.visitPyType((PyType)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyUnpackedTupleTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyUnpackedTupleTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackElementTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unpackElementTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asTupleType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

