/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;
    private static final int PROCESSING_TIME_LIMIT_MS = 500;

    protected static void addWord(@NotNull Consumer<? super TextRange> consumer, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (consumer == null) {
            BaseSplitter.$$$reportNull$$$0(0);
        }
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        ProgressManager.checkCanceled();
        consumer.consume((Object)found);
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text, @NotNull List<? extends TextRange> words) {
        if (text == null) {
            BaseSplitter.$$$reportNull$$$0(1);
        }
        if (words == null) {
            BaseSplitter.$$$reportNull$$$0(2);
        }
        for (TextRange textRange : words) {
            StringCharacterIterator it = new StringCharacterIterator(text, textRange.getStartOffset(), textRange.getEndOffset(), textRange.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<? extends TextRange> words) {
        if (words == null) {
            BaseSplitter.$$$reportNull$$$0(3);
        }
        for (TextRange textRange : words) {
            if (textRange.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(5);
        }
        return BaseSplitter.subRange(range, matcher.start(), matcher.end());
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher, int group) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(7);
        }
        return BaseSplitter.subRange(range, matcher.start(group), matcher.end(group));
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range, int start, int end) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(8);
        }
        TextRange textRange = TextRange.from((int)(range.getStartOffset() + start), (int)(end - start));
        if (textRange == null) {
            BaseSplitter.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    protected static boolean badSize(int from, int till) {
        int l = till - from;
        return l <= 3;
    }

    @NotNull
    protected static List<TextRange> excludeByPattern(String text, TextRange range, @NotNull Pattern toExclude, int groupToInclude) {
        int till;
        boolean addLast;
        int from;
        SmartList toCheck;
        block12: {
            SmartList smartList;
            if (toExclude == null) {
                BaseSplitter.$$$reportNull$$$0(10);
            }
            toCheck = new SmartList();
            from = range.getStartOffset();
            addLast = true;
            try {
                Matcher matcher = toExclude.matcher(BaseSplitter.newBombedCharSequence(text, range));
                while (matcher.find()) {
                    TextRange contentFound;
                    ProgressManager.checkCanceled();
                    TextRange found = BaseSplitter.matcherRange(range, matcher);
                    till = found.getStartOffset();
                    if (range.getEndOffset() - found.getEndOffset() < 3) {
                        addLast = false;
                    }
                    if (!BaseSplitter.badSize(from, till)) {
                        toCheck.add(new TextRange(from, till));
                    }
                    if (groupToInclude > 0 && BaseSplitter.badSize((contentFound = BaseSplitter.matcherRange(range, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                        toCheck.add(contentFound);
                    }
                    from = found.getEndOffset();
                }
                till = range.getEndOffset();
                if (!BaseSplitter.badSize(from, till)) break block12;
                smartList = toCheck;
            }
            catch (TooLongBombedMatchingException e) {
                List<TextRange> list = Collections.singletonList(range);
                if (list == null) {
                    BaseSplitter.$$$reportNull$$$0(13);
                }
                return list;
            }
            if (smartList == null) {
                BaseSplitter.$$$reportNull$$$0(11);
            }
            return smartList;
        }
        if (addLast) {
            toCheck.add(new TextRange(from, till));
        }
        SmartList smartList = toCheck;
        if (smartList == null) {
            BaseSplitter.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    protected static CharSequence newBombedCharSequence(String text, TextRange range) {
        return BaseSplitter.newBombedCharSequence(range.substring(text));
    }

    protected static CharSequence newBombedCharSequence(String substring) {
        return new StringUtil.BombedCharSequence(substring){
            final long myTime = System.currentTimeMillis() + 500L;

            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= this.myTime) {
                    throw new TooLongBombedMatchingException();
                }
            }
        };
    }

    @Deprecated(forRemoval=true)
    public static void checkCancelled() {
        if (ApplicationManager.getApplication() != null) {
            ProgressIndicatorProvider.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "subRange";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeByPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWord";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAllWordsAreUpperCased";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsShortWord";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matcherRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subRange";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "excludeByPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static class TooLongBombedMatchingException
    extends ProcessCanceledException {
    }
}

