/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.BadLocationException;
import org.protege.editor.core.ui.util.InlineFieldSearchIcon;
import org.protege.editor.core.ui.util.TextFieldSearchHandler;

public class AugmentedJTextField
extends JTextField {
    public static final Color DEFAULT_GHOST_TEXT_COLOR = Color.LIGHT_GRAY;
    private static final Color SEARCH_ICON_COLOR = new Color(200, 200, 200);
    private static final int SEARCH_RECT_WIDTH = 20;
    private String errorMessage = "";
    private int errorLocation = -1;
    private String ghostText = "";
    private final Border defaultBorder;
    private Optional<TextFieldSearchHandler> searchHandler = Optional.empty();
    private static final InlineFieldSearchIcon searchIcon = new InlineFieldSearchIcon(SEARCH_ICON_COLOR);

    public AugmentedJTextField(String ghostText) {
        this("", 40, ghostText);
    }

    public AugmentedJTextField(String text, String ghostText) {
        this(text, 40, ghostText);
    }

    public AugmentedJTextField(int columns, String ghostText) {
        this("", columns, ghostText);
    }

    public AugmentedJTextField(String text, int columns, String ghostText) {
        super(text, columns);
        this.ghostText = ghostText;
        this.defaultBorder = this.getBorder();
        this.installMouseListeners();
    }

    private void installMouseListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (AugmentedJTextField.this.isInSearchRect(e.getPoint())) {
                    AugmentedJTextField.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    AugmentedJTextField.this.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AugmentedJTextField.this.isInSearchRect(e.getPoint())) {
                    AugmentedJTextField.this.searchHandler.ifPresent(h -> {
                        Optional<String> result = h.handleSearch(AugmentedJTextField.this);
                        result.ifPresent(AugmentedJTextField.this::setText);
                    });
                }
            }
        });
    }

    public void setSearchHandler(TextFieldSearchHandler handler) {
        Preconditions.checkNotNull((Object)handler);
        this.searchHandler = Optional.of(handler);
        this.setSearchIconVisible();
    }

    private boolean isInSearchRect(Point pt) {
        return pt.getX() > (double)(this.getWidth() - 20) && pt.getX() < (double)this.getWidth();
    }

    private void setSearchIconVisible() {
        CompoundBorder searchBorder = BorderFactory.createCompoundBorder(this.defaultBorder, BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.setBorder(searchBorder);
    }

    public int getErrorLocation() {
        return this.errorLocation;
    }

    public void setErrorLocation(int errorLocation) {
        if (this.errorLocation != errorLocation) {
            this.errorLocation = errorLocation;
            this.repaint();
        }
    }

    public void clearErrorLocation() {
        if (this.errorLocation != -1) {
            this.errorLocation = -1;
            this.repaint();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getGhostText() {
        return this.ghostText;
    }

    public void setGhostText(String ghostText) {
        if (!this.ghostText.equals(ghostText)) {
            this.ghostText = ghostText;
            this.repaint();
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.repaint();
    }

    public void clearErrorMessage() {
        if (!this.errorMessage.isEmpty()) {
            this.errorMessage = "";
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        try {
            if (this.errorLocation != -1) {
                g.setColor(Color.PINK);
                Rectangle rectStart = this.modelToView(this.errorLocation);
                Rectangle rectEnd = this.modelToView(this.errorLocation + 1);
                g.fillRect(rectStart.x, rectStart.y, rectEnd.x - rectStart.x, rectStart.height);
            }
            if (this.getText().isEmpty()) {
                g.setColor(DEFAULT_GHOST_TEXT_COLOR);
                int baseLine = this.getBaseline(this.getWidth(), this.getHeight());
                Insets insets = this.getInsets();
                g.drawString(this.ghostText, insets.left, baseLine);
            }
            if (!this.errorMessage.isEmpty()) {
                int baseLine = this.getBaseline(this.getWidth(), this.getHeight());
                Rectangle rect = this.modelToView(this.getText().length());
                g.setColor(Color.PINK);
                g.drawString(this.errorMessage, rect.x + 20, baseLine);
            }
        }
        catch (BadLocationException e) {
            System.err.println(e.getMessage());
        }
        if (this.searchHandler.isPresent()) {
            g.setColor(SEARCH_ICON_COLOR);
            searchIcon.paintIcon(this, g, this.getWidth() - 20, (this.getHeight() - searchIcon.getIconHeight()) / 2);
        }
        g.setColor(oldColor);
    }
}

