/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.crt.AwsCrtHttpClientBase;
import software.amazon.awssdk.http.crt.ConnectionHealthConfiguration;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.crt.TcpKeepAliveConfiguration;
import software.amazon.awssdk.http.crt.internal.AwsCrtClientBuilderBase;
import software.amazon.awssdk.http.crt.internal.CrtAsyncRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtAsyncRequestExecutor;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class AwsCrtAsyncHttpClient
extends AwsCrtHttpClientBase
implements SdkAsyncHttpClient {
    private AwsCrtAsyncHttpClient(DefaultAsyncBuilder builder, AttributeMap config) {
        super(builder, config);
    }

    public static Builder builder() {
        return new DefaultAsyncBuilder();
    }

    public static SdkAsyncHttpClient create() {
        return new DefaultAsyncBuilder().build();
    }

    @Override
    public String clientName() {
        return super.clientName();
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncRequest) {
        Validate.paramNotNull((Object)asyncRequest, (String)"asyncRequest");
        Validate.paramNotNull((Object)asyncRequest.request(), (String)"SdkHttpRequest");
        Validate.paramNotNull((Object)asyncRequest.requestContentPublisher(), (String)"RequestContentPublisher");
        Validate.paramNotNull((Object)asyncRequest.responseHandler(), (String)"ResponseHandler");
        asyncRequest.metricCollector().ifPresent(metricCollector -> metricCollector.reportMetric(HttpMetric.HTTP_CLIENT_NAME, (Object)this.clientName()));
        try (HttpClientConnectionManager crtConnPool = this.getOrCreateConnectionPool(this.poolKey(asyncRequest.request()));){
            CrtAsyncRequestContext context = CrtAsyncRequestContext.builder().crtConnPool(crtConnPool).readBufferSize(this.readBufferSize).request(asyncRequest).build();
            CompletableFuture<Void> completableFuture = new CrtAsyncRequestExecutor().execute(context);
            return completableFuture;
        }
    }

    private static final class DefaultAsyncBuilder
    extends AwsCrtClientBuilderBase<Builder>
    implements Builder {
        private DefaultAsyncBuilder() {
        }

        public SdkAsyncHttpClient build() {
            return new AwsCrtAsyncHttpClient(this, this.getAttributeMap().build().merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new AwsCrtAsyncHttpClient(this, this.getAttributeMap().build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConcurrency(Integer var1);

        public Builder readBufferSizeInBytes(Long var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> var1);

        public Builder connectionHealthConfiguration(ConnectionHealthConfiguration var1);

        public Builder connectionHealthConfiguration(Consumer<ConnectionHealthConfiguration.Builder> var1);

        public Builder connectionMaxIdleTime(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder tcpKeepAliveConfiguration(TcpKeepAliveConfiguration var1);

        public Builder tcpKeepAliveConfiguration(Consumer<TcpKeepAliveConfiguration.Builder> var1);

        public Builder postQuantumTlsEnabled(Boolean var1);
    }
}

