/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;

public interface JsonEnum
extends JsonpSerializable {
    public String jsonValue();

    @Nullable
    default public String[] aliases() {
        return null;
    }

    @Override
    default public void serialize(JsonGenerator generator, JsonpMapper params) {
        generator.write(this.jsonValue());
    }

    public static class Deserializer<T extends JsonEnum>
    extends JsonpDeserializerBase<T> {
        private final Map<String, T> lookupTable;
        private static final EnumSet<JsonParser.Event> ACCEPTED_EVENTS = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE);
        private static final EnumSet<JsonParser.Event> NATIVE_EVENTS = EnumSet.of(JsonParser.Event.VALUE_STRING);

        public Deserializer(T[] values) {
            super(ACCEPTED_EVENTS, NATIVE_EVENTS);
            this.lookupTable = new HashMap<String, T>((int)((float)values.length / 0.75f) + 1);
            for (T member : values) {
                this.lookupTable.put(member.jsonValue(), member);
                String[] aliases = member.aliases();
                if (aliases == null) continue;
                for (String alias : aliases) {
                    this.lookupTable.put(alias, member);
                }
            }
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            String value;
            switch (event) {
                case VALUE_TRUE: {
                    value = "true";
                    break;
                }
                case VALUE_FALSE: {
                    value = "false";
                    break;
                }
                default: {
                    value = parser.getString();
                }
            }
            return this.deserialize(value, parser);
        }

        public T deserialize(String value, JsonParser parser) {
            JsonEnum result = (JsonEnum)this.lookupTable.get(value);
            if (result == null) {
                throw new JsonParsingException("Invalid enum '" + value + "'", parser.getLocation());
            }
            return (T)result;
        }

        public T parse(String value) {
            JsonEnum result = (JsonEnum)this.lookupTable.get(value);
            if (result == null) {
                throw new NoSuchElementException("Invalid enum '" + value + "'");
            }
            return (T)result;
        }
    }
}

