/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLSearchMemoriesInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLSearchMemoriesRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportSearchMemoriesAction
extends HandledTransportAction<MLSearchMemoriesRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportSearchMemoriesAction.class);
    private final Client client;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportSearchMemoriesAction(TransportService transportService, ActionFilters actionFilters, Client client, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/memories/search", transportService, actionFilters, MLSearchMemoriesRequest::new);
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, MLSearchMemoriesRequest request, ActionListener<SearchResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLSearchMemoriesInput input = request.getMlSearchMemoriesInput();
        String tenantId = request.getTenantId();
        if (input == null) {
            actionListener.onFailure((Exception)new IllegalArgumentException("Search memories input is required"));
            return;
        }
        if (StringUtils.isBlank((CharSequence)input.getMemoryContainerId())) {
            actionListener.onFailure((Exception)new IllegalArgumentException("Memory container ID is required"));
            return;
        }
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        this.memoryContainerHelper.getMemoryContainer(input.getMemoryContainerId(), tenantId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to search memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            this.searchMemories(input, (MLMemoryContainer)container, user, tenantId, actionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void searchMemories(MLSearchMemoriesInput input, MLMemoryContainer container, User user, String tenantId, ActionListener<SearchResponse> actionListener) {
        try {
            MemoryConfiguration memoryConfig = container.getConfiguration();
            MemoryType memoryType = input.getMemoryType();
            String indexName = memoryConfig.getIndexName(memoryType);
            this.memoryContainerHelper.addContainerIdFilter(input.getMemoryContainerId(), input.getSearchSourceBuilder());
            if (user != null && !ConnectorAccessControlHelper.isAdmin(user)) {
                this.memoryContainerHelper.addOwnerIdFilter(user, input.getSearchSourceBuilder());
            }
            SearchDataObjectRequest searchDataObjecRequest = SearchDataObjectRequest.builder().indices(new String[]{indexName}).searchSourceBuilder(input.getSearchSourceBuilder()).tenantId(tenantId).build();
            ActionListener searchResponseActionListener = ActionListener.wrap(response -> {
                try {
                    actionListener.onResponse(response);
                }
                catch (Exception e) {
                    log.error("Failed to parse search response", (Throwable)e);
                    actionListener.onFailure((Exception)new OpenSearchException("Failed to parse search response", (Throwable)e, new Object[0]));
                }
            }, e -> {
                log.error("Search execution failed", (Throwable)e);
                actionListener.onFailure((Exception)new OpenSearchException("Search execution failed: " + e.getMessage(), (Throwable)e, new Object[0]));
            });
            this.memoryContainerHelper.searchData(container.getConfiguration(), searchDataObjecRequest, (ActionListener<SearchResponse>)searchResponseActionListener);
        }
        catch (Exception e2) {
            log.error("Failed to build search request", (Throwable)e2);
            actionListener.onFailure((Exception)new OpenSearchException("Failed to build search request: " + e2.getMessage(), (Throwable)e2, new Object[0]));
        }
    }
}

