/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.indices;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchWrapperException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLIndex;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.utils.IndexUtils;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.transport.client.Client;

public class MLIndicesHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLIndicesHandler.class);
    @NonNull
    private final ClusterService clusterService;
    @NonNull
    private final Client client;
    @NonNull
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private static final Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();

    public static boolean doesMultiTenantIndexExist(ClusterService clusterService, boolean isMultiTenancyEnabled, String indexName) {
        return isMultiTenancyEnabled || clusterService.state().metadata().hasIndex(indexName);
    }

    public void initModelGroupIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MODEL_GROUP, listener);
    }

    public void initModelIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MODEL, listener);
    }

    public void initMLTaskIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.TASK, listener);
    }

    public void initMLConnectorIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONNECTOR, listener);
    }

    public void initMemoryMetaIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MEMORY_META, listener);
    }

    public void initMemoryMessageIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MEMORY_MESSAGE, listener);
    }

    public void initMLConfigIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONFIG, listener);
    }

    public void initMLControllerIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.CONTROLLER, listener);
    }

    public void initMLMcpSessionManagementIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MCP_SESSION_MANAGEMENT, listener);
    }

    public void initMLMcpToolsIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MCP_TOOLS, listener);
    }

    public void initMLJobsIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.JOBS, listener);
    }

    public void initMLAgentIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.AGENT, listener);
    }

    public void initMemoryContainerIndex(ActionListener<Boolean> listener) {
        this.initMLIndexIfAbsent(MLIndex.MEMORY_CONTAINER, listener);
    }

    public void initMLIndexIfAbsent(MLIndex index, ActionListener<Boolean> listener) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        Integer version = index.getVersion();
        this.initIndexIfAbsent(indexName, mapping, version, listener);
    }

    private String getMapping(String mappingPath) {
        if (mappingPath == null) {
            throw new IllegalArgumentException("Mapping path cannot be null");
        }
        try {
            return IndexUtils.getMappingFromFile((String)mappingPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to fetch index mapping from file: " + mappingPath, e);
        }
    }

    public void createSessionMemoryDataIndex(String indexName, MemoryConfiguration configuration, ActionListener<Boolean> listener) {
        String indexMappings = this.getMapping("index-mappings/ml_memory_sessions.json");
        Map indexSettings = configuration.getMemoryIndexMapping("session_index");
        this.initIndexIfAbsent(indexName, StringUtils.toJson((Object)indexMappings), indexSettings, 1, listener);
    }

    public void createWorkingMemoryDataIndex(String indexName, MemoryConfiguration configuration, ActionListener<Boolean> listener) {
        String indexMappings = this.getMapping("index-mappings/ml_memory_working.json");
        Map indexSettings = configuration.getMemoryIndexMapping("working_memory_index");
        this.initIndexIfAbsent(indexName, StringUtils.toJson((Object)indexMappings), indexSettings, 1, listener);
    }

    public void createLongTermMemoryHistoryIndex(String indexName, MemoryConfiguration configuration, ActionListener<Boolean> listener) {
        String indexMappings = this.getMapping("index-mappings/ml_memory_long_term_history.json");
        Map indexSettings = configuration.getMemoryIndexMapping("long_term_memory_history_index");
        this.initIndexIfAbsent(indexName, StringUtils.toJson((Object)indexMappings), indexSettings, 1, listener);
    }

    private String buildLongTermMemoryMapping(MemoryConfiguration memoryConfig) throws IOException {
        String baseMappingJson = this.getMapping("index-mappings/ml_memory_long_term.json");
        HashMap mapping = new HashMap();
        HashMap<String, Map<Object, Object>> properties = new HashMap<String, Map<Object, Object>>();
        XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)new BytesArray(baseMappingJson), (MediaType)XContentType.JSON);
        Map baseMapping = parser.mapOrdered();
        mapping.put("_meta", baseMapping.get("_meta"));
        properties.putAll((Map)baseMapping.get("properties"));
        if (memoryConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
            HashMap<String, Object> knnVector = new HashMap<String, Object>();
            knnVector.put("type", "knn_vector");
            knnVector.put("dimension", memoryConfig.getDimension());
            HashMap<String, Object> method = new HashMap<String, Object>();
            method.put("name", "hnsw");
            method.put("space_type", "cosinesimil");
            method.put("engine", "lucene");
            method.put("parameters", Map.of("ef_construction", 100, "m", 16));
            knnVector.put("method", method);
            properties.put("memory_embedding", knnVector);
        } else if (memoryConfig.getEmbeddingModelType() == FunctionName.SPARSE_ENCODING) {
            properties.put("memory_embedding", Map.of("type", "rank_features"));
        }
        mapping.put("properties", properties);
        return StringUtils.toJson(mapping);
    }

    public void createLongTermMemoryIndex(String pipelineName, String indexName, MemoryConfiguration memoryConfig, ActionListener<Boolean> listener) {
        try {
            String indexMappings = this.buildLongTermMemoryMapping(memoryConfig);
            HashMap<String, Object> indexSettings = new HashMap<String, Object>();
            if (memoryConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
                indexSettings.put("index.knn", true);
                indexSettings.put("index.knn.algo_param.ef_search", 100);
            }
            if (pipelineName != null) {
                indexSettings.put("default_pipeline", pipelineName);
            }
            if (!memoryConfig.getIndexSettings().isEmpty() && memoryConfig.getIndexSettings().containsKey("long_term_memory_index")) {
                Map configuredIndexSettings = memoryConfig.getMemoryIndexMapping("long_term_memory_index");
                indexSettings.putAll(configuredIndexSettings);
            }
            this.initIndexIfAbsent(indexName, indexMappings, indexSettings, 1, listener);
        }
        catch (Exception e) {
            log.error("Failed to create long-term memory index", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void initIndexWithMappingFileIfAbsent(String indexName, String mappingPath, Integer version, ActionListener<Boolean> listener) {
        String mapping = this.getMapping(mappingPath);
        this.initIndexIfAbsent(indexName, mapping, version, listener);
    }

    public void initIndexIfAbsent(String indexName, String mapping, Integer version, ActionListener<Boolean> listener) {
        this.initIndexIfAbsent(indexName, mapping, null, version, listener);
    }

    public void initIndexIfAbsent(String indexName, String mapping, Map<String, Object> indexSettings, Integer version, ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            if (!MLIndicesHandler.doesMultiTenantIndexExist(this.clusterService, this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), indexName)) {
                ActionListener actionListener = ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        log.info("create index:{}", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        internalListener.onResponse((Object)false);
                    }
                }, e -> {
                    if (e instanceof ResourceAlreadyExistsException || e instanceof OpenSearchWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                        log.info("Skip creating the Index:{} that is already created by another parallel request", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        log.error("Failed to create index {}", (Object)indexName, e);
                        internalListener.onFailure(e);
                    }
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping, XContentType.JSON);
                if (indexSettings != null) {
                    request.settings(indexSettings);
                } else {
                    request.settings(indexName.equals(MLIndex.CONFIG.getIndexName()) ? IndexUtils.ALL_NODES_REPLICA_INDEX_SETTINGS : IndexUtils.DEFAULT_INDEX_SETTINGS);
                }
                this.client.admin().indices().create(request, actionListener);
            } else {
                log.debug("index:{} is already created", (Object)indexName);
                if (indexMappingUpdated.containsKey(indexName) && !indexMappingUpdated.get(indexName).get()) {
                    this.shouldUpdateIndex(indexName, version, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        if (r.booleanValue()) {
                            this.client.admin().indices().putMapping(new PutMappingRequest().indices(new String[]{indexName}).source(mapping, (MediaType)XContentType.JSON), ActionListener.wrap(response -> {
                                if (response.isAcknowledged()) {
                                    UpdateSettingsRequest updateSettingRequest = new UpdateSettingsRequest();
                                    updateSettingRequest.indices(new String[]{indexName});
                                    if (indexSettings != null) {
                                        updateSettingRequest.settings(indexSettings);
                                    } else {
                                        updateSettingRequest.settings(indexName.equals(MLIndex.CONFIG.getIndexName()) ? IndexUtils.UPDATED_ALL_NODES_REPLICA_INDEX_SETTINGS : IndexUtils.UPDATED_DEFAULT_INDEX_SETTINGS);
                                    }
                                    this.client.admin().indices().updateSettings(updateSettingRequest, ActionListener.wrap(updateResponse -> {
                                        if (response.isAcknowledged()) {
                                            indexMappingUpdated.get(indexName).set(true);
                                            internalListener.onResponse((Object)true);
                                        } else {
                                            internalListener.onFailure((Exception)new MLException("Failed to update index setting for: " + indexName));
                                        }
                                    }, exception -> {
                                        log.error("Failed to update index setting for: {}", (Object)indexName, exception);
                                        internalListener.onFailure(exception);
                                    }));
                                } else {
                                    internalListener.onFailure((Exception)new MLException("Failed to update index: " + indexName));
                                }
                            }, exception -> {
                                log.error("Failed to update index {}", (Object)indexName, exception);
                                internalListener.onFailure(exception);
                            }));
                        } else {
                            indexMappingUpdated.get(indexName).set(true);
                            internalListener.onResponse((Object)true);
                        }
                    }, e -> {
                        log.error("Failed to update index mapping", (Throwable)e);
                        internalListener.onFailure(e);
                    }));
                } else {
                    internalListener.onResponse((Object)true);
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to init index {}", (Object)indexName, (Object)e2);
            listener.onFailure(e2);
        }
    }

    public void shouldUpdateIndex(String indexName, Integer newVersion, ActionListener<Boolean> listener) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(indexName);
        if (indexMetaData == null || indexMetaData.mapping() == null) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMetaData.mapping().getSourceAsMap();
        Object meta = indexMapping.get("_meta");
        if (meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get("schema_version")) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        listener.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    @VisibleForTesting
    public boolean doesIndexExists(String indexName) {
        return MLIndicesHandler.doesMultiTenantIndexExist(this.clusterService, this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), indexName);
    }

    @Generated
    public MLIndicesHandler(@NonNull ClusterService clusterService, @NonNull Client client, @NonNull MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        if (clusterService == null) {
            throw new NullPointerException("clusterService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (mlFeatureEnabledSetting == null) {
            throw new NullPointerException("mlFeatureEnabledSetting is marked non-null but is null");
        }
        this.clusterService = clusterService;
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    static {
        for (MLIndex mlIndex : MLIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
    }
}

