/**
 * Custom hook that provides a function to fit the view with a delay
 * Useful for ensuring smooth transitions when changing views
 *
 * @param delay - Delay in milliseconds before fitting the view (default: 100ms)
 * @param padding - Padding for the fit view operation (default: 0.15)
 * @param duration - Duration of the fit view animation in milliseconds (default: 400ms)
 * @returns Function to trigger the delayed fit view
 */
export declare const useFitViewWithDelay: (delay?: number, padding?: number, duration?: number) => () => void;
//# sourceMappingURL=use-fit-view-with-delay.hook.d.ts.map