/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.core.ParseField;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalExtendedStats;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

class ExtendedStatsAggregator
extends NumericMetricsAggregator.MultiValue {
    static final ParseField SIGMA_FIELD = new ParseField("sigma", new String[0]);
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final double sigma;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;
    DoubleArray sumOfSqrs;
    DoubleArray compensationOfSqrs;

    ExtendedStatsAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, double sigma, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        this.sigma = sigma;
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
            this.mins = bigArrays.newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = bigArrays.newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
            this.sumOfSqrs = bigArrays.newDoubleArray(1L, true);
            this.compensationOfSqrs = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum compensatedSum = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumOfSqr = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= ExtendedStatsAggregator.this.counts.size()) {
                    long from = ExtendedStatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    ExtendedStatsAggregator.this.counts = bigArrays.resize(ExtendedStatsAggregator.this.counts, overSize);
                    ExtendedStatsAggregator.this.sums = bigArrays.resize(ExtendedStatsAggregator.this.sums, overSize);
                    ExtendedStatsAggregator.this.compensations = bigArrays.resize(ExtendedStatsAggregator.this.compensations, overSize);
                    ExtendedStatsAggregator.this.mins = bigArrays.resize(ExtendedStatsAggregator.this.mins, overSize);
                    ExtendedStatsAggregator.this.maxes = bigArrays.resize(ExtendedStatsAggregator.this.maxes, overSize);
                    ExtendedStatsAggregator.this.sumOfSqrs = bigArrays.resize(ExtendedStatsAggregator.this.sumOfSqrs, overSize);
                    ExtendedStatsAggregator.this.compensationOfSqrs = bigArrays.resize(ExtendedStatsAggregator.this.compensationOfSqrs, overSize);
                    ExtendedStatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    ExtendedStatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    ExtendedStatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = ExtendedStatsAggregator.this.mins.get(bucket);
                    double max = ExtendedStatsAggregator.this.maxes.get(bucket);
                    double sum = ExtendedStatsAggregator.this.sums.get(bucket);
                    double compensation = ExtendedStatsAggregator.this.compensations.get(bucket);
                    compensatedSum.reset(sum, compensation);
                    double sumOfSqr = ExtendedStatsAggregator.this.sumOfSqrs.get(bucket);
                    double compensationOfSqr = ExtendedStatsAggregator.this.compensationOfSqrs.get(bucket);
                    compensatedSumOfSqr.reset(sumOfSqr, compensationOfSqr);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        compensatedSum.add(value);
                        compensatedSumOfSqr.add(value * value);
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    ExtendedStatsAggregator.this.sums.set(bucket, compensatedSum.value());
                    ExtendedStatsAggregator.this.compensations.set(bucket, compensatedSum.delta());
                    ExtendedStatsAggregator.this.sumOfSqrs.set(bucket, compensatedSumOfSqr.value());
                    ExtendedStatsAggregator.this.compensationOfSqrs.set(bucket, compensatedSumOfSqr.delta());
                    ExtendedStatsAggregator.this.mins.set(bucket, min);
                    ExtendedStatsAggregator.this.maxes.set(bucket, max);
                }
            }

            @Override
            public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
                super.collect(stream, owningBucketOrd);
            }

            @Override
            public void collectRange(int min, int max) throws IOException {
                super.collectRange(min, max);
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalExtendedStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.counts.size()) {
            switch (InternalExtendedStats.Metrics.resolve(name)) {
                case count: {
                    return 0.0;
                }
                case sum: {
                    return 0.0;
                }
                case min: {
                    return Double.POSITIVE_INFINITY;
                }
                case max: {
                    return Double.NEGATIVE_INFINITY;
                }
                case avg: {
                    return Double.NaN;
                }
                case sum_of_squares: {
                    return 0.0;
                }
                case variance: {
                    return Double.NaN;
                }
                case variance_population: {
                    return Double.NaN;
                }
                case variance_sampling: {
                    return Double.NaN;
                }
                case std_deviation: {
                    return Double.NaN;
                }
                case std_deviation_population: {
                    return Double.NaN;
                }
                case std_deviation_sampling: {
                    return Double.NaN;
                }
                case std_upper: {
                    return Double.NaN;
                }
                case std_lower: {
                    return Double.NaN;
                }
            }
            throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
        }
        switch (InternalExtendedStats.Metrics.resolve(name)) {
            case count: {
                return this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
            case sum_of_squares: {
                return this.sumOfSqrs.get(owningBucketOrd);
            }
            case variance: {
                return this.variance(owningBucketOrd);
            }
            case variance_population: {
                return this.variancePopulation(owningBucketOrd);
            }
            case variance_sampling: {
                return this.varianceSampling(owningBucketOrd);
            }
            case std_deviation: {
                return Math.sqrt(this.variance(owningBucketOrd));
            }
            case std_deviation_population: {
                return Math.sqrt(this.variance(owningBucketOrd));
            }
            case std_deviation_sampling: {
                return Math.sqrt(this.varianceSampling(owningBucketOrd));
            }
            case std_upper: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) + Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
            case std_lower: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) - Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    private double variance(long owningBucketOrd) {
        return this.variancePopulation(owningBucketOrd);
    }

    private double variancePopulation(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        double variance = (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
        return variance < 0.0 ? 0.0 : variance;
    }

    private double varianceSampling(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        double variance = (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)(count - 1L);
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalExtendedStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.sumOfSqrs.get(bucket), this.sigma, this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, this.sigma, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.maxes, this.mins, this.sumOfSqrs, this.compensationOfSqrs, this.sums, this.compensations});
    }
}

