<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Rule\Atom;

use DomDocument;
use DOMElement;
use OCA\News\Vendor\FeedIo\Feed\ItemInterface;
use OCA\News\Vendor\FeedIo\Feed\NodeInterface;
use OCA\News\Vendor\FeedIo\Rule\TextAbstract;
class Content extends TextAbstract
{
    public const NODE_NAME = 'content';
    public function setProperty(NodeInterface $node, DOMElement $element): void
    {
        if ($node instanceof ItemInterface) {
            $node->setContent($this->getProcessedContent($element, $node));
        }
    }
    protected function addElement(DomDocument $document, DOMElement $rootElement, NodeInterface $node): void
    {
        if ($node instanceof ItemInterface) {
            $rootElement->appendChild($this->generateElement($document, $node->getContent()));
        }
    }
    protected function hasValue(NodeInterface $node): bool
    {
        if ($node instanceof ItemInterface) {
            return !!$node->getContent();
        }
        return \false;
    }
}
