/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.DataInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.keycloak.common.crypto.CryptoIntegration;

public final class DerUtils {
    private DerUtils() {
    }

    public static PrivateKey decodePrivateKey(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        byte[] keyBytes = new byte[dis.available()];
        dis.readFully(keyBytes);
        dis.close();
        return DerUtils.decodePrivateKey(keyBytes);
    }

    public static PublicKey decodePublicKey(byte[] der) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return DerUtils.decodePublicKey(der, "RSA");
    }

    public static PublicKey decodePublicKey(byte[] der, String type) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
        KeyFactory kf = CryptoIntegration.getProvider().getKeyFactory(type);
        return kf.generatePublic(spec);
    }

    public static X509Certificate decodeCertificate(InputStream is) throws Exception {
        CertificateFactory cf = CryptoIntegration.getProvider().getX509CertFactory();
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        is.close();
        return cert;
    }

    public static PrivateKey decodePrivateKey(byte[] der) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        CharSequence[] algorithms;
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
        for (String string : algorithms = new String[]{"RSA", "EC"}) {
            try {
                return CryptoIntegration.getProvider().getKeyFactory(string).generatePrivate(spec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        throw new InvalidKeySpecException("Unable to decode the private key with supported algorithms: " + String.join((CharSequence)", ", algorithms));
    }
}

