/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.LongDataPacket;
import org.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import org.mariadb.jdbc.message.server.CachedPrepareResultPacket;
import org.mariadb.jdbc.message.server.ErrorPacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;

public final class PrepareExecutePacket
implements RedoableWithPrepareClientMessage {
    private final String sql;
    private final ServerPreparedStatement prep;
    private final InputStream localInfileInputStream;
    private PrepareResultPacket prepareResult;
    private Parameters parameters;

    public PrepareExecutePacket(String sql, Parameters parameters, ServerPreparedStatement prep, InputStream localInfileInputStream) {
        this.sql = sql;
        this.parameters = parameters;
        this.prep = prep;
        this.localInfileInputStream = localInfileInputStream;
        this.prepareResult = null;
    }

    @Override
    public int encode(Writer writer, Context context, Prepare newPrepareResult) throws IOException, SQLException {
        int statementId = -1;
        if (newPrepareResult == null) {
            writer.initPacket();
            writer.writeByte(22);
            writer.writeString(this.sql);
            writer.flushPipeline();
        } else {
            statementId = newPrepareResult.getStatementId();
        }
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            org.mariadb.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            new LongDataPacket(statementId, p, i).encode(writer, context);
        }
        writer.initPacket();
        writer.writeByte(23);
        writer.writeInt(statementId);
        writer.writeByte(0);
        writer.writeInt(1);
        if (parameterCount > 0) {
            org.mariadb.jdbc.client.util.Parameter p;
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            int initialPos = writer.pos();
            writer.pos(initialPos + nullCount);
            writer.writeByte(1);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                writer.writeByte(p.getBinaryEncodeType());
                writer.writeByte(0);
                if (!p.isNull()) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | (byte)(1 << i % 8));
            }
            writer.writeBytesAtPos(nullBitsBuffer, initialPos);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                if (p.isNull() || p.canEncodeLongData()) continue;
                p.encodeBinary(writer, context);
            }
        }
        writer.flush();
        return newPrepareResult == null ? 2 : 1;
    }

    @Override
    public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ClosableLock lock, boolean traceEnable, ClientMessage message, Consumer<String> redirectFct) throws IOException, SQLException {
        if (this.prepareResult == null) {
            ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
            if (buf.getUnsignedByte() == 255) {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode(), true);
            }
            if (context.getConf().useServerPrepStmts() && context.getConf().cachePrepStmts() && this.sql.length() < 8192) {
                CachedPrepareResultPacket prepare = new CachedPrepareResultPacket(buf, reader, context);
                PrepareResultPacket previousCached = (PrepareResultPacket)context.putPrepareCacheCmd(this.sql, prepare, stmt instanceof ServerPreparedStatement ? (ServerPreparedStatement)stmt : null);
                if (stmt != null) {
                    ((BasePreparedStatement)stmt).setPrepareResult(previousCached != null ? previousCached : prepare);
                }
                this.prepareResult = previousCached != null ? previousCached : prepare;
                return this.prepareResult;
            }
            PrepareResultPacket prepareResult = new PrepareResultPacket(buf, reader, context);
            if (stmt != null) {
                ((BasePreparedStatement)stmt).setPrepareResult(prepareResult);
            }
            this.prepareResult = prepareResult;
            return prepareResult;
        }
        return RedoableWithPrepareClientMessage.super.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable, message, redirectFct);
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            org.mariadb.jdbc.client.util.Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public boolean canSkipMeta() {
        return true;
    }

    @Override
    public String description() {
        return "PREPARE + EXECUTE " + this.sql;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String getCommand() {
        return this.sql;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.sql, this.parameters, fileName, context);
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

