/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.servers;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;

public class Server
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.servers.Server>
implements org.eclipse.microprofile.openapi.models.servers.Server {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected org.eclipse.microprofile.openapi.models.servers.Server filter(OASFilter filter) {
        return filter.filterServer((org.eclipse.microprofile.openapi.models.servers.Server)this);
    }

    public String getUrl() {
        return (String)this.getProperty("url", String.class);
    }

    public void setUrl(String newValue) {
        this.setProperty("url", newValue);
    }

    public Map<String, ServerVariable> getVariables() {
        return this.getMapProperty("variables");
    }

    public void setVariables(Map<String, ServerVariable> newValue) {
        this.setMapProperty("variables", newValue);
    }

    public Server addVariable(String newKey, ServerVariable newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("variables", newKey, newValue);
        return this;
    }

    public void removeVariable(String key) {
        this.removeMapPropertyEntry("variables", key);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(3);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(3);

        public Properties() {
            this.types.put("url", DataType.type(String.class));
            this.minVersions.put("url", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("variables", DataType.mapOf((DataType)DataType.type(ServerVariable.class)));
            this.minVersions.put("variables", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

