/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

class ComparatorForPatterns {
    final List<Pattern> fieldPatterns;
    final Comparator<?> comparator;

    ComparatorForPatterns(List<Pattern> fieldPatterns, Comparator<?> comparator) {
        this.fieldPatterns = Collections.unmodifiableList(fieldPatterns);
        this.comparator = comparator;
    }

    boolean hasComparatorForField(String fieldLocation) {
        return this.fieldPatterns.stream().anyMatch(pattern -> pattern.matcher(fieldLocation).matches());
    }

    Comparator<?> getComparatorForField(String fieldLocation) {
        return this.hasComparatorForField(fieldLocation) ? this.comparator : null;
    }

    public String toString() {
        return "ComparatorForPatterns[patterns=%s, comparator=%s]".formatted(this.fieldPatterns, this.comparator);
    }
}

