/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.ClientIdGutterIconRenderer;
import com.intellij.openapi.vcs.ex.LineStatusClientIdRenderer;
import com.intellij.ui.ClickListener;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0001\u00a8\u0006\u000e"}, d2={"showClientIdGutterIconRenderer", "", "project", "Lcom/intellij/openapi/project/Project;", "createClientIdGutterIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "clientIds", "", "Lcom/intellij/codeWithMe/ClientId;", "createClientIdGutterPopupPanel", "Ljavax/swing/JComponent;", "mergeSortedClientIds", "clientIds1", "clientIds2", "intellij.platform.vcs.impl"})
public final class LineStatusClientIdTrackerKt {
    public static final boolean showClientIdGutterIconRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return LineStatusClientIdRenderer.Companion.getInstance(project) != null;
    }

    @Nullable
    public static final GutterIconRenderer createClientIdGutterIconRenderer(@NotNull Project project, @NotNull List<ClientId> clientIds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
        if (clientIds.isEmpty()) {
            return null;
        }
        LineStatusClientIdRenderer lineStatusClientIdRenderer = LineStatusClientIdRenderer.Companion.getInstance(project);
        if (lineStatusClientIdRenderer == null) {
            return null;
        }
        LineStatusClientIdRenderer renderer = lineStatusClientIdRenderer;
        return new ClientIdGutterIconRenderer(clientIds, renderer);
    }

    @Nullable
    public static final JComponent createClientIdGutterPopupPanel(@NotNull Project project, @NotNull List<ClientId> clientIds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
        if (clientIds.isEmpty()) {
            return null;
        }
        LineStatusClientIdRenderer lineStatusClientIdRenderer = LineStatusClientIdRenderer.Companion.getInstance(project);
        if (lineStatusClientIdRenderer == null) {
            return null;
        }
        LineStatusClientIdRenderer renderer = lineStatusClientIdRenderer;
        Icon icon = renderer.getIcon(clientIds);
        String tooltipText = renderer.getTooltipText(clientIds);
        AnAction action = renderer.getClickAction(clientIds);
        JLabel label = new JLabel(icon);
        label.setToolTipText(tooltipText);
        if (action != null) {
            new ClickListener(label, action){
                final /* synthetic */ JLabel $label;
                final /* synthetic */ AnAction $action;
                {
                    this.$label = $label;
                    this.$action = $action;
                }

                public boolean onClick(MouseEvent event, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$label);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext dataContext2 = dataContext;
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)this.$action, (InputEvent)event, (String)"ICON_NAVIGATION", (DataContext)dataContext2);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    AnActionResult result2 = ActionUtil.performAction((AnAction)this.$action, (AnActionEvent)actionEvent);
                    return !result2.isIgnored();
                }
            }.installOn((Component)label);
        }
        return label;
    }

    @VisibleForTesting
    @NotNull
    public static final List<ClientId> mergeSortedClientIds(@NotNull List<ClientId> clientIds1, @NotNull List<ClientId> clientIds2) {
        Intrinsics.checkNotNullParameter(clientIds1, (String)"clientIds1");
        Intrinsics.checkNotNullParameter(clientIds2, (String)"clientIds2");
        if (clientIds1.isEmpty()) {
            return clientIds2;
        }
        if (clientIds2.isEmpty()) {
            return clientIds1;
        }
        int len1 = clientIds1.size();
        int len2 = clientIds2.size();
        if (len2 > len1) {
            return LineStatusClientIdTrackerKt.mergeSortedClientIds(clientIds2, clientIds1);
        }
        int index1 = 0;
        int index2 = 0;
        List newResult = null;
        while (true) {
            if (index1 >= len1) {
                if (index2 >= len2) break;
            }
            if (index1 == len1) {
                if (newResult == null) {
                    newResult = CollectionsKt.toMutableList((Collection)clientIds1);
                }
                newResult.addAll((Collection)clientIds2.subList(index2, len2));
                break;
            }
            if (index2 == len2) {
                if (newResult == null) break;
                newResult.addAll(clientIds1.subList(index1, len1));
                break;
            }
            ClientId value1 = clientIds1.get(index1);
            ClientId value2 = clientIds2.get(index2);
            int delta = value1.getValue().compareTo(value2.getValue());
            if (delta == 0) {
                if (newResult != null) {
                    ((Collection)newResult).add(value1);
                }
                ++index1;
                ++index2;
                continue;
            }
            if (delta < 0) {
                if (newResult != null) {
                    ((Collection)newResult).add(value1);
                }
                ++index1;
                continue;
            }
            if (newResult != null) {
                ((Collection)newResult).add(value2);
            } else {
                newResult = CollectionsKt.toMutableList((Collection)clientIds1.subList(0, index1));
                ((Collection)newResult).add(value2);
            }
            ++index2;
        }
        return newResult == null ? clientIds1 : (newResult.size() == 1 ? CollectionsKt.listOf((Object)CollectionsKt.single((List)newResult)) : (List)new ArrayList(newResult));
    }
}

