/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.util.Url;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.FileBackedSourceMapData;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMapBase;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap;", "Lorg/jetbrains/debugger/sourcemap/SourceMapBase;", "filePath", "Ljava/nio/file/Path;", "initialData", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "<init>", "(Ljava/nio/file/Path;Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;Lorg/jetbrains/debugger/sourcemap/SourceResolver;)V", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceIndexToMappings", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "Companion", "intellij.platform.scriptDebugger.backend"})
public final class FileBackedSourceMap
extends SourceMapBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FileBackedSourceMap(Path filePath, SourceMapDataEx initialData, SourceResolver sourceResolver) {
        super(new FileBackedSourceMapData(filePath, initialData), sourceResolver);
    }

    @Override
    @NotNull
    protected MappingList[] getSourceIndexToMappings() {
        SourceMapData sourceMapData = this.getSourceMapData();
        Intrinsics.checkNotNull((Object)sourceMapData, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.FileBackedSourceMapData");
        return ((FileBackedSourceMapData)sourceMapData).getSourceIndexToMappings();
    }

    @Override
    @NotNull
    public Mappings getGeneratedMappings() {
        SourceMapData sourceMapData = this.getSourceMapData();
        Intrinsics.checkNotNull((Object)sourceMapData, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.FileBackedSourceMapData");
        return ((FileBackedSourceMapData)sourceMapData).getGeneratedMappings();
    }

    public /* synthetic */ FileBackedSourceMap(Path filePath, SourceMapDataEx initialData, SourceResolver sourceResolver, DefaultConstructorMarker $constructor_marker) {
        this(filePath, initialData, sourceResolver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap$Companion;", "", "<init>", "()V", "newFileBackedSourceMap", "Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap;", "filePath", "Ljava/nio/file/Path;", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FileBackedSourceMap newFileBackedSourceMap(@NotNull Path filePath, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            String text = PathsKt.readText$default((Path)filePath, null, (int)1, null);
            SourceMapDataEx sourceMapDataEx = SourceMapDataCache.INSTANCE.getOrCreate(text, ((Object)filePath).toString());
            if (sourceMapDataEx == null) {
                return null;
            }
            SourceMapDataEx data = sourceMapDataEx;
            return new FileBackedSourceMap(filePath, data, new SourceResolver(data.getSourceMapData().getSources(), baseUrl, baseUrlIsFile, false, 8, null), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

